/*\file Kriging.c
 *\brief: best linear predictor
 */
#include "./Kriging.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*Outputs*/
	double *x            = NULL;
	double *y            = NULL;
	double *observations = NULL;
	double *x_interp     = NULL;
	double *y_interp     = NULL;
	double *predictions  = NULL;
	int     n_interp,n,n_obs;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&KrigingUsage);

	/*Fetch inputs: */
	FetchData(&x,&n_obs,X);
	FetchData(&y,&n,Y);                       if(n_obs!=n) _error_("x and y should have the same size");
	FetchData(&observations,&n,OBSERVATIONS); if(n_obs!=n) _error_("x and observations should have the same size");
	FetchData(&x_interp,&n_interp,XINTERP);
	FetchData(&y_interp,&n,YINTERP);          if(n_interp!=n) _error_("x_interp and y_interp should have the same size");

	/*Call x layer*/
	Krigingx(&predictions,x,y,observations,n_obs,x_interp,y_interp,n_interp);

	/*Generate output Matlab Structures*/
	WriteData(PREDICTIONS,predictions,n_interp);

	/*Free ressources: */
	xfree((void**)&x);
	xfree((void**)&y);
	xfree((void**)&observations);
	xfree((void**)&x_interp);
	xfree((void**)&y_interp);
	xfree((void**)&predictions);

	/*end module: */
	MODULEEND();
}

void KrigingUsage(void){
	_printf_(true,"\n");
	_printf_(true,"   usage: predictions=%s(x,y,observations,x_interp,y_interp);\n",__FUNCT__);
	_printf_(true,"\n");
}
