%STARTUP - Matlab startup script
%
%   startup.m is a script run by matlab at the beginning of a session, just
%   before handing over the prompt to the user. This delivery startup.m script
%   has been customized here for the ISSM code. This startup script should be
%   run by users before trying to use ISSM. The best way to do that is to put
%   the startup file in the location where Matlab starts and established its
%   root directory.

% clear the last warning to focus on the warnings of the ISSM path
lastwarn(''); 

%Recover ISSM_DIR , or if on a Windows machine, ISSM_DIR_WIN
if ~ispc,
	ISSM_DIR=getenv('ISSM_DIR');
else
	ISSM_DIR=getenv('ISSM_DIR_WIN');
	%ISSM_DIR='';
end
if (isempty(ISSM_DIR)),
	error('''ISSM_DIR'' environment variable is empty! You should define ISSM_DIR in your .cshrc or .bashrc!');
end

%Now add all issm code paths necessary to run issm smoothly. 
%We capture the error output, so that we can warn the user to update 
%the variable ISSM_DIR in this file, in case it is not correctly setup. 

%ISSM path
addpath([ISSM_DIR '/src/m/utils/']); %loads recursivepath
addpath([ISSM_DIR '/bin']);
addpath(recursivepath([ISSM_DIR '/src/m']));
addpath(recursivepath([ISSM_DIR '/externalpackages/scotch']));
addpath(recursivepath([ISSM_DIR '/externalpackages/canos']));
addpath(recursivepath([ISSM_DIR '/externalpackages/kml']));
addpath(recursivepath([ISSM_DIR '/externalpackages/export_fig']));
addpath(recursivepath([ISSM_DIR '/externalpackages/googleearthtoolbox']));
addpath(recursivepath([ISSM_DIR '/externalpackages/cm_and_cb_utilities']));

clear ISSM_DIR;

%Check on any warning messages that might indicate that the paths were not correct. 
if ~isempty(lastwarn),
	fprintf('\n  Error trying to setup ''ISSM'' code paths. Try and update the ISSM_DIR variable in your .cshrc or .bashrc!\n');
	fprintf('  ''ISSM'' will not  work at all until this is resolved\n\n');
else
	fprintf('\n  To get started with ISSM, type issmdoc at the command prompt.\n\n');
end

%  deal with Matlab bug (on Linux, not WinXP) -- unless
%  the class has been called, "empty" method can not be found
if ~ispc,
	normal_uncertain;
	continuous_design;
	continuous_state;
	linear_inequality_constraint;
	linear_equality_constraint;
	response_function;
	objective_function;
	least_squares_term;
	nonlinear_inequality_constraint;
	nonlinear_equality_constraint;
	clear ans;
end

%disable matlab bell!
beep off;

% no warning if we try to plot while in nojvm (will not be supported in future releases)
warning off MATLAB:HandleGraphics:noJVM
