#!/bin/bash

#Some cleanup
rm -rf install petsc-3.1-p7 src
mkdir install src

#Untar and move petsc to install directory
tar -zxvf  petsc-3.1-p7.tar.gz
mv petsc-3.1-p7/* src/
rm -rf petsc-3.1-p7

#configure
cd src
./config/configure.py \
 --prefix="$ISSM_DIR/externalpackages/petsc/install" \
 --with-mpi-dir=$ISSM_DIR/externalpackages/mpich2/install \
 --PETSC_ARCH=linux-gnu-amd64 \
 --PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
 --with-debugging=0 \
 --with-shared=0 \
 --download-mumps=yes \
 --download-scalapack=yes \
 --download-blacs=yes \
 --download-blas=yes \
 --download-f-blas-lapack=yes \
 --download-parmetis=yes \
 --FFLAGS=-I$ISSM_DIR/externalpackages/mpich2/install/include \
 --download-plapack=yes \
 --COPTFLAGS="-march=opteron -O2" \
 --FOPTFLAGS="-march=opteron -O2" \
 --CXXOPTFLAGS="-march=opteron -O2" \
 --with-pic=1

#Compile petsc and install it
make
make install
