#!/bin/bash

#Some cleanup
rm -rf install petsc-3.1-p7 src
mkdir install src

#Untar and move petsc to install directory
tar -zxvf  petsc-3.1-p7.tar.gz
mv petsc-3.1-p7/* src/
rm -rf petsc-3.1-p7

#configure
cd src
./config/configure.py \
	--prefix="$ISSM_DIR/externalpackages/petsc/install" \
	--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
	--with-batch=1  \
	--ISSM_ARCH=$ISSM_ARCH \
	--with-debugging=no COPTFLAGS=-O3 FOPTFLAGS=-O3 \
	--with-blas-lapack-dir=/opt/intel/mkl/10.0.5.025/ \
	--with-mpi-dir=/opt/mpich/gm/intel10.1/  \
	--download-mumps=yes \
	--download-scalapack=yes \
	--download-blacs=yes  \
	--download-plapack=yes \
	--FFLAGS=-I/usr/include  \
	--with-mpi-shared=0  \
	--download-parmetis=yes

#Compile petsc and install it
make
make install
