function ISSM_DIR=issmdir()
%ISSMDIR - Get ISSM_DIR environment variable
%
%   Usage:
%      ISSM_DIR=issmdir()

if ~ispc,
	ISSM_DIR =getenv('ISSM_DIR');
else
	ISSM_DIR =getenv('ISSM_DIR_WIN');
	if strcmpi(ISSM_DIR(end),'/') | strcmpi(ISSM_DIR(end),'\'),
		ISSM_DIR = ISSM_DIR(1:end-1); %shave off the last '/'
	end
end

if (isempty(ISSM_DIR)),
	error('issmdir error message: ''ISSM_DIR'' environment variable is empty! You should define ISSM_DIR in your .cshrc or .bashrc!');
end
