function md=meshrefine(md,areas)
%MESHREFINE:  refined the mesh from a model, according to an area metric.
%
%   Usage:
%      md=meshrefine(md,metric)

%some checks on list of arguments
if ((nargin~=2) | (nargout~=1)),
	meshrefineusage();
	error('meshrefine error message');
end
if ( (isempty(areas)) |  (length(areas)~=md.numberofelements) | (length(find(isnan(areas))))),
	meshrefineusage();
	error('meshrefine error message');
end

%Refine using TriMeshRefine
%[md.elements,md.x,md.y,md.segments,md.rifts]=TriMeshRefine(md.elements,md.x,md.y,md.segments,md.rifts,areas,'yes');
[md.elements,md.x,md.y,md.segments,md.segmentmarkers]=TriMeshRefine(md.elements,md.x,md.y,md.segments,md.segmentmarkers,areas,'yes');

%Fill in rest of fields:
md.numberofelements=length(md.elements);
md.numberofgrids=length(md.x);
md.z=zeros(md.numberofgrids,1);
md.gridonboundary=zeros(md.numberofgrids,1); md.gridonboundary(md.segments(:,1:2))=1;
md.gridonbed=ones(md.numberofgrids,1);
md.gridonsurface=ones(md.numberofgrids,1);
md.elementonbed=ones(md.numberofelements,1);
md.elementonsurface=ones(md.numberofelements,1);

%type of model
md.type='2d';
	
%augment counter  keeping track of what has been done to this model
md.counter=1;
end

function meshrefineusage(),
disp('usage: md=meshrefine(md,areas)');
end
