function md=rifttipsrefine(md,resolution,circleradius);
%RIFTTIPSREFINE - refine mesh near rift tips
%
%   Usage:
%      md=rifttipsrefine(md,resolution,circleradius);

numberofgrids=50;

%First check rifts are present!
if strcmpi(md.riftoutline,''),
	error('No rifts found in the outlines!');
end

%Ok, dumps riftoutline into a temporary file
writefile('Rifts.exp.temp',md.riftoutline);

%take rifts, and create refinement circles around tips
rifts=expread('Rifts.exp.temp',1);
!echo -n "" > Circles.exp
for i=1:length(rifts),
	tip1=[rifts(i).x(1) rifts(i).y(1)];
	tip2=[rifts(i).x(end) rifts(i).y(end)];
	%create circle around tip
	expcreatecircle('Circle1.exp',tip1(1),tip1(2),circleradius,numberofgrids);
	expcreatecircle('Circle2.exp',tip2(1),tip2(2),circleradius,numberofgrids);
	!cat Circles.exp Circle1.exp Circle2.exp > Circles2.exp
	!mv Circles2.exp Circles.exp
	!rm -rf Circle1.exp Circle2.exp
end

md=meshexprefine(md,'Circles.exp',resolution);

system('rm -rf Circles.exp');
