function expdisp(domainoutline,varargin)
%EXPDISP - plot the contours of a domain outline file
%
%   This routine reads in a domain outline file (Argus format) and plots all the contours 
%
%   Usage:
%      expdisp(domainoutline,varargin)
%      expdisp(domainoutline,figurenumber,linestyle,linewidth,unitmultiplier)
%
%   Example:
%      expdisp('Domain.exp',1,'--r',2,10^3);
%
%   See also EXPMASTER, EXPDOC

%check nargin
if ~nargin | nargin>5
	help expdisp
	error('expdisp error message: bad usage');
end

%parse input
if nargin<=1,
	figurenumber=1;
else
	figurenumber=varargin{1};
end
if nargin<=2
	linestyle='r-';
else
	linestyle=varargin{2};
end
if nargin<=3
	linewidth=1;
else
	linewidth=varargin{3};
end
if nargin<=4
	unitmultiplier=1;
else
	unitmultiplier=varargin{4}; if isnan(unitmultiplier), unitmultiplier=1; end
end

domain=expread(domainoutline);

figure(figurenumber),hold on
for i=1:length(domain),
	plot(domain(i).x*unitmultiplier,domain(i).y*unitmultiplier,linestyle,'linewidth',linewidth);
end
