/*!\file:  ContourToMeshxt.cpp
 * \brief  "thread" core code for interpolating values from a structured grid.
 */ 

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./ContourToMeshx.h"

void* ContourToMeshxt(void* vpthread_handle){
	
	int noerr=1;

	/*gate variables :*/
	ContourToMeshxThreadStruct* gate=NULL;
	pthread_handle* handle=NULL;
	int     my_thread;
	int     num_threads;
	int     i0;
	int     i1;

	int i;

	/*Contour:*/
	DataSet* contours=NULL;

	/*parameters: */
	int nods;
	int edgevalue;
	double* x=NULL;
	double* y=NULL;
	Vector* in_nod=NULL;


	/*recover handle and gate: */
	handle=(pthread_handle*)vpthread_handle;
	gate=(ContourToMeshxThreadStruct*)handle->gate;
	my_thread=handle->id;
	num_threads=handle->num;

	/*recover parameters :*/
	contours=gate->contours;
	nods=gate->nods;
	edgevalue=gate->edgevalue;
	in_nod=gate->in_nod;
	x=gate->x;
	y=gate->y;

	/*distribute indices across threads :*/
	PartitionRange(&i0,&i1,nods,num_threads,my_thread);

	/*Loop through all contours: */
	for (i=0;i<contours->Size();i++){
		Contour* contour=(Contour*)contours->GetObjectByOffset(i);
		IsInPoly(in_nod,contour->x,contour->y,contour->nods,x,y,i0,i1,edgevalue);
	}

	return NULL;

}
