#module imports
from fielddisplay import fielddisplay

class geometry:
	#properties
	def __init__(self):
		# {{{ Properties
		self.surface           = float('NaN')
		self.thickness         = float('NaN')
		self.bed               = float('NaN')
		self.bathymetry        = float('NaN')
		self.hydrostatic_ratio = float('NaN')

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(obj):
		# {{{ Display

		string="   geometry parameters:"

		string="%s\n\n%s"%(string,fielddisplay(obj,'surface','surface elevation'))
		string="%s\n%s"%(string,fielddisplay(obj,'thickness','ice thickness'))
		string="%s\n%s"%(string,fielddisplay(obj,'bed','bed elevation'))
		string="%s\n%s"%(string,fielddisplay(obj,'bathymetry','bathymetry elevation'))
		string="%s\n%s"%(string,fielddisplay(obj,'hydrostatic_ratio','coefficient for ice shelves'' thickness correction: hydrostatic_ratio H_obs+ (1-hydrostatic_ratio) H_hydro'))
		return string
		#}}}
		
	def setdefaultparameters(obj):
		# {{{setdefaultparameters
		return obj
	#}}}

