#module imports
from fielddisplay import fielddisplay

class friction:
	#properties
	def __init__(self):
		# {{{ Properties
		self.coefficient = float('NaN')
		self.p           = float('NaN')
		self.q           = float('NaN')

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(obj):
		# {{{ Display
		string="Sigma= drag^2 * Neff ^r * u ^s, with Neff=rho_ice*g*thickness+rho_water*g*bed, r=q/p and s=1/p"
		string="%s\n\n%s"%(string,fielddisplay(obj,"coefficient","friction coefficient [SI]"))
		string="%s\n%s"%(string,fielddisplay(obj,"p","p exponent"))
		string="%s\n%s"%(string,fielddisplay(obj,"q","q exponent"))
		return string
		#}}}

	def setdefaultparameters(obj):
		# {{{setdefaultparameters
		return obj
	#}}}

