/*\file pythonio.h
 *\brief: I/O for ISSM in python mode
 */

#ifndef _PYTHON_IO_H_
#define _PYTHON_IO_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif 


#include "../../objects/objects.h"
#include "../../Container/Container.h"
#include "../../include/include.h"

class DataSet;
class Parameters;

//void WriteData(PyObject* py_tuple,DataSet* dataset);
//void WriteData(PyObject* py_tuple,int*    matrix, int M,int N);
//void WriteData(PyObject* py_tuple,double* vector, int M);
//void WriteData(PyObject* py_tuple,int integer);
//void WriteData(PyObject* py_tuple,bool boolean);
//void WriteData(PyObject* py_tuple,double scalar);
//void WriteData(DataHandle* py_tuple,Parameters* parameters);
void WriteData(PyObject* py_tuple, int index, double* matrix, int M,int N);
void WriteData(PyObject* py_tuple, int index, char* string);
void WriteData(PyObject* py_tuple, int index, Matrix* matrix);
void WriteData(PyObject* py_tuple, int index, Vector* vector);


//void FetchData(DataSet** pdataset,PyObject* py_ref);
//void FetchData(double** pmatrix,int* pnumel,int* pndims,int** psize,PyObject* py_ref);
//void FetchData(int** pmatrix,int* pM,int *pN,PyObject* py_ref);
//void FetchData(bool** pmatrix,int* pM,int *pN,PyObject* py_ref);
//void FetchData(bool** pmatrix,int* pnumel,int* pndims,int** psize,PyObject* py_ref);
//void FetchData(Matrix** pmatrix,PyObject* py_ref);
//void FetchData(int** pvector,int* pM,PyObject* py_ref);
//void FetchData(float** pvector,int* pM,PyObject* py_ref);
//void FetchData(bool** pvector,int* pM,PyObject* py_ref);
//void FetchData(Vector** pvector,PyObject* py_ref);
//void FetchData(char** pmatrix,int* pnumel,int* pndims,int** psize,PyObject* py_ref);
//void FetchData(Parameters** pparameters, DataHandle py_ref);
void FetchData(double** pvector,int* pM,PyObject* py_ref);
void FetchData(double** pmatrix,int* pM,int *pN,PyObject* py_array);
void FetchData(char** pstring,PyObject* py_unicode);
void FetchData(double* pscalar,PyObject* py_float);
void FetchData(int* pinteger,PyObject* py_long);
void FetchData(bool* pbool,PyObject* py_boolean);

int CheckNumPythonArguments(PyObject* inputs,int NRHS, void (*function)( void ));

#endif	/* _IO_H_ */
