#!/bin/bash

#Some cleanup
rm -rf src install gsl-1.15
mkdir src install

#Untar 
tar -zxvf  gsl-1.15.tar.gz

#Move gsl into src directory
mv gsl-1.15/* src
rm -rf gsl-1.15

#Configure gsl
cd src

./configure \
    CC=$ANDROID_DIR/arm-linux-android-4.0/bin/arm-linux-androideabi-gcc\
    LD=$ANDROID_DIR/arm-linux-android-4.0/bin/arm-linux-androideabi-ld\
    AR=$ANDROID_DIR/arm-linux-android-4.0/bin/arm-linux-androideabi-ar\
    RANLIB=$ANDROID_DIR/arm-linux-android-4.0/bin/arm-linux-androideabi-ranlib\
    NM=$ANDROID_DIR/arm-linux-android-4.0/bin/arm-linux-androideabi-nm\
    OBJ_EXT=o\
    LIB_EXT=a\
    --host="arm-linux"\
	--prefix="$ISSM_TIER/externalpackages/gsl/install" 

#Compile gsl
if [ -z $1 ]; then
	make
else
	make -j $1
fi

make install
