/*\file NodeConnectivity.c
 *\brief: build node connectivity from elements. 
 */

#include "./NodeConnectivity.h"

WRAPPER(NodeConnectivity){

	/*inputs: */
	double* elements=NULL;
	int     nel;
	int     nods;

	/*outputs: */
	double* connectivity=NULL;
	int     width;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments: */
	CHECKARGUMENTS(NLHS,NRHS,&NodeConnectivityUsage);
        
	/*Input datasets: */
	FetchData(&elements,&nel,NULL,ELEMENTS);
	FetchData(&nods,NUMNODES);

	/*!Generate internal degree of freedom numbers: */
	NodeConnectivityx(&connectivity, &width,elements,nel, nods);

	/*write output datasets: */
	WriteData(CONNECTIVITY,connectivity,nods,width);

	/*end module: */
	MODULEEND();
}

void NodeConnectivityUsage(void) {
	_printf_(true,"\n");
	_printf_(true,"   usage: connectivity = %s(elements, numnodes);\n",__FUNCT__);
	_printf_(true,"\n");
}
