function [u_g grad_g]=GradJCompute(m,inputs,analysis_type,sub_analysis_type);

%recover parameters
debug=m.parameters.debug;
dim=m.parameters.dim;
extrude_param=m.parameters.extrude_param;
ishutter=m.parameters.ishutter;
ismacayealpattyn=m.parameters.ismacayealpattyn;
isstokes=m.parameters.isstokes;

%Recover solution for this stiffness and right hand side: 
displaystring(debug,'%s','         computing velocities...');
[u_g K_ff0 K_fs0 ]=diagnostic_core_nonlinear(m,inputs,analysis_type,sub_analysis_type);
inputs=add(inputs,'velocity',u_g,'doublevec',m.parameters.numberofdofspernode,m.parameters.numberofnodes);

%Buid Du, difference between observed velocity and model velocity.
displaystring(debug,'%s','          computing Du...');
[Du_g]=Du(m.elements,m.nodes,m.loads,m.materials,m.parameters,inputs,analysis_type,sub_analysis_type);

%Reduce adjoint load from g-set to f-set
[Du_f] = Reduceloadfromgtof( Du_g, m.Gmn, K_fs0, m.ys0, m.nodesets);

%Solve for adjoint vector: 
displaystring(debug,'%s','          computing adjoint state...');
lambda_f=Solver(K_ff0,Du_f,[],m.parameters);

%Merge back to g set
lambda_g= Mergesolutionfromftog( lambda_f, m.Gmn, m.ys0, m.nodesets ); 
inputs=add(inputs,'adjoint',lambda_g,'doublevec',m.parameters.numberofdofspernode,m.parameters.numberofnodes);

%Compute gradJ 
grad_g=Gradj(m.elements,m.nodes,m.loads,m.materials,m.parameters,inputs,analysis_type,sub_analysis_type);

if (dim==3 & extrude_param),
	displaystring(debug,'%s','          extruding gradient...');
	grad_g=FieldExtrude(m.elements,m.nodes,m.loads,m.materials,grad_g,'gradj',0);
end
