/*
 * \file Loads.c
 * \brief: implementation of the Loads class, derived from DataSet class
 */

/*Headers: {{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <vector>
#include <functional>
#include <algorithm>
#include <iostream>

#include "./DataSet.h"
#include "../shared/shared.h"
#include "../include/include.h"
#include "../EnumDefinitions/EnumDefinitions.h"

using namespace std;
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION Loads::Loads(){{{1*/
Loads::Loads(){
	enum_type=LoadsEnum;
	return;
}
/*}}}*/
/*FUNCTION Loads::~Loads(){{{1*/
Loads::~Loads(){
	return;
}
/*}}}*/

/*Numerics:*/
/*FUNCTION Loads::Configure{{{1*/
void Loads::Configure(Elements* elements,Loads* loads, Nodes* nodes, Vertices* vertices, Materials* materials,Parameters* parameters){

	vector<Object*>::iterator object;
	Load* load=NULL;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		load=(Load*)(*object);
		load->Configure(elements,loads,nodes,vertices,materials,parameters);

	}

}
/*}}}*/
/*FUNCTION Loads::NumberOfLoads{{{1*/
int Loads::NumberOfLoads(void){

	int localloads=0;
	int numberofloads=0;

	/*Get number of local loads*/
	localloads=this->Size();

	/*figure out total number of loads combining all the cpus (no clones here)*/
	#ifdef _HAVE_MPI_
	MPI_Reduce(&localloads,&numberofloads,1,MPI_INT,MPI_SUM,0,MPI_COMM_WORLD );
	MPI_Bcast(&numberofloads,1,MPI_INT,0,MPI_COMM_WORLD);
	#else
	numberofloads=localloads;
	#endif


	return numberofloads;
}
/*}}}*/
/*FUNCTION Loads::SetCurrentConfiguration{{{1*/
void Loads::SetCurrentConfiguration(Elements* elements,Loads* loads, Nodes* nodes, Vertices* vertices, Materials* materials,Parameters* parameters){

	vector<Object*>::iterator object;
	Load* load=NULL;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		load=(Load*)(*object);
		load->SetCurrentConfiguration(elements,loads,nodes,vertices,materials,parameters);

	}

}
/*}}}*/
