function matpar = matpar(varargin)
%MATPAR - constructor for matpar object
%
%   Usage:
%      matpar= matpar(varargin)

switch nargin
case 0
	% if no input arguments, create a default object
	matpar.rho_ice=NaN;
	matpar.rho_water=NaN;
	matpar.heatcapacity=NaN;
	matpar.thermalconductivity=NaN;
	matpar.meltingpoint=NaN;
	matpar.latentheat=NaN;
	matpar.beta=NaN;
	matpar.mixed_layer_capacity=NaN;
	matpar.thermal_exchange_velocity=NaN;
	matpar.g=9.81;
	matpar=class(matpar,'matpar');
				
case 1
	%If single argument of class matpar, we have a copy constructor. 
	if (isa(varargin{1},'matpar'))
		matpar = varargin{1};
	else
		error('matpar constructor error message: copy constructor called on a non ''matpar'' class object');
	end 
otherwise
	error('matpar constructor error message: 0 of 1 argument only in input.');
end
