function display(triaelem)
%DISPLAY - displays the fields of a tria element
%
%   echo function for 'triaelem' class

disp(sprintf('\n%s = \n',inputname(1)));
disp(sprintf('   type: %s',triaelem.type));
disp(sprintf('   id: %i',triaelem.id));
disp(sprintf('   material id: %i',triaelem.matid));
disp(sprintf('   grid ids: %i %i %i',triaelem.g(1),triaelem.g(2),triaelem.g(3)));
disp(sprintf('   grids thickness: %g %g %g',triaelem.h(1),triaelem.h(2),triaelem.h(3)));
disp(sprintf('   grids surface: %g %g %g',triaelem.s(1),triaelem.s(2),triaelem.s(3)));
disp(sprintf('   grids bedrock: %g %g %g',triaelem.b(1),triaelem.b(2),triaelem.b(3)));
disp(sprintf('   friction type: %i',triaelem.friction_type));
disp(sprintf('   viscosity overshoot: %g',triaelem.viscosity_overshoot));
disp(sprintf('   p: %i',triaelem.p));
disp(sprintf('   q: %i',triaelem.q));
disp(sprintf('   drag coeff: %g %g %g',triaelem.k(1),triaelem.k(2),triaelem.k(3)));
disp(sprintf('   shelf: %i',triaelem.shelf));
disp(sprintf('   meanvel: %g',triaelem.meanvel));
disp(sprintf('   epsvel: %g',triaelem.epsvel));
disp(sprintf('   artificial_diffusivity: %i',triaelem.artificial_diffusivity));
