/*
 * TriMesh: mesh a domain using an .exp file
 */

#include "./TriMesh.h"

WRAPPER(TriMesh){
	
	/* input: */
	char   *domainname = NULL;
	char   *riftsname  = NULL;
	double  area;

	/*intermediary: */
	DataSet *domain = NULL;
	DataSet *rifts  = NULL;

	/* output: */
	Matrix *index             = NULL;
	Vector *x                 = NULL;
	Vector *y                 = NULL;
	Matrix *segments          = NULL;
	Vector *segmentmarkerlist = NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CHECKARGUMENTS(NLHS,NRHS,&TriMeshUsage);
	
	/*Fetch data needed for meshing: */
	FetchData(&domainname,DOMAINOUTLINE);
	FetchData(&riftsname,RIFTSOUTLINE);
	FetchData(&area,AREA);

	/*Read domain outline: */
	domain = DomainOutlineRead(domainname);
	rifts  = DomainOutlineRead(riftsname);

	/*call x core: */
	TriMeshx(&index,&x,&y,&segments,&segmentmarkerlist,domain,rifts,area);

	/*write outputs: */
	WriteData(INDEX,index);
	WriteData(X,x);
	WriteData(Y,y);
	WriteData(SEGMENTS,segments);
	WriteData(SEGMENTMARKERLIST,segmentmarkerlist);

	/*free ressources: */
	delete domain;
	delete rifts;
	xdelete_module(&index);
	xdelete_module(&x);
	xdelete_module(&y);
	xdelete_module(&segments);
	xdelete_module(&segmentmarkerlist);

	/*end module: */
	MODULEEND();
}

void TriMeshUsage(void) //{{{1
{
	printf("\n");
	printf("   usage: [index,x,y,segments,segmentmarkers]=TriMesh(domainoutlinefilename,rifts,area) \n");
	printf("      where: index,x,y defines a triangulation, segments is an array made \n");
	printf("      of exterior segments to the mesh domain outline, segmentmarkers is an array flagging each segment, \n");
	printf("      outlinefilename an Argus domain outline file, \n");
	printf("      area is the maximum area desired for any element of the resulting mesh, \n");
	printf("\n");
}
//}}}
