/*
 * TriMeshRifts: mesh a domain using an .exp file
 */

#include "./TriMeshRifts.h"

WRAPPER(TriMeshRifts){
	
	/* input: */
	char   *domainname = NULL;
	char   *riftsname  = NULL;
	double  area;
	bool    order;

	/*intermediary: */
	DataSet *domain = NULL;
	DataSet *rifts  = NULL;

	/* output: */
	Matrix *index             = NULL;
	Vector *x                 = NULL;
	Vector *y                 = NULL;
	Matrix *segments          = NULL;
	Vector *segmentmarkerlist = NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CHECKARGUMENTS(NLHS,NRHS,&TriMeshRiftsUsage);
	
	/*Fetch data needed for meshing: */
	FetchData(&domainname,DOMAINOUTLINE);
	FetchData(&riftsname,RIFTSOUTLINE);
	FetchData(&area,AREA);
	FetchData(&order,ORDER);

	/*Read domain outline: */
	domain = DomainOutlineRead(domainname,false);
	rifts  = DomainOutlineRead(riftsname,false);

	/*call x core: */
	TriMeshRiftsx(&index,&x,&y,&segments,&segmentmarkerlist,domain,rifts,area,order);
	
	/*write outputs: */
	WriteData(INDEX,index);
	WriteData(X,x);
	WriteData(Y,y);
	WriteData(SEGMENTS,segments);
	WriteData(SEGMENTMARKERLIST,segmentmarkerlist);

	/*free ressources: */
	delete domain;
	delete rifts;
	xdelete_module(&index);
	xdelete_module(&x);
	xdelete_module(&y);
	xdelete_module(&segments);
	xdelete_module(&segmentmarkerlist);

	/*end module: */
	MODULEEND();
}

void TriMeshRiftsUsage(void) //{{{1
{
	printf("\n");
	printf("   usage: [index,x,y,segments,segmentmarkers]=TriMeshRifts(domainoutlinefilename,area,ordered) \n");
	printf("      where: index,x,y defines a triangulation, segments is an array made \n");
	printf("      of exterior segments to the mesh domain outline, segmentmarkers is an array flagging each segment, \n");
	printf("      outlinefilename an Argus domain outline file, \n");
	printf("      area is the maximum area desired for any element of the resulting mesh, \n");
	printf("      and ordered is a bool that determines whether segments are output in the \n");
	printf("      order they are made by Triangle (ie none), or ordered counter clockwise around the domain outline.\n");
	printf("\n");
}
//}}}
