/*!\file TriMeshx
 * \brief: x code for TriMesh mesher
 */

/*Header files: {{{*/
#include "./TriMeshx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../io/io.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
/*ANSI_DECLARATORS needed to call triangle library: */
#ifndef ANSI_DECLARATORS
#define ANSI_DECLARATORS
#include "triangle.h"
#undef ANSI_DECLARATORS
#else
#include "triangle.h"
#endif
/*}}}*/


void TriMeshx(Matrix** pindex,Vector** px,Vector** py,Matrix** psegments,Vector** psegmentmarkerlist,DataSet* domain,double area,bool order){

	/*indexing: */
	int i,j;

	/*output: */
	double* index=NULL;
	Matrix* index_matrix=NULL;
	double* x=NULL;
	double* y=NULL;
	double* segments=NULL;
	Matrix* segments_matrix=NULL;
	double* segmentmarkerlist=NULL;

	/*intermediary: */
	int      counter,backcounter;
	Contour* contour=NULL;

	/* Triangle structures needed to call Triangle library routines: */
	struct triangulateio in,out;
	char   options[256];

	/*Create initial triangulation to call triangulate(). First number of points:*/
	in.numberofpoints=0;
	for (i=0;i<domain->Size();i++){
		contour=(Contour*)domain->GetObjectByOffset(i);
		in.numberofpoints+=contour->nods;
	}
	/*number of point attributes: */
	in.numberofpointattributes=1;

	/*fill in the point list: */
	in.pointlist = (REAL *) xmalloc(in.numberofpoints * 2 * sizeof(REAL));

	counter=0;
	for (i=0;i<domain->Size();i++){
		contour=(Contour*)domain->GetObjectByOffset(i);
		for (j=0;j<contour->nods;j++){
			in.pointlist[2*counter+0]=contour->x[j];
			in.pointlist[2*counter+1]=contour->y[j];
			counter++;
		}
	}
	
	/*fill in the point attribute list: */
	in.pointattributelist = (REAL *) xmalloc(in.numberofpoints * in.numberofpointattributes * sizeof(REAL));
	for (i=0;i<in.numberofpoints;i++) in.pointattributelist[i] = 0.0;
	
	/*fill in the point marker list: */
	in.pointmarkerlist = (int *) xmalloc(in.numberofpoints * sizeof(int));
	for(i=0;i<in.numberofpoints;i++) in.pointmarkerlist[i] = 0;


	/*Build segments. First figure out number of segments: holes and closed outlines have as many segments as vertices: */
	in.numberofsegments=0;
	for (i=0;i<domain->Size();i++){
		contour=(Contour*)domain->GetObjectByOffset(i);
		in.numberofsegments+=contour->nods;
	}
	
	in.segmentlist = (int *) xmalloc(in.numberofsegments * 2 * sizeof(int));
	in.segmentmarkerlist = (int *) xcalloc(in.numberofsegments,sizeof(int));
	counter=0;
	backcounter=0;
	for (i=0;i<domain->Size();i++){
		contour=(Contour*)domain->GetObjectByOffset(i);
		for (j=0;j<contour->nods-1;j++){
			in.segmentlist[2*counter+0]=counter;
			in.segmentlist[2*counter+1]=counter+1;
			in.segmentmarkerlist[counter]=0;
			counter++;
		}
		/*Close this profile: */
		 in.segmentlist[2*counter+0]=counter;
		 in.segmentlist[2*counter+1]=backcounter;
		 in.segmentmarkerlist[counter]=0;
		 counter++;
		 backcounter=counter;
	}

	
	/*Build regions: */
	in.numberofregions = 0;

	/*Build holes: */
	in.numberofholes = domain->Size()-1; /*everything is a hole, but for the first profile.*/
	if(in.numberofholes){
		in.holelist = (REAL *) xmalloc(in.numberofholes * 2 * sizeof(REAL));
		for (i=0;i<domain->Size()-1;i++){
			contour=(Contour*)domain->GetObjectByOffset(i+1);
			GridInsideHole(&in.holelist[2*i+0],&in.holelist[2*i+1],contour->nods,contour->x,contour->y);
		}
	}

	/* Make necessary initializations so that Triangle can return a triangulation in `out': */

	out.pointlist = (REAL *) NULL;            
	out.pointattributelist = (REAL *) NULL;
	out.pointmarkerlist = (int *) NULL; 
	out.trianglelist = (int *) NULL;          
	out.triangleattributelist = (REAL *) NULL;
	out.neighborlist = (int *) NULL;         
	out.segmentlist = (int *) NULL;
	out.segmentmarkerlist = (int *) NULL;
	out.edgelist = (int *) NULL;             
	out.edgemarkerlist = (int *) NULL;   

	/* Triangulate the points:.  Switches are chosen to read and write a  */
	/*   PSLG (p), preserve the convex hull (c), number everything from  */
	/*   zero (z), assign a regional attribute to each element (A), and  */
	/*   produce an edge list (e), a Voronoi diagram (v), and a triangle */
	/*   neighbor list (n).                                              */

	sprintf(options,"%s%lf","pQzDq30ia",area); /*replace V by Q to quiet down the logging*/

  
	triangulate(options, &in, &out, NULL);

	/*report(&out, 0, 1, 1, 1, 1, 0);*/


	/*Allocate index, x and y: */
	index=(double*)xmalloc(3*out.numberoftriangles*sizeof(double));
	x=(double*)xmalloc(out.numberofpoints*sizeof(double));
	y=(double*)xmalloc(out.numberofpoints*sizeof(double));
	segments=(double*)xmalloc(3*out.numberofsegments*sizeof(double));
	segmentmarkerlist=(double*)xmalloc(out.numberofsegments*sizeof(double));

	for (i = 0; i < out.numberoftriangles; i++) {
		for (j = 0; j < out.numberofcorners; j++) {
			*(index+3*i+j)=(double)out.trianglelist[i * out.numberofcorners + j]+1;
		}
	}
	for (i = 0; i < out.numberofpoints; i++) {
		x[i]=out.pointlist[i * 2 + 0];
		y[i]=out.pointlist[i * 2 + 1];
	}
	
	for (i = 0; i < out.numberofsegments; i++) {
		segments[3*i+0]=(double)out.segmentlist[i*2+0]+1;
		segments[3*i+1]=(double)out.segmentlist[i*2+1]+1;
		segmentmarkerlist[i]=(double)out.segmentmarkerlist[i];
	}



	/*Associate elements with segments: */
	AssociateSegmentToElement(&segments,out.numberofsegments,index,out.numberoftriangles);

	/*Order segments so that their normals point outside the domain: */
	if(order){
		OrderSegments(&segments,out.numberofsegments, index,out.numberoftriangles);
	}


	/*Output : */
	index_matrix=new Matrix(index,out.numberoftriangles,3,1); 
	index_matrix->Convert(DENSE_SEQUENTIAL);
	*pindex=index_matrix;
	
	segments_matrix=new Matrix(segments,out.numberofsegments,3,1); segments_matrix->Convert(DENSE_SEQUENTIAL);
	*psegments=segments_matrix;

	*px=new Vector(x,out.numberofpoints);
	*py=new Vector(y,out.numberofpoints);
	*psegmentmarkerlist=new Vector(segmentmarkerlist,out.numberofsegments);

}
