#module imports
from fielddisplay import fielddisplay

class settings:
	#properties
	def __init__(self):
		# {{{ Properties
		self.io_gather           = 0;
		self.lowmem              = 0;
		self.results_as_patches  = 0;
		self.output_frequency    = 0;
		self.waitonlock          = 0;
		#}}}
	def __repr__(obj):
		# {{{ Display
		string="   general settings parameters:"

		string="%s\n%s"%(string,fielddisplay(obj,"io_gather","I/O gathering strategy for result outputs (default 1)"))
		string="%s\n%s"%(string,fielddisplay(obj,"lowmem","is the memory limited ? (0 or 1)"))
		string="%s\n%s"%(string,fielddisplay(obj,"results_as_patches","provide results as patches for each element (0 or 1)"))
		string="%s\n%s"%(string,fielddisplay(obj,"output_frequency","frequency at which results are saved in all solutions with multiple time_steps"))
		string="%s\n%s"%(string,fielddisplay(obj,"waitonlock","maximum number of minutes to wait for batch results, or return 0"))
		return string
		#}}}
