/*
	TriMesh.h
*/

#ifndef _TRIMESH_H
#define _TRIMESH_H

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

/*Very important definition in case we are compiling a python module!: needs to come before header files inclusion*/
#ifdef _HAVE_PYTHON_
#define PY_ARRAY_UNIQUE_SYMBOL PythonIOSymbol
#endif

/*Header files: */
#include "../../c/include/globals.h"
#include "../../c/toolkits/toolkits.h"
#include "../../c/include/include.h"
#include "../../c/modules/modules.h"
#include "../../c/Container/Container.h"
#include "../../c/shared/shared.h"
#include "../../c/issm-binding.h"
#include "../../c/io/io.h"
#include "../../c/EnumDefinitions/EnumDefinitions.h"

#ifdef _HAVE_MATLAB_
/* serial input macros: */
#define DOMAINOUTLINE  (mxArray *)prhs[0]
#define AREA           (mxArray *)prhs[1]
#define ORDER          (mxArray *)prhs[2]
/* serial output macros: */
#define INDEX             (mxArray**)&plhs[0]
#define X                 (mxArray**)&plhs[1]
#define Y                 (mxArray**)&plhs[2]
#define SEGMENTS          (mxArray**)&plhs[3]
#define SEGMENTMARKERLIST (mxArray**)&plhs[4]
#endif

#ifdef _HAVE_PYTHON_
/* serial input macros: */
#define DOMAINOUTLINE PyTuple_GetItem(args,0)
#define AREA          PyTuple_GetItem(args,1)
#define ORDER         PyTuple_GetItem(args,2)
/* serial output macros: */
#define INDEX             output,0
#define X                 output,1
#define Y                 output,2
#define SEGMENTS          output,3
#define SEGMENTMARKERLIST output,4
#endif

#undef __FUNCT__ 
#define __FUNCT__  "TriMesh"

/* serial arg counts: */
#undef NLHS
#define NLHS  5
#undef NRHS
#define NRHS  3

/* local prototypes: */
void TriMeshUsage(void);

#endif  /* _TRIMESH_H */
