/* \file matlab macros.h
 * \brief: macros used for the matlab bindings
 */

/*Header {{{1*/
#ifndef _MATLAB_MACROS_H_
#define _MATLAB_MACROS_H_

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif
/*}}}*/

/* MODULEBOOT/MODULEEND {{{1*/

/*The following macros hide the error exception handling in a matlab module. Just put 
 * MODULEBOOT(); and MODULEEND(); at the beginning and end of a module, and c++ exceptions 
 * will be trapped. Really nifty!*/

#define MODULEBOOT(); ModuleBoot(); \
	try{

#define MODULEEND(); ModuleEnd(); }\
	catch(ErrorException &exception){\
		exception.Report(); \
		mexErrMsgTxt(""); \
	}\
	catch (exception& e) {\
		_printf_(true,"Standard exception: %s\n",e.what());\
		mexErrMsgTxt(" ");\
	}
//}}}
/* WRAPPER {{{1*/
#ifdef _HAVE_MATLAB_
#define WRAPPER(modulename,...) void mexFunction(int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]) 
#endif

/*}}}*/
/* CHECKARGUMENTS {{{1*/
#ifdef _HAVE_MATLAB_
#define CHECKARGUMENTS(NLHS,NRHS,functionpointer) CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,functionpointer)
#endif
/*}}}*/

#endif
