/*! \file ControlInput.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _CONTROLINPUT_H_
#define _CONTROLINPUT_H_

/*Headers:*/
/*{{{1*/
#include "./Input.h"
#include "../../include/include.h"
class GaussTria;
/*}}}*/

class ControlInput: public Input{

	public:
		int    enum_type;
		int    control_id;
		Input* values;
		Input* savedvalues;
		Input* minvalues;
		Input* maxvalues;
		Input* gradient;

		/*ControlInput constructors, destructors: {{{1*/
		ControlInput();
		ControlInput(int enum_type,int enum_input,double* pvalues,double* pmin,double* pmax,int id);
		~ControlInput();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*ControlInput management: {{{1*/
		int    InstanceEnum();
		Input* SpawnTriaInput(int* indices);
		Input* PointwiseDivide(Input* inputB){_error_("not implemented yet");};
		Input* PointwiseMin(Input* inputB){_error_("not implemented yet");};
		Input* PointwiseMax(Input* inputB){_error_("not implemented yet");};
		ElementResult* SpawnResult(int step, double time);
		void AddTimeValues(double* values,int step,double time){_error_("not supported yet");};
		void Configure(Parameters* parameters);
		/*}}}*/
		/*numerics: {{{1*/
		void SetInput(Input* in_input);
		void GetInputValue(bool* pvalue);
		void GetInputValue(int* pvalue);
		void GetInputValue(double* pvalue);
		void GetInputValue(double* pvalue,GaussTria* gauss);
		void GetInputValue(double* pvalue,GaussPenta* gauss);
		void GetInputValue(double* pvalue,GaussTria* gauss ,int index){_error_("not implemented yet");};
		void GetInputValue(double* pvalue,GaussPenta* gauss ,int index){_error_("not implemented yet");};
		void GetInputDerivativeValue(double* derivativevalues, double* xyz_list, GaussTria* gauss);
		void GetInputDerivativeValue(double* derivativevalues, double* xyz_list, GaussPenta* gauss);
		void GetInputAverage(double* pvalue);
		void GetVxStrainRate2d(double* epsilonvx,double* xyz_list, GaussTria* gauss){_error_("not implemented yet");};
		void GetVyStrainRate2d(double* epsilonvy,double* xyz_list, GaussTria* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3d(double* epsilonvx,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3d(double* epsilonvy,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVzStrainRate3d(double* epsilonvz,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3dPattyn(double* epsilonvx,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3dPattyn(double* epsilonvy,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void ChangeEnum(int newenumtype){_error_("not implemented yet");};
		void SquareMin(double* psquaremin, bool process_units,Parameters* parameters){_error_("not implemented yet");};
		void ConstrainMin(double minimum){_error_("not implemented yet");};
		void Scale(double scale_factor){_error_("not implemented yet");};
		void ArtificialNoise(double min,double max){_error_("not implemented yet");};
		void AXPY(Input* xinput,double scalar){_error_("not implemented yet");};
		void Constrain(void);
		void Constrain(double min,double max);
		double InfinityNorm(void){_error_("not implemented yet");};
		double Max(void){_error_("not implemented yet");};
		double MaxAbs(void){_error_("not implemented yet");};
		double Min(void){_error_("not implemented yet");};
		double MinAbs(void){_error_("not implemented yet");};
		void Extrude(void);
		void VerticallyIntegrate(Input* thickness_input);
		void GetVectorFromInputs(Vector* vector,int* doflist,const char* data);
		void GetVectorFromInputs(Vector* vector,int* doflist);
		void GetValuesPtr(double** pvalues,int* pnum_values){_error_("not implemented yet");};
		ElementResult* SpawnGradient(int step, double time);
		void GetGradient(Vector* gradient_vec,int* doflist);
		void ScaleGradient(double scale);
		void SetGradient(Input* gradient_in);
		void UpdateValue(double scalar);
		void SaveValue(void);
		/*}}}*/

};
#endif  /* _CONTROLINPUT_H */
