/*!\file VectorParam.c
 * \brief: implementation of the VectorParam object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*VectorParam constructors and destructor*/
/*FUNCTION VectorParam::VectorParam(){{{1*/
VectorParam::VectorParam(){
	return;
}
/*}}}*/
/*FUNCTION VectorParam::VectorParam(int enum_type,IssmVector value){{{1*/
VectorParam::VectorParam(int in_enum_type,Vector* in_value){

	enum_type=in_enum_type;

	value=NULL;

	if(in_value){
		value=in_value->Duplicate();
		in_value->Copy(value);
	}
}
/*}}}*/
/*FUNCTION VectorParam::~VectorParam(){{{1*/
VectorParam::~VectorParam(){
	xdelete(&value);
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION VectorParam::Echo {{{1*/
void VectorParam::Echo(void){

	printf("VectorParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));

}
/*}}}*/
/*FUNCTION VectorParam::DeepEcho{{{1*/
void VectorParam::DeepEcho(void){

	int i;
	printf("VectorParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	value->Echo();
}
/*}}}*/
/*FUNCTION VectorParam::Id{{{1*/
int    VectorParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION VectorParam::MyRank{{{1*/
int    VectorParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION VectorParam::ObjectEnum{{{1*/
int VectorParam::ObjectEnum(void){

	return VectorParamEnum;

}
/*}}}*/
/*FUNCTION VectorParam::copy{{{1*/
Object* VectorParam::copy() {
	
	return new VectorParam(this->enum_type,this->value);

}
/*}}}*/

/*VectorParam virtual functions definitions: */
/*FUNCTION VectorParam::GetParameterValue{{{1*/
void  VectorParam::GetParameterValue(Vector** poutput){
	Vector*  output=NULL;

	if(value){
		output=value->Duplicate();
		value->Copy(output);
	}
	*poutput=output;
}
/*}}}*/
/*FUNCTION VectorParam::GetParameterName{{{1*/
void VectorParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION VectorParam::SetValue{{{1*/
void  VectorParam::SetValue(Vector* vector){

	/*avoid leak: */
	xdelete(&value);
	
	/*copy: */
	value=vector->Duplicate();
	vector->Copy(value);
}
/*}}}*/
/*FUNCTION VectorParam::UnitConversion{{{1*/
void  VectorParam::UnitConversion(int direction_enum){
	/*do nothing, no unit conversion*/
}
/*}}}*/
