/*!\file MatrixParam.c
 * \brief: implementation of the MatrixParam object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*MatrixParam constructors and destructor*/
/*FUNCTION MatrixParam::MatrixParam(){{{1*/
MatrixParam::MatrixParam(){
	return;
}
/*}}}*/
/*FUNCTION MatrixParam::MatrixParam(int enum_type,Matrix* value){{{1*/
MatrixParam::MatrixParam(int in_enum_type,Matrix* in_value){

	enum_type=in_enum_type;
	value=NULL;

	if(in_value){
		value=in_value->Duplicate();
	}
}
/*}}}*/
/*FUNCTION MatrixParam::~MatrixParam(){{{1*/
MatrixParam::~MatrixParam(){
	xdelete(&value);
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION MatrixParam::Echo {{{1*/
void MatrixParam::Echo(void){

	printf("MatrixParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));

}
/*}}}*/
/*FUNCTION MatrixParam::DeepEcho{{{1*/
void MatrixParam::DeepEcho(void){

	int i;
	printf("MatrixParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	this->value->Echo();
}
/*}}}*/
/*FUNCTION MatrixParam::Id{{{1*/
int    MatrixParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION MatrixParam::MyRank{{{1*/
int    MatrixParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION MatrixParam::ObjectEnum{{{1*/
int MatrixParam::ObjectEnum(void){

	return MatrixParamEnum;

}
/*}}}*/
/*FUNCTION MatrixParam::copy{{{1*/
Object* MatrixParam::copy() {
	
	return new MatrixParam(this->enum_type,this->value);

}
/*}}}*/

/*MatrixParam virtual functions definitions: */
/*FUNCTION MatrixParam::GetParameterValue{{{1*/
void  MatrixParam::GetParameterValue(Matrix** poutput){
	Matrix* output=NULL;

	if(value){
		output=value->Duplicate();
	}
	*poutput=output;
}
/*}}}*/
/*FUNCTION MatrixParam::GetParameterName{{{1*/
void MatrixParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION MatrixParam::SetValue{{{1*/
void  MatrixParam::SetValue(Matrix* matrix){
	
	/*avoid leak: */
	xdelete(&value);
	
	/*copy: */
	value=matrix->Duplicate();
}
/*}}}*/
/*FUNCTION MatrixParam::UnitConversion{{{1*/
void  MatrixParam::UnitConversion(int direction_enum){
	/*do nothing, no unit conversion*/
}
/*}}}*/
