/*!\file IntVecParam.c
 * \brief: implementation of the IntVecParam object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*IntVecParam constructors and destructor*/
/*FUNCTION IntVecParam::IntVecParam(){{{1*/
IntVecParam::IntVecParam(){
	return;
}
/*}}}*/
/*FUNCTION IntVecParam::IntVecParam(int enum_type,int* values,int M){{{1*/
IntVecParam::IntVecParam(int in_enum_type,int* in_values, int in_M){

	enum_type=in_enum_type;
	M=in_M;

	if(M){
		values=(int*)xmalloc(M*sizeof(int));
		memcpy(values,in_values,M*sizeof(int));
	}
	else values=NULL;
}
/*}}}*/
/*FUNCTION IntVecParam::IntVecParam(int enum_type,double* values,int M){{{1*/
IntVecParam::IntVecParam(int in_enum_type,double* in_values, int in_M){

	enum_type=in_enum_type;
	M=in_M;

	if(M){
		values=(int*)xmalloc(M*sizeof(int));
		for(int i=0;i<in_M;i++) values[i]=(int)in_values[i];
	}
	else values=NULL;
}
/*}}}*/
/*FUNCTION IntVecParam::~IntVecParam(){{{1*/
IntVecParam::~IntVecParam(){
	xfree((void**)&values);
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION IntVecParam::Echo {{{1*/
void IntVecParam::Echo(void){

	printf("IntVecParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   vector size: %i\n",this->M);

}
/*}}}*/
/*FUNCTION IntVecParam::DeepEcho{{{1*/
void IntVecParam::DeepEcho(void){

	int i;
	
	printf("IntVecParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   vector size: %i\n",this->M);
	for(i=0;i<this->M;i++){
		printf("%i %i\n",i,this->values[i]);
	}
}
/*}}}*/
/*FUNCTION IntVecParam::Id{{{1*/
int    IntVecParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION IntVecParam::MyRank{{{1*/
int    IntVecParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION IntVecParam::ObjectEnum{{{1*/
int IntVecParam::ObjectEnum(void){

	return IntVecParamEnum;

}
/*}}}*/
/*FUNCTION IntVecParam::copy{{{1*/
Object* IntVecParam::copy() {
	
	return new IntVecParam(this->enum_type,this->values,this->M);

}
/*}}}*/

/*IntVecParam virtual functions definitions: */
/*FUNCTION IntVecParam::GetParameterValue{{{1*/
void  IntVecParam::GetParameterValue(int** pintarray,int* pM){
	int* output=NULL;

	if(M){
		output=(int*)xmalloc(M*sizeof(int));
		memcpy(output,values,M*sizeof(int));
	}

	/*Assign output pointers:*/
	if(pM) *pM=M;
	*pintarray=output;
}
/*}}}*/
/*FUNCTION IntVecParam::GetParameterName{{{1*/
void IntVecParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION IntVecParam::SetValue{{{1*/
void  IntVecParam::SetValue(int* intarray,int in_M){

	/*avoid leak: */
	xfree((void**)&this->values);

	if(in_M){
		this->values=(int*)xmalloc(in_M*sizeof(int));
		memcpy(this->values,intarray,in_M*sizeof(int));
	}
	else this->values=NULL;

	this->M=in_M;
}
/*}}}*/
/*FUNCTION IntVecParam::UnitConversion{{{1*/
void  IntVecParam::UnitConversion(int direction_enum){
	/*do nothing, no unit conversion*/
}
/*}}}*/
