/*! \file DoubleParam.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _DOUBLEPARAM_H_
#define _DOUBLEPARAM_H_

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./Param.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
/*}}}*/

class DoubleParam: public Param{

	private: 
		/*just hold 3 values for 3 vertices: */
		int enum_type;
		IssmDouble value;

	public:
		/*DoubleParam constructors, destructors: {{{1*/
		DoubleParam();
		DoubleParam(int enum_type,IssmDouble value);
		~DoubleParam();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*Param vritual function definitions: {{{1*/
		int   InstanceEnum(){return enum_type;}
		void  GetParameterValue(bool* pbool);
		void  GetParameterValue(int* pinteger);
		void  GetParameterValue(int** pintarray,int* pM);
		void  GetParameterValue(int** pintarray,int* pM,int* pN);
		void  GetParameterValue(double* pdouble){*pdouble=value;}
		void  GetParameterValue(char** pstring){_error_("Double param of enum %i (%s) cannot return a string",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(char*** pstringarray,int* pM){_error_("Double param of enum %i (%s) cannot return a string array",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM);
		void  GetParameterValue(double** pdoublearray,int* pM, int* pN);
		void  GetParameterValue(double*** parray, int* pM,int** pmdims, int** pndims){_error_("Double param of enum %i (%s) cannot return a matrix array",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(Vector** pvec){_error_("Double param of enum %i (%s) cannot return a Vec",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(Matrix** pmat){_error_("Double param of enum %i (%s) cannot return a Mat",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(FILE** pfid){_error_("Double param of enum %i (%s) cannot return a FILE",enum_type,EnumToStringx(enum_type));}

		void  SetValue(bool boolean){this->value=(double)boolean;}
		void  SetValue(int integer){this->value=(double)integer;}
		void  SetValue(double scalar){this->value=(double)scalar;}
		void  SetValue(char* string){_error_("Double param of enum %i (%s) cannot hold a string",enum_type,EnumToStringx(enum_type));}
		void  SetValue(char** stringarray,int M){_error_("Double param of enum %i (%s) cannot hold a string array",enum_type,EnumToStringx(enum_type));}
		void  SetValue(double* doublearray,int M){_error_("Double param of enum %i (%s) cannot hold a double array",enum_type,EnumToStringx(enum_type));}
		void  SetValue(double* pdoublearray,int M,int N){_error_("Double param of enum %i (%s) cannot hold a double array",enum_type,EnumToStringx(enum_type));}
		void  SetValue(int* intarray,int M){_error_("Double param of enum %i (%s) cannot hold a int array",enum_type,EnumToStringx(enum_type));}
		void  SetValue(int* pintarray,int M,int N){_error_("Double param of enum %i (%s) cannot hold a int array",enum_type,EnumToStringx(enum_type));}
		void  SetValue(Vector* vec){_error_("Double param of enum %i (%s) cannot hold a Vec",enum_type,EnumToStringx(enum_type));}
		void  SetValue(Matrix* mat){_error_("Double param of enum %i (%s) cannot hold a Mat",enum_type,EnumToStringx(enum_type));}
		void  SetValue(FILE* fid){_error_("Double param of enum %i (%s) cannot hold a FILE",enum_type,EnumToStringx(enum_type));}
		void  SetValue(double** array, int M, int* mdim_array, int* ndim_array){_error_("Double param of enum %i (%s) cannot hold an array of matrices",enum_type,EnumToStringx(enum_type));}
		void  UnitConversion(int direction_enum);

		void GetParameterName(char**pname);

		/*}}}*/
};
#endif  /* _DOUBLEPARAM_H */
