/*!\file DoubleMatParam.c
 * \brief: implementation of the DoubleMatParam object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*DoubleMatParam constructors and destructor*/
/*FUNCTION DoubleMatParam::DoubleMatParam(){{{1*/
DoubleMatParam::DoubleMatParam(){
	return;
}
/*}}}*/
/*FUNCTION DoubleMatParam::DoubleMatParam(int enum_type,IssmDoubleMat value){{{1*/
DoubleMatParam::DoubleMatParam(int in_enum_type,double* in_value, int in_M,int in_N){

	enum_type=in_enum_type;
	M=in_M;
	N=in_N;

	value=(double*)xmalloc(M*N*sizeof(double));
	memcpy(value,in_value,M*N*sizeof(double));
}
/*}}}*/
/*FUNCTION DoubleMatParam::~DoubleMatParam(){{{1*/
DoubleMatParam::~DoubleMatParam(){
	xfree((void**)&value);
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION DoubleMatParam::Echo {{{1*/
void DoubleMatParam::Echo(void){

	printf("DoubleMatParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   matrix size: %ix%i\n",this->M,this->N);

}
/*}}}*/
/*FUNCTION DoubleMatParam::DeepEcho{{{1*/
void DoubleMatParam::DeepEcho(void){

	int i,j;
	
	printf("DoubleMatParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   matrix size: %ix%i\n",this->M,this->N);
	for(i=0;i<this->M;i++){
		for(i=0;i<this->N;i++){
			printf("%i %i %g\n",i,j,*(this->value+N*i+j));
		}
	}
}
/*}}}*/
/*FUNCTION DoubleMatParam::Id{{{1*/
int    DoubleMatParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DoubleMatParam::MyRank{{{1*/
int    DoubleMatParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION DoubleMatParam::ObjectEnum{{{1*/
int DoubleMatParam::ObjectEnum(void){

	return DoubleMatParamEnum;

}
/*}}}*/
/*FUNCTION DoubleMatParam::copy{{{1*/
Object* DoubleMatParam::copy() {
	
	return new DoubleMatParam(this->enum_type,this->value,this->M,this->N);

}
/*}}}*/

/*DoubleMatParam virtual functions definitions: */
/*FUNCTION DoubleMatParam::GetParameterValue(double** pdoublearray,int* pM,int* pN){{{1*/
void  DoubleMatParam::GetParameterValue(double** pdoublearray,int* pM,int* pN){
	double* output=NULL;

	output=(double*)xmalloc((int)(M*N*sizeof(double)));
	memcpy(output,value,M*N*sizeof(double));

	/*Assign output pointers:*/
	if(pM) *pM=M;
	if(pN) *pN=N;
	*pdoublearray=output;
}
/*}}}*/
/*FUNCTION DoubleMatParam::GetParameterValue(int** pintarray,int* pM,int* pN){{{1*/
void  DoubleMatParam::GetParameterValue(int** pintarray,int* pM,int* pN){
#if defined(_HAVE_MATLAB_) && defined(_SERIAL_)
	int* output=NULL;
	int  i;

	output=(int*)xmalloc((int)(M*N*sizeof(int)));
	for(i=0;i<M*N;i++) output[i]=(int)value[i];

	/*Assign output pointers:*/
	if(pM) *pM=M;
	if(pN) *pN=N;
	*pintarray=output;
#else
	_error_("DoubleMat of enum %i (%s) cannot return an array of int",enum_type,EnumToStringx(enum_type));
#endif
}
/*}}}*/
/*FUNCTION DoubleMatParam::GetParameterName{{{1*/
void DoubleMatParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION DoubleMatParam::SetValue{{{1*/
void  DoubleMatParam::SetValue(double* doublearray,int in_M,int in_N){

	/*avoid leak: */
	xfree((void**)&this->value);

	this->value=(double*)xmalloc(in_M*in_N*sizeof(double));
	memcpy(this->value,doublearray,in_M*in_N*sizeof(double));

	this->M=in_M;
	this->N=in_N;
}
/*}}}*/
/*FUNCTION DoubleMatParam::UnitConversion{{{1*/
void  DoubleMatParam::UnitConversion(int direction_enum){
	::UnitConversion(this->value,this->M*this->N,direction_enum,this->enum_type);
}
/*}}}*/
		
/*diverse: */
/*FUNCTION DoubleMatParam::GetPointer{{{1*/
double* DoubleMatParam::GetPointer(void){
	return this->value;
}
/*}}}*/
