/*! \file IntExternalResult.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _INTEXTERNALRESULT_H_
#define _INTEXTERNALRESULT_H_

/*Headers:*/
/*{{{1*/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./ExternalResult.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
/*}}}*/

class IntExternalResult: public ExternalResult{

	public:
		int    id;
		int    enum_type;
		int    value;
		int    step;
		double time;


		/*IntExternalResult constructors, destructors: {{{1*/
		IntExternalResult();
		IntExternalResult(int id,int enum_type,int value,int step,double time);
		~IntExternalResult();

		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*ExternalResult managemnet: {{{1*/
		int   InstanceEnum(){return enum_type;}
		void  WriteData(FILE* fid,bool io_gather);
		void  GetResultName(char**);
		int   GetStep(void);
		/*}}}*/
};
#endif  /* _INTEXTERNALRESULT_H */
