/*!\file IntExternalResult.c
 * \brief: implementation of the IntExternalResult object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*IntExternalResult constructors and destructor*/
/*FUNCTION IntExternalResult::IntExternalResult(){{{1*/
IntExternalResult::IntExternalResult(){
	return;
}
/*}}}*/
/*FUNCTION IntExternalResult::IntExternalResult(int in_id, int in_enum_type,int in_value,int in_step, double in_time){{{1*/
IntExternalResult::IntExternalResult(int in_id, int in_enum_type,int in_value,int in_step, double in_time){

	id=in_id;
	enum_type=in_enum_type;
	value=in_value;
	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION IntExternalResult::~IntExternalResult(){{{1*/
IntExternalResult::~IntExternalResult(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION IntExternalResult::Echo {{{1*/
void IntExternalResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION IntExternalResult::DeepEcho{{{1*/
void IntExternalResult::DeepEcho(void){

	printf("IntExternalResult:\n");
	printf("   id: %i\n",this->id);
	printf("   enum:  %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   value: %i\n",this->value);
	printf("   step: %i\n",this->step);
	printf("   time: %g\n",this->time);
}
/*}}}*/
/*FUNCTION IntExternalResult::Id{{{1*/
int    IntExternalResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION IntExternalResult::MyRank{{{1*/
int    IntExternalResult::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION IntExternalResult::ObjectEnum{{{1*/
int IntExternalResult::ObjectEnum(void){

	return IntExternalResultEnum;

}
/*}}}*/
/*FUNCTION IntExternalResult::copy{{{1*/
Object* IntExternalResult::copy() {
	
	return new IntExternalResult(this->id,this->enum_type,this->value,this->step,this->time);

}
/*}}}*/

/*IntExternalResult management: */
/*FUNCTION IntExternalResult::WriteData{{{1*/
void   IntExternalResult::WriteData(FILE* fid,bool io_gather){

	int     length;
	int     type;
	int     size;
	char   *name    = NULL;
	double  integer;
	extern  int my_rank;

	/*return if now on cpu 0: */
	if(my_rank)return;

	/*First write enum: */
	EnumToStringx(&name,this->enum_type);
	length=(strlen(name)+1)*sizeof(char);
	fwrite(&length,sizeof(int),1,fid);
	fwrite(name,length,1,fid);
	xfree((void**)&name);

	/*Now write time and step: */
	fwrite(&time,sizeof(double),1,fid);
	fwrite(&step,sizeof(int),1,fid);

	/*cast to a double: */
	integer=(double)this->value;

	/*writing a double, type is 1, size is 1: */
	type=1;
	size=1;
	fwrite(&type,sizeof(int),1,fid);
	fwrite(&size,sizeof(int),1,fid);
	fwrite(&integer,size*sizeof(double),1,fid);

}
/*}}}1*/
/*FUNCTION IntExternalResult::GetResultName{{{1*/
void IntExternalResult::GetResultName(char** pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION IntExternalResult::GetStep{{{1*/
int IntExternalResult::GetStep(void){

	return this->step;
}
/*}}}*/
