/*!\file BamgOpts.cpp
 */

#include <stdio.h>
#include "../../../objects/objects.h"
#include "../../../io/io.h"
#include "../../../shared/shared.h"
#include "../../io/matlabio.h"
#include "../../../include/include.h"

/*Constructors/Destructors*/
/*FUNCTION BamgOpts::BamgOpts(void* module_struct){{{1*/
BamgOpts::BamgOpts(void* module_struct){
	
	mxArray*    matlab_struct=NULL;

	/*recover pointer: */
	matlab_struct=(mxArray*)module_struct;

	FetchData(&this->anisomax,mxGetField(matlab_struct,0,"anisomax"));
	FetchData(&this->cutoff,mxGetField(matlab_struct,0,"cutoff"));
	FetchData(&this->coeff,mxGetField(matlab_struct,0,"coeff"));
	FetchData(&this->errg,mxGetField(matlab_struct,0,"errg"));
	FetchData(&this->gradation,mxGetField(matlab_struct,0,"gradation"));
	FetchData(&this->Hessiantype,mxGetField(matlab_struct,0,"Hessiantype"));
	FetchData(&this->MaxCornerAngle,mxGetField(matlab_struct,0,"MaxCornerAngle"));
	FetchData(&this->maxnbv,mxGetField(matlab_struct,0,"maxnbv"));
	FetchData(&this->maxsubdiv,mxGetField(matlab_struct,0,"maxsubdiv"));
	FetchData(&this->Metrictype,mxGetField(matlab_struct,0,"Metrictype"));
	FetchData(&this->nbjacobi,mxGetField(matlab_struct,0,"nbjacobi"));
	FetchData(&this->nbsmooth,mxGetField(matlab_struct,0,"nbsmooth"));
	FetchData(&this->omega,mxGetField(matlab_struct,0,"omega"));
	FetchData(&this->power,mxGetField(matlab_struct,0,"power"));
	FetchData(&this->verbose,mxGetField(matlab_struct,0,"verbose"));

	FetchData(&this->Crack,mxGetField(matlab_struct,0,"Crack"));
	FetchData(&this->geometricalmetric,mxGetField(matlab_struct,0,"geometricalmetric"));
	FetchData(&this->KeepVertices,mxGetField(matlab_struct,0,"KeepVertices"));
	FetchData(&this->splitcorners,mxGetField(matlab_struct,0,"splitcorners"));

	FetchData(&this->hmin,mxGetField(matlab_struct,0,"hmin"));
	FetchData(&this->hmax,mxGetField(matlab_struct,0,"hmax"));
	FetchData(&this->hminVertices,&this->hminVerticesSize[0],&this->hminVerticesSize[1],mxGetField(matlab_struct,0,"hminVertices"));
	FetchData(&this->hmaxVertices,&this->hmaxVerticesSize[0],&this->hmaxVerticesSize[1],mxGetField(matlab_struct,0,"hmaxVertices"));
	FetchData(&this->hVertices,&this->hVerticesSize[0],&this->hVerticesSize[1],mxGetField(matlab_struct,0,"hVertices"));
	FetchData(&this->metric,&this->metricSize[0],&this->metricSize[1],mxGetField(matlab_struct,0,"metric"));
	FetchData(&this->field,&this->fieldSize[0],&this->fieldSize[1],mxGetField(matlab_struct,0,"field"));
	FetchData(&this->err,&this->errSize[0],&this->errSize[1],mxGetField(matlab_struct,0,"err"));

	/*Additional checks*/
	this->Check();

}
/*}}}*/
