/*!\file BamgMesh.cpp
 */

#include <stdio.h>
#include "../../../objects/objects.h"
#include "../../../io/io.h"
#include "../../../shared/shared.h"
#include "../../io/matlabio.h"

/*Constructors/Destructors*/
/*FUNCTION BamgMesh::BamgMesh(void* module_struct){{{1*/
BamgMesh::BamgMesh(void* module_struct){

	mxArray* matlab_struct=NULL;
	int lines,cols;

	/*recover our pointer: */
	matlab_struct=(mxArray*)module_struct;


	FetchData(&this->Vertices,            &this->VerticesSize[0],            &this->VerticesSize[1],            mxGetAssignedField(matlab_struct,0,"Vertices"));
	FetchData(&this->Edges,               &this->EdgesSize[0],               &this->EdgesSize[1],               mxGetAssignedField(matlab_struct,0,"Edges"));
	FetchData(&this->Triangles,           &this->TrianglesSize[0],           &this->TrianglesSize[1],           mxGetAssignedField(matlab_struct,0,"Triangles"));
	this->QuadrilateralsSize[0]=0,        this->QuadrilateralsSize[1]=0;     this->Quadrilaterals=NULL;

	this->SubDomainsSize[0]=0,            this->SubDomainsSize[1]=0;         this->SubDomains=NULL;
	this->SubDomainsFromGeomSize[0]=0,    this->SubDomainsFromGeomSize[1]=0; this->SubDomainsFromGeom=NULL;
	this->CrackedVerticesSize[0]=0,       this->CrackedVerticesSize[1]=0;    this->CrackedVertices=NULL;
	FetchData(&this->CrackedEdges,        &this->CrackedEdgesSize[0],        &this->CrackedEdgesSize[1],        mxGetAssignedField(matlab_struct,0,"CrackedEdges"));

	FetchData(&this->VerticesOnGeomEdge,  &this->VerticesOnGeomEdgeSize[0],  &this->VerticesOnGeomEdgeSize[1],  mxGetAssignedField(matlab_struct,0,"VerticesOnGeomEdge"));
	FetchData(&this->VerticesOnGeomVertex,&this->VerticesOnGeomVertexSize[0],&this->VerticesOnGeomVertexSize[1],mxGetAssignedField(matlab_struct,0,"VerticesOnGeomVertex"));
	FetchData(&this->EdgesOnGeomEdge,     &this->EdgesOnGeomEdgeSize[0],     &this->EdgesOnGeomEdgeSize[1],     mxGetAssignedField(matlab_struct,0,"EdgesOnGeomEdge"));

	this->IssmEdgesSize[0]=0,             this->IssmEdgesSize[1]=0;          this->IssmEdges=NULL;
	FetchData(&this->IssmSegments,        &this->IssmSegmentsSize[0],        &this->IssmSegmentsSize[1],        mxGetAssignedField(matlab_struct,0,"IssmSegments"));

	this->ElementConnectivitySize[0]=0,      this->ElementConnectivitySize[1]=0;      this->ElementConnectivity=NULL;
	this->NodalConnectivitySize[0]=0,        this->NodalConnectivitySize[1]=0;        this->NodalConnectivity=NULL;
	this->NodalElementConnectivitySize[0]=0, this->NodalElementConnectivitySize[1]=0; this->NodalElementConnectivity=NULL;

}
/*}}}*/

/*Methods*/
/*FUNCTION BamgMesh::SetStructureFields{{{1*/
void BamgMesh::SetStructureFields(void* module_struct){
	
	mxArray** matlab_struct=NULL;

	/*Intermediary*/
	int         i;
	mxArray*    output=NULL;
	const int         numfields=16;
	const char* fnames[numfields];
	mwSize      ndim=2;
	mwSize      dimensions[2]={1,1};

	/*recover pointer: */
	matlab_struct=(mxArray**)module_struct;

	/*Initialize field names*/
	i=0;
	fnames[i++] = "Triangles";
	fnames[i++] = "Vertices";
	fnames[i++] = "Edges";
	fnames[i++] = "IssmSegments";
	fnames[i++] = "IssmEdges";
	fnames[i++] = "Quadrilaterals";
	fnames[i++] = "VerticesOnGeomVertex";
	fnames[i++] = "VerticesOnGeomEdge";
	fnames[i++] = "EdgesOnGeomEdge";
	fnames[i++] = "SubDomains";
	fnames[i++] = "SubDomainsFromGeom";
	fnames[i++] = "ElementConnectivity";
	fnames[i++] = "NodalConnectivity";
	fnames[i++] = "NodalElementConnectivity";
	fnames[i++] = "CrackedVertices";
	fnames[i++] = "CrackedEdges";
	_assert_(i==numfields);

	/*Initialize Matlab structure*/
	output=mxCreateStructArray(ndim,dimensions,numfields,fnames);

	/*set each matlab each field*/
	i=0;
	i++; SetStructureField(output,"Triangles",                this->TrianglesSize[0],                this->TrianglesSize[1],                 this->Triangles);
	i++; SetStructureField(output,"Vertices",                 this->VerticesSize[0],                 this->VerticesSize[1],                  this->Vertices);
	i++; SetStructureField(output,"Edges",                    this->EdgesSize[0],                    this->EdgesSize[1],                     this->Edges);
	i++; SetStructureField(output,"IssmSegments",             this->IssmSegmentsSize[0],             this->IssmSegmentsSize[1],              this->IssmSegments);
	i++; SetStructureField(output,"IssmEdges",                this->IssmEdgesSize[0],                this->IssmEdgesSize[1],                 this->IssmEdges);
	i++; SetStructureField(output,"Quadrilaterals",           this->QuadrilateralsSize[0],           this->QuadrilateralsSize[1],            this->Quadrilaterals);
	i++; SetStructureField(output,"VerticesOnGeomVertex",this->VerticesOnGeomVertexSize[0],this->VerticesOnGeomVertexSize[1], this->VerticesOnGeomVertex);
	i++; SetStructureField(output,"VerticesOnGeomEdge",  this->VerticesOnGeomEdgeSize[0],  this->VerticesOnGeomEdgeSize[1],   this->VerticesOnGeomEdge);
	i++; SetStructureField(output,"EdgesOnGeomEdge",     this->EdgesOnGeomEdgeSize[0],     this->EdgesOnGeomEdgeSize[1],      this->EdgesOnGeomEdge);
	i++; SetStructureField(output,"SubDomains",               this->SubDomainsSize[0],               this->SubDomainsSize[1],                this->SubDomains);
	i++; SetStructureField(output,"SubDomainsFromGeom",       this->SubDomainsFromGeomSize[0],       this->SubDomainsFromGeomSize[1],        this->SubDomainsFromGeom);
	i++; SetStructureField(output,"ElementConnectivity",      this->ElementConnectivitySize[0],      this->ElementConnectivitySize[1],       this->ElementConnectivity);
	i++; SetStructureField(output,"NodalConnectivity",        this->NodalConnectivitySize[0],        this->NodalConnectivitySize[1],         this->NodalConnectivity);
	i++; SetStructureField(output,"NodalElementConnectivity", this->NodalElementConnectivitySize[0], this->NodalElementConnectivitySize[1],  this->NodalElementConnectivity);
	i++; SetStructureField(output,"CrackedVertices",          this->CrackedVerticesSize[0],          this->CrackedVerticesSize[1],           this->CrackedVertices);
	i++; SetStructureField(output,"CrackedEdges",             this->CrackedEdgesSize[0],             this->CrackedEdgesSize[1],              this->CrackedEdges);
	_assert_(i==numfields);

	/*Assign output*/
	*matlab_struct=output;

}
/*}}}*/
/*FUNCTION BamgMesh::SetStructureField{{{1*/
void BamgMesh::SetStructureField(void* module_struct,const char* fieldname,int fieldrows,int fieldcols,double* fieldpointer){

	/*Intermediary*/
	mxArray*    matlab_struct=NULL;
	int         i1,i2;
	mxArray*    pfield=NULL;
	mxArray*    pfield2=NULL;

	/*recover pointer: */
	matlab_struct=(mxArray*)module_struct;

	/*Copy field*/
	double*  fieldcopy=NULL;
	if (fieldrows*fieldcols){
		fieldcopy=(double*)xmalloc(fieldrows*fieldcols*sizeof(double));
		for(i1=0;i1<fieldrows;i1++){
			for(i2=0;i2<fieldcols;i2++){
				fieldcopy[fieldcols*i1+i2]=fieldpointer[fieldcols*i1+i2];
			}
		}
	}

	/*Set matlab field*/
	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,fieldcols);
	mxSetN(pfield,fieldrows);
	mxSetPr(pfield,fieldcopy);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(matlab_struct,0,fieldname,pfield2);
}
/*}}}*/
