/*!\file BamgGeom.cpp
 */

#include <stdio.h>
#include "../../../objects/objects.h"
#include "../../../io/io.h"
#include "../../../shared/shared.h"
#include "../../io/matlabio.h"
#include <mex.h>

/*Constructors/Destructors*/
/*FUNCTION BamgGeom::BamgGeom(void* module_struct){{{1*/
BamgGeom::BamgGeom(void* module_struct){

	mxArray* matlab_struct=NULL;

	/*recover our pointer: */
	matlab_struct=(mxArray*)module_struct;

	FetchData(&this->Vertices,        &this->VerticesSize[0],        &this->VerticesSize[1],        mxGetAssignedField(matlab_struct,0,"Vertices"));
	FetchData(&this->Edges,           &this->EdgesSize[0],           &this->EdgesSize[1],           mxGetAssignedField(matlab_struct,0,"Edges"));
	this->TangentAtEdgesSize[0]=0,    this->TangentAtEdgesSize[1]=0;    this->TangentAtEdges=NULL;
	FetchData(&this->Corners,         &this->CornersSize[0],         &this->CornersSize[1],         mxGetAssignedField(matlab_struct,0,"Corners"));
	FetchData(&this->RequiredVertices,&this->RequiredVerticesSize[0],&this->RequiredVerticesSize[1],mxGetAssignedField(matlab_struct,0,"RequiredVertices"));
	FetchData(&this->RequiredEdges,   &this->RequiredEdgesSize[0],   &this->RequiredEdgesSize[1],   mxGetAssignedField(matlab_struct,0,"RequiredEdges"));
	FetchData(&this->CrackedEdges,    &this->CrackedEdgesSize[0],    &this->CrackedEdgesSize[1],    mxGetAssignedField(matlab_struct,0,"CrackedEdges"));
	FetchData(&this->SubDomains,      &this->SubDomainsSize[0],      &this->SubDomainsSize[1],      mxGetAssignedField(matlab_struct,0,"SubDomains"));

}
/*}}}*/

/*Methods*/
/*FUNCTION BamgGeom::SetStructureFields{{{1*/
void BamgGeom::SetStructureFields(void* module_struct){

	mxArray** matlab_struct=NULL;

	/*Intermediary*/
	int         i;
	mxArray*    output=NULL;
	const int         numfields=7;
	const char* fnames[numfields];
	mwSize      ndim=2;
	mwSize      dimensions[2]={1,1};
	
	/*recover pointer: */
	matlab_struct=(mxArray**)module_struct;

	/*Initialize field names*/
	i=0;
	fnames[i++] = "Vertices";
	fnames[i++] = "Edges";
	fnames[i++] = "TangentAtEdges";
	fnames[i++] = "RequiredVertices";
	fnames[i++] = "RequiredEdges";
	fnames[i++] = "CrackedEdges";
	fnames[i++] = "SubDomains";
	_assert_(i==numfields);

	/*Initialize Matlab structure*/
	output=mxCreateStructArray(ndim,dimensions,numfields,fnames);

	/*set each matlab each field*/
	i=0;
	i++; SetStructureField(output,"Vertices",        this->VerticesSize[0],        this->VerticesSize[1],        this->Vertices);
	i++; SetStructureField(output,"Edges",           this->EdgesSize[0],           this->EdgesSize[1],           this->Edges);
	i++; SetStructureField(output,"TangentAtEdges",  this->TangentAtEdgesSize[0],  this->TangentAtEdgesSize[1],  this->TangentAtEdges);
	i++; SetStructureField(output,"RequiredVertices",this->RequiredVerticesSize[0],this->RequiredVerticesSize[1],this->RequiredVertices);
	i++; SetStructureField(output,"RequiredEdges",   this->RequiredEdgesSize[0],   this->RequiredEdgesSize[1],   this->RequiredEdges);
	i++; SetStructureField(output,"CrackedEdges",    this->CrackedEdgesSize[0],    this->CrackedEdgesSize[1],    this->CrackedEdges);
	i++; SetStructureField(output,"SubDomains",      this->SubDomainsSize[0],      this->SubDomainsSize[1],      this->SubDomains);
	_assert_(i==numfields);

	/*Assign output*/
	*matlab_struct=output;

}
/*}}}*/
/*FUNCTION BamgGeom::SetStructureField{{{1*/
void BamgGeom::SetStructureField(void* module_struct,const char* fieldname,int fieldrows,int fieldcols,double* fieldpointer){

	/*Intermediary*/
	mxArray*    matlab_struct=NULL;
	int         i1,i2;
	mxArray*    pfield=NULL;
	mxArray*    pfield2=NULL;

	/*recover pointer: */
	matlab_struct=(mxArray*)module_struct;

	/*Copy field*/
	double*  fieldcopy=NULL;
	if (fieldrows*fieldcols){
		fieldcopy=(double*)xmalloc(fieldrows*fieldcols*sizeof(double));
		for(i1=0;i1<fieldrows;i1++){
			for(i2=0;i2<fieldcols;i2++){
				fieldcopy[fieldcols*i1+i2]=fieldpointer[fieldcols*i1+i2];
			}
		}
	}

	/*Set matlab field*/
	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,fieldcols);
	mxSetN(pfield,fieldrows);
	mxSetPr(pfield,fieldcopy);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(matlab_struct,0,fieldname,pfield2);
}
/*}}}*/
