/* \file PetscVectorToDoubleVector.cpp
 */


#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif


/*Petsc includes: */
#include "petscmat.h"
#include "petscvec.h"
#include "petscksp.h"

/*Petsc includes: */
#include "mex.h"

#include "../../shared/shared.h"
#include <string>


void PetscVectorToDoubleVector(double** pvector, int* prows, Vec petsc_vector){

	int     i;
	int     rows;
	int    *idxm   = NULL;
	double *vector = NULL;

	/*output: */
	mxArray* dataref=NULL;

	/*Get size of vector: */
	if(vector){
		VecGetSize(petsc_vector,&rows);
		if(rows){
			idxm=(int*)xmalloc(rows*sizeof(int));
			vector=(double*)xmalloc(rows*sizeof(double));
			for(i=0;i<rows;i++)idxm[i]=i;

			VecGetValues(petsc_vector,rows,idxm,vector);
		}
	}
	else{
		rows=0;
	}

	/*Assign output pointers: */
	*pvector=vector;
	*prows=rows;
}
