/*
 * \file Options.c
 * \brief: implementation of the Options class methods that depend on Matlab
 */

/*Headers: {{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <vector>
#include <algorithm>
#include <mex.h>

#include "../../Container/DataSet.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../io/matlabio.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION Options::Options(int istart, int nrhs, const mxArray* prhs[]){{{1*/
Options::Options(int istart, int nrhs, void* module_references){

	const mxArray** prhs = NULL;
	int            i;
	char          *name    = NULL;
	Option *option = NULL;

	/*Recover matlab references: */
	prhs=(const mxArray**)module_references;

	/*loop over each name and value*/
	for (i=istart; i<nrhs; i=i+2){
		if (!mxIsClass(prhs[i],"char")) _error_("Argument %d must be name of option.",i+1);

		FetchData(&name,prhs[i]);
		if (i+1 == nrhs) _error_("Argument %d must exist and be value of option \"%s\".",i+2,name);

		//_printf_(true,"  Processing option \"%s\" of class \"%s\".\n",name,mxGetClassName(prhs[i+1]));
		option=(Option*)OptionParse(name,&prhs[i+1]);
		this->AddOption(option);
		option=NULL;
	}

	/*echo the dataset  */
	//if (this->Size()) for(i=0;i<this->Size();i++) ((Option*)this->GetObjectByOffset(i))->Echo();
}
/*}}}*/
