/* \file alloc_module.h
 */


#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile without HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <stdlib.h>

#include  "./alloc_module.h"
#include "../Exceptions/exceptions.h"
#include "../../include/include.h"
#include "../../objects/objects.h"

void xdelete_module(Matrix** pv){
	
	if (pv && *pv){
		/*Actually, still get rid of internal Petsc matrix. Quick fix until Matlab handles C++ 
		 * correctly: */
		#ifdef _HAVE_PETSC_
			MatFree(&(*pv)->matrix);
		#endif
		*pv=NULL;
	}
}

void xdelete_module(Vector** pv){

	if (pv && *pv){
		/*Actually, still get rid of internal Petsc vector. Quick fix until Matlab handles C++ 
		 * correctly: */
		#ifdef _HAVE_PETSC_
			VecFree(&(*pv)->vector);
		#endif
		*pv=NULL;
	}
}
