/*!\file VectorParam.c
 * \brief: implementation of the VectorParam object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*VectorParam constructors and destructor*/
/*FUNCTION VectorParam::VectorParam(){{{1*/
VectorParam::VectorParam(){
	return;
}
/*}}}*/
/*FUNCTION VectorParam::VectorParam(int enum_type,IssmVector value){{{1*/
VectorParam::VectorParam(int in_enum_type,Vector* in_value){

	enum_type=in_enum_type;

	value=NULL;

	if(in_value){
		value=in_value->Duplicate();
		in_value->Copy(value);
	}
}
/*}}}*/
/*FUNCTION VectorParam::~VectorParam(){{{1*/
VectorParam::~VectorParam(){
	xdelete(&value);
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION VectorParam::Echo {{{1*/
void VectorParam::Echo(void){

	printf("VectorParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));

}
/*}}}*/
/*FUNCTION VectorParam::DeepEcho{{{1*/
void VectorParam::DeepEcho(void){

	int i;
	printf("VectorParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	value->Echo();
}
/*}}}*/
/*FUNCTION VectorParam::Id{{{1*/
int    VectorParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION VectorParam::MyRank{{{1*/
int    VectorParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
#ifdef _SERIAL_
/*FUNCTION VectorParam::Marshall{{{1*/
void  VectorParam::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;
	int   M;
	double* serial_value=NULL;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of VectorParam: */
	enum_value=VectorParamEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall VectorParam data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	if(value){
		value->GetSize(&M);
		serial_value=value->ToMPISerial();
		memcpy(marshalled_dataset,&M,sizeof(M));marshalled_dataset+=sizeof(M);
		memcpy(marshalled_dataset,serial_value,M*sizeof(double));marshalled_dataset+=(M*sizeof(double));
	}
	else{
		M=0;
		memcpy(marshalled_dataset,&M,sizeof(M));marshalled_dataset+=sizeof(M);
	}
	/*Free ressources:*/
	xfree((void**)&serial_value);

	/*return:*/
	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION VectorParam::MarshallSize{{{1*/
int   VectorParam::MarshallSize(){

	int M=0;
	if(value)value->GetSize(&M);

	return sizeof(M)+M*sizeof(double)
		+sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION VectorParam::Demarshall{{{1*/
void  VectorParam::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;
	double* serial_vec=NULL;
	int   M;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*data: */
	
	memcpy(&M,marshalled_dataset,sizeof(M));marshalled_dataset+=sizeof(M);
	if(M){
		serial_vec=(double*)xmalloc(M*sizeof(double));
		memcpy(serial_vec,marshalled_dataset,M*sizeof(double));marshalled_dataset+=(M*sizeof(double));

		value=new Vector(serial_vec,M);
	}
	else{
		value=NULL;
	}

	/*Free ressources:*/
	xfree((void**)&serial_vec);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
#endif
/*FUNCTION VectorParam::ObjectEnum{{{1*/
int VectorParam::ObjectEnum(void){

	return VectorParamEnum;

}
/*}}}*/
/*FUNCTION VectorParam::copy{{{1*/
Object* VectorParam::copy() {
	
	return new VectorParam(this->enum_type,this->value);

}
/*}}}*/

/*VectorParam virtual functions definitions: */
/*FUNCTION VectorParam::GetParameterValue{{{1*/
void  VectorParam::GetParameterValue(Vector** poutput){
	Vector*  output=NULL;

	if(value){
		output=value->Duplicate();
		value->Copy(output);
	}
	*poutput=output;
}
/*}}}*/
/*FUNCTION VectorParam::GetParameterName{{{1*/
void VectorParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION VectorParam::SetValue{{{1*/
void  VectorParam::SetValue(Vector* vector){

	/*avoid leak: */
	xdelete(&value);
	
	/*copy: */
	value=vector->Duplicate();
	vector->Copy(value);
}
/*}}}*/
/*FUNCTION VectorParam::UnitConversion{{{1*/
void  VectorParam::UnitConversion(int direction_enum){
	/*do nothing, no unit conversion*/
}
/*}}}*/
