/*!\file MatrixParam.c
 * \brief: implementation of the MatrixParam object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*MatrixParam constructors and destructor*/
/*FUNCTION MatrixParam::MatrixParam(){{{1*/
MatrixParam::MatrixParam(){
	return;
}
/*}}}*/
/*FUNCTION MatrixParam::MatrixParam(int enum_type,Matrix* value){{{1*/
MatrixParam::MatrixParam(int in_enum_type,Matrix* in_value){

	enum_type=in_enum_type;
	value=NULL;

	if(in_value){
		value=in_value->Duplicate();
	}
}
/*}}}*/
/*FUNCTION MatrixParam::~MatrixParam(){{{1*/
MatrixParam::~MatrixParam(){
	xdelete(&value);
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION MatrixParam::Echo {{{1*/
void MatrixParam::Echo(void){

	printf("MatrixParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));

}
/*}}}*/
/*FUNCTION MatrixParam::DeepEcho{{{1*/
void MatrixParam::DeepEcho(void){

	int i;
	printf("MatrixParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	this->value->Echo();
}
/*}}}*/
/*FUNCTION MatrixParam::Id{{{1*/
int    MatrixParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION MatrixParam::MyRank{{{1*/
int    MatrixParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
#ifdef _SERIAL_
/*FUNCTION MatrixParam::Marshall{{{1*/
void  MatrixParam::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;
	int   M,N;
	double* serial_mat=NULL;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of MatrixParam: */
	enum_value=MatrixParamEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall MatrixParam data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	if(value){
		value->GetSize(&M,&N);
		serial_mat=value->ToSerial();
		memcpy(marshalled_dataset,&M,sizeof(M));marshalled_dataset+=sizeof(M);
		memcpy(marshalled_dataset,&N,sizeof(N));marshalled_dataset+=sizeof(N);
		memcpy(marshalled_dataset,serial_mat,M*N*sizeof(double));marshalled_dataset+=(M*N*sizeof(double));
	}
	else{
		M=0;
		N=0;
		memcpy(marshalled_dataset,&M,sizeof(M));marshalled_dataset+=sizeof(M);
		memcpy(marshalled_dataset,&N,sizeof(N));marshalled_dataset+=sizeof(N);
	}
	
	/*Free ressources:*/
	xfree((void**)&serial_mat);

	/*return:*/
	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION MatrixParam::MarshallSize{{{1*/
int   MatrixParam::MarshallSize(){

	int M=0;
	int N=0;
	if(value)value->GetSize(&M,&N);
			
	return sizeof(M)+
		sizeof(N)+
		M*N*sizeof(double)+
		+sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION MatrixParam::Demarshall{{{1*/
void  MatrixParam::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   M,N;
	double* serial_mat=NULL;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*data: */
	memcpy(&M,marshalled_dataset,sizeof(M));marshalled_dataset+=sizeof(M);
	memcpy(&N,marshalled_dataset,sizeof(N));marshalled_dataset+=sizeof(N);
	if(M!=0 && N!=0){
		serial_mat=(double*)xmalloc(M*N*sizeof(double));
		memcpy(serial_mat,marshalled_dataset,M*N*sizeof(double));marshalled_dataset+=(M*N*sizeof(double));
		value=new Matrix(serial_mat,M,N,.001);
	}
	else{
		value=NULL;
	}

	/*Free ressources:*/
	xfree((void**)&serial_mat);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
#endif
/*FUNCTION MatrixParam::ObjectEnum{{{1*/
int MatrixParam::ObjectEnum(void){

	return MatrixParamEnum;

}
/*}}}*/
/*FUNCTION MatrixParam::copy{{{1*/
Object* MatrixParam::copy() {
	
	return new MatrixParam(this->enum_type,this->value);

}
/*}}}*/

/*MatrixParam virtual functions definitions: */
/*FUNCTION MatrixParam::GetParameterValue{{{1*/
void  MatrixParam::GetParameterValue(Matrix** poutput){
	Matrix* output=NULL;

	if(value){
		output=value->Duplicate();
	}
	*poutput=output;
}
/*}}}*/
/*FUNCTION MatrixParam::GetParameterName{{{1*/
void MatrixParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION MatrixParam::SetValue{{{1*/
void  MatrixParam::SetValue(Matrix* matrix){
	
	/*avoid leak: */
	xdelete(&value);
	
	/*copy: */
	value=matrix->Duplicate();
}
/*}}}*/
/*FUNCTION MatrixParam::UnitConversion{{{1*/
void  MatrixParam::UnitConversion(int direction_enum){
	/*do nothing, no unit conversion*/
}
/*}}}*/
