/*!\file FileParam.c
 * \brief: implementation of the FileParam object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*FileParam constructors and destructor*/
/*FUNCTION FileParam::FileParam(){{{1*/
FileParam::FileParam(){
	return;
}
/*}}}*/
/*FUNCTION FileParam::FileParam(int enum_type,FILE *value){{{1*/
FileParam::FileParam(int in_enum_type,FILE* in_value){

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
/*FUNCTION FileParam::~FileParam(){{{1*/
FileParam::~FileParam(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION FileParam::Echo {{{1*/
void FileParam::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION FileParam::DeepEcho{{{1*/
void FileParam::DeepEcho(void){

	printf("FileParam:\n");
	printf("   enum:  %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   value: %p\n",this->value);
}
/*}}}*/
/*FUNCTION FileParam::Id{{{1*/
int    FileParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION FileParam::MyRank{{{1*/
int    FileParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
#ifdef _SERIAL_
/*FUNCTION FileParam::Marshall{{{1*/
void  FileParam::Marshall(char** pmarshalled_dataset){

	_error_("FileParam is a pointer and cannot be marshalled");
}
/*}}}*/
/*FUNCTION FileParam::MarshallSize{{{1*/
int   FileParam::MarshallSize(){
	_error_("FileParam is a pointer and cannot be marshalled");
}
/*}}}*/
/*FUNCTION FileParam::Demarshall{{{1*/
void  FileParam::Demarshall(char** pmarshalled_dataset){
	_error_("FileParam is a pointer and cannot be marshalled");
}
/*}}}*/
#endif
/*FUNCTION FileParam::ObjectEnum{{{1*/
int FileParam::ObjectEnum(void){

	return FileParamEnum;

}
/*}}}*/
/*FUNCTION FileParam::copy{{{1*/
Object* FileParam::copy() {
	
	return new FileParam(this->enum_type,this->value);

}
/*}}}*/

/*FileParam virtual functions definitions: */
/*FUNCTION FileParam::GetParameterName{{{1*/
void FileParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION FileParam::UnitConversion{{{1*/
void  FileParam::UnitConversion(int direction_enum){
	/*do nothing, no unit conversion*/
}
/*}}}*/
