/*!\file DoubleVecExternalResult.c
 * \brief: implementation of the DoubleVecExternalResult object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*DoubleVecExternalResult constructors and destructor*/
/*FUNCTION DoubleVecExternalResult::DoubleVecExternalResult(){{{1*/
DoubleVecExternalResult::DoubleVecExternalResult(){
	return;
}
/*}}}*/
/*FUNCTION DoubleVecExternalResult::DoubleVecExternalResult(int enum_type,IssmDoubleVec values,int M,int in_step,double in_time){{{1*/
DoubleVecExternalResult::DoubleVecExternalResult(int in_id, int in_enum_type,double* in_values, int in_M,int in_step,double in_time){

	id=in_id;
	enum_type=in_enum_type;
	M=in_M;

	if(M){
		values=(double*)xmalloc(M*sizeof(double));
		memcpy(values,in_values,M*sizeof(double));
	}
	else values=NULL;

	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION DoubleVecExternalResult::~DoubleVecExternalResult(){{{1*/
DoubleVecExternalResult::~DoubleVecExternalResult(){
	xfree((void**)&values);
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION DoubleVecExternalResult::Echo {{{1*/
void DoubleVecExternalResult::Echo(void){

	printf("DoubleVecExternalResult:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   vector size: %i\n",this->M);
	printf("   step: %i\n",this->step);
	printf("   time: %g\n",this->time);

}
/*}}}*/
/*FUNCTION DoubleVecExternalResult::DeepEcho{{{1*/
void DoubleVecExternalResult::DeepEcho(void){

	int i;
	
	printf("DoubleVecExternalResult:\n");
	printf("   id: %i\n",this->id);
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   vector size: %i\n",this->M);
	for(i=0;i<this->M;i++){
		printf("%i %g\n",i,this->values[i]);
	}
	printf("   step: %i\n",this->step);
	printf("   time: %g\n",this->time);
}
/*}}}*/
/*FUNCTION DoubleVecExternalResult::Id{{{1*/
int    DoubleVecExternalResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DoubleVecExternalResult::MyRank{{{1*/
int    DoubleVecExternalResult::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
#ifdef _SERIAL_
/*FUNCTION DoubleVecExternalResult::Marshall{{{1*/
void  DoubleVecExternalResult::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of DoubleVecExternalResult: */
	enum_value=DoubleVecExternalResultEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall DoubleVecExternalResult data: */
	memcpy(marshalled_dataset,&id,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&M,sizeof(M));marshalled_dataset+=sizeof(M);
	memcpy(marshalled_dataset,values,M*sizeof(double));marshalled_dataset+=M*sizeof(double);
	memcpy(marshalled_dataset,&step,sizeof(step));marshalled_dataset+=sizeof(step);
	memcpy(marshalled_dataset,&time,sizeof(time));marshalled_dataset+=sizeof(time);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION DoubleVecExternalResult::MarshallSize{{{1*/
int   DoubleVecExternalResult::MarshallSize(){
	
	return sizeof(M)
		+M*sizeof(double)
		+sizeof(id)
		+sizeof(enum_type)
		+sizeof(step)
		+sizeof(time)
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION DoubleVecExternalResult::Demarshall{{{1*/
void  DoubleVecExternalResult::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&id,marshalled_dataset,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*data: */
	memcpy(&M,marshalled_dataset,sizeof(M));marshalled_dataset+=sizeof(M);
	values=(double*)xmalloc(M*sizeof(double));
	memcpy(values,marshalled_dataset,M*sizeof(double));marshalled_dataset+=M*sizeof(double);
	memcpy(&step,marshalled_dataset,sizeof(step));marshalled_dataset+=sizeof(step);
	memcpy(&time,marshalled_dataset,sizeof(time));marshalled_dataset+=sizeof(time);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
#endif
/*FUNCTION DoubleVecExternalResult::ObjectEnum{{{1*/
int DoubleVecExternalResult::ObjectEnum(void){

	return DoubleVecExternalResultEnum;

}
/*}}}*/
/*FUNCTION DoubleVecExternalResult::copy{{{1*/
Object* DoubleVecExternalResult::copy() {
	
	return new DoubleVecExternalResult(this->id,this->enum_type,this->values,this->M,this->step,this->time);

}
/*}}}*/

/*DoubleVecExternalResult management: */
/*FUNCTION DoubleVecExternalResult::WriteData{{{1*/
void   DoubleVecExternalResult::WriteData(FILE* fid,bool io_gather){

	int     length;
	int     type;
	int     size;
	char   *name    = NULL;
	extern  int my_rank;

	/*return if now on cpu 0: */
	if(my_rank)return;

	/*First write enum: */
	EnumToStringx(&name,this->enum_type);
	length=(strlen(name)+1)*sizeof(char);
	fwrite(&length,sizeof(int),1,fid);
	fwrite(name,length,1,fid);
	xfree((void**)&name);

	/*Now write time and step: */
	fwrite(&time,sizeof(double),1,fid);
	fwrite(&step,sizeof(int),1,fid);

	/*writing a double, type is 1, size is 1: */
	type=1;
	size=this->M;
	fwrite(&type,sizeof(int),1,fid);
	fwrite(&size,sizeof(int),1,fid);
	fwrite(this->values,size*sizeof(double),1,fid);

}
/*}}}1*/
/*FUNCTION DoubleVecExternalResult::GetResultName{{{1*/
void DoubleVecExternalResult::GetResultName(char** pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION DoubleVecExternalResult::GetStep{{{1*/
int DoubleVecExternalResult::GetStep(void){

	return this->step;
}
/*}}}*/
