/*\file matlabio.h
 *\brief: I/O for ISSM in matlab mode
 */

#ifndef _MATLAB_IO_H_
#define _MATLAB_IO_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif 

#include "../../objects/objects.h"
#include "../../Container/Container.h"
#include "../../include/include.h"

class DataSet;
class Parameters;

#include <mex.h>

void WriteData(mxArray** pdataref,DataSet* dataset);
void WriteData(mxArray** pdataref,Matrix* matrix);
void WriteData(mxArray** pdataref,double* matrix, int M,int N);
void WriteData(mxArray** pdataref,int*    matrix, int M,int N);
void WriteData(mxArray** pdataref,Vector* vector);
void WriteData(mxArray** pdataref,double* vector, int M);
void WriteData(mxArray** pdataref,int integer);
void WriteData(mxArray** pdataref,bool boolean);
void WriteData(mxArray** pdataref,double scalar);
void WriteData(mxArray** pdataref,char* string);
void WriteData(DataHandle* pdataref,Parameters* parameters);

void FetchData(DataSet** pdataset,const mxArray* dataref);
void FetchData(double** pmatrix,int* pM,int *pN,const mxArray* dataref);
void FetchData(double** pmatrix,int* pnumel,int* pndims,int** psize,const mxArray* dataref);
void FetchData(int** pmatrix,int* pM,int *pN,const mxArray* dataref);
void FetchData(bool** pmatrix,int* pM,int *pN,const mxArray* dataref);
void FetchData(bool** pmatrix,int* pnumel,int* pndims,int** psize,const mxArray* dataref);
void FetchData(Matrix** pmatrix,const mxArray* dataref);
void FetchData(int** pvector,int* pM,const mxArray* dataref);
void FetchData(float** pvector,int* pM,const mxArray* dataref);
void FetchData(double** pvector,int* pM,const mxArray* dataref);
void FetchData(bool** pvector,int* pM,const mxArray* dataref);
void FetchData(Vector** pvector,const mxArray* dataref);
void FetchData(char** pstring,const mxArray* dataref);
void FetchData(char** pmatrix,int* pnumel,int* pndims,int** psize,const mxArray* dataref);
void FetchData(double* pscalar,const mxArray* dataref);
void FetchData(int* pinteger,const mxArray* dataref);
void FetchData(bool* pbool,const mxArray* dataref);
void FetchData(Parameters** pparameters, DataHandle dataref);

Option* OptionParse(char* name, const mxArray* prhs[]);
OptionDouble*   OptionDoubleParse( char* name, const mxArray* prhs[]);
OptionLogical*  OptionLogicalParse( char* name, const mxArray* prhs[]);
OptionChar*     OptionCharParse( char* name, const mxArray* prhs[]);
OptionStruct*   OptionStructParse( char* name, const mxArray* prhs[]);
OptionCell*     OptionCellParse( char* name, const mxArray* prhs[]);

mxArray* mxGetAssignedField(const mxArray* pmxa_array,int number, const char* field);
int CheckNumMatlabArguments(int nlhs,int NLHS, int nrhs,int NRHS, const char* THISFUNCTION, void (*function)( void ));

/*Matlab to Matrix routines: */
Matrix* MatlabMatrixToMatrix(const mxArray* mxmatrix);
Vector* MatlabVectorToVector(const mxArray* mxvector);

/*Matlab to double* routines: */
int MatlabVectorToDoubleVector(double** pvector,int* pvector_rows,const mxArray* mxvector);
int MatlabMatrixToDoubleMatrix(double** pmatrix,int* pmatrix_rows,int* pmatrix_cols,const mxArray* mxmatrix);
int MatlabNArrayToNArray(double** pmatrix,int* pmatrix_numel,int* pmatrix_ndims,int** pmatrix_size,const mxArray* mxmatrix);
int MatlabNArrayToNArray(bool** pmatrix,int* pmatrix_numel,int* pmatrix_ndims,int** pmatrix_size,const mxArray* mxmatrix);
int MatlabNArrayToNArray(char** pmatrix,int* pmatrix_numel,int* pmatrix_ndims,int** pmatrix_size,const mxArray* mxmatrix);
int MatlabMatrixToPetscMatrix(Mat* matrix,int* prows,int* pcols, const mxArray* mxmatrix);

/*Matlab to Petsc routines: */
int MatlabVectorToPetscVector(Vec* pvector,int* pvector_rows,const mxArray* mxvector);
void PetscMatrixToDoubleMatrix(double** pmatrix, int* prows, int* pcols,Mat matrix);
void PetscVectorToDoubleVector(double** pvector, int* prows, Vec vector);

/*Matlab to SeqMat routines: */
SeqMat* MatlabMatrixToSeqMat(const mxArray* dataref);
SeqVec* MatlabVectorToSeqVec(const mxArray* dataref);

#endif	/* _IO_H_ */
