/*!\file: Options.h
 * \brief prototypes for Options.h
 */ 

#ifndef _CONTAINER_OPTIONS_H_
#define _CONTAINER_OPTIONS_H_

/*forward declarations */
class Option;

class Options: public DataSet{

	public:

		/*constructors, destructors*/
		Options();
		Options(int istart, int nrhs, void* module_references);
		~Options();

		/*numerics*/
		int  AddOption(Option* in_oobject);
		Option* GetOption(const char* name);
		void Get(double*  pvalue,const char* name);
		void Get(double*  pvalue,const char* name,double default_value);
		void Get(bool*    pvalue,const char* name);
		void Get(bool*    pvalue,const char* name,bool default_value);
		void Get(char**   pvalue,const char* name);
		void Get(char**   pvalue,const char* name,const char* default_value);
		void Get(char***  pvalue,int* numel,const char* name);
		void Get(double** pvalue,int* numel,const char* name);
};

#endif //ifndef _INPUTS_H_
