/*! \file StringExternalResult.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _STRINGEXTERNALRESULT_H_
#define _STRINGEXTERNALRESULT_H_

/*Headers:*/
/*{{{1*/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#if defined(_HAVE_MATLAB_) && defined(_SERIAL_)
#include <mex.h>
#endif


#include "./ExternalResult.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../include/include.h"
/*}}}*/

class StringExternalResult: public ExternalResult{

	private: 
		int    id;
		int    enum_type;
		char*  value;
		int    step;
		double time;

	public:
		/*StringExternalResult constructors, destructors: {{{1*/
		StringExternalResult();
		StringExternalResult(int id,int enum_type,char* value,int step, double time);
		~StringExternalResult();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		#ifdef _SERIAL_
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		#endif
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*ExternalResult management: {{{1*/
		int   InstanceEnum(){return enum_type;}
		void  WriteData(FILE* fid,bool io_gather);
		void  GetResultName(char**);
		#if defined(_HAVE_MATLAB_) && defined(_SERIAL_)
		void  SetMatlabField(mxArray* dataref);
		#endif
		int   GetStep(void);
		/*}}}*/
};
#endif  /* _STRINGEXTERNALRESULT_H */
