/*\file pythonio.h
 *\brief: I/O for ISSM in python mode
 */

#ifndef _PYTHON_IO_H_
#define _PYTHON_IO_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif 


#include "../../objects/objects.h"
#include "../../Container/Container.h"
#include "../../include/include.h"

class DataSet;
class Parameters;

#if defined(_HAVE_PYTHON_) && defined(_SERIAL_)

//void WriteData(mxArray** pdataref,DataSet* dataset);
//void WriteData(mxArray** pdataref,double* matrix, int M,int N);
//void WriteData(mxArray** pdataref,int*    matrix, int M,int N);
//void WriteData(mxArray** pdataref,double* vector, int M);
//void WriteData(mxArray** pdataref,int integer);
//void WriteData(mxArray** pdataref,bool boolean);
//void WriteData(mxArray** pdataref,double scalar);
//void WriteData(DataHandle* pdataref,Parameters* parameters);
void WriteData(PyObject* py_tuple, int index, char* string);
void WriteData(PyObject* py_tuple, int index, Matrix* matrix);
void WriteData(PyObject* py_tuple, int index, Vector* vector);


//void FetchData(DataSet** pdataset,const mxArray* dataref);
//void FetchData(double** pmatrix,int* pM,int *pN,const mxArray* dataref);
//void FetchData(double** pmatrix,int* pnumel,int* pndims,int** psize,const mxArray* dataref);
//void FetchData(int** pmatrix,int* pM,int *pN,const mxArray* dataref);
//void FetchData(bool** pmatrix,int* pM,int *pN,const mxArray* dataref);
//void FetchData(bool** pmatrix,int* pnumel,int* pndims,int** psize,const mxArray* dataref);
//void FetchData(Matrix** pmatrix,const mxArray* dataref);
//void FetchData(int** pvector,int* pM,const mxArray* dataref);
//void FetchData(float** pvector,int* pM,const mxArray* dataref);
//void FetchData(double** pvector,int* pM,const mxArray* dataref);
//void FetchData(bool** pvector,int* pM,const mxArray* dataref);
//void FetchData(Vector** pvector,const mxArray* dataref);
//void FetchData(char** pmatrix,int* pnumel,int* pndims,int** psize,const mxArray* dataref);
//void FetchData(Parameters** pparameters, DataHandle dataref);
void FetchData(char** pstring,PyObject* py_unicode);
void FetchData(double* pscalar,PyObject* py_float);
void FetchData(int* pinteger,PyObject* py_long);
void FetchData(bool* pbool,PyObject* py_boolean);

int CheckNumPythonArguments(PyObject* inputs,int NRHS, void (*function)( void ));

#endif

#endif	/* _IO_H_ */
