//  (C) Copyright John Maddock 2006-7.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
   static const boost::array<boost::array<T, 5>, 4032> binomial_quantile_data = {{
      {{ SC_(2), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(0), SC_(0.28467385230321224203411154382440248724380832183117) }}, 
      {{ SC_(2), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(0), SC_(0.25727865882740919932840773421531232758964168093055) }}, 
      {{ SC_(2), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(0), SC_(0.035694410305790976496105074803969225386555435216338) }}, 
      {{ SC_(2), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(0.11873939407970113038114981488058971337236924303007), SC_(0) }}, 
      {{ SC_(2), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(0.17128223695871555977493584741313475336874139582588), SC_(0) }}, 
      {{ SC_(2), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(0.40618092349808500975883593147831009145063213747834), SC_(0) }}, 
      {{ SC_(2), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(0.43899397179953045991755739555886582435275603281127), SC_(0) }}, 
      {{ SC_(2), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(0.799870552103486022724664124290614736962329408812), SC_(0) }}, 
      {{ SC_(2), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(0), SC_(0.31872738789970909485536768848150766202976148899251) }}, 
      {{ SC_(2), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(0), SC_(0.29102994230646182726533783572628827290811626372966) }}, 
      {{ SC_(2), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(0), SC_(0.066564891771854913273348344758795546234545331752506) }}, 
      {{ SC_(2), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(0.15078204185386621729912132630692143434650445884609), SC_(0) }}, 
      {{ SC_(2), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(0.20400864316514337235281173322687950297863712869268), SC_(0) }}, 
      {{ SC_(2), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(0.44143516661223776441613153671576118711196945856282), SC_(0) }}, 
      {{ SC_(2), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(0.47453330316861439745293287393350226948540566881404), SC_(0) }}, 
      {{ SC_(2), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(0.83739716340650425258932397703845268032687863038399), SC_(0) }}, 
      {{ SC_(2), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(0), SC_(0.62037836131298603609519052823209625564881710064378) }}, 
      {{ SC_(2), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(0), SC_(0.59093627733744182629509254823619511720015775666619) }}, 
      {{ SC_(2), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(0), SC_(0.34807449373182945948809948184050473370388203786438) }}, 
      {{ SC_(2), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(0.44009477935063047177182669621147331809907557267519), SC_(0) }}, 
      {{ SC_(2), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(0.49769020155560349641877333505982794296467077593034), SC_(0) }}, 
      {{ SC_(2), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(0.74944500698304949182235362474586290610889103220154), SC_(0) }}, 
      {{ SC_(2), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(0.78387321971706370473245717801953625642542459567953), SC_(0) }}, 
      {{ SC_(2), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(1.1498981366557770839693825192073836593340168170678), SC_(0) }}, 
      {{ SC_(2), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(0.49788422454509726888212532584283407165868239438731), SC_(1.7926192943764322245525372122405254834085320140091) }}, 
      {{ SC_(2), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(0.52684446645645143763351083479730514213286478982046), SC_(1.7800376961833357223696231469588443580528305056426) }}, 
      {{ SC_(2), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(0.76404470698225093423433928273194254681576983826729), SC_(1.6575789550348265198775169987571194771809264616601) }}, 
      {{ SC_(2), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(1.7079778135930259197017395920782252633535682554395), SC_(0.67451997209260747234500120079260379985847433758707) }}, 
      {{ SC_(2), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(1.7370140616146297876215882640682879489503844226303), SC_(0.61826978524366906854726038797379514512007309468525) }}, 
      {{ SC_(2), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(1.8422676954366467819691658272374144020837995309592), SC_(0.37038562663058272269915604803279695742811766811068) }}, 
      {{ SC_(2), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(1.8540370189939540680880864847938744361486513005951), SC_(0.33622087984946386620856678308455255506401496039699) }}, 
      {{ SC_(2), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(1.9445446166763026262975190991518462099527425413065), SC_(0) }}, 
      {{ SC_(2), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(0.56958071116299011326336908222173795424895818167301), SC_(1.8137304876186701320041037003716921955178542458777) }}, 
      {{ SC_(2), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(0.5981209280634265150735741168005063416283431515107), SC_(1.8021715458778761995268427585444094026357861343759) }}, 
      {{ SC_(2), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(0.83090525438122511558400411768603959990549654637303), SC_(1.6886385783899505992169862804407221877862974299577) }}, 
      {{ SC_(2), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(1.7355710512108993168349123864726150726576737171558), SC_(0.74325147999645043591309459835699081406440836189148) }}, 
      {{ SC_(2), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(1.7624843207443737418084928974357752849439279812566), SC_(0.68804994566426817141775845555990924647720468985401) }}, 
      {{ SC_(2), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(1.8591104224011548582974193339913952604895234253212), SC_(0.44361740870722582924969757610991167298608216875062) }}, 
      {{ SC_(2), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(1.8698085272287528501704175046677138004183965889567), SC_(0.40977531663720771089918606908851370822175913476053) }}, 
      {{ SC_(2), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(1.9511576367649285600816205566246603680285988358087), SC_(0.04270968378107433525053371598152689901997251726038) }}, 
      {{ SC_(2), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(0.85726514749037069310481801247489294724056715593457), SC_(1.8804012228077026734797789762290784583931682768768) }}, 
      {{ SC_(2), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(0.88317282091352864079844947551166117006159739583613), SC_(1.8724468451410620279960951785191670507195296736355) }}, 
      {{ SC_(2), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(1.0910330409403430891037561412815026317636099593003), SC_(1.7917361917429781245858890856792542281128619769022) }}, 
      {{ SC_(2), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(1.8256368040155375748945733586742605410385625353702), SC_(1.0134903208545149583207088570984469685131364451052) }}, 
      {{ SC_(2), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(1.8447459049829273901888950923074855808716795544247), SC_(0.96420439216641466386114172651122642007725184484882) }}, 
      {{ SC_(2), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(1.9110961325206285706348172771253849974988114040724), SC_(0.74181276998520831022621554064240699221049217515329) }}, 
      {{ SC_(2), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(1.9182016049508608107144693813859479953781777592049), SC_(0.71048287939882036081575390191907931744136876928891) }}, 
      {{ SC_(2), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(1.9704054870490370002358180573372532707004531569272), SC_(0.36148284689566546008465068509644207578794848416303) }}, 
      {{ SC_(2), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(0.89304497468867083816771394620213863419351236317246), SC_(1.8870232605851419470398115356711266643254699771051) }}, 
      {{ SC_(2), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(0.91851945191911824076604443011738717499646726916982), SC_(1.8794600719495634932055235107252033034069412489192) }}, 
      {{ SC_(2), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(1.1224843497731917039711130632336027140465423975867), SC_(1.8024497787541843720192470688348029663403440451005) }}, 
      {{ SC_(2), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(1.83485221156906006833275716665342524466131493622), SC_(1.0464844000705148022237920054031962146037112159275) }}, 
      {{ SC_(2), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(1.8530821242970069710452437452965833721890011728762), SC_(0.99812279051607284064880069674044726059897838816945) }}, 
      {{ SC_(2), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(1.916157535857756708867513265885680286333674160506), SC_(0.77938820736848709904568261768475993485626028602912) }}, 
      {{ SC_(2), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(1.9228895086526470247831260416402280392514808687008), SC_(0.74850804304125107192927556102838634718019846833922) }}, 
      {{ SC_(2), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(1.9721908607758403884646499241470186512990610404954), SC_(0.40343052762669687946310568011982924189671555341509) }}, 
      {{ SC_(2), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(1.219201450126183079318676263646153854601579006327), SC_(1.9350373809079666836999431876137104944574428624569) }}, 
      {{ SC_(2), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(1.2396148960321004151359986179895006135495084676892), SC_(1.9304973628928072264207215026173314973900010140732) }}, 
      {{ SC_(2), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(1.3999337004234246540631799267105791681544589227942), SC_(1.8830751425475383580386501751033238159943302559557) }}, 
      {{ SC_(2), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(1.9032845197351552805024834424312366828109880544359), SC_(1.3408612705720849488466007423034897969311893922241) }}, 
      {{ SC_(2), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(1.914493646816680323502341300602515574175713346603), SC_(1.3028550425520181746307970074911468699561794578722) }}, 
      {{ SC_(2), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(1.9523148075028214318426363845910557072771253778725), SC_(1.1271112472563136150093623218081584509971585071423) }}, 
      {{ SC_(2), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(1.9562579226009881088210671421944586716867895152512), SC_(1.1018080012426695411192973371485245069943322457214) }}, 
      {{ SC_(2), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(1.9845388981027882440443564122236200930250308142901), SC_(0.81086993731498529375959228825686023902845921423536) }}, 
      {{ SC_(5), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(0), SC_(0.98623278039249983055367190826649550767964102350066) }}, 
      {{ SC_(5), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(0), SC_(0.94751865114509654788699818254669665586168646980629) }}, 
      {{ SC_(5), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(0), SC_(0.63435737469237153077636493055394066544839817811588) }}, 
      {{ SC_(5), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(0.75180331636922892930414680942120817288497273719322), SC_(0) }}, 
      {{ SC_(5), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(0.82603778851222148995690317375710549667980365212588), SC_(0) }}, 
      {{ SC_(5), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(1.1581874398122557751430288786976914445338371286637), SC_(0) }}, 
      {{ SC_(5), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(1.2047260115460347237384722365368913393827499369116), SC_(0) }}, 
      {{ SC_(5), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(1.7222813467832163936085179872509517305850813908258), SC_(0) }}, 
      {{ SC_(5), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(0), SC_(1.0536616398767741175571384251069263904563260329049) }}, 
      {{ SC_(5), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(0), SC_(1.0143389872728294158583141289706818563116343122007) }}, 
      {{ SC_(5), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(0), SC_(0.69577346685700638510895765169789898304376204545473) }}, 
      {{ SC_(5), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(0.81535057424234387885782011768010296348911856823941), SC_(0) }}, 
      {{ SC_(5), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(0.89086613998938100916999942884599995479582130021435), SC_(0) }}, 
      {{ SC_(5), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(1.2281721288812144259762950861100933862618489601052), SC_(0) }}, 
      {{ SC_(5), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(1.2753623411342921726673104381269474406910664386496), SC_(0) }}, 
      {{ SC_(5), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(1.7990792422175226600058902129912553099189026754717), SC_(0) }}, 
      {{ SC_(5), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(0), SC_(1.6737020653136916733596535716772165435972364026522) }}, 
      {{ SC_(5), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(0), SC_(1.6302225326949068773517679248673352546636487857346) }}, 
      {{ SC_(5), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(0), SC_(1.2734396958135111632456063081488867212152513694408) }}, 
      {{ SC_(5), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(1.4083427555959507760323069657632090054953299158666), SC_(0) }}, 
      {{ SC_(5), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(1.4929184159486549300658050325819542597029682441315), SC_(0) }}, 
      {{ SC_(5), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(1.8652684829895896142301301374343453327236973177773), SC_(0) }}, 
      {{ SC_(5), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(1.9166900525395859117627209244874086517873551236022), SC_(0) }}, 
      {{ SC_(5), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(2.4769502658559700824910454784337557865674903125797), SC_(0) }}, 
      {{ SC_(5), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(2.5741856282073034243711111657354159830645262015128), SC_(4.5404265626726682569056456058173398759286382982096) }}, 
      {{ SC_(5), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(2.6163044543069225202108978658768233024577446398884), SC_(4.5174577854840975571410642764433662010758684503628) }}, 
      {{ SC_(5), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(2.9602177913445011813031990964422715814336701247719), SC_(4.3053568577198347044655448882395390812536479732569) }}, 
      {{ SC_(5), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(4.3905110151745908495245171369794076021787756679816), SC_(2.8305436189022256370458631241850156178139813371657) }}, 
      {{ SC_(5), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(4.440820069796997547533217965681006138984877464339), SC_(2.7490190948039197423087254188472495182835999407204) }}, 
      {{ SC_(5), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(4.6341603090209127259800035098032060876283583950576), SC_(2.3880903942830551911363883321918117854955849877003) }}, 
      {{ SC_(5), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(4.6572446041289735983771860808386715691144481042782), SC_(2.3379927950467602900042453073297720581194520484723) }}, 
      {{ SC_(5), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(4.8521008099817356648945522422798471650284026510536), SC_(1.788149283390753729480066232949550043470007754391) }}, 
      {{ SC_(5), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(2.7214692732902412004647184520865471768713003597818), SC_(4.5993883390222681391842648419683250330582439348776) }}, 
      {{ SC_(5), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(2.7625924470914592531940464793248074993813372803375), SC_(4.5783969721600147952263738046249821710506935993863) }}, 
      {{ SC_(5), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(3.0973598631889430232199102357597886480722482634636), SC_(4.38243770549209103069310850646870524266077941434) }}, 
      {{ SC_(5), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(4.4615202634300571913664164445385680817832594176107), SC_(2.9713519540128339986214249698086124078674548184213) }}, 
      {{ SC_(5), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(4.5079991918736531832982253515602563475953309607201), SC_(2.8919956157030106119887355412833718286458385435879) }}, 
      {{ SC_(5), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(4.6844465404381571363429843649150042758592537039919), SC_(2.5394618325928391038622378119588663842313983169556) }}, 
      {{ SC_(5), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(4.705224337239825715849222693910693807982507385177), SC_(2.4903791454847839836607264358416491157260943893531) }}, 
      {{ SC_(5), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(4.8768716224445600566144129727770335512623625205651), SC_(1.9493259057013485489941468651424998021768381722148) }}, 
      {{ SC_(5), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(3.288896188753107916003236812593202033315263069661), SC_(4.7781320742368641623491821013507015838490065932549) }}, 
      {{ SC_(5), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(3.3247778739532023861541155005202171536199642696319), SC_(4.7645494104028939023889893329377380313059694585465) }}, 
      {{ SC_(5), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(3.6131234933748300078026229443021331328847299175568), SC_(4.6315847149335902853219842635809473991627432397347) }}, 
      {{ SC_(5), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(4.68647642654934697432587249248703530748247288726), SC_(3.5053967376875327940705022402844353038428106181243) }}, 
      {{ SC_(5), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(4.7179932606655530431793452435751963305817615612615), SC_(3.4370448887447143657898238957347297377498576937279) }}, 
      {{ SC_(5), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(4.8315913815647421585782680255898847463362635666137), SC_(3.1289418047403285906503500608110552996134190895118) }}, 
      {{ SC_(5), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(4.844231776769781265530007264967536282095006368052), SC_(3.0854929087361223332218389196992004940822397662546) }}, 
      {{ SC_(5), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(4.9410329299017523606402076486889743131307881945812), SC_(2.5980289585199945355528762055842005652318640154982) }}, 
      {{ SC_(5), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(3.3566851670651562300349575508402922386254229343659), SC_(4.7947436493679075941524820281553657831545093599892) }}, 
      {{ SC_(5), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(3.3917779574246194181463664768742590461818171191463), SC_(4.7819860049494286612680406498686207009565492733493) }}, 
      {{ SC_(5), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(3.6732931033241433023814772022460671492147372198727), SC_(4.6563535563542660736695591730664814320724792323311) }}, 
      {{ SC_(5), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(4.7083668628099697388551053546026483593056461066898), SC_(3.5682252451747414036861820160207362061168904108598) }}, 
      {{ SC_(5), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(4.7381411484867750038148457133615587347206059462478), SC_(3.5014925963614948287850115474496736022827992487478) }}, 
      {{ SC_(5), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(4.8447860474039482557850267608230319633134593934586), SC_(3.2000978170144359702426975061454921368597494161867) }}, 
      {{ SC_(5), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(4.8565750034423192206018517154557900566383427348099), SC_(3.1575228887096100066774234625804497438731261019467) }}, 
      {{ SC_(5), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(4.9461735910047342259536968202780463655535155879112), SC_(2.6787735674644576253280338824250960695991786068366) }}, 
      {{ SC_(5), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(3.9417441318134440068639737954707590106273970994648), SC_(4.9034550028495157018952660861524549939018535313155) }}, 
      {{ SC_(5), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(3.9682777978457445671463403009270804168929068500662), SC_(4.8968459001177439612764580191231241519804564120832) }}, 
      {{ SC_(5), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(4.1773311144889962105148439220139248854054191869056), SC_(4.8286626872317981007578504099952023568545574222152) }}, 
      {{ SC_(5), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(4.8575406614715527295442824855688190683518971566965), SC_(4.1001333608565885781849995761834203943832602573318) }}, 
      {{ SC_(5), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(4.8736689212362325896464494044156522671529652158244), SC_(4.0505794955178143393506701893962226896308135585351) }}, 
      {{ SC_(5), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(4.9287551601147010779251770426419014221764368895729), SC_(3.8221788418881979840458926247871600795297548461914) }}, 
      {{ SC_(5), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(4.9345640142121638432673482051990823751695143830321), SC_(3.7893519709627674998117560496476928437617806084273) }}, 
      {{ SC_(5), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(4.9766468528929433819013699320785773056336491818983), SC_(3.4116609888589226636096463658891010915964074035119) }}, 
      {{ SC_(8), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(0), SC_(1.5975531934145445499455782867998060380210313828206) }}, 
      {{ SC_(8), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(0), SC_(1.5507297314587392322761076321241930437692005091896) }}, 
      {{ SC_(8), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(0), SC_(1.1711261637391554525393520822022506137212275866884) }}, 
      {{ SC_(8), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(1.3137031393373713665054776539258027781663471544691), SC_(0) }}, 
      {{ SC_(8), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(1.4036781891639000341666269461063191708099172541838), SC_(0) }}, 
      {{ SC_(8), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(1.8053655594676505704912918683002626466710318438464), SC_(0) }}, 
      {{ SC_(8), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(1.8615777865101521331034987019774736777396700940198), SC_(0) }}, 
      {{ SC_(8), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(2.4868666027155862362050560423624063463014865906812), SC_(0) }}, 
      {{ SC_(8), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(0), SC_(1.6963681537663636705765968396918410359210872170443) }}, 
      {{ SC_(8), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(0), SC_(1.6487162227285730697711412421866392982139140843155) }}, 
      {{ SC_(8), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(0), SC_(1.2618816992631851605706428173218226127029115948379) }}, 
      {{ SC_(8), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(1.4072864495415986595533264529638945519683373141731), SC_(0) }}, 
      {{ SC_(8), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(1.4989752203054474683906501795011740931935967391184), SC_(0) }}, 
      {{ SC_(8), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(1.9077027074065342461326253142268113678510061592396), SC_(0) }}, 
      {{ SC_(8), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(1.9648257563712275683291714097605187886945093232466), SC_(0) }}, 
      {{ SC_(8), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(2.5991353820476662798634366989417415648106068539833), SC_(0) }}, 
      {{ SC_(8), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(0), SC_(2.6195481235084993788398181848243481751008884343148) }}, 
      {{ SC_(8), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(0), SC_(2.5660100458940575035140582094694199436474017870783) }}, 
      {{ SC_(8), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(0.31927338814426921612088172937139434659602078657372), SC_(2.1266336167208010966030725174336651366542234336692) }}, 
      {{ SC_(8), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(2.2928192572454368268007745314533653580109264518292), SC_(0.19349725370092510891521905819340656406697805621155) }}, 
      {{ SC_(8), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(2.3969606281325348415417008951503940015641568511585), SC_(0.11770443802296133827343843128307786622554272114691) }}, 
      {{ SC_(8), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(2.8555491327933046098182332178570282640746448048787), SC_(0) }}, 
      {{ SC_(8), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(2.9189485476766768304499848550432809032647723736638), SC_(0) }}, 
      {{ SC_(8), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(3.6125038915778185887521626133324931600575562656131), SC_(0) }}, 
      {{ SC_(8), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(4.7525119434223879243476545676940161406902978347835), SC_(7.233872055484985337460772313366441801546561189233) }}, 
      {{ SC_(8), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(4.8040595442554609748323062366077467206259058255082), SC_(7.2019154796589379900485129569989311015676936123214) }}, 
      {{ SC_(8), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(5.2253584594777590975685975841884682542903750272508), SC_(6.9152320724856987085830621802327105417821783708115) }}, 
      {{ SC_(8), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(7.0287745882544993036728906628573074470488910049102), SC_(5.0663832055191576273043401827286434568962286398231) }}, 
      {{ SC_(8), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(7.0967587787935989073375399975198384619389441153446), SC_(4.9665263662398979969595317807385097132037314035064) }}, 
      {{ SC_(8), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(7.3669430942184369984665847270615491124088688704993), SC_(4.5247568727171159056793721687975985317211578695586) }}, 
      {{ SC_(8), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(7.4005030778110887673952187244993302751046286061549), SC_(4.463427977888737276267793104328120275143192290071) }}, 
      {{ SC_(8), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(7.7047360581904019590779778430225352217268667728579), SC_(3.7886134642666439271698262578298213370744299537035) }}, 
      {{ SC_(8), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(4.9717399387145089823745733586305970794561632513591), SC_(7.3389763547088901787175571278072890101450877023296) }}, 
      {{ SC_(8), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(5.0218793876895695694227024303013218501549611626848), SC_(7.3096053430250263713177464091327882064313814781227) }}, 
      {{ SC_(8), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(5.4306152874819620374094473379469431934433760614437), SC_(7.0436292685781529807460094586896251675279872406167) }}, 
      {{ SC_(8), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(7.1494473625067568262543333217309637656575051855187), SC_(5.2766075652516322046976256398858371795352885878478) }}, 
      {{ SC_(8), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(7.2125242928928775241498480642518513285899834879926), SC_(5.179728190165988017953634562466143743196252501051) }}, 
      {{ SC_(8), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(7.4604981754240830803968214300115902233069214287243), SC_(4.7498879940697838929284499274461046264561550369018) }}, 
      {{ SC_(8), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(7.4909169046977613730178923869632591982242728286438), SC_(4.6900617750217993232053908538995650497164997755709) }}, 
      {{ SC_(8), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(7.7604331494561252714067089794881487385224509950281), SC_(4.0294508268691586463561787876518991332056620224694) }}, 
      {{ SC_(8), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(5.8019199602371492796780881885063681433728457184511), SC_(7.6591859456615026358589894659614821495426646061683) }}, 
      {{ SC_(8), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(5.8449431612958809083394798420363083089098751790438), SC_(7.6401692703801432771467720865321486779235493362185) }}, 
      {{ SC_(8), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(6.1916832891126894384324803755499691267841811975543), SC_(7.459425116240171610751252020768764096585791833574) }}, 
      {{ SC_(8), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(7.5330063979744472572265958910504295868919017481301), SC_(6.061896583635478331279488867702283313260726668871) }}, 
      {{ SC_(8), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(7.5758665730834609677927170712395304160225290105655), SC_(5.9797101285429970468470070178855785217760498666524) }}, 
      {{ SC_(8), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(7.7353980321732618101998645015615573445437221692406), SC_(5.6103570369256105070440630084687932138336329643772) }}, 
      {{ SC_(8), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(7.7537865902447360441037949819237710156464322633006), SC_(5.5583732490459623606342598995454919109909116162738) }}, 
      {{ SC_(8), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(7.9012332736463500230032331951517918017163934074985), SC_(4.9757081321700624819239729947490627705513103288791) }}, 
      {{ SC_(8), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(5.8993483081081915064182366551975441271234987770393), SC_(7.6886100071836491570746123758042558240309917416985) }}, 
      {{ SC_(8), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(5.9413260212486446867432470889123650805375437312681), SC_(7.6708132252538400247320737568646468908552822040221) }}, 
      {{ SC_(8), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(6.2790996977994015166585194816878277399803495170146), SC_(7.5004714758607326828836650571695943960412472692886) }}, 
      {{ SC_(8), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(7.5700496094795420407947636293073503010736363463405), SC_(6.1527874893333878428659274802999707844153020666101) }}, 
      {{ SC_(8), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(7.6104398190649244046085181099357217722459770601892), SC_(6.0727260967752193932475101482813820195635327916802) }}, 
      {{ SC_(8), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(7.7596217162714820703867200949227468306453119657072), SC_(5.7122782794936941388159708441785316985470657786938) }}, 
      {{ SC_(8), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(7.7766711688987982087407433360342835087871234997089), SC_(5.6614699854699088597902484576935737692115251681702) }}, 
      {{ SC_(8), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(7.9117883023237024464191195389352805294365346427165), SC_(5.0908310840611668671280905255392622638748091629196) }}, 
      {{ SC_(8), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(6.71909840851420181048979468711141614532428668071), SC_(7.8726338289849308371080610776664758884585969171513) }}, 
      {{ SC_(8), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(6.74997516914698986078551147967929842463260454969), SC_(7.8641139321645272968832734923455728676746579643248) }}, 
      {{ SC_(8), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(6.9941142543782601833249640769596707386395498022376), SC_(7.7773122429334014474115355028856625150049616498483) }}, 
      {{ SC_(8), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(7.8138499443528439115043170733450889340753369166048), SC_(6.903759181002902018866000264286197269534324170773) }}, 
      {{ SC_(8), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(7.8343951456580714540346628108258716866535433660742), SC_(6.8458910419763555040941626924311513683230460068565) }}, 
      {{ SC_(8), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(7.9054532285921767656418757805725653104974772316907), SC_(6.5801977143451748564398084228416743640426150600365) }}, 
      {{ SC_(8), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(7.9130374770177925483375400405539140515791387453992), SC_(6.5421211598756069105959732597770536383353317537145) }}, 
      {{ SC_(8), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(7.9686104117514492077813408006371039408801242570413), SC_(6.1052374390100729183128842557533199710523441301264) }}, 
      {{ SC_(11), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(0), SC_(2.167473095716121587731912883993309388774621070307) }}, 
      {{ SC_(11), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(0), SC_(2.1140003140541254692852677000749783222128092841047) }}, 
      {{ SC_(11), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(0), SC_(1.6796511744437743466272656783964388535643512641642) }}, 
      {{ SC_(11), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(1.8429896217811417056077917670666851833478110787552), SC_(0) }}, 
      {{ SC_(11), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(1.9459349180377605520107044071204383531965557278175), SC_(0) }}, 
      {{ SC_(11), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(2.4045986048537162973723228230184529748819236423455), SC_(0) }}, 
      {{ SC_(11), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(2.4686934746983498400459708934696735009686353055374), SC_(0) }}, 
      {{ SC_(11), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(3.1809794822340814910131986930441837178690253826), SC_(0) }}, 
      {{ SC_(11), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(0), SC_(2.2967057003832552392345736088704448354439437682067) }}, 
      {{ SC_(11), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(0), SC_(2.2422240413382618385312996400166563310948740511457) }}, 
      {{ SC_(11), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(0.061172663227154448551277153329608133145431739969472), SC_(1.7991429654197614996243714623588269194862029747509) }}, 
      {{ SC_(11), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(1.9658819030125753396386010837663205217046080865987), SC_(0) }}, 
      {{ SC_(11), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(2.0708964788635606255121883903578042793883854484496), SC_(0) }}, 
      {{ SC_(11), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(2.538144492820851667891584582871661149802027195456), SC_(0) }}, 
      {{ SC_(11), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(2.6033618338307157605427520208990728975056998613894), SC_(0) }}, 
      {{ SC_(11), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(3.326981093737861931485193395899460423573839284439), SC_(0) }}, 
      {{ SC_(11), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(0.39795209151837785099505939564944467278986253303265), SC_(3.5154478693089854251837537995037558480226752329358) }}, 
      {{ SC_(11), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(0.44237631689868162460349212361541565896005707920621), SC_(3.4536635077649702609500285005027127485221105137315) }}, 
      {{ SC_(11), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(0.83026699182511012881996417984042106504381744133163), SC_(2.9462776625844107475209735945369590582762640980146) }}, 
      {{ SC_(11), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(3.1382809107304237610347780200159660128565317179166), SC_(0.67863656725250929559747648904312933346920881573102) }}, 
      {{ SC_(11), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(3.2585345496280253227805471623004224463100986346677), SC_(0.5866788846723945869272092416460956807137173725655) }}, 
      {{ SC_(11), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(3.7877719104944048676024390817889721037533277103148), SC_(0.20944020436057653728808253528268721275356105428726) }}, 
      {{ SC_(11), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(3.8609314549465213784804415609873418803745721373583), SC_(0.16083721984971719291281634097924946649179118127989) }}, 
      {{ SC_(11), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(4.6620663844468865494204912492300197399831560157716), SC_(0) }}, 
      {{ SC_(11), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(6.9780361515718149029642816170573436643012615054465), SC_(9.8906100650430231825488782232326453954726163711522) }}, 
      {{ SC_(11), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(7.0373145888980355809987208776061223202361768588052), SC_(9.8509272827210241723847959350730352454886483505518) }}, 
      {{ SC_(11), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(7.5223477781105675894146935837629468361544432506579), SC_(9.500702274301093218663642282409486075005648291668) }}, 
      {{ SC_(11), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(9.6383351196047628642737872084460980698881314835466), SC_(7.3391833440008872653156323195291205030455569715582) }}, 
      {{ SC_(11), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(9.7213707932923883352310658033244933494139164782174), SC_(7.2242269558192156271663409058559327877300384224048) }}, 
      {{ SC_(11), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(10.057782800034991131115598228225451396821512733967), SC_(6.7162225891342822425602910218271800283956798858923) }}, 
      {{ SC_(11), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(10.100524912422443076945989347777427173413324231103), SC_(6.6457406679654394132515621179013359380389597714948) }}, 
      {{ SC_(11), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(10.505846154809183115185866487621501807662586819916), SC_(5.8700224147579674955234767490240539804763050578597) }}, 
      {{ SC_(11), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(7.2673999093734025547290629423931321872971083701177), SC_(10.045669525736338568928219144116985236967058594375) }}, 
      {{ SC_(11), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(7.3249322795850745531107392350979118796196528832441), SC_(10.008984794784043643219880742318298305521033721178) }}, 
      {{ SC_(11), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(7.7945964706202709364263308472608885335941575466297), SC_(9.6827083054064633576237166898436296654871646274692) }}, 
      {{ SC_(11), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(9.811413653636669730526745045564138449150852578001), SC_(7.6174690567844474439670459695997166220237703627556) }}, 
      {{ SC_(11), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(9.8887761121954549878823221267610685182642417306365), SC_(7.5061548353312469659451490362796542176496302246578) }}, 
      {{ SC_(11), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(10.199397124500628041006587786172029951501180610828), SC_(7.0129729203538491851449984997166462528477532826883) }}, 
      {{ SC_(11), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(10.238460960766546530237803157812882303042475574801), SC_(6.9443910364819257411107445068134408276887511456379) }}, 
      {{ SC_(11), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(10.601670072785220161703250211390576415899216643615), SC_(6.1872337092154794882930876239851478277032785468704) }}, 
      {{ SC_(11), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(8.3520760015746565962394572211465738905250900664255), SC_(10.524491170028298844782221926315893980529824338888) }}, 
      {{ SC_(11), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(8.4009541010537980643968059730524682441762114664587), SC_(10.500336569262119716286441086351963504320603429095) }}, 
      {{ SC_(11), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(8.7958232186488404380383265622585272582362468476075), SC_(10.27585020268324218956008588733390495078926797175) }}, 
      {{ SC_(11), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(10.366281553012760412986387992021846217933576366618), SC_(8.6478012551228897365062142266601263196035674768941) }}, 
      {{ SC_(11), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(10.419518153797230760665228051628617586347655178774), SC_(8.5542118823780913860248839686044235049823831927752) }}, 
      {{ SC_(11), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(10.622730590579734640877084302705931136592220817217), SC_(8.1346815356468310382676586845306821776869647430531) }}, 
      {{ SC_(11), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(10.646839478435421791904193985927588776876694292037), SC_(8.0757460350057218621653575759387310317619569445758) }}, 
      {{ SC_(11), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(10.848854798261799032568186105530591943264763391147), SC_(7.4162390831519878306438294294535916105367629630198) }}, 
      {{ SC_(11), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(8.4780099404798621534818595739210022147320182995527), SC_(10.568787703608691238872807007114528057489260505398) }}, 
      {{ SC_(11), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(8.5256317539929159210587279312084536501478786408961), SC_(10.546179759333481252712140004165791807094776775403) }}, 
      {{ SC_(11), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(8.9097768376352311196233262988426787410428557133795), SC_(10.334567666760573839364348016100468108315128772381) }}, 
      {{ SC_(11), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(10.420100173769723127255423003306520049332447702813), SC_(8.7659008468686277071103319690499471263712237818374) }}, 
      {{ SC_(11), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(10.470282755246597545933770254174219774798879414106), SC_(8.6748528590099234515502704290551284395531007224226) }}, 
      {{ SC_(11), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(10.660307028788603161579041627045976503265633144615), SC_(8.2660317058416281892447356875399886731882840462915) }}, 
      {{ SC_(11), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(10.682645730839116547148308961551732405965676370236), SC_(8.208518452918906669770648231119970279356656419746) }}, 
      {{ SC_(11), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(10.86714845511359374364733182116233674397199120302), SC_(7.5637257952320644205324591578841982942030348755878) }}, 
      {{ SC_(11), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(9.5210674897471645978357242509712851517584303199635), SC_(10.840773969006494307480215488162849961310861729028) }}, 
      {{ SC_(11), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(9.5554934750471391222568135456089414346922636896698), SC_(10.830386857839104365397679126065112123059993586184) }}, 
      {{ SC_(11), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(9.8285069914019465398408571500570865205073540427657), SC_(10.725852514539509075011983804408972974493214963925) }}, 
      {{ SC_(11), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(10.7695924816026877611378179259886016466317205309), SC_(9.7272798172748387950451486302833649522985295748122) }}, 
      {{ SC_(11), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(10.794347415698217181312076216414481916769508547765), SC_(9.6625694011762836703817950015273732007774021894685) }}, 
      {{ SC_(11), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(10.88104385163569629053560688941109986304830619697), SC_(9.3664269691510811059708615487871052027934879050869) }}, 
      {{ SC_(11), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(10.890413070484709140785336522882921452598174579773), SC_(9.3240936718798667687807818118935865446829726770234) }}, 
      {{ SC_(11), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(10.959927507437739108924762009895355126804391020586), SC_(8.8396763598709593261309091020867886900750477284118) }}, 
      {{ SC_(14), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(0), SC_(2.712400632124789779551613897864424284445095897895) }}, 
      {{ SC_(14), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(0), SC_(2.65315950199915039740317082554810414160948144961) }}, 
      {{ SC_(14), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(0.26558322243320311449786107587522467208197588227562), SC_(2.1711952521528709946492249708876661108406979676679) }}, 
      {{ SC_(14), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(2.3526161133228662965515720308297389717394004483467), SC_(0.13798255002468249326746163899466147417427544940488) }}, 
      {{ SC_(14), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(2.4668426580062830301798730200744948723136068806668), SC_(0.061482969087541275222883522254161623036137330397865) }}, 
      {{ SC_(14), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(2.9749146083872193340067257336655298417940224473351), SC_(0) }}, 
      {{ SC_(14), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(3.0458249942417791477076384072896256097549023968441), SC_(0) }}, 
      {{ SC_(14), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(3.8329718186425153457294672506857618564521343935726), SC_(0) }}, 
      {{ SC_(14), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(0), SC_(2.8714472333765571808649462139783127204697421407159) }}, 
      {{ SC_(14), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(0.022997481996621754978701346286085774277532252172362), SC_(2.811040572865369404433005658530487632481597872277) }}, 
      {{ SC_(14), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(0.3592177307105504485025885171160718948877219664573), SC_(2.319040300869333530392131272148606214545187682321) }}, 
      {{ SC_(14), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(2.5043592933339455439020386277688336180191652620832), SC_(0.22652559060355558821928869529119456488681792000873) }}, 
      {{ SC_(14), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(2.6209640690774752417654958859549989430546814788873), SC_(0.14680874260378736281867774092959680870697478214698) }}, 
      {{ SC_(14), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(3.1389608668833618575499479400654572692572811403025), SC_(0) }}, 
      {{ SC_(14), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(3.2111771611923774939402409932448052718890946804705), SC_(0) }}, 
      {{ SC_(14), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(4.0116529001298310151592917460228802827086988631932), SC_(0) }}, 
      {{ SC_(14), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(0.8604643264982837573907779859918270605275596174925), SC_(4.3810069365429508095223141272957431475989809639035) }}, 
      {{ SC_(14), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(0.91213616611646503957451603499362808304359695261111), SC_(4.3120681186696479199585820461044826437055727110176) }}, 
      {{ SC_(14), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(1.3596156715145882260479072164593338420793234269071), SC_(3.7455432191409963447554806561495990329879364233152) }}, 
      {{ SC_(14), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(3.9600232281104855215800444689206220997274394675627), SC_(1.1853933726475352501322205288519746735055136487368) }}, 
      {{ SC_(14), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(4.0942882836788902152941524718467514435311644455275), SC_(1.0793213621949821125460809164614107851528087414732) }}, 
      {{ SC_(14), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(4.6847972274725244803460104298476352684477742898129), SC_(0.63993416104843326129186452885226359993309779160584) }}, 
      {{ SC_(14), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(4.7663979040184663589255919837989716048654106826266), SC_(0.5826957664620422700134497715436169641588190211746) }}, 
      {{ SC_(14), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(5.6601202935847808939551766357983248755370628462259), SC_(0.012631425510332257629147033221764456411391975236853) }}, 
      {{ SC_(14), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(9.2321751158967468720299266245486199484050218968146), SC_(12.52202042213423058719477457477292761492012976371) }}, 
      {{ SC_(14), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(9.2981608091877277479491057174088533263545434796984), SC_(12.475553528581657734294875978437448563677598612833) }}, 
      {{ SC_(14), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(9.8386189149449152284634561528122765100949442958505), SC_(12.06956900459963607397201496871612961141295791243) }}, 
      {{ SC_(14), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(12.228338235228003011414322773366293094085281000672), SC_(9.6343932038269175305471017308801976371056361931982) }}, 
      {{ SC_(14), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(12.324581086769619427953584846643567604038466374621), SC_(9.5063053253736498291506217586791508997196837406835) }}, 
      {{ SC_(14), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(12.71916830070540501467199288253137899321225303309), SC_(8.9408574136874291596499177488769894969029304373659) }}, 
      {{ SC_(14), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(12.769995304234111910713076661107672042098461927792), SC_(8.8624595207995110844313678574452412750333006241654) }}, 
      {{ SC_(14), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(13.265574113841458766673693178720740223863748439708), SC_(7.9998923613975086662750206972033504731320963696505) }}, 
      {{ SC_(14), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(9.5905422256936737543946545028598075754262839333933), SC_(12.728985795962073389887147603334047419730838533607) }}, 
      {{ SC_(14), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(9.6544885556086003405058068391558611381831367665573), SC_(12.685835538266285056921891040879209900282370800983) }}, 
      {{ SC_(14), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(10.177139671966946326043852027666662119213013365815), SC_(12.306394053405266230432524053579427052475442384597) }}, 
      {{ SC_(14), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(12.455256060826934797239074083691981299231411536666), SC_(9.9798805425853216442255795757828648550836584432603) }}, 
      {{ SC_(14), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(12.545211501610648354008260572107527493016166127527), SC_(9.8560124247286671524415360854082001439947923821433) }}, 
      {{ SC_(14), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(12.911266157376058853837170796457610265310061120676), SC_(9.3078972513714531563710267305076143719673211780216) }}, 
      {{ SC_(14), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(12.958025395879006984351602704090508443204326743064), SC_(9.2317434314987183347266214623686316960094030808682) }}, 
      {{ SC_(14), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(13.40666556158407406568555218720533971940179232107), SC_(8.391489522023476545900136272052011344010151762742) }}, 
      {{ SC_(14), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(10.924571090733759111139368686815066348696604560166), SC_(13.37647688373602934841616689662352413151292941703) }}, 
      {{ SC_(14), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(10.978527611226199219998476168340384096816204792687), SC_(13.347534151760587994989222381307115396575798320029) }}, 
      {{ SC_(14), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(11.415263295046869011568123017176988450501087687055), SC_(13.082992592817664846529067629206749380290826277173) }}, 
      {{ SC_(14), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(13.188728869765856802538411746032041746948092278941), SC_(11.251353731372739871693183345901103303968353023812) }}, 
      {{ SC_(14), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(13.251460881444985961870998414921999749083073942118), SC_(11.147844970102549252056353596161489439503683132973) }}, 
      {{ SC_(14), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(13.495538807341318868145144916423822677847335174208), SC_(10.684809703141976816893934585336406351015315542357) }}, 
      {{ SC_(14), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(13.525150013755001840948121796327325836477235503703), SC_(10.619865846941921800690934769302397400955515678411) }}, 
      {{ SC_(14), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(13.782965806151883705612096996050018884097593088656), SC_(9.8942693945689589520032049573640436380150194924384) }}, 
      {{ SC_(14), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(11.078307913549649115189339800474350120478553105796), SC_(13.437063411560137647118839057844491165251430575052) }}, 
      {{ SC_(14), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(11.1308250432840828439057823327330083595535451321), SC_(13.409931133476240865719799180205243471591614261363) }}, 
      {{ SC_(14), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(11.555309587162449138436945724144935112840609617566), SC_(13.160265827907934226385946278406255444263887883982) }}, 
      {{ SC_(14), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(13.2603745421437147914681019662258068281146239516), SC_(11.396129387551758728521168790043692068759289710526) }}, 
      {{ SC_(14), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(13.319579940051631521701139398781880357525824119321), SC_(11.295523779841010092031236110729828602722635893919) }}, 
      {{ SC_(14), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(13.548169980320285938363354658104539047079102868964), SC_(10.844764297307601642574901515001679305760057524415) }}, 
      {{ SC_(14), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(13.575656031726235667410425542879015330224675924201), SC_(10.781456712180302221277888387584135831237714912411) }}, 
      {{ SC_(14), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(13.811293222095159790481290114682618950215499633651), SC_(10.072897867935478593556664868569368918705156518369) }}, 
      {{ SC_(14), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(12.3376799884847119942429915678326394905222640955), SC_(13.807340446850373936514853606817111070107270940968) }}, 
      {{ SC_(14), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(12.375179390117606904175894056635750073432887956798), SC_(13.795103934940870434232213595950420398479841386127) }}, 
      {{ SC_(14), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(12.673304949198538860614626482744348973604199470001), SC_(13.673400762377738407539699762319608810879847296015) }}, 
      {{ SC_(14), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(13.72403596367771746940488462987098400619642947658), SC_(12.562598571399290144702727666030581618252957880163) }}, 
      {{ SC_(14), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(13.752868126267133972249249797053273220642579319459), SC_(12.491937571874878338986669517487093162384935715533) }}, 
      {{ SC_(14), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(13.855087057485530555087011953314488902101690962355), SC_(12.169441884435690828477698880668481642848444488126) }}, 
      {{ SC_(14), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(13.866272824984795888676034616199145581916429420222), SC_(12.123439915028952637672168437400916462230111375412) }}, 
      {{ SC_(14), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(13.950384113585257550058783137400617159156712021496), SC_(11.598290717892468144208760568350897004106790749988) }}, 
      {{ SC_(17), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(0.14437183813444952995046264009219710507250009179279), SC_(3.2401679013560077309418420449048382205452389718558) }}, 
      {{ SC_(17), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(0.18565330947377194350189781345113841664728051567543), SC_(3.1757635495374392921701019214791832206664838609604) }}, 
      {{ SC_(17), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(0.55105005335820856520027183656266777712398307643896), SC_(2.6511108197807158958273833393904911309219761341415) }}, 
      {{ SC_(17), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(2.848757026543820744283929777893728970508105520657), SC_(0.40722789149347153214474663459817058871109536524596) }}, 
      {{ SC_(17), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(2.9730977826943974023699300135993479878108694167746), SC_(0.32060015530190816031101507520220302583193816789909) }}, 
      {{ SC_(17), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(3.5253840637290069748258666265498863323246175637229), SC_(0) }}, 
      {{ SC_(17), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(3.6023822633820690530122710250418753683081356239672), SC_(0) }}, 
      {{ SC_(17), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(4.4561970118575053691487702886584238048305213389735), SC_(0) }}, 
      {{ SC_(17), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(0.24387525962812971282871262494272953501408096553407), SC_(3.4286049343625006443158982676532168966157003976657) }}, 
      {{ SC_(17), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(0.28699681480516373029170333089207848274918196669284), SC_(3.3628946662817724128208224064701981736686486482492) }}, 
      {{ SC_(17), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(0.66724223661495793307148481951275665984659556478335), SC_(2.8270369571556529839048642191352500189569177775111) }}, 
      {{ SC_(17), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(3.029027377583354374670622854651461607065934743591), SC_(0.51785143912338237878280093132721802085029846239833) }}, 
      {{ SC_(17), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(3.1560233206299228043711180008659812817640418725618), SC_(0.42770627217861634777279096852618948926450904736722) }}, 
      {{ SC_(17), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(3.7194355959229359529759669218222938283661335531862), SC_(0.062029296910114800596443260464116103522490321920603) }}, 
      {{ SC_(17), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(3.7979039312927213588929712156162654626080943410825), SC_(0.015470025462353473781884048826593946436774224686907) }}, 
      {{ SC_(17), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(4.6668301120804469081922394623852400965531412702746), SC_(0) }}, 
      {{ SC_(17), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(1.3430265865673867854915520685656993942967834307375), SC_(5.2256478461777866139467389922440518004557526598227) }}, 
      {{ SC_(17), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(1.4011851331584713318286379280106387164858686633294), SC_(5.1503038238835517561370647803464172296173359928207) }}, 
      {{ SC_(17), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(1.9021019858374156286157513830005845919437112662229), SC_(4.5307592670455697772849909010438551434193052902878) }}, 
      {{ SC_(17), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(4.7654048190055001702014318917185741094899964730528), SC_(1.7076005168588866975563951629870223756053089584583) }}, 
      {{ SC_(17), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(4.9122318247573589077674578775160755867224884961273), SC_(1.5888703554844460739668212150059743338203456293896) }}, 
      {{ SC_(17), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(5.557582948498653707451854839430948580317946675781), SC_(1.0938808024344078199000738052308118438968556958118) }}, 
      {{ SC_(17), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(5.6467260818793587630038668621943491212321922963808), SC_(1.0289372102314034351698515282443267951858648996698) }}, 
      {{ SC_(17), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(6.6229325017109936233803989963888938538337079534983), SC_(0.37306885157970940382241750995455814076013264170327) }}, 
      {{ SC_(17), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(11.506018233116187488177504955328327666326865924581), SC_(15.135022784030456936607830884362860734432602102679) }}, 
      {{ SC_(17), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(11.578008508844123908971868624004442394838015812444), SC_(15.08246841117147789813438904916221699624805812075) }}, 
      {{ SC_(17), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(12.168156428350027861196691043632506968227878942401), SC_(14.626386112283399141143998500400296346506134963189) }}, 
      {{ SC_(17), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(14.804157994481700865564970651061674034812578267578), SC_(11.945034584860458985309712863139265723901132783274) }}, 
      {{ SC_(17), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(14.912267418790559146295157660942134582544798002848), SC_(11.80517368749314938782682092134852903803706320954) }}, 
      {{ SC_(17), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(15.359046075748550428176045567674581751319074788497), SC_(11.188312170893584054392764322818221273987573090765) }}, 
      {{ SC_(17), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(15.417116180354180722121982907854950332115959739874), SC_(11.102841508094886995085031419505518320845192168269) }}, 
      {{ SC_(17), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(15.993557843256097494239004590508129287775886193623), SC_(10.16290500367311056621296201751065910823435646512) }}, 
      {{ SC_(17), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(11.93259289206639824292981819385571390066189191893), SC_(15.395051705433618129044439490506579542045957198206) }}, 
      {{ SC_(17), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(12.002280999637291534487659824993559714989056301744), SC_(15.346083283606347256695754318130406595273500998551) }}, 
      {{ SC_(17), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(12.572436163162333089853760747877678292872280074224), SC_(14.918778613890250933246981028561121075046489949182) }}, 
      {{ SC_(17), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(15.085792240937927667061726565803548544042167250062), SC_(12.357114455411609091427563841619687721868041349227) }}, 
      {{ SC_(17), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(15.187084790323376004640709262880052578986122121054), SC_(12.221991188567526862876745306181430409514969230653) }}, 
      {{ SC_(17), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(15.603024847859272971682527952589593104129456806449), SC_(11.6247113056721413741909679953305010048518650533) }}, 
      {{ SC_(17), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(15.656710098756545197288132524481082518058790694152), SC_(11.541792563601282491396321143083454158040488867549) }}, 
      {{ SC_(17), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(16.182644762381018807376652255833514447914986375335), SC_(10.627517028638517025423710724513546912130868779626) }}, 
      {{ SC_(17), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(13.512366690897172871431436339709987228311262039843), SC_(16.217477884719730918119621220440608739841545595096) }}, 
      {{ SC_(17), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(13.570868156839957641812731755271610973722519787925), SC_(16.184089808456311350694985038690044694905905629825) }}, 
      {{ SC_(17), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(14.045140284808616046098268442525154718358037461436), SC_(15.882690703004829109561677951519003320600867462986) }}, 
      {{ SC_(17), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(16.002453395895476185204551498536858820568822684718), SC_(13.866972293591558024503887992575715363096627617541) }}, 
      {{ SC_(17), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(16.0739191867988760849651527591192323406687724469), SC_(13.754569947462424994034541611565226050325069776374) }}, 
      {{ SC_(17), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(16.356023649524715672250137224385689456206750284336), SC_(13.252609949387298541509089105510269939895837368046) }}, 
      {{ SC_(17), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(16.390834815330655643457996047050500283392626584963), SC_(13.182301021679397480065638937846564537169520219761) }}, 
      {{ SC_(17), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(16.703628792074241541319349087759791223520765543245), SC_(12.39787426952464589317898242965882960048045162636) }}, 
      {{ SC_(17), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(13.69341451867880905010070797700898170868917813122), SC_(16.295322255016774902831790045515039512988620447648) }}, 
      {{ SC_(17), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(13.750312509257044436023642521525693464568371903329), SC_(16.263960667948387442526909216813239438849513551655) }}, 
      {{ SC_(17), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(14.210965067432562864625275905206769874288653019325), SC_(15.979106465481747982713004635848684035964131033474) }}, 
      {{ SC_(17), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(16.092627785622583029241506074814999710079471887176), SC_(14.038049133823958206307671240416939084876963858646) }}, 
      {{ SC_(17), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(16.160172911671799517823421123344434943433085535588), SC_(13.928874142972266982968653870903073281869304178505) }}, 
      {{ SC_(17), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(16.424908805173163792782447075361817930612251327764), SC_(13.44059363327360055688968621108691869661725101291) }}, 
      {{ SC_(17), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(16.457307619842182818725385622456676169687520873429), SC_(13.372112637376386620758718753227331801393998380904) }}, 
      {{ SC_(17), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(16.744009566208498479682121183599526546240989763072), SC_(12.606800141930339172606814789316829854205311669265) }}, 
      {{ SC_(17), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(15.164232098588991332185826002393043709764925490785), SC_(16.772141622145132480200592023310122221466597727453) }}, 
      {{ SC_(17), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(15.204479110282743331126436210011358550890943780679), SC_(16.758069532057392943438477536967613751702480461392) }}, 
      {{ SC_(17), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(15.525121339790853202305908496206288395808054986842), SC_(16.6196619509124564757779966215506663445174123869) }}, 
      {{ SC_(17), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(16.676940640568211183614753364127913366087936984488), SC_(15.405900847988278000216485596351743089787905281905) }}, 
      {{ SC_(17), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(16.709740030629665765592634012952047294856994142534), SC_(15.329904370028489853394362679680084636068590211648) }}, 
      {{ SC_(17), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(16.827400025396642632417002643904182702471594158181), SC_(14.983857442569853937553209857963785772861198912686) }}, 
      {{ SC_(17), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(16.840435273462159332414553386289590545770065458501), SC_(14.934586284155619483278065105898927993745009725485) }}, 
      {{ SC_(17), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(16.939843434774604652148548927067963332918391744563), SC_(14.3732814897329682167467320699655189571314510654) }}, 
      {{ SC_(20), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(0.39326542142841477848937602291297185140804535124815), SC_(3.7552241240199550124461182716019052727043149614565) }}, 
      {{ SC_(20), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(0.439318276781494020252379301799905693872112886522), SC_(3.6861049317768231312050359781849773876446844920648) }}, 
      {{ SC_(20), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(0.84398973934914948313963075697865408742313915422869), SC_(3.1224281271187152844806554421466835029469385966283) }}, 
      {{ SC_(20), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(3.3349155072027394287822776516206428703536642221277), SC_(0.68526886696904600298816796741630112866648051736665) }}, 
      {{ SC_(20), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(3.4685024063998838303219876468203639349504130587851), SC_(0.58933813970995139795288785552025892875495494085375) }}, 
      {{ SC_(20), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(4.0611566091060913566900635431132447404318669825094), SC_(0.1985687320651031269425224438323549606439370886598) }}, 
      {{ SC_(20), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(4.1437059643025156534083422409451394924939856780198), SC_(0.14857089363212682631852305280182924867360335219458) }}, 
      {{ SC_(20), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(5.0581862989073316902141877041473678338328389749028), SC_(0) }}, 
      {{ SC_(20), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(0.51437946158629074988546386854254020011649935336401), SC_(3.9727328294787529246467849784513342030128317217425) }}, 
      {{ SC_(20), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(0.56240809568134511290648443375496838773622854328404), SC_(3.9021793684988641431828464642951160997591039441116) }}, 
      {{ SC_(20), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(0.98304386982521418669541426666228794504439392588054), SC_(3.3262286846534587418269002771590834576998326857193) }}, 
      {{ SC_(20), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(3.543468176661473404314804350618454865456618112365), SC_(0.81833121837805283281693922524285356853238995192934) }}, 
      {{ SC_(20), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(3.6799635226164913041799280134548397894610159857029), SC_(0.71861884385978104260417443271838717956976770063884) }}, 
      {{ SC_(20), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(4.2848418125490394120574079381043288304649528553072), SC_(0.3108728101002758570020193971425389758490602379338) }}, 
      {{ SC_(20), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(4.3690113646539952047674830827091869962329551928836), SC_(0.2584772384539115486486422118856055471810050849312) }}, 
      {{ SC_(20), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(5.300229554766274355217193954905262844253812304779), SC_(0) }}, 
      {{ SC_(20), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(1.8407297464381653751331151830476934096902624901838), SC_(6.0547483258962203382383225498733656254652957565561) }}, 
      {{ SC_(20), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(1.904805038233385253574884649463753482882996132164), SC_(5.9735540035195808740560162237539791771831792261849) }}, 
      {{ SC_(20), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(2.4545448825581795697603216362768253973570129985834), SC_(5.3055371832911269723138659354455450016992781519897) }}, 
      {{ SC_(20), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(5.558627731276124518348026535236940944527093336422), SC_(2.241500400432410599118761114695227191822642762066) }}, 
      {{ SC_(20), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(5.7169394996279094985645913879929378451932651422418), SC_(2.1112044332128742321969759017749406644068523374493) }}, 
      {{ SC_(20), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(6.4123737616601798289175116607552745181763672215216), SC_(1.5655154139693905686005846090249789739046269239886) }}, 
      {{ SC_(20), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(6.5083968323739291231955722532052471052937161510047), SC_(1.4935626601807575487042367052391416079021134632756) }}, 
      {{ SC_(20), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(7.5596904746640969229177922477438222494684346147364), SC_(0.76002573875546282312965326544804848314451841058235) }}, 
      {{ SC_(20), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(13.794487397105652852797123356966058423864433198804), SC_(17.734001089201369543296955625989098798166804515843) }}, 
      {{ SC_(20), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(13.871961750135913560927288893709412749975560003598), SC_(17.675889411042579793354043832710304874689809578026) }}, 
      {{ SC_(20), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(14.507536518440891374443772711135639438059001311826), SC_(17.174003815907302292452866312089692267661713806225) }}, 
      {{ SC_(20), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(17.369162170780163399957287728385204575098770326706), SC_(14.267130886637463528344108361323791606990358688178) }}, 
      {{ SC_(20), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(17.488121524809304471713561490974552685660347146533), SC_(14.116506795983038553856058647356411704442951484053) }}, 
      {{ SC_(20), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(17.982532046204292281128497391301417510164288087482), SC_(13.452695896525244826908749002637690293291222882502) }}, 
      {{ SC_(20), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(18.047198881038573479562840271820926690237508338649), SC_(13.360774212089305778370870886256564928772273081334) }}, 
      {{ SC_(20), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(18.697024164745455756567339793043238786906089951389), SC_(12.350411225017006772362370782984608122580054663478) }}, 
      {{ SC_(20), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(14.288670396367583796474618302845022475814690894451), SC_(18.047869226551438807933657512325839428541664047861) }}, 
      {{ SC_(20), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(14.36360231141961215104420289234124440424994072539), SC_(17.993583143010443189873015456831794593933495350151) }}, 
      {{ SC_(20), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(14.977185274595666665207651683503722339001312258175), SC_(17.52248018348390369101020006641809212293102478475) }}, 
      {{ SC_(20), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(17.706113805631898282526610356833534647093393963285), SC_(14.745342220891248621160606221032275221033783324881) }}, 
      {{ SC_(20), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(17.817781041330786455464031449585047829363967450284), SC_(14.599929409601692550246908252875874493674411361203) }}, 
      {{ SC_(20), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(18.279305572165771187584300769223451934497196545549), SC_(13.957755964212609321496089801796860333022449275676) }}, 
      {{ SC_(20), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(18.339310255499037445849747206590245063180203188304), SC_(13.868667411753943219363187876657477619104214537412) }}, 
      {{ SC_(20), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(18.93567007191491838824034836358475598842110777933), SC_(12.887017864166223068967487278153581050043147850347) }}, 
      {{ SC_(20), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(16.111474381324530750013351754586479993593134954942), SC_(19.049425228498573826111009013003902324712037402563) }}, 
      {{ SC_(20), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(16.174125443277864579115569483841252501548138377523), SC_(19.011901092847265752797150598848266806350563397524) }}, 
      {{ SC_(20), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(16.682711460125123615814444026615425469235043298676), SC_(18.676352707949193147933273618356044007564333328218) }}, 
      {{ SC_(20), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(18.809087036609358877045768933882418763489968953087), SC_(16.491500389887885949368868733023641426183939538233) }}, 
      {{ SC_(20), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(18.888643090585384232164365736040548575190919244229), SC_(16.37096789270299898245838647495418536809282302285) }}, 
      {{ SC_(20), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(19.20617110328123938940938041849439095285416998646), SC_(15.833475501911211879275663037806038018366105570638) }}, 
      {{ SC_(20), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(19.245864942948530300500601994979396576648264010597), SC_(15.75827585605826081957277536429229716304989169495) }}, 
      {{ SC_(20), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(19.611620685420950946563170092187674250838750466454), SC_(14.920336368550502561853254548295455223566432544093) }}, 
      {{ SC_(20), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(16.319463441732062715749540306863082232744792449716), SC_(19.145202084420413204464868818351688199755205349298) }}, 
      {{ SC_(20), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(16.380361031149278181902485617436402852063567536033), SC_(19.109886683924476500074661170876029696951841355699) }}, 
      {{ SC_(20), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(16.874076663418440736289710293718980551097693680552), SC_(18.792320433386626922620046588326483481620396260131) }}, 
      {{ SC_(20), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(18.918278923713994764220865399737419731464568908505), SC_(16.688595349160096288201592031826734891281026519378) }}, 
      {{ SC_(20), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(18.993574621530615244626812007722234818361630894733), SC_(16.571586558474345871480918527152331123162044461135) }}, 
      {{ SC_(20), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(19.292153527605479002052398186977579244936152779246), SC_(16.049056762890889418459826482908383681921205433372) }}, 
      {{ SC_(20), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(19.329199289842474649186876482857328997918610272942), SC_(15.975860190738055928045809123565923541074385628906) }}, 
      {{ SC_(20), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(19.665681844984031525518468446299714932304468162053), SC_(15.158930468825449602625100700162762393569876479539) }}, 
      {{ SC_(20), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(17.998078109909625436070584364366376465602169896743), SC_(19.735124737342476882330959136827018518281502624452) }}, 
      {{ SC_(20), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(18.040831709649030353876081070274622980715392552264), SC_(19.719233779411409593669857581694149426877726934238) }}, 
      {{ SC_(20), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(18.382059926698191764937446311547293506852341641095), SC_(19.564556706589202088045724182321672683106769027168) }}, 
      {{ SC_(20), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(19.628251957386054058589582615565260180225585192616), SC_(18.25504563731335217664329721003512253116018127357) }}, 
      {{ SC_(20), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(19.664914905072526358612061962029190942225318490273), SC_(18.174171240926689254168542776322218646584475720669) }}, 
      {{ SC_(20), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(19.797909812233646316693429097841395712218259353623), SC_(17.80664455002251803320237553153157781011609735534) }}, 
      {{ SC_(20), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(19.812821257414415375227618619522737064595277157105), SC_(17.754398004789837205183898744078319959839640177997) }}, 
      {{ SC_(20), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(19.92820144624215533248395787343029854871095947766), SC_(17.160280219711473848689605391618629018197120013196) }}, 
      {{ SC_(23), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(0.65134208936734105473157175300444225921388167937448), SC_(4.260380069239661594734583756651302556714814873294) }}, 
      {{ SC_(23), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(0.70182203996257925254745640880576955124212590582596), SC_(4.186895330313698758691560765494396166677762654539) }}, 
      {{ SC_(23), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(1.1429538396105367090684146265711462255307354060596), SC_(3.5870566902911733413040736034137847987121491324146) }}, 
      {{ SC_(23), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(3.8133025008848662870114826319810611719538078070261), SC_(0.9703978999080680214869166670676918023873300225357) }}, 
      {{ SC_(23), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(3.9554574823668804061882834624362284085313944232184), SC_(0.86583072893231422352414239276608325016438188165846) }}, 
      {{ SC_(23), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(4.5854843920651918871558891418464788149304795877835), SC_(0.4371104568291518402691694967369144382892286923525) }}, 
      {{ SC_(23), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(4.6731682397612850513715371037759046983537357838624), SC_(0.38185094616014899162517214463987422845554336439839) }}, 
      {{ SC_(23), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(5.6436756349601955690678790248260647751931798168977), SC_(0) }}, 
      {{ SC_(23), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(0.79440819746086359697314827538721843813088400695882), SC_(4.5067091439727555152492908914490481412472583104652) }}, 
      {{ SC_(23), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(0.84698562769729355420026928511480537571929786116967), SC_(4.4316711514756227310604978416389154149018916253683) }}, 
      {{ SC_(23), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(1.3050927864563752492099522321597363016700916831259), SC_(3.8185676632248368134988121278594709431277801358443) }}, 
      {{ SC_(23), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(4.0499437429521374022916773497148032208131092101136), SC_(1.1261597817755367982426784618642785311015130261824) }}, 
      {{ SC_(23), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(4.1952419727965399115243688489725342010382758152132), SC_(1.0175713972163468626973565599016442746245367325678) }}, 
      {{ SC_(23), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(4.8385108610246303904832934249997475110936326449977), SC_(0.57083273189100287077887289561613394902922816117026) }}, 
      {{ SC_(23), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(4.9279539603589206233168502594378607656815847766845), SC_(0.51303253692964735526098246251742973353537986633354) }}, 
      {{ SC_(23), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(5.9167048953056902791822692041954306078129153843426), SC_(0) }}, 
      {{ SC_(23), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(2.3503550520259767444245488505086783007766929441478), SC_(6.8717176474036257647113405756892906754874590111734) }}, 
      {{ SC_(23), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(2.4199022226209881964297833833800017472242694223443), SC_(6.7851052106982070553272895276142514469493215732358) }}, 
      {{ SC_(23), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(3.0148534596459355104648780855771723991224893840923), SC_(6.0721661630729554911139331676698664659629692894741) }}, 
      {{ SC_(23), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(6.3423568665564953520033965462667108070960756975811), SC_(2.7846266988432163448744396901837993887249582721018) }}, 
      {{ SC_(23), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(6.5113124244901102861107182286523297358987634536302), SC_(2.6436199845176953180650428571457175536784706039355) }}, 
      {{ SC_(23), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(7.2531246891536845085558500564849823155647862203362), SC_(2.0510561796460974202481434061601360935528820894927) }}, 
      {{ SC_(23), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(7.3555133464018964074033985523247741071507657159932), SC_(1.972635214459745612726118875776614184433005746067) }}, 
      {{ SC_(23), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(8.4761793467003926683370484506375012487886905396724), SC_(1.1677154189059859463982243023844250479749323671972) }}, 
      {{ SC_(23), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(16.094366690694536501121385830651937098378884919635), SC_(20.32188458010038418672786136664669289011926131075) }}, 
      {{ SC_(23), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(16.176919692065378047433813927383000076159302274197), SC_(20.258632479999189624224617839195224556306862500332) }}, 
      {{ SC_(23), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(16.854592829930279897954810063401236041085831408202), SC_(19.71432299078445068429768831974264359866701878407) }}, 
      {{ SC_(23), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(19.925595455651351199981341662147924034748970447041), SC_(16.598163918853664398938060767319902601368538510634) }}, 
      {{ SC_(23), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(20.054604715729192853169745564132912578741350097409), SC_(16.437565129437350951209466415694886701832260809459) }}, 
      {{ SC_(23), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(20.593061839611990055436109870800147882554514865974), SC_(15.730280760362499145447164313482714089612208761666) }}, 
      {{ SC_(23), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(20.663817240219356293560742334589288430848455963211), SC_(15.632390791958285558507487736323166180821874767135) }}, 
      {{ SC_(23), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(21.381106454565069138331281553935965081345386589057), SC_(14.556966500716078209803255344004054637855995366666) }}, 
      {{ SC_(23), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(16.655685568874268409804781277751008721727921600129), SC_(20.690158473967913604964566625171532909151159595664) }}, 
      {{ SC_(23), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(16.735473398336749906715557037252342540084365005503), SC_(20.630951449227138616102553558300037564661529731793) }}, 
      {{ SC_(23), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(17.389301132439845258177931842274760519991723486042), SC_(20.119266974590389626674765643183056249771438047104) }}, 
      {{ SC_(23), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(20.318309325723166680323233014176519918349867677494), SC_(17.142141827642308552637422321245579269289846108192) }}, 
      {{ SC_(23), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(20.439589715847882617891914279086194216452931846709), SC_(16.987193514449976177871372972525960647753106408325) }}, 
      {{ SC_(23), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(20.943287300615749600783435929898421183188768595507), SC_(16.303452230265165321955527369288486771841372509717) }}, 
      {{ SC_(23), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(21.009128277828751353877963170838928660163222368754), SC_(16.208655932084701001774220671425535967639060077319) }}, 
      {{ SC_(23), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(21.670319616353066050123469680259714579534620121108), SC_(15.164769685742017252114091980357681953788300295348) }}, 
      {{ SC_(23), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(18.719379616645862847013527970591236471987599987546), SC_(21.873844530406026129849606947390235764242925337019) }}, 
      {{ SC_(23), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(18.785872271521334373013073698384899426573646500237), SC_(21.832454113628122359947425386630891471499579309482) }}, 
      {{ SC_(23), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(19.326254061596554144234204868211147473860719691), SC_(21.465039221652094421618854782911348926859797066341) }}, 
      {{ SC_(23), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(21.609869132414596837136768105913665344953867828996), SC_(19.12295118286093883093631609001667279632228073658) }}, 
      {{ SC_(23), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(21.696973879105915470618065499147512439480143468525), SC_(18.994885092404044154032834592212640295811546314776) }}, 
      {{ SC_(23), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(22.047633754178267663223840941972132678749588154583), SC_(18.424502073224930807138890623519730051290445875146) }}, 
      {{ SC_(23), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(22.091911166639428196905448228255439989503480402285), SC_(18.344779943326535754575375068932919780970331666011) }}, 
      {{ SC_(23), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(22.508098317349331977010249318529558836454775360232), SC_(17.457436123299601083059307229255784289526074683825) }}, 
      {{ SC_(23), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(18.954018515049052056671706648141811447779866205133), SC_(21.988040347938265772647057422896660069837199365149) }}, 
      {{ SC_(23), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(19.018618671368630546252344814574891058157886575805), SC_(21.949017294492218755733676163974128497855478936416) }}, 
      {{ SC_(23), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(19.542970874164947635238689439972443261488919460253), SC_(21.600858699169314801276423397208328913232982699861) }}, 
      {{ SC_(23), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(21.738434676942093453374116826053599592475321040821), SC_(19.34584040804548262159226926999010986223694867041) }}, 
      {{ SC_(23), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(21.820977657420710139516856327441789932595756916225), SC_(19.221572679242199282451630662662730250895267155192) }}, 
      {{ SC_(23), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(22.151318453911100624536122624730402276107280092704), SC_(18.667341464191570358053720051888612975310071862043) }}, 
      {{ SC_(23), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(22.192748716369740568674364251408605901667842063115), SC_(18.589784704644156934494928338334132124529497439145) }}, 
      {{ SC_(23), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(22.577077761028710404064696340429578305893888553114), SC_(17.725205825292092409942070647393020826756724540386) }}, 
      {{ SC_(23), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(20.837560991887821805417784672045946478721273663636), SC_(22.696305051176980244291732989824712232321053194115) }}, 
      {{ SC_(23), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(20.882633596288395984893512001209616996832753592712), SC_(22.678616742520000592243973497806049667817884919412) }}, 
      {{ SC_(23), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(21.242938625239289640499957264151161561602305736825), SC_(22.508097640246702951532550350840163806535177126056) }}, 
      {{ SC_(23), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(22.577996739207148335024288466081573515320131641119), SC_(21.108695064822106441366681319841688741627819540614) }}, 
      {{ SC_(23), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(22.618420977659289384592065866142617254380258384727), SC_(21.023300403168780745634634052187666365098291679048) }}, 
      {{ SC_(23), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(22.766602381445384780523190566337483630162412931546), SC_(20.635905330591112714765315652507702484900754160756) }}, 
      {{ SC_(23), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(22.78340770400166649758447388138292542629065000453), SC_(20.580911027297111069908884104728072486416570955041) }}, 
      {{ SC_(23), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(22.915373322882104730687705155906575322633341345937), SC_(19.956556471194319977091937100370003020528697308289) }}, 
      {{ SC_(30), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(1.2809413750287839345400894101729317198082013475557), SC_(5.4103054384754350956339668179975489810618717029562) }}, 
      {{ SC_(30), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(1.3407208767717036012116737827716813773978744943398), SC_(5.3276495634238617439807164302117582203267838709465) }}, 
      {{ SC_(30), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(1.8585480902402196911319752912701926096501467756557), SC_(4.6517730423149269025491809149050064490452397369055) }}, 
      {{ SC_(30), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(4.9069626840916963270886399602875263693015308385403), SC_(1.6568697195174546661257423825008343090484850248149) }}, 
      {{ SC_(30), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(5.0671341265366823604504297912034006596892923696265), SC_(1.5341346356656720458061504699435750087528845807416) }}, 
      {{ SC_(30), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(5.7756624518283548743255998169211442252718919789167), SC_(1.0257158186205398923570324794978454153250020395511) }}, 
      {{ SC_(30), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(5.8741197770919641317057027746064671732687171040449), SC_(0.9594269514531636689426928691713712144500047611942) }}, 
      {{ SC_(30), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(6.9619807572207523689998761835888371510418225950583), SC_(0.29634286801447458509765833581280673246849243480359) }}, 
      {{ SC_(30), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(1.4761433804596787010760098387920807554788718635972), SC_(5.7231424709461610582670341922985469636581822251321) }}, 
      {{ SC_(30), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(1.5382700946358177706110210000978851389238252470966), SC_(5.6386829373707895188444693585375364404397326532567) }}, 
      {{ SC_(30), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(2.0751628066050520680864082410592017207870345244593), SC_(4.9474558904480181082466720988520461573023296633608) }}, 
      {{ SC_(30), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(5.2085716978433131830461811487976802595628034580062), SC_(1.8663081883603402257708328081150637246577799514845) }}, 
      {{ SC_(30), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(5.3723805854013396988050371577470009477364272333255), SC_(1.7390564724592752645040860880941502789568421392294) }}, 
      {{ SC_(30), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(6.0962929263455705656598837919022130923783885826991), SC_(1.2104857925860809757950622352339960503730301793476) }}, 
      {{ SC_(30), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(6.196802028236874482679323084804358459282440529282), SC_(1.1413674163318195291510892710471210924345922722428) }}, 
      {{ SC_(30), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(7.3060708580738297226441443302194660557207167579451), SC_(0.44627728594865453047045059927408436035261899580019) }}, 
      {{ SC_(30), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(3.5744263339569324617716209181263839862399544528552), SC_(8.742642787385538708062844934215003344468126839995) }}, 
      {{ SC_(30), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(3.6554506239304317755753296037001145226467080101069), SC_(8.6446440950599196486694680852798537364950540441641) }}, 
      {{ SC_(30), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(4.3453783949333354088164110114296605931731287836252), SC_(7.8372266523473088375983493938656770663055567677098) }}, 
      {{ SC_(30), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(8.143396046337660474532407807862872009363943017475), SC_(4.0790292342263685807373289968677786357363987790281) }}, 
      {{ SC_(30), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(8.3347375120167043716668788560229381126669131659388), SC_(3.9155210198792658213734672893008542312148164596529) }}, 
      {{ SC_(30), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(9.1740012764047894392224627352650247003589223980687), SC_(3.2246696564883235824809504193502534451338839020415) }}, 
      {{ SC_(30), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(9.2897527460843413876581678532111720326549314126477), SC_(3.1327159765466285050456069878747263306973031955805) }}, 
      {{ SC_(30), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(10.555806136716738174234942686890223514182353698305), SC_(2.1791611013067461496691567413642371926534858310221) }}, 
      {{ SC_(30), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(21.493966684687755624000320330161037972180030966262), SC_(26.327652188020278909819917952704645189314391848305) }}, 
      {{ SC_(30), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(21.587191583043692166616538940981112079762368447721), SC_(26.253620140605703609186193666141120595759112163597) }}, 
      {{ SC_(30), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(22.353398585132500992946755732796662114892757305752), SC_(25.620193572138611814781504526465552611688798261616) }}, 
      {{ SC_(30), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(25.86534357036138175489955898994202171802227813274), SC_(22.063258262632057345911271152008550540367378361643) }}, 
      {{ SC_(30), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(26.015465295403022627999135869967553463267246511072), SC_(21.881682109570240015548808243505192601119762449264) }}, 
      {{ SC_(30), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(26.646259897952880173376195597702776042402638723852), SC_(21.083057843775455541919229912246602919471265689993) }}, 
      {{ SC_(30), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(26.729748090750893817377664946466924070817213960308), SC_(20.972640525274920203935098652484353913162652363082) }}, 
      {{ SC_(30), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(27.587378104892656204029347261172756707619303075516), SC_(19.76088086649487670637476292640825147237956466989) }}, 
      {{ SC_(30), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(22.210545676757907813962547962674897543647228547441), SC_(26.824438564336552107637753145460002374145727822432) }}, 
      {{ SC_(30), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(22.300536649603156584486081984389044670913298350778), SC_(26.754910757380058227120221382431008143594912306117) }}, 
      {{ SC_(30), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(23.038996261333414653652442448179604435991429069444), SC_(26.15796741129302286658178612017336782453613957888) }}, 
      {{ SC_(30), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(26.389409360070716413029396729562645178458601262734), SC_(22.759614041810829945869006044088213929505923224489) }}, 
      {{ SC_(30), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(26.530887584681499790818228538465546277824381005494), SC_(22.584612935023644706321802965583075151851022254245) }}, 
      {{ SC_(30), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(27.123003834515636919094103468704367963827154443093), SC_(21.813541918847709759773509556233755312275977332787) }}, 
      {{ SC_(30), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(27.201050696842917314315885885307274985765606571448), SC_(21.706766258498699330665856445063838126333053279957) }}, 
      {{ SC_(30), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(27.99711835725381140873602997899611553878010442063), SC_(20.532478060046639923699248600870576810857908358169) }}, 
      {{ SC_(30), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(24.830018373857992223257187552758752227817480924981), SC_(28.441106218410795042466575332139040678360956368925) }}, 
      {{ SC_(30), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(24.904579609555599783292584177237065420149870241396), SC_(28.391545335114980789426750720945396449310025269973) }}, 
      {{ SC_(30), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(25.511812027937538382541020796928370126726186653768), SC_(27.95681217126836912380739560851550909267081429468) }}, 
      {{ SC_(30), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(28.127191495379380729311265443402588986724334351323), SC_(25.283072037713694572368100743206416481701594626802) }}, 
      {{ SC_(30), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(28.230242319612840955124189785465679809930251339811), SC_(25.139166368688789826791210154500550247746238269604) }}, 
      {{ SC_(30), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(28.650934607671230157592309360792520284181833596086), SC_(24.49971310321466513413424980953126292742385728678) }}, 
      {{ SC_(30), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(28.704914054325054830275626441454796498135093440632), SC_(24.410504960918238058848221977913546205202594982446) }}, 
      {{ SC_(30), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(29.228780535928886317743380488000295008212626666923), SC_(23.419727455237458220152912523784645603663408035819) }}, 
      {{ SC_(30), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(25.125982737481238866053202502584909962839441289395), SC_(28.599558649102854862123324595582235486566433939574) }}, 
      {{ SC_(30), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(25.198358965496960099550418778456316280631856717258), SC_(28.552677557261490844326504687345722117780103592894) }}, 
      {{ SC_(30), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(25.787123203553865655588229112370446413192024345916), SC_(28.139762151355790624859647549942094354987767174418) }}, 
      {{ SC_(30), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(28.301917214513661829299455840192907897012561635012), SC_(25.5654866971394918267284773738652809372380779342) }}, 
      {{ SC_(30), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(28.399799736941914163841032944840862497782871424094), SC_(25.425957197268121301260565990428746154596655382603) }}, 
      {{ SC_(30), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(28.797488840086123866696241210278965860700324722089), SC_(24.805157718652066386991979460055934988189639496718) }}, 
      {{ SC_(30), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(28.84824396049385979817953022057193008777109376996), SC_(24.71845635074659740937279228008149011679705883508) }}, 
      {{ SC_(30), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(29.335725989503924871062136837768424629226318037932), SC_(23.754133129743331266996340930043438600159970191146) }}, 
      {{ SC_(30), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(27.479259630709795696076028168952651085762439204754), SC_(29.599040828430097812733707746737742632111030575387) }}, 
      {{ SC_(30), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(27.529198504784168790394200451964586608654387338266), SC_(29.577267782718139791456136192893519271375895039141) }}, 
      {{ SC_(30), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(27.929613226041841280636944764726648680383252284382), SC_(29.371428281824468186658750556429431515069886459015) }}, 
      {{ SC_(30), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(29.455033927653193169872173783193809567954148668755), SC_(27.78015285726955058799609046112152841773178771) }}, 
      {{ SC_(30), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(29.503840487193348360214926674629498866884796952723), SC_(27.685254280838887280112131837973692327788015446352) }}, 
      {{ SC_(30), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(29.686648314190153252982149509287482178337965219959), SC_(27.256176643661173502128088745477752483937050300376) }}, 
      {{ SC_(30), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(29.707888137372531953986967280091807332524991142265), SC_(27.195428802162108183842001035436316572586931526967) }}, 
      {{ SC_(30), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(29.880456835568680592854533499452725300326797961638), SC_(26.507927150055082960896648088969452275232660703944) }}, 
      {{ SC_(38), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(2.0349855077013239315047689027290594101062466665781), SC_(6.6889950007333271908103967936284764672275399442648) }}, 
      {{ SC_(38), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(2.1041041671302701503709581007277305012963573666982), SC_(6.5971105172496137960491196741517587603075193178525) }}, 
      {{ SC_(38), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(2.6991044713256757929701422417189775842008697308093), SC_(5.8446495965825396811749414836881630673271094688588) }}, 
      {{ SC_(38), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(6.1290050440886587751526088916747398607835472505805), SC_(2.4680945401859258104532499418920170001503379468976) }}, 
      {{ SC_(38), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(6.3073227232170202791418954072009225519609556904403), SC_(2.327077050362333960212872745747398180875237541372) }}, 
      {{ SC_(38), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(7.0948330321604410508751274169968267563097023555363), SC_(1.7386528159389415095989348885665976211611107245911) }}, 
      {{ SC_(38), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(7.2041180377728764023880012862820739685930559532304), SC_(1.6613232650055025139459733367765916954651711613534) }}, 
      {{ SC_(38), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(8.4097130107844996004103566813359446908902957440845), SC_(0.8762981056915440024950375362038206942320495802741) }}, 
      {{ SC_(38), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(2.2908276254682393649789194688854810240620188756194), SC_(7.0769167218869948907314283178472983666005876912863) }}, 
      {{ SC_(38), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(2.362542142510559307570810534776661295370169693902), SC_(6.9829760336226128781831302789527317410141375634441) }}, 
      {{ SC_(38), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(2.978695181027272745501976546380675682577963601855), SC_(6.2130609194792881734720933187138336942528077767069) }}, 
      {{ SC_(38), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(6.5041452905052547087525009339071543031287195558301), SC_(2.739709812456994142898015447695292306858629880826) }}, 
      {{ SC_(38), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(6.6865988857699514720005229764383151583687547543401), SC_(2.5936809101908994536944265290965700456096826141074) }}, 
      {{ SC_(38), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(7.4916534516799088741352845061812452576375892476201), SC_(1.9829821906832547823152197015511649299337674104783) }}, 
      {{ SC_(38), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(7.603285155682404893749757291709875054887407717413), SC_(1.9025372453959923963872207828580565245361443936964) }}, 
      {{ SC_(38), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(8.8334753715421190756501914756020936397623743665758), SC_(1.0825257178417367658372975626892738719212523945451) }}, 
      {{ SC_(38), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(5.0167840156902493452073218513944042116163711078462), SC_(10.837128778291767542344604909553073711561725972951) }}, 
      {{ SC_(38), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(5.1093384827752225091889627132005172725359760723097), SC_(10.727667433100014823281380053055009500769067436319) }}, 
      {{ SC_(38), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(5.8948298574654020063367012612255011506627402123763), SC_(9.8250635065850258596159258004526575927778496837593) }}, 
      {{ SC_(38), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(10.167495750033284280375297737656348052990752848211), SC_(5.5921074475227452627887270335363072103132233189244) }}, 
      {{ SC_(38), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(10.381391277523660544017602837264644775140073476311), SC_(5.405957482068671620886730362060436422036599724167) }}, 
      {{ SC_(38), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(11.31874767384887941874088521470854084141445123621), SC_(4.6163948179261560656919174745045196683180563866572) }}, 
      {{ SC_(38), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(11.447936930477999746256051929142622041202756925044), SC_(4.5108797352264860574087274401529810074336130995546) }}, 
      {{ SC_(38), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(12.859951307055069323963369861055600985160191906649), SC_(3.4090647749619811690532023324978136673566340636067) }}, 
      {{ SC_(38), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(27.706001577758691998996212985148495194927177264627), SC_(33.150763129716643475548229523434472212189786309787) }}, 
      {{ SC_(38), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(27.809968710972636922569004625731807934675962449166), SC_(33.065906396829113683871030176836165343335179456189) }}, 
      {{ SC_(38), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(28.66536528117117319263099886869703370109555112591), SC_(32.34283507097116604042519893144403792009313993809) }}, 
      {{ SC_(38), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(32.622092395883378738619465753024747047603126515187), SC_(28.34124968558703508633083536792393680580592801617) }}, 
      {{ SC_(38), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(32.793452903998894551229677161382023033334791195257), SC_(28.138540457185196611024678471013798719914123167832) }}, 
      {{ SC_(38), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(33.51693466753256070701070355532411854588092330531), SC_(27.247986478006115493652040394328448252799259273433) }}, 
      {{ SC_(38), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(33.613171615471376981459660819270346375180385206763), SC_(27.124973371631713269752349616116010676952033165261) }}, 
      {{ SC_(38), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(34.610547226458577289787651318182250094588656036188), SC_(25.776363459194280854378454852434453355363031543927) }}, 
      {{ SC_(38), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(28.598283518219063679322684389459161938528052140846), SC_(33.796287437761495448203747011870632585753650737091) }}, 
      {{ SC_(38), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(28.698543955633637873993229905497739538248645560873), SC_(33.716398128886711755759116616253031368261594179044) }}, 
      {{ SC_(38), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(29.522256779691196836043773352315422042749733060365), SC_(33.033698099159910081830746376550865270375254764802) }}, 
      {{ SC_(38), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(33.29775856920522178225564683731974627304265395459), SC_(29.210401029611445725710021716289490256215762994163) }}, 
      {{ SC_(38), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(33.459553937768456069442138747097737443725187231799), SC_(29.015199580628196182516016780992289091276431820169) }}, 
      {{ SC_(38), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(34.140402929855522985147539749782796479766720884029), SC_(28.156243088171581758165458648576515643414173540562) }}, 
      {{ SC_(38), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(34.230665700725558880661979536125385815057500843436), SC_(28.03742402721758004219286023349501711279799379097) }}, 
      {{ SC_(38), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(35.160916681937146926095138974882885962711753818563), SC_(26.732259794429895338631092167110544510342730804193) }}, 
      {{ SC_(38), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(31.845059365491349651747165862371541781974244605595), SC_(35.916983778841631276962414416403368142177978093092) }}, 
      {{ SC_(38), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(31.927737347783917669098317250852423416033869196494), SC_(35.859190082700876066625276701338267557802274534589) }}, 
      {{ SC_(38), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(32.602289680995895898660208748320141307532709088842), SC_(35.356549049009171940709099059101498933899360459022) }}, 
      {{ SC_(38), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(35.552716218645839962621484608487837310266175864635), SC_(32.34791983609088187532968046537679753566074032078) }}, 
      {{ SC_(38), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(35.671853318081509658694111156381389410582095702686), SC_(32.18806317115972249848881766183641160970668301071) }}, 
      {{ SC_(38), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(36.163100795138306585347091242821332121007775938796), SC_(31.47913829363736197469118645995766056507657956767) }}, 
      {{ SC_(38), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(36.22684282708097816458070259715014649969146727617), SC_(31.380400473584191714107620820771932377066166841524) }}, 
      {{ SC_(38), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(36.859115352111387832211497962049870810634539688287), SC_(30.285911911155636637124869817776297719222354026762) }}, 
      {{ SC_(38), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(32.210037892459790915142054230748749831992869133554), SC_(36.12743359950456395240734443970990748730781317385) }}, 
      {{ SC_(38), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(32.290235938203446170881361282270702288773607776082), SC_(36.072619066997739511684882588734706802237382815648) }}, 
      {{ SC_(38), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(32.943861711210958471725491834825466890167294943013), SC_(35.594289326964362511981336892239744424554431786567) }}, 
      {{ SC_(38), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(35.781280859359715958887841234014479911474290585856), SC_(32.697533838585586493249647630058468099962724472914) }}, 
      {{ SC_(38), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(35.894658757955744912486003607934856331491149018797), SC_(32.54263585709051461890846846011468316283278554269) }}, 
      {{ SC_(38), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(36.360342110533889176487788673372738945901558278549), SC_(31.854887363641681388556776509451867894168467800542) }}, 
      {{ SC_(38), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(36.420509995567639882071528704308202789951047059266), SC_(31.759000495366248174959219893478139399136179943208) }}, 
      {{ SC_(38), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(37.01255646319800443038407788854841269974803843482), SC_(30.694683049338236793318495404756366329123791534348) }}, 
      {{ SC_(38), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(35.08962352327392036754166706611251787414279473438), SC_(37.477486313180612493335725472915067167068518584305) }}, 
      {{ SC_(38), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(35.144452142442706043669974410610771591853543201279), SC_(37.451271083441356461656097451187957475122219546008) }}, 
      {{ SC_(38), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(35.585251864299932856750374703441749739342649352879), SC_(37.207782760836999161732769869996364723245916268086) }}, 
      {{ SC_(38), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(37.305861979777708040858952341275726638014299574435), SC_(35.420452598891250007247719209138678833627661259243) }}, 
      {{ SC_(38), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(37.363597775016296045469906891439566931680465450358), SC_(35.315984957618570457987329581447932220464259054697) }}, 
      {{ SC_(38), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(37.584211866542346242324285275041868703271705966472), SC_(34.845034119056458963902149338968022406086697272789) }}, 
      {{ SC_(38), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(37.610440392671859955493869566384558930251886476664), SC_(34.778518110297069146727446786654007551996042622893) }}, 
      {{ SC_(38), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(37.831414261647376512421270897438097409043899699), SC_(34.027885133158543103977025405250437468788239678432) }}, 
      {{ SC_(46), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(2.8153718033919262460169840834175583807937540251853), SC_(7.940911246138560307031718945384040409134762235448) }}, 
      {{ SC_(46), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(2.8928556590665030464708120752458148384112292392358), SC_(7.840742237589943661041118297452257074532453685457) }}, 
      {{ SC_(46), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(3.5570886489429032262496374127672937554831850101629), SC_(7.019488160408201576475389735334627842164749742999) }}, 
      {{ SC_(46), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(7.3300508428053864781252219363931257200739696812611), SC_(3.2997453193314752887563449709315890010020918789913) }}, 
      {{ SC_(46), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(7.5246688539922665579913324317285325818385664250685), SC_(3.1423255747221397832929912314292018896519065903793) }}, 
      {{ SC_(46), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(8.3830742181721961213875086466676997638392469679452), SC_(2.4822630004471717685947522939140502464889220623357) }}, 
      {{ SC_(46), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(8.5020709478087721868551542403230895097552229779152), SC_(2.3950698658113346907604860257780012645891864220882) }}, 
      {{ SC_(46), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(9.813134427788980014989761353947814489895418160992), SC_(1.5016496966986951016707799378457144496034992750199) }}, 
      {{ SC_(46), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(3.1326151997751767905676437041175516041072998830075), SC_(8.4032123469811837609252442533994329881199608353051) }}, 
      {{ SC_(46), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(3.212918129876971584824200753051198158605762922815), SC_(8.3007599821575608623670509352764637880253256497274) }}, 
      {{ SC_(46), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(3.900177038333401249237399340885337867712173172932), SC_(7.4601594951773803179892041015935119623166753924687) }}, 
      {{ SC_(46), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(7.7781731681647456175489819950208935487531485911292), SC_(3.6341411034368286093442038012251188086615286014527) }}, 
      {{ SC_(46), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(7.9773754682936147294416449739597764346445057156239), SC_(3.4712659252595253175711009339012372654426359468155) }}, 
      {{ SC_(46), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(8.855268048033564479607332624053073847023719369587), SC_(2.7870230528193881566587825573848315629751385571337) }}, 
      {{ SC_(46), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(8.9768766865207941072145582775467889003660481346459), SC_(2.6964576170637407877695909976582258833376365488672) }}, 
      {{ SC_(46), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(10.3154001642945854241348647423784792221633208608), SC_(1.7653669275584959833896403062573392528342368110626) }}, 
      {{ SC_(46), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(6.4920418337984944446938668754784468533613951873289), SC_(12.898584841094025461171715929106055172931294249274) }}, 
      {{ SC_(46), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(6.5949360850268775602682708991155626604308748054564), SC_(12.778829598674748003558994460359033214803303264761) }}, 
      {{ SC_(46), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(7.4662135535435236436527044387990238841651259530309), SC_(11.790698985382207149546397482710336307907800606836) }}, 
      {{ SC_(46), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(12.165722929486369109219047352801563078163075243479), SC_(7.1308227935302160490078161773220126074313684767679) }}, 
      {{ SC_(46), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(12.399883902603716952375614274285704297184864407262), SC_(6.9243469844202633119568024015509985662771058771263) }}, 
      {{ SC_(46), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(13.425323374835975086474418851111148691483137009037), SC_(6.0462820161254143693441306203710842333059393604949) }}, 
      {{ SC_(46), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(13.566571242601187459333066990993365871607741299096), SC_(5.9286255158778596513312663550195809883745121389492) }}, 
      {{ SC_(46), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(15.109417413326052496893260875121706547589671779009), SC_(4.6944681753865057013320948527811951717041383349395) }}, 
      {{ SC_(46), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(33.949045272495228659936786374526344470528478924626), SC_(39.943056448538904107569506588907743503408591576209) }}, 
      {{ SC_(46), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(34.062658365718651713468683867168731690070751668667), SC_(39.848496959419424091692874196954317695231514129168) }}, 
      {{ SC_(46), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(34.998186972903557248265960239650193937530076610444), SC_(39.044975429925746348188507391418614781993768636113) }}, 
      {{ SC_(46), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(39.354859801394092624273484084588765576179485017169), SC_(34.643537690916236769571199897862636626963180216603) }}, 
      {{ SC_(46), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(39.545281467527410866075078055558959736793562256853), SC_(34.421841310175522726371251536858702472742863505609) }}, 
      {{ SC_(46), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(40.351823731930096105601732346030102653606039197428), SC_(33.44874684323085680563691181274765754167303460362) }}, 
      {{ SC_(46), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(40.459465914174041858030323844489735619789838527704), SC_(33.314432113949018662313729564880268128147902866777) }}, 
      {{ SC_(46), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(41.581407244578115436718226221150759064715180099696), SC_(31.843174746141786498857887366560024023696897669643) }}, 
      {{ SC_(46), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(35.01570532303158096667331376362166509604932671465), SC_(40.738698011348322335334668112488740483050791468589) }}, 
      {{ SC_(46), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(35.125186489263032088901498997538878536824809658691), SC_(40.649523778355886234513532702748167048516623623968) }}, 
      {{ SC_(46), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(36.025490297630184263877149526528987003575060462115), SC_(39.889875724924837983387273343500327622787564922334) }}, 
      {{ SC_(46), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(40.183223057451274409392010962083305715509604247591), SC_(35.684451869688898217913451518382454403225310627259) }}, 
      {{ SC_(46), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(40.363249485827064628345850323595524833020070364236), SC_(35.471102343000827982826779156133255394134989646038) }}, 
      {{ SC_(46), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(41.123590292976770231676304543191037345433480886185), SC_(34.533242778243763854376151506341471519849431725552) }}, 
      {{ SC_(46), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(41.224776101389687471244221221228532908669820495749), SC_(34.403618776680014852543421679347151171470996936741) }}, 
      {{ SC_(46), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(42.274517574971951037592626802232841146618636025889), SC_(32.981175151099873853658820798814495777716668247278) }}, 
      {{ SC_(46), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(38.883777349864326559518722878976673143918226191935), SC_(43.369997781095898300503880906765064635944679936079) }}, 
      {{ SC_(46), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(38.973739868571597849133570394892317594856128794513), SC_(43.304824925023996262102190037497281918873243468147) }}, 
      {{ SC_(46), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(39.708753261647238378820885077627534973308841571961), SC_(42.741224695434154809830335181339498447391351533792) }}, 
      {{ SC_(46), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(42.960557987781320133394669478740489653628985461755), SC_(39.431356132002312053132494606014297396080929206223) }}, 
      {{ SC_(46), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(43.094136161053107109898919103582896625742315925242), SC_(39.257173474272500477833895424078224893678436244626) }}, 
      {{ SC_(46), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(43.648603320085177416228915690068934145377503880407), SC_(38.485906790677929940858296771928350602510755044313) }}, 
      {{ SC_(46), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(43.721074068898877702177703125752180328806006652327), SC_(38.378624479321222444590750345897508504928613558048) }}, 
      {{ SC_(46), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(44.449878839949522005919632841646683611955180696927), SC_(37.191271762240952250692655262815297700181372977144) }}, 
      {{ SC_(46), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(39.316951606871539943051468991638113740460412683283), SC_(43.633419164994267259104213678913296202649344010092) }}, 
      {{ SC_(46), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(39.404168965643826569109111016196173036799490632026), SC_(43.571489158735551274306863438883039939690524347727) }}, 
      {{ SC_(46), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(40.116045267617724120315730973386701689794021673087), SC_(43.034409278650744034491281055244992694269812247813) }}, 
      {{ SC_(46), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(43.243721882668813743177627746791085922674650792791), SC_(39.847533902427283695943808106973261178982872246765) }}, 
      {{ SC_(46), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(43.3710172379880870052026471744071040653571881415), SC_(39.67883372405075423841295144807432892553527526337) }}, 
      {{ SC_(46), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(43.897668107389772229297797852243474198395518184893), SC_(38.931011903229992072388434921808139691827101844566) }}, 
      {{ SC_(46), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(43.966260305890444980483354590100471486446088809272), SC_(38.826890032956211226244175399731040366133540194678) }}, 
      {{ SC_(46), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(44.651624260119531355855586062230424009263686196644), SC_(37.673049357944067417344736583310625622323483798785) }}, 
      {{ SC_(46), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(42.714808706222770842707210138820384387620947361268), SC_(45.346374642372622513525920006890452859993123152191) }}, 
      {{ SC_(46), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(42.774021283668064684201829865465011426219427632196), SC_(45.315977348945514467987654067540745108145473667086) }}, 
      {{ SC_(46), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(43.251080309736671670891007645829565841739266542809), SC_(45.037496678067520174056198439486584108175646865193) }}, 
      {{ SC_(46), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(45.148949073469681529861487542232585473172627192155), SC_(43.07249811724529963424244550451773489280929838019) }}, 
      {{ SC_(46), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(45.21497978568861528121374856386751275645608202265), SC_(42.959439004145295059206156206965415551593952495549) }}, 
      {{ SC_(46), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(45.471291193822887518879621338115453317560681726071), SC_(42.450953003650035894089955599957721058186654994) }}, 
      {{ SC_(46), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(45.502329126563130627235552811295265528463610551298), SC_(42.379273894994276601446240236094528372106775741894) }}, 
      {{ SC_(46), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(45.77226977795264094337184898061934906479582214343), SC_(41.572246447505940611032662850967609720477889092755) }}, 
      {{ SC_(54), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(3.6155167596791913443325132103477974564529087196639), SC_(9.1728696267435834667293673603564788169867541076611) }}, 
      {{ SC_(54), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(3.7006421455436361310470423643009244097343471305712), SC_(9.0651195062065392247688241616310394027245148084489) }}, 
      {{ SC_(54), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(4.4281886474590755608762232660960501195025084846239), SC_(8.1808859449862395093199054403586009356770717982984) }}, 
      {{ SC_(54), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(8.5154465041042511899876254077969445690377542579215), SC_(4.1467504279759677044074039999555907249031116041748) }}, 
      {{ SC_(54), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(8.7249874372988440189879209998134617812156134300046), SC_(3.9743301785583635142182973911770489522266203745221) }}, 
      {{ SC_(54), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(9.648263867962717856146157425567082672156260787697), SC_(3.2488416714241500240273296032342655001791501347337) }}, 
      {{ SC_(54), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(9.7761424721702624463692047041784689689971272598304), SC_(3.152654747847702727836391189949593136318563376756) }}, 
      {{ SC_(54), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(11.183578884289778959218420316204230804594578553663), SC_(2.1607473441261247103454732331391839274071460370867) }}, 
      {{ SC_(54), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(3.9947170801253353576074896674889511307683169817795), SC_(9.7090197533046085134136457025794670628177244825842) }}, 
      {{ SC_(54), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(4.0828663688779576499443123347349240613474421625289), SC_(9.5987780877508455252326675651075895948782003397773) }}, 
      {{ SC_(54), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(4.8351559841228395983037550375857964990799707135661), SC_(8.6934638204756291958956017871062084842346816263748) }}, 
      {{ SC_(54), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(9.0361371744410021510940419167566567234465545156393), SC_(4.5443679832531620642323516809432921819956337538419) }}, 
      {{ SC_(54), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(9.2506733522981006783018149555931701544226047495842), SC_(4.3660852788330277731257445811295666632665570388506) }}, 
      {{ SC_(54), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(10.195217725260203137591150685311699425858479057316), SC_(3.6146671673243123295405243507522453185399356960601) }}, 
      {{ SC_(54), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(10.3259512788641353918188072187447236504285318779), SC_(3.5148716886291135163261137015319153165336644897897) }}, 
      {{ SC_(54), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(11.763472122178697172472200106972496381071868455631), SC_(2.4828112330364986137542674660272528372028661842914) }}, 
      {{ SC_(54), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(7.9918984449719823011639870833800330230149892499052), SC_(14.935380120408154170641764491498813917264450319688) }}, 
      {{ SC_(54), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(8.1042484965826161918241157058752578189275498629894), SC_(14.806202173869944987238851326488791980740302534848) }}, 
      {{ SC_(54), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(9.0540315844078781238538502329898236030156929655725), SC_(13.739754546378151417165427067704841322156696420527) }}, 
      {{ SC_(54), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(14.14462838217597201123718664804194674412370002204), SC_(8.6887348663635081485633460792074719532577769667332) }}, 
      {{ SC_(54), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(14.397346625810038755819469024703225325844472248014), SC_(8.463657835747400640254163998530824561332677548165) }}, 
      {{ SC_(54), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(15.503409611760172352552222416773989513191648718895), SC_(7.5046675548271301841960332677396093540433959662782) }}, 
      {{ SC_(54), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(15.65568987747946301537382112832714272014735900999), SC_(7.3759195056884952380544956967663290776150830201093) }}, 
      {{ SC_(54), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(17.318140601857309844711475681156306331286381571554), SC_(6.0210926877521489511098768820595810787074905113576) }}, 
      {{ SC_(54), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(40.215230912612345022196786091790865891069376425178), SC_(46.712298067781324122336839651742953304816760887924) }}, 
      {{ SC_(54), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(40.337672897177433480227218453836259932823372802999), SC_(46.608868416912627541377610149920598774226255303639) }}, 
      {{ SC_(54), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(41.346573897660239773328510351677444089472593937644), SC_(45.731741071086698187569835033555601572734225945474) }}, 
      {{ SC_(54), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(46.069657899606369548630330530010780978846373501002), SC_(40.963961156236726419284071274298509620683140258156) }}, 
      {{ SC_(54), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(46.277519522495944727229636008545793711179700890732), SC_(40.724879169664925768262092070899375145033392045369) }}, 
      {{ SC_(54), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(47.159982872055397607112491533228635063634796071162), SC_(39.676240628284387570797338154606485829731096767896) }}, 
      {{ SC_(54), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(47.278038298309396495512722012468700833107269008578), SC_(39.531587089717116918547311610739191698090759623335) }}, 
      {{ SC_(54), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(48.51344595692305033825969931629589022913179318058), SC_(37.948220398532086483049511223180084546121515869851) }}, 
      {{ SC_(54), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(41.455273299252481246695213577970795799134551205459), SC_(47.659077522893443364836369776955399731901975585726) }}, 
      {{ SC_(54), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(41.573193628988920988445764005363434217895779918998), SC_(47.561417165922917871571982928522808838488719202508) }}, 
      {{ SC_(54), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(42.543624140441561090698101659781260158853072787593), SC_(46.731378372749730818859956520092996211330745566006) }}, 
      {{ SC_(54), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(47.051528497677196497528129279707977885674424747795), SC_(42.175860615946570336091734236569122350280427318378) }}, 
      {{ SC_(54), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(47.248232879514873440402429670155792478063847999235), SC_(41.945894575373010803880754985478598686645140507049) }}, 
      {{ SC_(54), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(48.081213717475791222647380883564534305662613226717), SC_(40.935824570706743791049799400681272189683283466436) }}, 
      {{ SC_(54), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(48.192368509480668139295076066864824106533974335027), SC_(40.796316884654138722693211431277794787272350244871) }}, 
      {{ SC_(54), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(49.35087262867433908660947162250633413454758842486), SC_(39.266680795469132621630911890622912145325910289629) }}, 
      {{ SC_(54), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(45.940124254817372973499912621889983564450730126383), SC_(50.805756289882833875980079017565898325690184594334) }}, 
      {{ SC_(54), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(46.036751412393916041494344749616474849750934602126), SC_(50.733844016541198989989004133208085966095013149368) }}, 
      {{ SC_(54), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(46.827108207035754306809774984219165666100175653245), SC_(50.114498039760479053224335381788661453052751899715) }}, 
      {{ SC_(54), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(50.355029264998817187774176591939817189755397922088), SC_(46.528627436045353930077393183788004389998866309164) }}, 
      {{ SC_(54), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(50.501814101879828424324227609139260698185097357752), SC_(46.34133128663790493344223344537594977760548829367) }}, 
      {{ SC_(54), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(51.114004345418056071449408271148010023527923831148), SC_(45.513032338363689074822935115987619365721732650733) }}, 
      {{ SC_(54), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(51.19442991619270600681757440368222399132278059331), SC_(45.397937815345116149147710044304913889082997015948) }}, 
      {{ SC_(54), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(52.010847959346875187631934609533598433835432975174), SC_(44.125759726695970021394295697380752809277499308476) }}, 
      {{ SC_(54), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(46.440878457925530086064266577980142001617126133713), SC_(51.122837044806745782775026826662020022707128754966) }}, 
      {{ SC_(54), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(46.534517399808307968380976479607985408346156834109), SC_(51.054407561550589596887490404560289113122432459225) }}, 
      {{ SC_(54), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(47.299711477769036549611068701409485417983101511556), SC_(50.463594895876803065430043692916527850548771957637) }}, 
      {{ SC_(54), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(50.693334876583298744494229644742640547932282006531), SC_(47.010889635676143255035249190183432721264853290911) }}, 
      {{ SC_(54), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(50.833359738417781673283186974825735104470022724524), SC_(46.82955595238454843486966354308510870794474165368) }}, 
      {{ SC_(54), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(51.41568503650769508548273929504309111803818126801), SC_(46.026780723901481306418744109121360257375910135202) }}, 
      {{ SC_(54), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(51.491955820938562823374324454697504685756633645615), SC_(45.915130254283638803865368024751504351227970252009) }}, 
      {{ SC_(54), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(52.26204360747039325426841762061119789357551157435), SC_(44.679525090214650432298317108879653771798580389676) }}, 
      {{ SC_(54), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(50.350957961592687926729640928371646841739509460738), SC_(53.207162093626282871444418054229820375669176701772) }}, 
      {{ SC_(54), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(50.41417798732421788929718090882653004499554527997), SC_(53.172834922085528085319980442043724349830737161415) }}, 
      {{ SC_(54), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(50.924415098877445196978506882239479848196492687838), SC_(52.861707551596498818331072637507934824072483681493) }}, 
      {{ SC_(54), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(52.985596189242422132628626633848290950664389269402), SC_(50.733214255160025082360512125210082792855533123719) }}, 
      {{ SC_(54), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(53.059363223350931520810854527920706548673216294033), SC_(50.612293749161121077471254373228160770610580510012) }}, 
      {{ SC_(54), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(53.349281201492652524826185295601246798359046913912), SC_(50.06950063479177584103791840982680182945949351675) }}, 
      {{ SC_(54), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(53.384903923303137854434991361834712015504704947412), SC_(49.993107293301100251512674896997280976214751061993) }}, 
      {{ SC_(54), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(53.70314565442408398077733337305109495811943438013), SC_(49.134663172899560420005056840875626384799520769226) }}, 
      {{ SC_(62), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(4.4311754968725160937094728786808725652665311656989), SC_(10.389208728301550261858042993952457246953970257047) }}, 
      {{ SC_(62), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(4.5233783685435650597499045126545412416967645490101), SC_(10.274427731549105699699555455326544784959296442921) }}, 
      {{ SC_(62), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(5.3096122775667176922342891758110280336533643112236), SC_(9.3317671047442602353293527054155903849709752521588) }}, 
      {{ SC_(62), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(9.6885945447217846289462399147968694396499764836569), SC_(5.0058309560742976201438926498242105204541511595723) }}, 
      {{ SC_(62), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(9.9119797947259126793690393018155765609458792081226), SC_(4.8195058537292921892720587141805892069652847888478) }}, 
      {{ SC_(62), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(10.895415872898765038779199384985111262393256570441), SC_(4.0334306573794032108468304003924048155744986861651) }}, 
      {{ SC_(62), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(11.031528112810402917728339763267479623168559730601), SC_(3.9289247743559923343593042855593341200097342875344) }}, 
      {{ SC_(62), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(12.528246522566498300418014912457584326627455926484), SC_(2.8461480780533958750451182477773098890375625287655) }}, 
      {{ SC_(62), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(4.8727635283096545792277138353721360021408646678537), SC_(10.998790189457709033916657720372802568232330886369) }}, 
      {{ SC_(62), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(4.9681808479176742624239749083642675745205213656735), SC_(10.881324323519001883911844918373750904634674658188) }}, 
      {{ SC_(62), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(5.7807538077502399933234606115516447163812218907539), SC_(9.9159724992624861537809656281690258274213355191446) }}, 
      {{ SC_(62), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(10.281527293719762119221396004781568020129548513501), SC_(5.4670121866586237700212408177167623584620795898709) }}, 
      {{ SC_(62), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(10.510289409316423175308771015762573793897392130318), SC_(5.2744463678711692481674804715771494518222358167714) }}, 
      {{ SC_(62), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(11.516646994499075026762575799118249544092553567545), SC_(4.4608138355555194467392677201130780412670809081887) }}, 
      {{ SC_(62), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(11.655839853906329860098797416584998129025578525931), SC_(4.3524791861650840633702057383499521770256833110734) }}, 
      {{ SC_(62), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(13.185079047486325946674017495638882592665983671922), SC_(3.227223855086371429772822226737251519099181104479) }}, 
      {{ SC_(62), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(9.5110432278045633711581213491989646802476223619145), SC_(16.952853377209111428909963256829875968775883619085) }}, 
      {{ SC_(62), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(9.6321591798185624607965482231297316986871037128346), SC_(16.814934489720402936375566627109356809599451430791) }}, 
      {{ SC_(62), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(10.654755230170457646338117466854794866218970458816), SC_(15.675816948112138298003804815530107778553918176366) }}, 
      {{ SC_(62), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(16.108392110174057727279412229264922142728000161803), SC_(10.261714481242831206580019730848943740627989326759) }}, 
      {{ SC_(62), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(16.378329640854057623635387384064997742135843415007), SC_(10.019384808544636347074745750490566417087763410487) }}, 
      {{ SC_(62), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(17.559179436856106863476677926864244519945454064312), SC_(8.9853804236667915889162700490456049129819588366318) }}, 
      {{ SC_(62), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(17.721690029431195864112070082395035372614411957279), SC_(8.8463577468800510835472822653771978497507196454228) }}, 
      {{ SC_(62), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(19.494986776999701109281636553086590968865986876696), SC_(7.3798948751771766120703234759061142088873309672626) }}, 
      {{ SC_(62), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(46.499543005014436215649565681084517418598497136455), SC_(53.463462022978638619187704072946545506455095544122) }}, 
      {{ SC_(62), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(46.63017454610242888650966572285638416997003134841), SC_(53.351811548371387601495107787243741272600775986763) }}, 
      {{ SC_(62), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(47.707153769995999773732047579956502418430818930596), SC_(52.406427925072096263505824108195636656027396337044) }}, 
      {{ SC_(62), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(52.770347135414321809410687263367961403465541521731), SC_(47.298591548436668495883293342585291042928045593019) }}, 
      {{ SC_(62), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(52.994381494160210893124025303157333878753973323191), SC_(47.04337831502496265510894081746086730348140809163) }}, 
      {{ SC_(62), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(53.947200409884780354035139069489739947495738230548), SC_(45.924669377974112775763179457168669355569276730769) }}, 
      {{ SC_(62), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(54.07489816449697644382177756399679895591674297964), SC_(45.770429443374082231608164621437283053487703062159) }}, 
      {{ SC_(62), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(55.415203780329043227051071487031053146542543490529), SC_(44.083173107965332485064656145373574978342701722692) }}, 
      {{ SC_(62), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(47.912183772387661071901561681293663793270872083257), SC_(54.562176356830858787231496724089117049238408188929) }}, 
      {{ SC_(62), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(48.037931764109422072720325384749479226847956987692), SC_(54.456652614311206756305379174940471915872477532545) }}, 
      {{ SC_(62), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(49.073426435413121601606900927492857898332843780113), SC_(53.561347253067897365765690920071026668950063612159) }}, 
      {{ SC_(62), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(53.906356754489995529781478157433651134114092212251), SC_(48.680863444638464010848352500452937791238240154865) }}, 
      {{ SC_(62), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(54.11852531216811633856945142753466332248718371615), SC_(48.435480366525368017775628563456144859920137329804) }}, 
      {{ SC_(62), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(55.018807246726532375831454807749899025263233928914), SC_(47.35843546974380841698737457144987914157387810097) }}, 
      {{ SC_(62), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(55.139190162035141428940759054688651367114202899019), SC_(47.209763955438293927559275283619907483853258597529) }}, 
      {{ SC_(62), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(56.3981888946403620650316818848528467481140046208), SC_(45.580802108258766683405506535830277601240998535088) }}, 
      {{ SC_(62), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(53.010255761964292471676883982361460631272222823008), SC_(58.227925758278434830001042538584319030372854152947) }}, 
      {{ SC_(62), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(53.113062775909546295042857686169070872317329091645), SC_(58.149774144021722331208702705104385122143074722516) }}, 
      {{ SC_(62), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(53.954756023941235507468450245433791670445997068666), SC_(57.478766920481970035595511490006192508370246921702) }}, 
      {{ SC_(62), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(57.738952409628841833709403124831953379884805253058), SC_(53.636714381798976211931145893069240057506906446217) }}, 
      {{ SC_(62), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(57.897976711972467427617411473244964747775315059237), SC_(53.437254101445785008820342600198062659360890274743) }}, 
      {{ SC_(62), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(58.563595517256306521011811501036636969278609344349), SC_(52.556074408230447259930353546200107413278409289788) }}, 
      {{ SC_(62), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(58.651373218926170178343207578603537969393897548816), SC_(52.433739470685448838458549555581839965190261977098) }}, 
      {{ SC_(62), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(59.548499786932758461405989589485771610064575756759), SC_(51.082999822812179375389477722928189416979653055991) }}, 
      {{ SC_(62), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(53.578104677666686473190003999645584164948428400606), SC_(58.599188489728580543441684743319143609641071817244) }}, 
      {{ SC_(62), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(53.67769778855561474746275121473412302413606110964), SC_(58.524742027027521013070159361677149327904752033989) }}, 
      {{ SC_(62), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(54.492347540875255070876389473164844357196858609753), SC_(57.884133480300813895619499833264034913155392667024) }}, 
      {{ SC_(62), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(58.132813664229621612473743997930407138385571898685), SC_(54.184682675500257737386583076402944583252736299298) }}, 
      {{ SC_(62), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(58.284635829642874912230462348599310854782572832377), SC_(53.991630528484730027022533445874902439824272663229) }}, 
      {{ SC_(62), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(58.918491027635648686254736855077572108380829995265), SC_(53.137904849530374723780136127722008745539050014019) }}, 
      {{ SC_(62), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(59.001857856915908252375922375437682526276276371089), SC_(53.019277307206639845086035912513359017718333350018) }}, 
      {{ SC_(62), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(59.849974341360241521762472946823865127903032432676), SC_(51.707952287461765965101496530748540778866548388712) }}, 
      {{ SC_(62), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(57.995637539029368007929782161528805196085489694703), SC_(61.061075569281977247798523468673159598569388465074) }}, 
      {{ SC_(62), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(58.062570760336362937537264350411940335012410635548), SC_(61.023049714589638381647479096090513569374663764154) }}, 
      {{ SC_(62), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(58.603572227051180219077515369624704288017635140924), SC_(60.681314166572362156366368370885628804202877015829) }}, 
      {{ SC_(62), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(60.81684258148642138915796329584486919172713124401), SC_(58.400666036139388226478494488139725318065250869296) }}, 
      {{ SC_(62), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(60.89786146977766455201309105630915200591186578333), SC_(58.272456047489341018885847412206164813618061601969) }}, 
      {{ SC_(62), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(61.219442975800148759490644092870949599664442127882), SC_(57.697877931530137913179259501933959223925135863278) }}, 
      {{ SC_(62), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(61.259416362397637519899387829710861949244662639847), SC_(57.617120274073598852787727824112987857089139696069) }}, 
      {{ SC_(62), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(61.624536339631523014295673586439700289155516999634), SC_(56.711128459422124003675347500768411217810546538379) }}, 
      {{ SC_(70), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(5.2594283194243214687967514325258847595470300896035), SC_(11.592892182341811916170339986868691915289161281067) }}, 
      {{ SC_(70), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(5.3582533541895972585795922429224045656710604952913), SC_(11.471525943263190039125286177938127876676713188884) }}, 
      {{ SC_(70), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(6.1994322715529475526566751779614915178748322927921), SC_(10.474128108874874731631067587116232697293784410968) }}, 
      {{ SC_(70), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(10.851818838867625631857013231594376689877824387622), SC_(5.8747264640612888653720088382885566720104528710787) }}, 
      {{ SC_(70), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(11.088174155050454475035867884332920579115383172296), SC_(5.6753829363673199811191910241848919572756204043223) }}, 
      {{ SC_(70), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(12.127954587891984984576233941578799949462975667226), SC_(4.8326257157866384216045595225735284316355148331742) }}, 
      {{ SC_(70), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(12.271776004257178230361701112003831653216015757661), SC_(4.7203436725421964243148485708622536017159169445862) }}, 
      {{ SC_(70), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(13.852048064804644290348021887686427064153181772295), SC_(3.5527821301022003509728795254287115561589125065319) }}, 
      {{ SC_(70), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(5.7637516046350795765967807830913234205451615105133), SC_(12.275564910738648806292850628749707869055636680631) }}, 
      {{ SC_(70), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(5.8659700530079189502322148920826842312018309088368), SC_(12.151332540177755711750440738209915238751473362106) }}, 
      {{ SC_(70), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(6.7349857855370206075011994211239210911123367033135), SC_(11.129733486975750769062372139349907732916307118125) }}, 
      {{ SC_(70), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(11.516727790807320727726178970729457156558145216384), SC_(6.3997469183132979546808230943943619878170526561979) }}, 
      {{ SC_(70), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(11.75881778730994162229184365353719948880279024517), SC_(6.193807694961816683648357131250738917483283498114) }}, 
      {{ SC_(70), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(12.823070110950957989528076072347553737607645547777), SC_(5.321964015014415628597123183963199879630531671138) }}, 
      {{ SC_(70), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(12.97018372621976890900587392573945691330751481544), SC_(5.205646049128182643100360134817505386008289332111) }}, 
      {{ SC_(70), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(14.585260474570617608581932429771247614016900593357), SC_(3.9934096632554368182719533066577041256441795683561) }}, 
      {{ SC_(70), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(11.045837213058683079807212474558014799079161819383), SC_(18.954657133731191948267827210451962844237653378188) }}, 
      {{ SC_(70), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(11.175161218945875708985244647829536989613219765804), SC_(18.808549671066463499419616637245562806336897518497) }}, 
      {{ SC_(70), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(12.265960943405496188200469225766057671732692568793), SC_(17.601340568505792019215429061047236243033998931466) }}, 
      {{ SC_(70), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(18.059874520203844296091609614634873268662640890163), SC_(11.846927829837111523671792609917975556965388388515) }}, 
      {{ SC_(70), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(18.345946559977976916396247633118759035161223074361), SC_(11.588437494530519223458822014877867790993762575457) }}, 
      {{ SC_(70), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(19.596854783119652849034580461596205991945467242751), SC_(10.484197478075992726426344499169522671672563209061) }}, 
      {{ SC_(70), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(19.768946468982515665629110865646775944710636746886), SC_(10.335559314445701105253787973242194057350722350855) }}, 
      {{ SC_(70), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(21.64600961288080084391238773152912550364554218051), SC_(8.7647210634422761515995786655666240330051424839756) }}, 
      {{ SC_(70), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(52.798551634327957236487050935675820804750438182038), SC_(60.199958445987507168621864187919705454837520881291) }}, 
      {{ SC_(70), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(52.93685479502045850128272754999634711682629042087), SC_(60.080611875220534272249926619018072667902404194063) }}, 
      {{ SC_(70), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(54.077620362993234480878771752274407285264176566473), SC_(59.071301813252549093358115246865718426404452120502) }}, 
      {{ SC_(70), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(59.45957900682568968000641389616221959382179169583), SC_(53.644741939959641690950945618189471163214916523677) }}, 
      {{ SC_(70), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(59.69876037535772044371232877682551278221215564585), SC_(53.374414358406102003506174827479038958833129083886) }}, 
      {{ SC_(70), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(60.71743882953332504913538331032617402328159533618), SC_(52.190068850703154315387051461972218146899688794707) }}, 
      {{ SC_(70), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(60.854157534033873445459995883695282718622809111335), SC_(52.026851481431291463064861785711872301824330601587) }}, 
      {{ SC_(70), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(62.292487509014418260949077063108558539584341828167), SC_(50.24234862182834764616551429793875894282391355813) }}, 
      {{ SC_(70), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(54.383152712380557279905294033197245382517113680468), SC_(61.451253263539387042582198858186114168199074250467) }}, 
      {{ SC_(70), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(54.516233016043379153437169762216859887529295815587), SC_(61.338369168330458387376557825106234318637427456496) }}, 
      {{ SC_(70), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(55.612687976230319025398270195924849026929149545699), SC_(60.381943725958906857385218666122336194811414368436) }}, 
      {{ SC_(70), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(60.750238634086725638476773791161322798246123418499), SC_(55.196887079633364235925552542208823096695864782043) }}, 
      {{ SC_(70), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(60.97688911541758937047196460101699207505659810813), SC_(54.937059314387670934321115317871701914589853285854) }}, 
      {{ SC_(70), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(61.940161051709214218714938756611042556069717849615), SC_(53.797280118129510360572644705466273733920947865941) }}, 
      {{ SC_(70), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(62.069175360536165273788694585751902252851021984687), SC_(53.640027329338201611356492199896800776198465740841) }}, 
      {{ SC_(70), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(63.422045278924663254565590955704780267107872818315), SC_(51.918096824599726596740606367023600229576185719406) }}, 
      {{ SC_(70), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(60.091548868837825897042069691312222113573428676492), SC_(65.639046350692635343224059755806444601542114306638) }}, 
      {{ SC_(70), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(60.200143209607034103902749319316605153113518728611), SC_(65.55505936858786908352538264270449706359971408992) }}, 
      {{ SC_(70), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(61.089925604577041968841694173997000078899931219286), SC_(64.835697858383602736417865034799820909836109659426) }}, 
      {{ SC_(70), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(65.114286457258091644397924142979649348693758654672), SC_(60.75355775278230296991778813059178316604548606093) }}, 
      {{ SC_(70), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(65.284767071779023953365584123843621413732090921887), SC_(60.542702731014498214964775230904758791585949142632) }}, 
      {{ SC_(70), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(66.000346948116392527706660658494604292294076802827), SC_(59.612003338885605031411003094523643102501812260029) }}, 
      {{ SC_(70), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(66.094991773268135365626980958744614837595190740949), SC_(59.482890441022222734433043268949344029460282648994) }}, 
      {{ SC_(70), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(67.06731081358747279226516522842166144100925542794), SC_(58.058647131288000067825722040255335793663797624218) }}, 
      {{ SC_(70), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(60.726097255293009438124376728970526840333012688405), SC_(66.06490750541990181316746156404383529480793499348) }}, 
      {{ SC_(70), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(60.831266094139563692896942331930883154055673693702), SC_(65.984834160807117084389861540714857261932520817258) }}, 
      {{ SC_(70), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(61.692241692321650863159939116284707019367632730049), SC_(65.297619380886845612843324608459601058680297938845) }}, 
      {{ SC_(70), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(65.56403366217419884421724272203961421690318515314), SC_(61.366923606135200016472224521358207925461236361839) }}, 
      {{ SC_(70), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(65.726897799800530671157506436644256771060786035901), SC_(61.162894549270587502316439917675754596142408328112) }}, 
      {{ SC_(70), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(66.408933602578734562184685925205038007726546971082), SC_(60.261458961876333241932898960622017388694367375183) }}, 
      {{ SC_(70), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(66.498927158849768965016573309494497904763336945658), SC_(60.136300360744310879885354631674976399016351203735) }}, 
      {{ SC_(70), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(67.419712562837952438691565021892965623317159332388), SC_(58.754135724346901543620359763556390719442665982486) }}, 
      {{ SC_(70), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(65.647196727879673126774462428933200450991646266224), SC_(68.909118423247655108084313816361350550022605886326) }}, 
      {{ SC_(70), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(65.717605044799948747887302187019209647921133602577), SC_(68.867600425671782901569162172125006695601576732349) }}, 
      {{ SC_(70), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(66.287414283534301186444926912228843629038564629184), SC_(68.497021140829673506995321056872889647713465439186) }}, 
      {{ SC_(70), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(68.643509205676085629636916314366734798807976404117), SC_(66.073543830999807181963380893100518885826945148837) }}, 
      {{ SC_(70), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(68.731361204040920277656964628692790127851903494345), SC_(65.938507948197145030699851629593771809022699730939) }}, 
      {{ SC_(70), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(69.082855563633155168671162193888126970497192365232), SC_(65.334185211722462728560149116066162024599473565016) }}, 
      {{ SC_(70), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(69.126954776332843416832331263562970372275138180149), SC_(65.249345832427216388833975960111325904406792668174) }}, 
      {{ SC_(70), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(69.537151811827442842265602305241617814854528179369), SC_(64.298923739399983068176360162871436075763705084709) }}, 
      {{ SC_(78), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(6.0981674585201265748651390379014065000632978696527), SC_(12.786050706104797419087851434451927359249995972656) }}, 
      {{ SC_(78), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(6.2032371913245289457585059007212338937411561355801), SC_(12.658469680458110665431863830797790388814271395415) }}, 
      {{ SC_(78), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(7.0962534227258885680819210401928814946342151036238), SC_(11.609403876698271303790026343215348295669708838874) }}, 
      {{ SC_(78), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(12.006790015590923136971520252904890413295281422669), SC_(6.7518021118373485422019789125671986834907832368642) }}, 
      {{ SC_(78), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(12.255388184857853097745174341972876212511503388023), SC_(6.5401762962180433876514105190743274357814276355386) }}, 
      {{ SC_(78), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(13.348341620866503576633590247343608640835528611055), SC_(5.643972887988872536126909106595720983906488906285) }}, 
      {{ SC_(78), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(13.49943658540682252133646378061246527216822375891), SC_(5.5243634098253764919539972735322876323163213119556) }}, 
      {{ SC_(78), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(15.158509787231291514297478255255390728517477679996), SC_(4.2770196974734968938104098616080055113458811537689) }}, 
      {{ SC_(78), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(6.6655144749460166080669969765381840123063195241354), SC_(13.541530817104923294911098281364023652376401970164) }}, 
      {{ SC_(78), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(6.7741469256580988219720303159543448295299524171099), SC_(13.410912442029829230241409936429053993303262259082) }}, 
      {{ SC_(78), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(7.6964159697266406006799927231847296877565828391254), SC_(12.33621906836703282960419143795735161529723564764) }}, 
      {{ SC_(78), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(12.743453070833783406174399874791333822693721192039), SC_(7.3408902646856894149920910373389894468019223339227) }}, 
      {{ SC_(78), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(12.998123909359296156433958146519668965678687339548), SC_(7.1223331634013146582666057834278115232399510514779) }}, 
      {{ SC_(78), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(14.117013700440518538599640271520165013249676522082), SC_(6.1955964924796214060234817753913948942721828651027) }}, 
      {{ SC_(78), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(14.271600712224044880495470085069973662730019460937), SC_(6.0717548746582339575631535104184359340882562020413) }}, 
      {{ SC_(78), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(15.967635658481667354950541472827510985299215510102), SC_(4.7776499518964909342479778210614703340966553442217) }}, 
      {{ SC_(78), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(12.593658478929117307375150288231907763924261476882), SC_(20.943420568849494732095148368298286760450177937713) }}, 
      {{ SC_(78), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(12.730727340314328999140552138536196906331485096827), SC_(20.789583867900446728382766255618653365979787985111) }}, 
      {{ SC_(78), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(13.885899565468189104240595946976322600462739641012), SC_(19.518092449705623627052199797032305898299973354791) }}, 
      {{ SC_(78), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(20.001134993215327628363922568877797305942053661922), SC_(13.442330786254114879394865487782704490471232438411) }}, 
      {{ SC_(78), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(20.302438983500465030303461588696105520298026664079), SC_(13.168587454975444001810615286364832117320627948146) }}, 
      {{ SC_(78), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(21.619473938877647402206972474919408295945475219701), SC_(11.998078742175478870198422341670522910479586607565) }}, 
      {{ SC_(78), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(21.800607218307497015146066001169682106971606411755), SC_(11.84037152111815035059537617137869557081285860011) }}, 
      {{ SC_(78), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(23.775560134568438938358816336637101843878636284043), SC_(10.17115991365124603225753385330502295679829428556) }}, 
      {{ SC_(78), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(59.109788660829604193837210424941554832650250000357), SC_(66.924244968987694268863165874938454456108510648603) }}, 
      {{ SC_(78), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(59.255332774180660505476142372380727502124388974604), SC_(66.79763777832188139755960894776987723878108365708) }}, 
      {{ SC_(78), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(60.456314048141400995921255794541734297959198563523), SC_(65.727998997828659495057567318431595018789528256335) }}, 
      {{ SC_(78), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(66.139267009377777886113198945270824453362033043951), SC_(60.000478610577498216146317652574852177097818535033) }}, 
      {{ SC_(78), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(66.392743064266774599467884183311511753740305595559), SC_(59.715882701399618308284463773985459180674558691182) }}, 
      {{ SC_(78), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(67.473550658502085904014894582403192643764770933443), SC_(58.469587043806073658977941853877826195280981073541) }}, 
      {{ SC_(78), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(67.618775617088088386484629627180591391800202404172), SC_(58.297898217569266177955162890290575060065745572195) }}, 
      {{ SC_(78), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(69.149456426035708019820004333069223664604587002723), SC_(56.42166241462038363086676260227061587139426722999) }}, 
      {{ SC_(78), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(60.865817532077809305399522591237833903933591254638), SC_(68.328657475272288835516395231114470305009190675914) }}, 
      {{ SC_(78), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(61.005818290397950321727955774332909657441420867643), SC_(68.208830351385742862929272074206114090074372705436) }}, 
      {{ SC_(78), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(62.159819494659174189534376476818337723298304171366), SC_(67.194729451885809593008272582401789416803651264591) }}, 
      {{ SC_(78), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(67.585001355682629221497711175362414781078945190708), SC_(61.722080140680660434480545900678652286758748995903) }}, 
      {{ SC_(78), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(67.825317733502907955107108718224006376545939353007), SC_(61.448616603844617077855436324809623076172321655726) }}, 
      {{ SC_(78), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(68.848004093644857113972882129576235637255830908299), SC_(60.249628618132825301987955428298278426321424333934) }}, 
      {{ SC_(78), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(68.985155813524848074393627859799455138519492593226), SC_(60.084278548696019305644923246601400368454940846312) }}, 
      {{ SC_(78), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(70.426436044750656374763727198158387783441011117362), SC_(58.274655031334242890864641063452258136748048237601) }}, 
      {{ SC_(78), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(67.182119456881668590209547212549397042260000171737), SC_(73.040959319316628591872463346923870223791854677862) }}, 
      {{ SC_(78), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(67.296174885852741545471913364662312666618785212899), SC_(72.951471814372329894998713946622146344875785446864) }}, 
      {{ SC_(78), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(68.23134567569884170429561233132889872860353512977), SC_(72.18650247067321052307576699132990441408903730218) }}, 
      {{ SC_(78), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(72.482454109208514802673589944549141560056853395719), SC_(67.877678842801839129897095245619305863504871673204) }}, 
      {{ SC_(78), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(72.663740569040805992302722492053286398199708740694), SC_(67.656068979822551725958381777326725687648239417322) }}, 
      {{ SC_(78), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(73.426408630030840427266872729925877106098726489048), SC_(66.678643023714659593711276540095160152949326791053) }}, 
      {{ SC_(78), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(73.527519913354658591440335235356903691312930266763), SC_(66.543136174255799400032395335397862901664550419367) }}, 
      {{ SC_(78), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(74.570504776286308401704132808392995969181452965507), SC_(65.049583837780643600222073473983157275695251228261) }}, 
      {{ SC_(78), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(67.883037237702601564500530021515735282672672117905), SC_(73.521761879351762644155794825735598660115347701041) }}, 
      {{ SC_(78), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(67.99346729470455738850814359125371087350703425732), SC_(73.436385091821375813700091217059011563811674946564) }}, 
      {{ SC_(78), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(68.898165779135716665224028391079053412479669461582), SC_(72.705213871130125938741802533345688987919443778894) }}, 
      {{ SC_(78), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(72.988359341310321099493793077646856107160503177601), SC_(68.556184361850217330245651452722572288039742057575) }}, 
      {{ SC_(78), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(73.161637909519561878061161640348306894823546208348), SC_(68.341795123605742350149254629147905718530412190201) }}, 
      {{ SC_(78), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(73.889078546202701769627647801447872225917887417616), SC_(67.39534244395318347647339561926799267015896265829) }}, 
      {{ SC_(78), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(73.985311011431170402415399599919268621105858694263), SC_(67.264023107309542706723983737823887125227842591784) }}, 
      {{ SC_(78), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(74.974365210633849051984655526774583794183022650949), SC_(65.815065664541557284152329819709461662892952483868) }}, 
      {{ SC_(78), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(73.304455618647976580595912915407191946980786399481), SC_(76.75210412549802484504593944827597388703023676926) }}, 
      {{ SC_(78), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(73.378141271343760371851626266935034943054281758235), SC_(76.70727661577521950577797844930735722123098076257) }}, 
      {{ SC_(78), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(73.975130942847286595749256665438825485449131952239), SC_(76.309384336290618724908928011289984656716411339919) }}, 
      {{ SC_(78), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(76.466246878733272007361857504198625387360193515533), SC_(73.750913095201008034940013271134681612882558921592) }}, 
      {{ SC_(78), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(76.56056903809157532829272303700967246231520071603), SC_(73.609436894051951047164797953026345311340958375796) }}, 
      {{ SC_(78), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(76.940419963376266468475540516877416578452763961885), SC_(72.977063940692095634899830362289227200545631708748) }}, 
      {{ SC_(78), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(76.988437509185908405311540071145851719108698486292), SC_(72.88837719555197816057352844344073011307243397166) }}, 
      {{ SC_(78), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(77.441786368881892206369964333416131459357599622617), SC_(71.896105336218724141993111624777836475748285880146) }}, 
      {{ SC_(86), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(6.9458132392291489038850907267913626444433705044728), SC_(13.970276980700601735255642515781733873282679171085) }}, 
      {{ SC_(86), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(7.0568081747540961299601050665915132531984583276886), SC_(13.836795449517586242133827166462858011783176518516) }}, 
      {{ SC_(86), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(7.9990277643957790986709272365019071939676940174165), SC_(12.738666768626891005012980367294980473347414092904) }}, 
      {{ SC_(86), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(13.154756797885136157840075800706545967828992011944), SC_(7.6358308598828143020477308378805458575063014015422) }}, 
      {{ SC_(86), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(13.414980574444300651451796881632537346539199660968), SC_(7.4125467070027878211667338596391762819324180197558) }}, 
      {{ SC_(86), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(14.558416763512127082677278042429029999750948228059), SC_(6.4656352341305925470552786755572145029608559525464) }}, 
      {{ SC_(86), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(14.716415947591449736745075772937811774443205706144), SC_(6.3390772942918271949564010568991186545623342940776) }}, 
      {{ SC_(86), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(16.450264905533239567169625148580918110962585928866), SC_(5.016158600014299201442148395655238195137643395186) }}, 
      {{ SC_(86), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(7.5764286379509488731473121094088807228976594207663), SC_(14.798322811147296981833771936641668602193613526893) }}, 
      {{ SC_(86), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(7.6911473632162838516441154663505786535397369750429), SC_(14.661641247015487750409083780460230526658042449484) }}, 
      {{ SC_(86), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(8.6639662095933011530322507766098077076434353472979), SC_(13.536529741061104909108680309505137017335077373812) }}, 
      {{ SC_(86), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(13.962984792313887405218337942726135186356522392457), SC_(8.2891802888203541513825007736369038496769715908772) }}, 
      {{ SC_(86), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(14.229602380631387259343785759213898606735197232224), SC_(8.0586457517182070075888382942427270061330055586897) }}, 
      {{ SC_(86), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(15.400366387267729234352262663622146219751489655335), SC_(7.0798243926246533758050205613749749920790841697973) }}, 
      {{ SC_(86), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(15.56204750108214768212598688379792897401422319702), SC_(6.9488474536893650045343905015643735938507773743244) }}, 
      {{ SC_(86), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(17.334907545900045541789199694328819501724917030953), SC_(5.5771761930851915577002965364439080327093883829855) }}, 
      {{ SC_(86), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(14.152544052341125297690598968059413956743114015101), SC_(22.921110862370147433426190115630440823412194553027) }}, 
      {{ SC_(86), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(14.296965147159144952240444953941918720161797722386), SC_(22.759934724724060249246699444149272428353753767342) }}, 
      {{ SC_(86), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(15.513259847605159079635664024437711070410090357229), SC_(21.427394923979231644312102480320665965682159188654) }}, 
      {{ SC_(86), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(21.933714623831016921002090587331003699617457875962), SC_(15.046391626132485873187641096213960562768478204004) }}, 
      {{ SC_(86), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(22.249484312992175781101073472591190497513724631678), SC_(14.758165301042908525239911451603033331518432505515) }}, 
      {{ SC_(86), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(23.629309722939979789825855497122309418803702250998), SC_(13.524749880931188279515365121491234301059717294689) }}, 
      {{ SC_(86), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(23.81902703167861416381282547451529469025941281084), SC_(13.358436199543591127434796603661807762423546422622) }}, 
      {{ SC_(86), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(25.886889937109894601641651313701144692765062771253), SC_(11.595921392605201251396507384571311655994866904914) }}, 
      {{ SC_(86), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(65.431407873129473866187907222098304378724475336987), SC_(73.638161755825974774794504484074929308268702792113) }}, 
      {{ SC_(86), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(65.583827497225122270072680729159245572409473391), SC_(73.504662912900637122203408295870761092400605276157) }}, 
      {{ SC_(86), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(66.841993311893388067741365610557157602897067430734), SC_(72.377746546528227937594422835123641134871274313077) }}, 
      {{ SC_(86), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(72.810845379145839214622217853006470719787899918954), SC_(66.36435494887230954770509248099492672155561208993) }}, 
      {{ SC_(86), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(73.077893265133970868140692841687714030591484820658), SC_(66.066208917378633799427911066047212373537458212798) }}, 
      {{ SC_(86), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(74.217669915889290904025349679730309526863621647581), SC_(64.761090996505632093466336881570837299668209147732) }}, 
      {{ SC_(86), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(74.370965689829175068477708884263996557746047555922), SC_(64.581359804083116806418562592965647970102615924518) }}, 
      {{ SC_(86), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(75.989210331825244956501620559492242257802421361584), SC_(62.618062663278157974115412221599622246935980424473) }}, 
      {{ SC_(86), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(67.358411318767441717974677592541107425870655318786), SC_(75.196148255238443992248450366597358272429691829128) }}, 
      {{ SC_(86), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(67.504983072277283780566850134910883988177308309477), SC_(75.069731582973801652105850918075813677730068288321) }}, 
      {{ SC_(86), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(68.713632427999510219067731875276829239875538597997), SC_(74.000875956704331650693968328532006514136943513147) }}, 
      {{ SC_(86), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(74.412014867228942289261902287031488007619846418845), SC_(68.255057937475010259989054255465463629239581549417) }}, 
      {{ SC_(86), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(74.665305199778665960987573613233515304853133004433), SC_(67.968645302350124562516193790695585961327917663391) }}, 
      {{ SC_(86), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(75.744378047998858796911342508821850605894936715196), SC_(66.713439693628400894160222915163162307211335394297) }}, 
      {{ SC_(86), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(75.889249472340800294187941076943531699376976604995), SC_(66.540402759581842369008537079166646220366352347298) }}, 
      {{ SC_(86), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(77.414336615857410234961033114589209364399614395911), SC_(64.647555822782736824879937440166805990064367140666) }}, 
      {{ SC_(86), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(74.280560204105565792899264034941182265359096407063), SC_(80.435047933607831810092574201084355331362964951028) }}, 
      {{ SC_(86), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(74.399800007466737671323101205941505677065932486287), SC_(80.340343187766454429179547301091221007366112847022) }}, 
      {{ SC_(86), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(75.378067167159335651078460344512550525277358998206), SC_(79.532093387918790049535461537988165124915705988028) }}, 
      {{ SC_(86), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(79.844525996046821761737382523809814252546147966756), SC_(75.007973375625704690509687280588088002200094652958) }}, 
      {{ SC_(86), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(80.036067051164637687101559240873306625217186275649), SC_(74.776151735053241165423718387231750856226274234337) }}, 
      {{ SC_(86), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(80.843393689062794969455400044263577214972748247745), SC_(73.754368135853644899205000776174001008875078731575) }}, 
      {{ SC_(86), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(80.95063341889224311140374152455392944207675412221), SC_(73.612792812538500966689432592282213237409532906646) }}, 
      {{ SC_(86), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(82.06048665719460702646117824531393731997649069726), SC_(72.053483096160489860318184259123714632206395794888) }}, 
      {{ SC_(86), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(75.047566296710508804105560701167719801433603935752), SC_(80.97108128787527023700521915894815220037159658513) }}, 
      {{ SC_(86), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(75.16299082171825432268168581080614380934140329328), SC_(80.880674702052207535592675813988885437325118488437) }}, 
      {{ SC_(86), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(76.10920323648607769851161797032383244777845114023), SC_(80.107792723772017158208205001731122378911129706279) }}, 
      {{ SC_(86), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(80.406818727521015247335978320605109324719290615003), SC_(75.751398795393786414008452023445252478320086386397) }}, 
      {{ SC_(86), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(80.589979851162393740346564954463845877040720685435), SC_(75.527172756055502599196437318837980672891311228387) }}, 
      {{ SC_(86), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(81.360477775810018967177402666075734364204224577624), SC_(74.53798668528137535964062028956141380311380992585) }}, 
      {{ SC_(86), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(81.462621997260557582582058859924324277535107237729), SC_(74.400820465858676410379603253738268856477127254579) }}, 
      {{ SC_(86), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(82.516254731942869631602283336588073825361574684681), SC_(72.888496334789514474812560818277562819692781872347) }}, 
      {{ SC_(86), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(80.966536513901647711514244142772321612050712884101), SC_(84.590693106881046778018451889656228247314980354581) }}, 
      {{ SC_(86), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(81.043331870604669812047307540229224661248016855006), SC_(84.542717240518969757775101266596586800567881067784) }}, 
      {{ SC_(86), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(81.666121025181775428962263371059795485118224599435), SC_(84.11884721018919645391414608198100415918128614085) }}, 
      {{ SC_(86), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(84.285576378552851242722368138890277457976363736459), SC_(81.432079580377667728196621951521533389073870560388) }}, 
      {{ SC_(86), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(84.386052288054460594734587967694516337096019774512), SC_(81.284490257052186219273745394348992507528725454014) }}, 
      {{ SC_(86), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(84.792881919346504539283037797094027062695963309625), SC_(80.625503155944509629076817576397666278275689177907) }}, 
      {{ SC_(86), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(84.844629925046726608261790369371208575327290009901), SC_(80.533167450157378773318434492827003614740884164349) }}, 
      {{ SC_(86), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(85.339230370096032070734739222487868334586639845669), SC_(79.501227165620096745252089669392865748677099936068) }}, 
      {{ SC_(94), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(7.801145985023555209786634390060878302823223057646), SC_(15.146798540032044618618696769667582084529973896819) }}, 
      {{ SC_(94), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(7.9177911480702794932896409338309681366992069464133), SC_(15.007687503555726510687831747237410012104978527306) }}, 
      {{ SC_(94), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(8.9069447068384104776001009780017419598880066728379), SC_(13.862743176080042879294985239287374474663386295711) }}, 
      {{ SC_(94), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(14.29668160507190083031258913481029068138600446676), SC_(8.5258641767433119729022228379674560721325609618188) }}, 
      {{ SC_(94), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(14.567998530184756618935149917585416621451806495576), SC_(8.2914592966772296215773118275518341022515183376968) }}, 
      {{ SC_(94), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(15.759597854090727025980919437324539086842588419625), SC_(7.296195812169845466519979794257352785981092155484) }}, 
      {{ SC_(94), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(15.924182962796968034385378591474222611875282780888), SC_(7.1630149980545438505539909616418923184971391180644) }}, 
      {{ SC_(94), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(17.729341239978339411641471919427342555773712488765), SC_(5.7681237441254984639386594724929362300361626477156) }}, 
      {{ SC_(94), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(8.4952407790762502884294148171732734560738663745865), SC_(16.047201111583644038586704558955395786168140016462) }}, 
      {{ SC_(94), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(8.6157636738504986670494881939769236355928003927831), SC_(15.904734727947326766648557097206925850697300060355) }}, 
      {{ SC_(94), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(9.6368027883972775528501267735691476648690268123343), SC_(14.731513712479967275265369118174985389101090967119) }}, 
      {{ SC_(94), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(15.176310893498349139114865139250984421919596124124), SC_(9.2436417036093322655286955857078670351824812796869) }}, 
      {{ SC_(94), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(15.45432822565433449771111325757287675312840831257), SC_(9.0016816002789885881864899940758956889751053654136) }}, 
      {{ SC_(94), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(16.674583795222815490635985746609821006524241746618), SC_(7.9731924117520267945871041558651972670887244641673) }}, 
      {{ SC_(94), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(16.843032111986809985282402780087360511711595353484), SC_(7.8354138701669740669119816753469280782725608850446) }}, 
      {{ SC_(94), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(18.689157852228469202095100036990933593253128212869), SC_(6.3898619968033505802105382948018166943063833501692) }}, 
      {{ SC_(94), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(15.720979149202354985761381883477340231363198612585), SC_(24.889245392034195107580996649610247431035153794221) }}, 
      {{ SC_(94), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(15.872414145087270586233178462247983262369189844388), SC_(24.72106602837218133736745001682764210423807370415) }}, 
      {{ SC_(94), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(17.147028900686247366200323905188333565666862338536), SC_(23.330268114052149251223476965824028254350423277965) }}, 
      {{ SC_(94), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(23.858802291030027259184177219111845868399368618215), SC_(16.657927541685284238553016760867961026392682256377) }}, 
      {{ SC_(94), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(24.188376544786041456147519061526636476043992418103), SC_(16.355882190191059398083782786339730856654296335723) }}, 
      {{ SC_(94), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(25.628114973724624737918831251073553550435749118405), SC_(15.062456822309169971727080308044419856974412605654) }}, 
      {{ SC_(94), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(25.82602184170651971444194179315222305939058132684), SC_(14.887934919287318948010659827834075151488187794679) }}, 
      {{ SC_(94), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(27.98250468682738835427953108981114702493060162993), SC_(13.03647421539277724699880442503362385008332999302) }}, 
      {{ SC_(94), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(71.761985502401641809400119600606177916530080831367), SC_(80.343128870284935880693974650974323187993949463676) }}, 
      {{ SC_(94), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(71.920965460109548257549729822061655651186412406752), SC_(80.203056211656777005692075471209842644029125282814) }}, 
      {{ SC_(94), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(73.233700649897853023155070449245731017031748873341), SC_(79.02149255490542621813962817144899129475008636669) }}, 
      {{ SC_(94), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(79.475421834891954830923674185428950014058290542962), SC_(72.735255243192664813730346858503408331313229838377) }}, 
      {{ SC_(94), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(79.755418384011661063264584559051656756651955502721), SC_(72.424178732212054550608230668517194050174101900775) }}, 
      {{ SC_(94), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(80.951442327283864476766669065735610415695384401698), SC_(71.062936052258651628007457863363019012979911268912) }}, 
      {{ SC_(94), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(81.11243426424981550187601841942582846483697130024), SC_(70.875532383897045834838463069899574597626592141408) }}, 
      {{ SC_(94), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(82.814132672637175323508906585298746650176297034011), SC_(68.82919804537338968246782623664700123409119111382) }}, 
      {{ SC_(94), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(73.859571674283745724554637528866921244637466799877), SC_(82.055083335237835056219535792222543304497331360309) }}, 
      {{ SC_(94), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(74.012413046512243823687100619117024117574124143577), SC_(81.922381531234332095742681405387251933597827315226) }}, 
      {{ SC_(94), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(75.273210305725007473799076347462365102531700182684), SC_(80.801288631449308233332584723812452401217534599683) }}, 
      {{ SC_(94), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(81.232337422702411951957034608628868006503845846844), SC_(74.794752716760790853658068429232948646409937638766) }}, 
      {{ SC_(94), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(81.498005291024239777685438826771409607773040241406), SC_(74.495983395892053218205804355115518037866354912646) }}, 
      {{ SC_(94), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(82.630857408797728335168743694450949586186578808368), SC_(73.187139615103532318949671652429480674068742471319) }}, 
      {{ SC_(94), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(82.78308929112105577651228821213984079013112432343), SC_(73.006769584441544477241413720682517351707777699476) }}, 
      {{ SC_(94), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(84.388033822784174069063020299774251856369061976038), SC_(71.034549039245372247644063845378791168907922456769) }}, 
      {{ SC_(94), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(81.385787095760532631011995482097952344188577707495), SC_(87.822381821250148525729959265990999781425597362135) }}, 
      {{ SC_(94), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(81.509972709964573561429312033744742617473466472875), SC_(87.722703495401044191591531000464516106170584650936) }}, 
      {{ SC_(94), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(82.529359319863293187539717395874296614096317127913), SC_(86.873177882369364592844829548683225816210702324421) }}, 
      {{ SC_(94), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(87.201331196694772835156800875842650807814831544276), SC_(82.143590885962568466362006245838003206817602556038) }}, 
      {{ SC_(94), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(87.402652012492616445307573869941310874183544444923), SC_(81.902025875071559906645072234171695750105619998421) }}, 
      {{ SC_(94), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(88.252548061972664616559086960448901809300266332327), SC_(80.837926809684677600188127197906059300099614989901) }}, 
      {{ SC_(94), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(88.36562618412177227082099175636694832918551995174), SC_(80.690563448783234592418390476284028064275585357359) }}, 
      {{ SC_(94), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(89.539104223137902726734580837733215808281797389115), SC_(79.06855390482842967148959365105655443034268812811) }}, 
      {{ SC_(94), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(82.218638360397974654987981446773330285286070885862), SC_(88.413894703795294146860560230620021711899341227924) }}, 
      {{ SC_(94), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(82.33882739198524054548183237665709810226639243846), SC_(88.318693674453272967421104809217091136334070854107) }}, 
      {{ SC_(94), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(83.324648531227060153902371392918520532337137377448), SC_(87.506035216540946925939414351913968001432763456468) }}, 
      {{ SC_(94), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(87.820208543212136470865057850441553586277109362077), SC_(82.951746004152344877184293697040893873356677956287) }}, 
      {{ SC_(94), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(88.012794074606636510527490308420541394849102724923), SC_(82.718134578156719734399077338962566250474653525059) }}, 
      {{ SC_(94), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(88.824330867726189930373030685822202331436244582328), SC_(81.688183719576963479853887755445243804310741190373) }}, 
      {{ SC_(94), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(88.932106169193255994075375686470609054114880154469), SC_(81.545441017708913025177764516335363992725069723706) }}, 
      {{ SC_(94), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(90.047167090419334392854830288848246875570486534409), SC_(79.97269940747037984619521668755044595799405937608) }}, 
      {{ SC_(94), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(88.632765718787040523843959438237494824369514964228), SC_(92.425424902037059080837210507087498486262820595011) }}, 
      {{ SC_(94), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(88.712526347851097058558336647577679095926533544603), SC_(92.374443196406595580034075735690993663845828818575) }}, 
      {{ SC_(94), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(89.359924077241611916690390754525883296187928158695), SC_(91.92576805605481448245153114216349157130107944978) }}, 
      {{ SC_(94), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(92.101919213323680221941518266232699521409470464954), SC_(89.116510980974737484440893820327115971331048122069) }}, 
      {{ SC_(94), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(92.208271093986097477185447060480540232398613850555), SC_(88.963090703759665136095723572285963397235559035967) }}, 
      {{ SC_(94), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(92.640858425361466174354215186087483105177743302958), SC_(88.278726631158769897593283615099380848459302677143) }}, 
      {{ SC_(94), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(92.69616813943873924626530921117852777654310510982), SC_(88.182912734031051207705053480143478087906660497225) }}, 
      {{ SC_(94), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(93.230221341776895913396226034296597926358134334975), SC_(87.113179136552973727414101965553584412690168084971) }}, 
      {{ SC_(102), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(8.6632008807861670752536305990337881574438371700273), SC_(16.316585195700711779871008047730587123595797220946) }}, 
      {{ SC_(102), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(8.7852563585694291252402185560061984423806519982759), SC_(16.172081471581745732760251311015062940512785910346) }}, 
      {{ SC_(102), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(9.819362102388435677255928187976591487107044010712), SC_(14.982285928856556977811893349360540028861053730497) }}, 
      {{ SC_(102), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(15.433324795444787584614892373536575205308669028909), SC_(9.4211510038091679975133718560077800598843464529262) }}, 
      {{ SC_(102), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(15.715269413805476311308603410136373979976228317508), SC_(9.1760948884866244174979570140899400756472719549933) }}, 
      {{ SC_(102), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(16.95300494759159880476040498131170219356987758859), SC_(8.1345346496650686442854582992128352759617456805367) }}, 
      {{ SC_(102), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(17.123897960346715813987984637467359876541541227861), SC_(7.9950146222368598165601064681039837339962619558096) }}, 
      {{ SC_(102), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(18.99733973275075548730128990694324660459335558577), SC_(6.5312808696524098555214921095493123682045122358726) }}, 
      {{ SC_(102), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(9.4209595691616734830883638570009026989480144752921), SC_(17.289161447518906001659460668938982789231536576334) }}, 
      {{ SC_(102), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(9.547040464693301163395722572143016761179515224155), SC_(17.141153509822953812097311780912807356686838102209) }}, 
      {{ SC_(102), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(10.614265360304164091812956245551206469605527681406), SC_(15.921841133006061032616141611290556434797873836836) }}, 
      {{ SC_(102), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(16.384211982231084429237394366668961678432071190898), SC_(10.203502384260964062506122581960011636245150485445) }}, 
      {{ SC_(102), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(16.673150874364595004012861111794967533335003144776), SC_(9.9505987009254690210168754714620386636682786958316) }}, 
      {{ SC_(102), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(17.940815930625829228051316046074799847941398420616), SC_(8.8745503119417025876364737483462775311429433794048) }}, 
      {{ SC_(102), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(18.115745902300849413171947190638486439850333338302), SC_(8.7302609828513173210279317735874859850733271430827) }}, 
      {{ SC_(102), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(20.032030202198952813933839506850730804261873949311), SC_(7.2140323813947691966883213835794825665411698748935) }}, 
      {{ SC_(102), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(17.297765851595619577058752177646007501473097739413), SC_(26.84902375570066638547065701032647157974168485542) }}, 
      {{ SC_(102), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(17.455919239712267057987430915516604234815671464676), SC_(26.674135039297925547538088013756627462993846717269) }}, 
      {{ SC_(102), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(18.78640506120763614787615562107495358758759491314), SC_(25.227518604550054405191519397941397844278788856597) }}, 
      {{ SC_(102), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(25.777338000341389521938811679312747001341356043072), SC_(18.276002632933612657435599267649235016212247914564) }}, 
      {{ SC_(102), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(26.120138770955741398178993776840152758438684041957), SC_(17.960718494252922672721950595213394921473655838701) }}, 
      {{ SC_(102), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(27.617275243377743021780493527081324004076945720931), SC_(16.609813039647759813735958547138523357579275902558) }}, 
      {{ SC_(102), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(27.823027010767748786472664380524856722292710281138), SC_(16.427430469068922284500094321060190604781619117239) }}, 
      {{ SC_(102), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(30.06438369134110681557300962776995822948471260358), SC_(14.490821357849230338638528087736993502585288537978) }}, 
      {{ SC_(102), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(78.10039615300577322405286750591958236053874954583), SC_(87.040269321734090024029409561738589564060961411331) }}, 
      {{ SC_(102), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(78.26566097382456539361830804734952120518897514739), SC_(86.893900372269900934920267566210440333416447190304) }}, 
      {{ SC_(102), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(79.630679162951877565933087210749806441736167223186), SC_(85.659987532129803616670826985761789364620519483603) }}, 
      {{ SC_(102), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(86.133872959620059545026532759506843992973821836018), SC_(79.11229751982733938869129551358658514180720684378) }}, 
      {{ SC_(102), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(86.426273695437994238010658108993777627476052706659), SC_(78.788832271436964907540910944878944548619202219092) }}, 
      {{ SC_(102), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(87.676168654511358384674558350407202513595465685562), SC_(77.373822385245469155081121210563135575641940288225) }}, 
      {{ SC_(102), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(87.844529934033355799975384393720058454803905486953), SC_(77.17906939928371896959490624410935820213959972999) }}, 
      {{ SC_(102), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(89.626102849127154070917764861650899081988970160995), SC_(75.053211446557898553293301313237746467799228780495) }}, 
      {{ SC_(102), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(80.368221855363800275965452345572746319737795377984), SC_(88.906536464729878563341780511692887143269671639171) }}, 
      {{ SC_(102), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(80.527069450737181489058959815673974300461542066985), SC_(88.767815277331774836358084340609235267634988029848) }}, 
      {{ SC_(102), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(81.837828792598123861543181425071304778505862769015), SC_(87.596684296316734349520167906029366526883423676846) }}, 
      {{ SC_(102), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(88.046806559417840350104581495898989986520215337937), SC_(81.340320547297557910355696237728029137085331610689) }}, 
      {{ SC_(102), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(88.324330933449083898594589749913687220667400378953), SC_(81.029712455665641980104328855593562698901043591536) }}, 
      {{ SC_(102), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(89.508686589093729073095346208857175041023836204476), SC_(79.669484766715716833161768480619456437287552993308) }}, 
      {{ SC_(102), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(89.667965656784124129044041494648656957301348071564), SC_(79.482090693741057056615544414926317346718710125836) }}, 
      {{ SC_(102), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(91.349330200248507759373895765505184814675364584523), SC_(77.433857666854521496278142280242603271645046332251) }}, 
      {{ SC_(102), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(88.496944143689839974064880142399399122421418798751), SC_(95.203807908491592754921368028304619187026556668376) }}, 
      {{ SC_(102), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(88.62586713045748479785387297790611141522368402543), SC_(95.099368462266850366769747094419820067003444417935) }}, 
      {{ SC_(102), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(89.684645257649711258721241906909193080856329278709), SC_(94.210317023019982926624846578026130905600785966562) }}, 
      {{ SC_(102), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(94.553526984142053895234741208388602857234125363621), SC_(89.283859876238198013154529891020569871694347928421) }}, 
      {{ SC_(102), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(94.764213027344307199573875291465347838679818198277), SC_(89.032960910555609738122814260563654903615281776267) }}, 
      {{ SC_(102), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(95.654857298507168065316776638358173384871516169874), SC_(87.928330569057151162483148144946461774439825879857) }}, 
      {{ SC_(102), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(95.773521395496859758674227300977180608010015717548), SC_(87.775424070431993782714155785106323195971078701168) }}, 
      {{ SC_(102), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(97.007812345898782857165691620029024523601422332773), SC_(86.093382889551883942072273258481831603525464338284) }}, 
      {{ SC_(102), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(89.395427538492976862303554768900632532721806503029), SC_(95.851017272542885795257570181708402025736451036344) }}, 
      {{ SC_(102), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(89.520180163966281655564824584317287299335181108512), SC_(95.75122699160862670132697173474282858991364755106) }}, 
      {{ SC_(102), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(90.543944831011421478385217143000909280233831587416), SC_(94.900480534155618955090706058448722084861138465369) }}, 
      {{ SC_(102), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(95.229160762391208043913872496958433622056134440103), SC_(90.156577962677356115108678581663003821751109090593) }}, 
      {{ SC_(102), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(95.430770753461278770804453920308206143415336067028), SC_(89.913975699861523868827071299305388222957731219112) }}, 
      {{ SC_(102), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(96.28158714716449816069448899331779475256808258825), SC_(88.844979878071455830584996471642292301632396001996) }}, 
      {{ SC_(102), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(96.394749337786047118544038419758416132005743090617), SC_(88.696896813985452715473993989025330181119786304891) }}, 
      {{ SC_(102), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(97.568509006405942907421906549118839395958802357751), SC_(87.066311152560258360005769540860086519286534578454) }}, 
      {{ SC_(102), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(96.302612858518283709246934368506433942499259910698), SC_(100.25674401782485230570540263931807103408593637078) }}, 
      {{ SC_(102), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(96.385212641033269959086011893082429190894248710337), SC_(100.20288305186671121306217580304109156049220220515) }}, 
      {{ SC_(102), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(97.056178246072585545448744295093487819877895554447), SC_(99.730440044935050677374566021854396718364421462783) }}, 
      {{ SC_(102), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(99.915620606945997082825044830771434239963476923664), SC_(96.803788607648547633731025849877009625629843362907) }}, 
      {{ SC_(102), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(100.02760280613057254423425393587351724682083382942), SC_(96.644783955039517995515369932585560488422334349434) }}, 
      {{ SC_(102), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(100.48486204043269995352945994473162591927761682462), SC_(95.936123118466509565122023291719833223677795994635) }}, 
      {{ SC_(102), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(100.54358218677394102916984114271044167233384726745), SC_(95.836980016962354943183597806948441580975322885464) }}, 
      {{ SC_(102), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(101.11542285588358068003997590845367290788097669958), SC_(94.731087264830922630899778436819099173707655975884) }}, 
      {{ SC_(110), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(9.5311992295056841462628434239846898249452970051196), SC_(17.480418958328505207260538231638427453951331258138) }}, 
      {{ SC_(110), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(9.6584533041508528619969444531802888379257874721588), SC_(17.330731809622492416863120459176405836205473307874) }}, 
      {{ SC_(110), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(10.735761049939511999177430337333042074329584380849), SC_(16.097821406636012344517927002712726638397045351302) }}, 
      {{ SC_(110), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(16.565299492183664773996318158323627932567769426795), SC_(10.321084676314554239255625432489933480208823724416) }}, 
      {{ SC_(110), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(16.857460386951702723034998692995951182028584417416), SC_(10.065791960949573590646309581770577560927767636161) }}, 
      {{ SC_(110), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(18.139541127452114554913425450588176959391602210312), SC_(8.979748417015074101220364683626286051258205885204) }}, 
      {{ SC_(110), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(18.316496467444591789224251152041275464141671740938), SC_(8.8341392015703380303470453311944536570066600821417) }}, 
      {{ SC_(110), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(20.255550519206839043668944319526734618212855652425), SC_(7.3043157564650578152771580085891623372020131841304) }}, 
      {{ SC_(110), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(10.352784957695106415384161662722173698759841475183), SC_(18.525006793352553594391943383795848970326679739823) }}, 
      {{ SC_(110), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(10.484206587558023630306074730542777959234859321959), SC_(18.37167226861510913165720573060813802702174526073) }}, 
      {{ SC_(110), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(11.595820390961819270439100184871235739716557277055), SC_(17.108052406435486520718512179244152127120867942847) }}, 
      {{ SC_(110), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(17.587317570190287728608547891729978050981432786118), SC_(11.168138717341224366472186597008840737948212047627) }}, 
      {{ SC_(110), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(17.886755345001343380288732866080327327512632241142), SC_(10.904717157439616652245000363036567093007185564766) }}, 
      {{ SC_(110), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(19.19999009644968147169669237617423114964817342146), SC_(9.7829703674417416447601191973279139105401365579394) }}, 
      {{ SC_(110), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(19.381149487689537484752879539375268680964631170468), SC_(9.6324266359464271487155559676217879711661768897294) }}, 
      {{ SC_(110), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(21.364849220523239504830418459055294239392716287481), SC_(8.0483401198573268889581949104829694557915698010208) }}, 
      {{ SC_(110), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(18.88193744861250885407727000922396593115457303044), SC_(28.801413797178619584075281359169255681798807837557) }}, 
      {{ SC_(110), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(19.046548205788864576436301751563902251246270216112), SC_(28.620075464100981748779043570084250219002722135071) }}, 
      {{ SC_(110), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(20.430740960559105594550271105332990851877554732411), SC_(27.119797228136994546970497011228178005608058541436) }}, 
      {{ SC_(110), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(27.69008023226574878169283616456290493155748131413), SC_(19.899861294734220892819896545780896217097418279213) }}, 
      {{ SC_(110), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(28.04559649468282024176106651348578921854475971442), SC_(19.571851123442908728509388752516043864164971733774) }}, 
      {{ SC_(110), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(29.597908270950176889218065013990342729413992018948), SC_(18.165700028813246859764645137002658515267245113205) }}, 
      {{ SC_(110), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(29.81120041693909230812631468254644674091953158368), SC_(17.975763581953372960805913848879708480128263452345) }}, 
      {{ SC_(110), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(32.134122774595544213972101074336850438105758703031), SC_(15.957354360004545078336007663886168868210267885587) }}, 
      {{ SC_(110), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(84.445731982734573228514115285672497857063836680566), SC_(93.730489351315609549554036910315394383223308268403) }}, 
      {{ SC_(110), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(84.617038209823759124007800202453407117172816957677), SC_(93.578069187195003302460148504530958306117146094544) }}, 
      {{ SC_(110), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(86.032318226881423394473463982235356780299269343234), SC_(92.293837610839661238221835143223693504601729501887) }}, 
      {{ SC_(110), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(92.786906519476999772050453176275702830807230582404), SC_(85.494770245738821129984768859211851462623005459924) }}, 
      {{ SC_(110), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(93.091230373089260591595694835435533440560578888559), SC_(85.159395166099199524011066537053412218186642566661) }}, 
      {{ SC_(110), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(94.39289811472596815107740575037423278981834055352), SC_(83.692701558751675278649968230278392016719008106057) }}, 
      {{ SC_(110), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(94.568340357738521297631142403886491455369613685215), SC_(83.490884758444170268245624538028169446073515867682) }}, 
      {{ SC_(110), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(96.426633907825001942092980466101610565821706022826), SC_(81.288605752396751908652355598623044612606306990051) }}, 
      {{ SC_(110), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(86.883493364703087667890541611753138841329973369939), SC_(95.751374139356056580938832283449403606407300189918) }}, 
      {{ SC_(110), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(87.048114408257289533864831333469452350304726018651), SC_(95.606868200728318119866305559679066410346455278925) }}, 
      {{ SC_(110), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(88.4069036207752576128908842277112264287421047613), SC_(94.387641942629699353156760407026847366263489384696) }}, 
      {{ SC_(110), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(94.856098570513961897229749444675951748994394581185), SC_(87.891080675637989621508437680801646110839924005376) }}, 
      {{ SC_(110), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(95.145019155112401475914331554375023336892150100475), SC_(87.56909163985267423709405610182955322612335514176) }}, 
      {{ SC_(110), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(96.378869302946612315216721396889334141102332223091), SC_(86.159472156520441183060129479254309198128574424277) }}, 
      {{ SC_(110), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(96.544919212415243505129221767441377688346510206447), SC_(85.965327069125056999966892559752702478005688762392) }}, 
      {{ SC_(110), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(98.299676434654431821130035470603843501334645947136), SC_(83.844049304667358475111017410878023021934387426832) }}, 
      {{ SC_(110), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(95.613341419350033545992164658934422339977914941371), SC_(102.58001016800569317930686656211982320999058022544) }}, 
      {{ SC_(110), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(95.746817620324770699900424946019780004668689606918), SC_(102.47099698095642986175139170887421259190109884851) }}, 
      {{ SC_(110), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(96.843460118127644940785917756029322604791833238296), SC_(101.54396464890553009117648492564268216904035410906) }}, 
      {{ SC_(110), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(101.90164472746385878017346583007791798411635010629), SC_(96.428239157637359601598826053621780942117848804625) }}, 
      {{ SC_(110), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(102.12133002404691705111750580384244923317413954869), SC_(96.16836808055239594081995983838857754028761968561) }}, 
      {{ SC_(110), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(103.05111664638367532524388715469442488532276982095), SC_(95.024782742177757682528412151413819962433803238977) }}, 
      {{ SC_(110), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(103.17514446343391510399479696269359385850998195512), SC_(94.866549385346926568834636264333042060733933490013) }}, 
      {{ SC_(110), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(104.46778032848804609991839734905078280228134895151), SC_(93.126831491287759242155830626631905077683204869898) }}, 
      {{ SC_(110), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(96.577268255645872260217124892956649447979952522736), SC_(103.28310752388057060861258211136239465162366842163) }}, 
      {{ SC_(110), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(96.706406973493689176394357091778058623212457609772), SC_(103.17890893525577072689399763090115222196698167628) }}, 
      {{ SC_(110), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(97.766643513745322888043623580687139481148256363294), SC_(102.2915650063524215924844656733913255655443644485) }}, 
      {{ SC_(110), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(102.6341865062394079045880502557367683126898061993), SC_(97.365372488632961487569633614272722940298851007608) }}, 
      {{ SC_(110), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(102.84446788327680091928533131189466619090743442466), SC_(97.114128083162065404633450614152965732379951020718) }}, 
      {{ SC_(110), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(103.73301285820780601854038503195990199217206265326), SC_(96.007606642528597306650663825503412595498193217587) }}, 
      {{ SC_(110), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(103.85134698698012056956239072423837436298150837409), SC_(95.854391729828185327631572914798186390827310015072) }}, 
      {{ SC_(110), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(105.08141118285361256949969877297338048103034428707), SC_(94.168233132529090081436684716915122962817931114362) }}, 
      {{ SC_(110), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(103.97565157381340246914904601541398189457031869727), SC_(108.08502007846483371724543358606478969673259944166) }}, 
      {{ SC_(110), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(104.06097914419886624979278717246735467064606814919), SC_(108.02839286711820890696390854754148299501074663144) }}, 
      {{ SC_(110), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(104.75459307606926636092702397206406620458067603031), SC_(107.53310596229390629678529754771993683603328826059) }}, 
      {{ SC_(110), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(107.72696657343394690656973274374203280742551497175), SC_(104.49357613388784551183399097283639554755036942631) }}, 
      {{ SC_(110), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(107.84436029241709455399960575448125211159580778636), SC_(104.329204979801841124202299920179642338448355729) }}, 
      {{ SC_(110), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(108.32532128823860819514357963868981683768366936785), SC_(103.59720114487939654393782321262591848160447059253) }}, 
      {{ SC_(110), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(108.38731607810520439284454618069018524759691977947), SC_(103.49486029911472453877454432565460982330324622811) }}, 
      {{ SC_(110), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(108.99541996323565737934372266821034303079456117103), SC_(102.35424895521932015307681694777176335089517201142) }}, 
      {{ SC_(118), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(10.404501822180385700715329671490535462630986873634), SC_(18.638941312877205514365907274862319688175417653472) }}, 
      {{ SC_(118), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(10.536765848606679942303482203691810453563129513277), SC_(18.484257406209677342088827220163401105367779168761) }}, 
      {{ SC_(118), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(11.655715166903718791230785778321405230385252251589), SC_(17.209781383196939029398373261113014637613906663332) }}, 
      {{ SC_(118), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(17.693108649339633904780556983925842663286232694063), SC_(11.225166863786548246823738433355908965051053272772) }}, 
      {{ SC_(118), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(17.995118737395024896601759117583489732424163602795), SC_(10.960007236823616293030063800755114157200700200648) }}, 
      {{ SC_(118), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(19.319947138671172887213278184134339524908392023266), SC_(9.8310960070495122263777473954746299894746472540517) }}, 
      {{ SC_(118), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(19.502745819914267349231266496720412950894976684918), SC_(9.6796201577950928915639679355404161490180214919567) }}, 
      {{ SC_(118), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(21.505031334616551708215451533553627793607494157515), SC_(8.0861528610157949697291459816373044363089825950917) }}, 
      {{ SC_(118), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(11.290060229086740993600074469850161298532583842386), SC_(19.75539587669619285074112582447291810107620147674) }}, 
      {{ SC_(118), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(11.426628982317421122542578951235289221479887389598), SC_(19.596926524754548682206919025850304542334728452549) }}, 
      {{ SC_(118), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(12.581029517659022550051490169576050178074078636458), SC_(18.290590850875332123078143444122104031048623960171) }}, 
      {{ SC_(118), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(18.786144097236733234020941932804021906497188858402), SC_(12.137038489909107314374033231920620418954749459132) }}, 
      {{ SC_(118), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(19.09570361665091250594247179237693747499603973208), SC_(11.86347863770244820723468354569350842965401812574) }}, 
      {{ SC_(118), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(20.452866953416694083098789103489286923299305422463), SC_(10.697691454120541570842437245934478088498598946257) }}, 
      {{ SC_(118), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(20.640030833046467922146960501700284163176079993796), SC_(10.541121577332541157735657557605726265300940662967) }}, 
      {{ SC_(118), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(22.688700986191269352955390042166422508447653676008), SC_(8.891682455729345206656431975091274946818185167209) }}, 
      {{ SC_(118), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(20.472700422244131074441467612913645720014152640566), SC_(30.747209824566426787929759373244556083970373500121) }}, 
      {{ SC_(118), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(20.643535782941428117416802894626612379287750408983), SC_(30.559653609449400412440246668638297005716880023987) }}, 
      {{ SC_(118), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(22.079504915033133265125184944045933803025485746634), SC_(29.007638177464812930088288539398026771358542546304) }}, 
      {{ SC_(118), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(29.597651526913630927095933501178999191487379791693), SC_(21.528883060551029329325136664163091043655789109376) }}, 
      {{ SC_(118), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(29.965427252399173451487056306274131048893296224246), SC_(21.188604273990333212517389290053489306004734324417) }}, 
      {{ SC_(118), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(31.570931288316848106432929757652463897502103039966), SC_(19.729199955423354569369429749012240947930875354495) }}, 
      {{ SC_(118), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(31.791492200064023216783769047971045739189137450471), SC_(19.531983058789152495905903663320335639789020293151) }}, 
      {{ SC_(118), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(34.193030856019682819754802482772208848939143743906), SC_(17.434755051070521739274216035818712407458037151877) }}, 
      {{ SC_(118), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(90.797248021471103618264083483493637293116464626711), SC_(100.41453281768142901195422247191773745981608247276) }}, 
      {{ SC_(118), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(90.974378455795622071247116507700159314179736748532), SC_(100.2562799366581161148453857152259630339437499764) }}, 
      {{ SC_(118), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(92.438116732889332978895579938763830836429044401402), SC_(98.923540650745538007584468314059980491562319053542) }}, 
      {{ SC_(118), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(99.435103724984032846794406201240865035557215406819), SC_(91.88208949918755465831091531489242648980288150125) }}, 
      {{ SC_(118), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(99.750921608720062264007968050283574636962636463589), SC_(91.535231936396850534984075833245299081280171979469) }}, 
      {{ SC_(118), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(101.10249160539694448556532591472481321373765212021), SC_(90.018713314645521576884828359124586661691168920011) }}, 
      {{ SC_(118), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(101.28475787858887608269666419734618452942268726978), SC_(89.810087334240168693849810476834797191893361611305) }}, 
      {{ SC_(118), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(103.21696535239064121075578887781803739517044162466), SC_(87.53415314393764710493553127385326824565189696659) }}, 
      {{ SC_(118), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(93.404673587163035131593981396699191769568964798265), SC_(102.59030758911368759256890854971815018735212916476) }}, 
      {{ SC_(118), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(93.574860417883339060008971120928792123311032167247), SC_(102.44022605145739860082028361870842126203028049647) }}, 
      {{ SC_(118), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(94.979955370212930566917859006048472550072649652805), SC_(101.17463717710367982294708054459058768121906433434) }}, 
      {{ SC_(118), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(101.66076885078961354189138396003247954028425496839), SC_(94.44647450140145073212726982869152313010031906655) }}, 
      {{ SC_(118), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(101.96067513250970868842463316011127168828291763115), SC_(94.113513046342276929524519788669073542555664180503) }}, 
      {{ SC_(118), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(103.24222906619147843735461955731802972380439362952), SC_(92.656278889527315627661004693822844358701131846015) }}, 
      {{ SC_(118), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(103.41480366886864742875214578262973937925111097375), SC_(92.455626283608250528748650430950016252448791168784) }}, 
      {{ SC_(118), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(105.24026060384639529306131125289380903325347388253), SC_(90.263949307875257237406270601468463429622175104081) }}, 
      {{ SC_(118), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(102.73441318553958687286478882128168154020299460939), SC_(109.9515502806333607118067657994402479082935970167) }}, 
      {{ SC_(118), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(102.87227835022307980232344301148186227526107533675), SC_(109.83813021950417612279795935674072464784440540613) }}, 
      {{ SC_(118), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(104.00542278092588518196000578864986371681613388236), SC_(108.87449396132728777449159443693478629283840436512) }}, 
      {{ SC_(118), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(109.24612118209186814047626238211895432913494446203), SC_(103.57628498200538145138215961411046650472947351606) }}, 
      {{ SC_(118), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(109.47447953712416375306922539803808753432248563691), SC_(103.30776461223548096513176825856144634968549320143) }}, 
      {{ SC_(118), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(110.44197868931555836014307009564906587344466170321), SC_(102.12663009610856071860265691497815161571096908951) }}, 
      {{ SC_(118), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(110.57117257773396737429866496207213267843743538218), SC_(101.96326270849367583745362768440114193797899237003) }}, 
      {{ SC_(118), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(111.91996445899388029255441375864341567734381212661), SC_(100.16796655171222793394095819705115976401659742693) }}, 
      {{ SC_(118), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(103.76361481107101912465786205561847419200840619299), SC_(110.71070637081783873621309107090531887636287074222) }}, 
      {{ SC_(118), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(103.89698131447571311636996483906208450772478165244), SC_(110.60226058639410474056509416899278614589467719402) }}, 
      {{ SC_(118), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(104.99237683579703410209745850416038339740773021813), SC_(109.67964755544061844611624682788566829503053165786) }}, 
      {{ SC_(118), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(110.03570601158909794455598052088322962373930911656), SC_(104.57770148115575685270386967116524105122899806124) }}, 
      {{ SC_(118), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(110.25434410208696010831280455112255944011819415401), SC_(104.31812601153604625465767153633418289853659535545) }}, 
      {{ SC_(118), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(111.1792369010053383922590890341987846380442189101), SC_(103.17543393614332262433481443861492100031429779215) }}, 
      {{ SC_(118), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(111.30255186638157567490432690321752458872548468631), SC_(103.01727306845828104879011315638072306547541818495) }}, 
      {{ SC_(118), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(112.58679829137816265038713437272686581616892401284), SC_(101.27756516651305774583863629117905356591364328281) }}, 
      {{ SC_(118), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(111.65153306079136030472464361383372064044999486834), SC_(115.91056332571942716785269851004123774319607026549) }}, 
      {{ SC_(118), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(111.73948914503923842143528709198838532647260731306), SC_(115.85127133526785874463436195198998548291911131404) }}, 
      {{ SC_(118), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(112.45493124343788925928275194367636669204419208247), SC_(115.33396912205325572344372937446839188763779296631) }}, 
      {{ SC_(118), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(115.53619664900614513226627323943613692533239055446), SC_(112.18559858389987209196120172516843378557017168327) }}, 
      {{ SC_(118), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(115.65880568752398040093231572702132539092403823872), SC_(112.01605525387694196326991028449752882969348966202) }}, 
      {{ SC_(118), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(116.16259710230660219192291858263010407108967382139), SC_(111.26155856881104039153434436032797437014621967278) }}, 
      {{ SC_(118), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(116.22774427454560352129688250375626876727996096302), SC_(111.15613708951556156153910218993127409333210950939) }}, 
      {{ SC_(118), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(116.87072316105687490671015767594797396298978146706), SC_(109.98208942093409763814941812150282789971778776213) }}, 
      {{ SC_(126), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(11.282576314514349103677126147919154466117952175614), SC_(19.792686213986515693786581259393884486607316406882) }}, 
      {{ SC_(126), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(11.419680812441834156668679887817997007868316065536), SC_(19.633173412522187082865638075490664648753938635243) }}, 
      {{ SC_(126), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(12.578869048847407323677948837636965502126203219348), SC_(18.318525247029505770328824186448433529256441217135) }}, 
      {{ SC_(126), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(18.817170920232743182670258117612298902761819161798), SC_(12.132982309151151670306478098616638215169428375153) }}, 
      {{ SC_(126), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(19.128700024080038265001276324914078301555329253541), SC_(11.858288085629509255540035838405656900789724415391) }}, 
      {{ SC_(126), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(20.494839514971836083902461052350331090539258289101), SC_(10.687960501768540234723303881874187633743038548371) }}, 
      {{ SC_(126), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(20.683284668007751745196836496439100455921836594109), SC_(10.530817792791598546835518328233099618800810529165) }}, 
      {{ SC_(126), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(22.746662193828527941660552936662158462346081873275), SC_(8.8758987344722695298715416048005252992874590060943) }}, 
      {{ SC_(126), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(12.232238469081499955790374060700653944359601134655), SC_(20.980877037854394085065393040378733001462910557322) }}, 
      {{ SC_(126), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(12.373780386452849237823605680971287565262568091813), SC_(20.817445306260873917814533714819967966287725451764) }}, 
      {{ SC_(126), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(13.569527377923134706918282761927211506472326474751), SC_(19.46982549296054554732364934998508682331487266992) }}, 
      {{ SC_(126), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(19.981121472390240749262775387335041635046789621686), SC_(13.109774900654669333520423880089194255019602559786) }}, 
      {{ SC_(126), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(20.30046350832794554724505190946476343660422737746), SC_(12.826417988850775960305454535789716124465876495081) }}, 
      {{ SC_(126), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(21.700079647756784419354467632935738096089107104022), SC_(11.618079982983610900768583958322363279525777864638) }}, 
      {{ SC_(126), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(21.893045795347720910361514476588633725817845138827), SC_(11.455688887033655065512459812648808787749068095054) }}, 
      {{ SC_(126), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(24.004489144985436133467624179125947746100484683357), SC_(9.7431431818018571975491185700580332728587613132146) }}, 
      {{ SC_(126), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(22.069393901322386328476935543432477872311354297695), SC_(32.687073275916743253960594439426726570782118042714) }}, 
      {{ SC_(126), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(22.246244599021445956386599961913553114434743352505), SC_(32.493507606912343497118947481969047579011490056875) }}, 
      {{ SC_(126), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(23.73225391065656341477241324855948721498498921739), SC_(30.891486328216096829691724509066577244156601035624) }}, 
      {{ SC_(126), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(31.50057032894149954451996483428980298420323571362), SC_(23.162551018640173468341426180948624821359363546933) }}, 
      {{ SC_(126), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(31.880195278477987430070835135502677444437476315292), SC_(22.810414987437459631004500878064082431544593813483) }}, 
      {{ SC_(126), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(33.537108025722101457988519109605297246169464991662), SC_(21.299548611439443146608866042394898569047753716988) }}, 
      {{ SC_(126), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(33.764693468867402084464052672758683276841975902104), SC_(21.095296970941503519056843208910117289912566610319) }}, 
      {{ SC_(126), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(36.242197344446458740905510710265450122095646392107), SC_(18.921927095193265845345086659391837358175160558313) }}, 
      {{ SC_(126), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(97.154323984373696265154412101133906923833884615106), SC_(107.09301921153370105254661555056023564614888081212) }}, 
      {{ SC_(126), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(97.33708328075317954483589824805895909272332607675), SC_(106.92913001609833456882728226334834344204249828167) }}, 
      {{ SC_(126), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(98.847657415538995652069655801907106088036540103353), SC_(105.54951150896702490101080354617765636912538960541) }}, 
      {{ SC_(126), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(106.07894879795899129021673435810095307433112472289), SC_(98.273769057451193332306390300510408405147452042085) }}, 
      {{ SC_(126), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(106.40587486887334402968038264694092212199027815955), SC_(97.915813434710968321342089969311434063952075855082) }}, 
      {{ SC_(126), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(107.80566586411666804509597065861258346783823108798), SC_(96.351141436638236687929585990609985720861490752272) }}, 
      {{ SC_(126), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(107.99452534686144868774204067514569396617554823605), SC_(96.135935230182048384187120156367855131362815817807) }}, 
      {{ SC_(126), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(109.998127751333590824154261691293251131849652443), SC_(93.788831813285187838868776010989958091903496368812) }}, 
      {{ SC_(126), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(99.931169227341946702520282339489708751858167037339), SC_(109.42392912260114452872595635211672199989158984468) }}, 
      {{ SC_(126), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(100.10673508508494155297684672864242369546589799879), SC_(109.26845996119357596099969446062881417947167336009) }}, 
      {{ SC_(126), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(101.55658487777646067136139327017990838490094446923), SC_(107.9580663386451183616584520308989074194673531331) }}, 
      {{ SC_(126), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(108.46128013109920726217545535154511975630332742707), SC_(101.00603693102101868316615501602274109543649218665) }}, 
      {{ SC_(126), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(108.77180300493578439743201199661075128700131340323), SC_(100.66247053668645026611294374800739585657110662279) }}, 
      {{ SC_(126), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(110.09945145606157494170304372549291724732597914146), SC_(99.159219910983229333797992960016039475572783756255) }}, 
      {{ SC_(126), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(110.27832966763881936919431115915692440650127714509), SC_(98.952278715925681604840625946585433955873243971751) }}, 
      {{ SC_(126), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(112.17207027320375668496677898573600672739274037584), SC_(96.692580195315388623264031756780549837614127981026) }}, 
      {{ SC_(126), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(109.8596886924119212603971363664420391521833579918), SC_(117.31889614879852038418961991952710034870300330525) }}, 
      {{ SC_(126), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(110.00179513403159423295604639084085845161419864806), SC_(117.20121905199894747326643795635195862722905260824) }}, 
      {{ SC_(126), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(111.17021615726072424416709670371323617125244947302), SC_(116.20221621491884089791674974157198832178668867318) }}, 
      {{ SC_(126), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(116.58732046474589977721124123395016628312950843912), SC_(110.72762812036017210042136750562575831549850721472) }}, 
      {{ SC_(126), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(116.82405875072542078464502491075466195314143849196), SC_(110.45074879378766299384163341024104354109157843107) }}, 
      {{ SC_(126), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(117.82798671337136673566852387198285546329587220182), SC_(109.23332910187369887583627727870458413973433985956) }}, 
      {{ SC_(126), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(117.96216940504418422659305482435396225373017446561), SC_(109.06500100884928839752441087801106430683302134663) }}, 
      {{ SC_(126), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(119.36515855294228625329158503898947282999580912119), SC_(107.21601192674668705731437757934902155865947473937) }}, 
      {{ SC_(126), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(110.95401317596261808263574905798021341180582420505), SC_(118.13426448851367332444286670524786121062666384247) }}, 
      {{ SC_(126), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(111.09146512778697548390067975266778167084028079518), SC_(118.02171615832703461429648640355241481879153890266) }}, 
      {{ SC_(126), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(112.22083888233413132518590553231688750899132179388), SC_(117.06502760362601474622601489053655359798128499597) }}, 
      {{ SC_(126), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(117.43406970147550859668027897255547575371674770271), SC_(111.79320877634766771879149579559035959967979740767) }}, 
      {{ SC_(126), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(117.6607817549785791085401692223912722817863512441), SC_(111.52558201187455966659002997163101004480604795891) }}, 
      {{ SC_(126), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(118.62078290546241610357739644418798837938629372588), SC_(110.34793754956977423300949994479301195651592073966) }}, 
      {{ SC_(126), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(118.74890735512541530140491776176471133379840587094), SC_(110.1849978115774059117046635772758133297651493946) }}, 
      {{ SC_(126), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(120.08543780834901958650753984883961829897824255622), SC_(108.3935586086277906742475464547905609163984682111) }}, 
      {{ SC_(126), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(119.32996767423927810254632032210432875148831487115), SC_(123.73363652444767179828936999195759463333486167797) }}, 
      {{ SC_(126), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(119.42046305445129755014720157643333632756225021377), SC_(123.67177135581530255522101080556469573327931151991) }}, 
      {{ SC_(126), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(120.15699588553256673359642070352360809466728644663), SC_(123.13320153426021900670120466141123950224526428985) }}, 
      {{ SC_(126), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(123.34351346463359047700086477108916124576489719325), SC_(119.87962774043454997690173775134994014275739910067) }}, 
      {{ SC_(126), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(123.47116078057844177139606626940039347240976503115), SC_(119.70508695946898822175765857231074130399626997453) }}, 
      {{ SC_(126), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(123.99699585256225784950683574309476593078726737969), SC_(118.92886140656770446731835240466413429015556057235) }}, 
      {{ SC_(126), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(124.06518489225471329964063319278234002616137641504), SC_(118.82046448170754762933210389098080206569412137714) }}, 
      {{ SC_(126), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(124.74177600985142969515653753524211323430250474787), SC_(117.61413137674664647430428869322814194914254850327) }}, 
      {{ SC_(134), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(12.164973793479179055838591076757301598446237179049), SC_(20.942103743437730006224316187647871075790002199686) }}, 
      {{ SC_(134), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(12.306765407217627789092947349271005159213199176447), SC_(20.777914064596120148747915355600001193009427892992) }}, 
      {{ SC_(134), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(13.50492277074412647982037799845184139922045258231), SC_(19.424355930760879916599378543825950177092348045224) }}, 
      {{ SC_(134), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(19.937839204252561131072238257348163265847413097561), SC_(13.044180663342977448639702370856465139889346258921) }}, 
      {{ SC_(134), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(20.258588256951454780129873074456155071690054567523), SC_(12.760252684939217283508240344352930072297585044559) }}, 
      {{ SC_(134), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(21.664737913463933292206929775917790595349907612192), SC_(11.549821877864571628127206783261101748629833723475) }}, 
      {{ SC_(134), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(21.858651298510372290360371520193358669543384711849), SC_(11.387192944205093453654678628915644658961741548596) }}, 
      {{ SC_(134), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(23.981184568737368619437080977280700612221952488777), SC_(9.6728015890602524782674199585996387427420420479061) }}, 
      {{ SC_(134), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(13.178858481859951488915907865820239149870591801921), SC_(22.201912509296400983747438576161533135535857773455) }}, 
      {{ SC_(134), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(13.325216140733304316719571043150832234157758880944), SC_(22.033674570605443518026151843187672293451052755595) }}, 
      {{ SC_(134), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(14.561005661202695855695530654551488370630968624221), SC_(20.646067410792168164361331294777082378780692225829) }}, 
      {{ SC_(134), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(21.172612105170135100637077372995842886930104631039), SC_(14.085987875599015550688989868298865689606035208424) }}, 
      {{ SC_(134), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(21.501429387445227133161093131306204142828039600692), SC_(13.793142837148418780435666836090845001119429391587) }}, 
      {{ SC_(134), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(22.942161865778646740007785126241805465240215739942), SC_(12.543601867939642901052203892742089303132292080874) }}, 
      {{ SC_(134), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(23.140747191812499679029649437166549967717287060248), SC_(12.375574872437885521117651832873486345113624083352) }}, 
      {{ SC_(134), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(25.31297511671939868624703913000220666140685395202), SC_(10.601951243900023506133865158724124005265682572253) }}, 
      {{ SC_(134), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(23.671460557071470136411510801851150686353157815111), SC_(34.621561896755696764091388426507677903650637782346) }}, 
      {{ SC_(134), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(23.854137117305881938904950115881024499072786614015), SC_(34.422175557424840322376377621526235653181495247339) }}, 
      {{ SC_(134), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(25.388614192816636239743116710894975764590105822812), SC_(32.771716845500194041733317767837402412259148316247) }}, 
      {{ SC_(134), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(33.399273838766922738633252613646971016957581077497), SC_(24.80042912619042845314064094012879859748216042177) }}, 
      {{ SC_(134), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(33.790376379299730351383564777068721506432027450583), SC_(24.436808417649488898004140645685421342210459638286) }}, 
      {{ SC_(134), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(35.497082433247449945694307625435519018104899843602), SC_(22.876101664641943736689916586543086332959586486582) }}, 
      {{ SC_(134), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(35.731471241498740358190365799076468967496080481851), SC_(22.665037656869067067291360162942566219521191018217) }}, 
      {{ SC_(134), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(38.282540451562628725288414424091173491771301836487), SC_(20.41794699216846987575950781773694454403444863894) }}, 
      {{ SC_(134), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(103.51643687806312053300603438234993262919863049639), SC_(113.76647094466222369290379918057565494655358447561) }}, 
      {{ SC_(134), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(103.70464811045967852123508404668450557228279159632), SC_(113.59712323297982176183217896745365904874052790075) }}, 
      {{ SC_(134), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(105.26058843585345237853011085968676594550748227771), SC_(112.17210020157806590218002044321176995024607769718) }}, 
      {{ SC_(134), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(112.71885021286830058979080945915053471833055578593), SC_(104.66939893728892398296806830559414248706811113392) }}, 
      {{ SC_(134), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(113.05653506306349381326663688526441684189767171776), SC_(104.30069348888752321743428971443084105001681594686) }}, 
      {{ SC_(134), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(114.5030251489528990894257580889470196237232631515), SC_(102.68938209229292626513463441034135993330316793505) }}, 
      {{ SC_(134), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(114.69826898687911147613486903141407014873767100302), SC_(102.46780297816678414529270054433203534594739138392) }}, 
      {{ SC_(134), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(116.77098895783546051134123705852799808277957961592), SC_(100.05178060261864140338932850882087173565907021177) }}, 
      {{ SC_(134), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(106.46248008473228756043679937024191884139744342702), SC_(116.25273821956778736366837686930927198973349457211) }}, 
      {{ SC_(134), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(106.64325582453186914057809228762395321149495234283), SC_(116.09205158245960321311558706949693495264494585162) }}, 
      {{ SC_(134), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(108.13645559936848440030409516658339549027317340719), SC_(114.7382638351776232086332233225454083655623902437) }}, 
      {{ SC_(134), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(115.25802276638601150332776916988123675009993502773), SC_(107.56937582997085787106137296359572423659091801208) }}, 
      {{ SC_(134), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(115.57882801037387183187707007864632615096613181232), SC_(107.21553737361888421316737561198829200345926715344) }}, 
      {{ SC_(134), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(116.95111442886327284069264070316430397981377280895), SC_(105.66771770076939782951272732123358576604223023792) }}, 
      {{ SC_(134), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(117.13609624213453341206011426080705668671787372844), SC_(105.45468614967999360842741982478647538797186753159) }}, 
      {{ SC_(134), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(119.09593690150308349161415891280758621781651595869), SC_(103.12911822278080876770633125928983087812629206318) }}, 
      {{ SC_(134), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(116.98877124943269649500704069322397388246221261435), SC_(124.68244241169938565689006019077068839790183212799) }}, 
      {{ SC_(134), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(117.1349852375836192689356964644714035664082730024), SC_(124.56064379919947925342031700879737950874591996734) }}, 
      {{ SC_(134), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(118.33757307076942355580039952793973481198311794848), SC_(123.52739419387184082523541152400758865382439529485) }}, 
      {{ SC_(134), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(123.9255498857492744756672359342270987565691603662), SC_(117.88195743966152071432893658085665625507479621556) }}, 
      {{ SC_(134), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(124.1704028137552979665789870356007477821411951818), SC_(117.59698211258788054403431023425851371010134540885) }}, 
      {{ SC_(134), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(125.20959868801516376092982957287237522824843028325), SC_(116.34442176030631494253059206636460548742221912158) }}, 
      {{ SC_(134), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(125.34861001869974986697317961543404317750164587136), SC_(116.17128986289294967877620647793897532302807804299) }}, 
      {{ SC_(134), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(126.80403009501984340283114198668443370391032243787), SC_(114.27031383229093680053634801297401341127846331405) }}, 
      {{ SC_(134), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(118.14808078648710633999023280040133689903874847088), SC_(125.5541620296957555647865676312078478137616519852) }}, 
      {{ SC_(134), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(118.28948930488464196771593540401522077005686546952), SC_(125.43764196328861561700174822237859536520114870599) }}, 
      {{ SC_(134), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(119.45177192488764490099937017194749575462799821165), SC_(124.44795799571301415952065069242583222387922272413) }}, 
      {{ SC_(134), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(124.82957337891704348158898362026531141240538937072), SC_(119.01159428411239698568182960197205421247172338741) }}, 
      {{ SC_(134), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(125.06410351835422765556120215967623882348916175929), SC_(118.73616960442182199437256023711726521364350775132) }}, 
      {{ SC_(134), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(126.05809230270001837643353632368389867741028810364), SC_(117.52467580221916362549441319753874471771057760513) }}, 
      {{ SC_(134), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(126.19087145390693346727059500803176342103152956183), SC_(117.35710843884018855772999695555813223818525177658) }}, 
      {{ SC_(134), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(127.57797497037001166895897816061520095964573740393), SC_(115.51558289033520680083317010292724665924207426321) }}, 
      {{ SC_(134), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(127.01071178257072634947245148293064635859502935035), SC_(131.55446414066887224550652711288484651595616080401) }}, 
      {{ SC_(134), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(127.10366571036574603591153740233558230541692508227), SC_(131.49010892684449462236541745470395613282046136687) }}, 
      {{ SC_(134), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(127.86062156511444338094827427503359000966961199519), SC_(130.93095008947311222672088836102200824329120179699) }}, 
      {{ SC_(134), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(131.14909001692501036831198211963395002056480332785), SC_(127.57547172865108381096640752124576970679290478098) }}, 
      {{ SC_(134), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(131.28161493190187081195636599904069640190922498682), SC_(127.39609170171313630690463721296956091996937312637) }}, 
      {{ SC_(134), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(131.82877960084093564100603572279190766812865818756), SC_(126.59882869869713603581904268864670534578961118623) }}, 
      {{ SC_(134), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(131.89991018137578984494109489185270830573155414953), SC_(126.4875514827833493769465357150649957500399321071) }}, 
      {{ SC_(134), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(132.60896374121318090743343829459226612264081427425), SC_(125.24997337963903660789206665220185538496106337751) }}, 
      {{ SC_(142), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(13.051311557942732330100992894414079516115140246443), SC_(22.087577469526451109510918414920898740083265098605) }}, 
      {{ SC_(142), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(13.19765065108550155588579574934561682783279090778), SC_(21.918849429942628028390444536789279409363793687465) }}, 
      {{ SC_(142), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(14.433620481489611762311246505581780093141132930276), SC_(20.527531598353096307610225185043541433033617879493) }}, 
      {{ SC_(142), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(21.055414255807215608171599765741975617262078390726), SC_(13.958463124006131095158101367806055401156282782225) }}, 
      {{ SC_(142), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(21.385110704583394323307726689081546392462374964229), SC_(13.665575432701713202572764889119755525251576250857) }}, 
      {{ SC_(142), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(22.830085170722179660564927484074763525194829482865), SC_(12.416236966064568715580776019387958350485272932902) }}, 
      {{ SC_(142), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(23.029304414696760054329901292750945609954289167621), SC_(12.248286178766206629905277192945503372783229963226) }}, 
      {{ SC_(142), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(25.209230117936614074173897090141905670769153830255), SC_(10.476221718481629350464317199382694439665784414003) }}, 
      {{ SC_(142), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(14.129527095720859029705475912537865984198255348789), SC_(23.418896233014534313195864097862733966165858344731) }}, 
      {{ SC_(142), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(14.280557145087258830518366351226867087004546441819), SC_(23.245994392898230116951993332355571229502138891508) }}, 
      {{ SC_(142), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(15.555201375110275521064980460861869915471737098506), SC_(21.819581726000994004961225177137395119233681954087) }}, 
      {{ SC_(142), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(22.360924871573638540784777395319385804932727868424), SC_(15.065370327686753991293633864933642730879268136534) }}, 
      {{ SC_(142), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(22.698937366862419508306371766408354652222963011165), SC_(14.763318590023063467942746964355523316768735042506) }}, 
      {{ SC_(142), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(24.179568419819397037150775845084221744665709553222), SC_(13.473801945169107054408304962879313952309600894719) }}, 
      {{ SC_(142), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(24.383606128926857063460886022132347888875440578528), SC_(13.300307704913772715883232859048352099027594199944) }}, 
      {{ SC_(142), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(26.614807582122391740428923677579586880422250318544), SC_(11.467450452285168793190997629438427766905275914377) }}, 
      {{ SC_(142), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(25.2784252262898104289554838033379519728955415253), SC_(36.551151163183073355291998216394551136478462361247) }}, 
      {{ SC_(142), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(25.466755030144293186977538445749252741701415789731), SC_(36.34611619636798190812364738622402462628026398619) }}, 
      {{ SC_(142), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(27.048266997966301787442104958957686759673094716433), SC_(34.648649581011075081154131741111737527725699653697) }}, 
      {{ SC_(142), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(35.294134792381194394311843035725743300216672655181), SC_(26.442145537700519403723880742530746188547480275515) }}, 
      {{ SC_(142), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(35.696376198084717339577669122799626249707828359283), SC_(26.067379657847349923814705284129734246254490321989) }}, 
      {{ SC_(142), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(37.451403437054149762125155603122341947931536384532), SC_(24.458309880478471885326825846061774640388186038211) }}, 
      {{ SC_(142), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(37.692394095701388164369318419081106130685073041892), SC_(24.240636027512329967986667724085386175137935805717) }}, 
      {{ SC_(142), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(40.31484263856055765083913484670862592125345189095), SC_(21.922028173945326689371665427267923568730344447273) }}, 
      {{ SC_(142), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(109.88314089048533942609869123161959621882652055866), SC_(120.43533339399250626974577090916531603672750878716) }}, 
      {{ SC_(142), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(110.07664282844477638953144450836489873959266906719), SC_(120.26068912424855662695184662243473300055358000493) }}, 
      {{ SC_(142), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(111.6766098606362707307093626626479479792835521567), SC_(118.79160525664365852841733714608172056611548251676) }}, 
      {{ SC_(142), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(119.35515630916678070615119767343868051138081520648), SC_(111.0686296401439251298237098127032006034544677326) }}, 
      {{ SC_(142), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(119.70328156884278954456073747669464223102882786169), SC_(110.6894917547346761339168204217664958473967024385) }}, 
      {{ SC_(142), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(121.19508449534440278299951987965562105030098217151), SC_(109.03292059516642021127603853224448838436744244914) }}, 
      {{ SC_(142), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(121.39652252121291376815199122104595958575423229571), SC_(108.80515746160491659948371023780830763486987005541) }}, 
      {{ SC_(142), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(123.53628795955367035840093650095590477414737183676), SC_(106.32226572796995008340525646479337344627330074214) }}, 
      {{ SC_(142), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(112.99817980412189530634144638383078803769824573598), SC_(123.07716069730196913392899216638112685357722276795) }}, 
      {{ SC_(142), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(113.18401129090979188808239118146006910821433285422), SC_(122.91141155711348821988574246847208367393289724669) }}, 
      {{ SC_(142), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(114.71928066335988360032140338068560241546758442313), SC_(121.5155148927729899473648938852527363009965476277) }}, 
      {{ SC_(142), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(122.05132964953459707674631073071448056708467729652), SC_(114.13615693958655977941491191602259652896374878039) }}, 
      {{ SC_(142), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(122.3821127539419767945131428711915763318355694487), SC_(113.77234980575271430360763247977709131671936760473) }}, 
      {{ SC_(142), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(123.79771057631245145947545320829985091156881798644), SC_(112.18128003076504184818949505118552753548763083484) }}, 
      {{ SC_(142), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(123.98861390939744069280170597338045520961474774053), SC_(111.9623387276786037978944163967586920275336008951) }}, 
      {{ SC_(142), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(126.01256835065359401530512358801575385779863480223), SC_(109.5728615289155123752059741420219590267337464438) }}, 
      {{ SC_(142), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(124.12132287597211607838221673144251443563062946529), SC_(132.04252553849817820089941864059890647999057825812) }}, 
      {{ SC_(142), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(124.27152256970497544520107584135026407222202125627), SC_(131.91672875484289561450654860229459692344439358384) }}, 
      {{ SC_(142), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(125.50726590538281001804172473515306619560100322924), SC_(130.85025214496150197335604602066233460647695160476) }}, 
      {{ SC_(142), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(131.26107161117820071470287943972554089684163502213), SC_(125.03900785897227099699319632068383181224735648831) }}, 
      {{ SC_(142), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(131.51379758937221174610796262187321983424240558374), SC_(124.74617615546517292849171432173311454310269759817) }}, 
      {{ SC_(142), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(132.58720489197725599190598408848032574786852668875), SC_(123.45951787243960117716357691526013161957120205939) }}, 
      {{ SC_(142), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(132.73089921669508933496622740223884178496726992195), SC_(123.28172508560526594832095978535183324760793216569) }}, 
      {{ SC_(142), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(134.2371466804899999693432412616887946338301816292), SC_(121.33031544090402321140235096703233591170008719561) }}, 
      {{ SC_(142), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(125.34549172543396937919889009709493204819026445694), SC_(132.9707231384538013892085128108247697724730987633) }}, 
      {{ SC_(142), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(125.49073939070800138960077421556273466196694235629), SC_(132.85035037793922912449343043127669697912751418209) }}, 
      {{ SC_(142), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(126.68495642095345751662844821136499275462676603373), SC_(131.82865453081584743954955158952311284950352469038) }}, 
      {{ SC_(142), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(132.22246942613369722791205622500310423325232266205), SC_(126.23260235721122588559124901273288711227431045051) }}, 
      {{ SC_(142), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(132.4645846486369924258969790353743781498358285075), SC_(125.94961065386364567722375498909202357981726407554) }}, 
      {{ SC_(142), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(133.49154129259556196756834507438186770755490909533), SC_(124.70527242770003862101699316244620227855364236017) }}, 
      {{ SC_(142), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(133.62883442439568322557629873094770535724764044766), SC_(124.53321519631309817681409990285223812816725642785) }}, 
      {{ SC_(142), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(135.06495836153030420697478274944593959639437147597), SC_(122.64310099717586895152396342354109672529262744365) }}, 
      {{ SC_(142), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(134.69355815210337705361630811791401138996869884729), SC_(139.37323946311086748997900731702510451576301232358) }}, 
      {{ SC_(142), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(134.78889709124908781215101061366593574686299021999), SC_(139.30647002850775496387223481099351162147613019178) }}, 
      {{ SC_(142), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(135.56566767205304074706886822151501010760371884752), SC_(138.72734129787412779087236225796632496186205776078) }}, 
      {{ SC_(142), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(138.95307525149357629795143675208160795205964708643), SC_(135.27296740330045743234805238506688740185492797429) }}, 
      {{ SC_(142), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(139.09033116664477808472507757518679991184179341544), SC_(135.08889225891946980446386346154406356842069364429) }}, 
      {{ SC_(142), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(139.65817417581237918738475977933085466095100846903), SC_(134.27122143670113381576055287484629175224834223619) }}, 
      {{ SC_(142), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(139.73215482209550223096717917082886029977273834826), SC_(134.15715054653188339529316848231416300308777063842) }}, 
      {{ SC_(142), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(140.47262155736106117958742912808823973048581745725), SC_(132.8892739823397270295416842380254090111853956217) }}, 
      {{ SC_(150), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(13.941260212382988427562319433276446825247465465584), SC_(23.229437443696521126911088190939308502892330771878) }}, 
      {{ SC_(150), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(14.092018936571034281876823116039967094870287418383), SC_(23.056297945526348513913702353963967125063014164092) }}, 
      {{ SC_(150), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(15.364741844342962807083964346852363154789902217487), SC_(21.628274394214026597931700307335106757408801244277) }}, 
      {{ SC_(150), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(22.170154872947448640808698620101499020265225694639), SC_(14.875572412414013601850526353014668334599934130334) }}, 
      {{ SC_(150), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(22.508548980471349565056225746322929102384765579019), SC_(14.573976007070542700270424614728102213277710059357) }}, 
      {{ SC_(150), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(23.991262317318698105098006000983762330055604711618), SC_(13.286824440605141291731804911141338839735599686408) }}, 
      {{ SC_(150), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(24.195638692349604187332533186971120004213206240471), SC_(13.11370221117862598563103415183685162882754065639) }}, 
      {{ SC_(150), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(26.431342183979266542925017949821371744031355456057), SC_(11.285609412716587944740513533466493775260817735342) }}, 
      {{ SC_(150), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(15.083905902039569687241298607781916380238725415024), SC_(24.632167201087605807851987450002363861184971855249) }}, 
      {{ SC_(150), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(15.239477083104520601934575135156367129963601601243), SC_(24.454731835495431325731597061104734282603253622983) }}, 
      {{ SC_(150), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(16.551888041026700644667470046050508212563398769837), SC_(22.990596582055164831585962645935866605412001641516) }}, 
      {{ SC_(150), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(23.546325570983470951761625552522658745226019203307), SC_(16.047657850806700731122210781055657310919730475304) }}, 
      {{ SC_(150), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(23.89327668373196984275431382153286623248731403494), SC_(15.736657189635296666724103321175038969247265574025) }}, 
      {{ SC_(150), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(25.412690660562331802824258581910414570560096089671), SC_(14.408288558930987269959611369521657398202134770523) }}, 
      {{ SC_(150), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(25.622027970627328522494619377070946052748253489625), SC_(14.22948142240874135636954476449398748345302372235) }}, 
      {{ SC_(150), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(27.910544548114196146948552535907145087367177278829), SC_(12.339076863232828126008054317306490480283019706454) }}, 
      {{ SC_(150), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(26.889878893743561196782046466242249539196003790068), SC_(38.476250329722642815021251526266013365479394486742) }}, 
      {{ SC_(150), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(27.083703817396490368981472108964719755433421913135), SC_(38.265724373917406351361722861543781529103125875767) }}, 
      {{ SC_(150), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(28.710937854893079501133967225177271670516038666034), SC_(36.522559858852308147151612493575983261430322922879) }}, 
      {{ SC_(150), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(37.185474032110076285173004450994346898024699751145), SC_(28.087380107035552881803645779646899295623355926027) }}, 
      {{ SC_(150), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(37.598543897908252031433365951914829495153038909875), SC_(27.701780119161602084319459568111582009812458001626) }}, 
      {{ SC_(150), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(39.40054348194375912423140528831412410251959059751), SC_(26.045700563041058798039405616383108675433841931414) }}, 
      {{ SC_(150), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(39.647951380235735409231441563524693180322577142242), SC_(25.82160232300497420435150447582754254744846835872) }}, 
      {{ SC_(150), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(42.339777151249013811498664957545610820200325869451), SC_(23.433494157277334710420843672778756186210502811448) }}, 
      {{ SC_(150), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(116.25405232877980283477824218063982146188867548012), SC_(127.09998992069567931352016938677596055903106792813) }}, 
      {{ SC_(150), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(116.45269724625782203203429656662502673376159923492), SC_(126.92019743243202393891262234254421480286563580359) }}, 
      {{ SC_(150), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(118.09546353524966560275286270509416430307016854153), SC_(125.40828372827369525204371610123572752002302261582) }}, 
      {{ SC_(150), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(125.98816699642069378674242082829807592774145574957), SC_(117.47116035131636964651843200815972208014148759064) }}, 
      {{ SC_(150), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(126.3464409938376470254461450316412243694304750439), SC_(117.0818808721273965884642083698074387093668162162) }}, 
      {{ SC_(150), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(127.88228713446369555119954696480552311826019250306), SC_(115.38131400186140629905296808378199312583628500856) }}, 
      {{ SC_(150), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(128.08974523615398988666248411873815363417398568375), SC_(115.14753988473909803820824694682042458692632232978) }}, 
      {{ SC_(150), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(130.29466017890473967979788319721655525932981929512), SC_(112.59965587177014763294123753129577592680658191952) }}, 
      {{ SC_(150), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(119.53790145957088920034512811549294190881082769855), SC_(129.89756307262890251520754064985194427505747933592) }}, 
      {{ SC_(150), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(119.72864747224908992476479192232055644509667952585), SC_(129.72689335692993453776168692264100791617680641056) }}, 
      {{ SC_(150), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(121.30481317482152331903557014881367476181786413188), SC_(128.29006511825764901075685808976927485457572316114) }}, 
      {{ SC_(150), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(128.84148739406649198491898815957482970790253748508), SC_(120.70609258077200971053500689879657724095743809299) }}, 
      {{ SC_(150), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(129.18196940384201358121315930958455784175311610786), SC_(120.33259477362205886719246329349858863108941434939) }}, 
      {{ SC_(150), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(130.63966379410665781923068741883789831019595823826), SC_(118.69948330891348402022585811745257796437857045686) }}, 
      {{ SC_(150), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(130.83632196164729206495493413738298434915996192371), SC_(118.47479769522403274005105678498509782328998216876) }}, 
      {{ SC_(150), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(132.92257317648028519740161039350246493356568996629), SC_(116.02320629435435915684592951800126166747666808962) }}, 
      {{ SC_(150), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(131.25705281427876576849082221768151419698464686467), SC_(139.39943515109906479702007329500737484767036884441) }}, 
      {{ SC_(150), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(131.41112659967210579031037661150230119832100132296), SC_(139.26975308516013283384787826579597296242794430336) }}, 
      {{ SC_(150), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(132.67909886021512032469493148874826606103615336571), SC_(138.17098324155347320884747070026242995636204862534) }}, 
      {{ SC_(150), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(138.59411142122310148786620250765951859757566962916), SC_(132.19855133716757499404651192815290935520237015746) }}, 
      {{ SC_(150), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(138.8544892266869995925513601100276729229022806447), SC_(131.89808280570207291764963182452995060482116317836) }}, 
      {{ SC_(150), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(139.96114112445202225923202191604987183398865382435), SC_(130.57828177168034202249023935519667789184174083847) }}, 
      {{ SC_(150), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(140.10938524808575231085452284668561537735034878315), SC_(130.39595898443911590454543775824728349902520402564) }}, 
      {{ SC_(150), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(141.66499575182095959427922368583031361579470604795), SC_(128.39553787986754551569729305193107469384663398951) }}, 
      {{ SC_(150), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(132.54596563410654925626290854776184296006604013973), SC_(140.38422684344707569753185015820019564990099029679) }}, 
      {{ SC_(150), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(132.69494488567408121679586898664259167740148373106), SC_(140.26011032706232017913974568879322424673693952087) }}, 
      {{ SC_(150), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(133.92020353348486551716840167404814537803039986312), SC_(139.20730312880017474344642492997728161954746214936) }}, 
      {{ SC_(150), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(139.61297521961324037120076294767652120627917602396), SC_(133.45601308938283398150684975087572272148430818497) }}, 
      {{ SC_(150), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(139.86246218260223453682278430553085866859260471362), SC_(133.16566590515785773584211794088148462167848380997) }}, 
      {{ SC_(150), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(140.92145356706156038889594021652400774995959349363), SC_(131.88940376781887187922981010550651535280676567379) }}, 
      {{ SC_(150), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(141.06313201278141278943348113689142816941329657276), SC_(131.71298282905685190152291021999403444039326214833) }}, 
      {{ SC_(150), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(142.54685901759121485441661609599204373636276928668), SC_(129.77565112706231531890304028330436322960682183018) }}, 
      {{ SC_(150), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(142.37832876812224264424802779992995642243792240753), SC_(147.19013017304003622559708887321459787496476175261) }}, 
      {{ SC_(150), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(142.47598538353214997827771104797614412715883744352), SC_(147.1210159976750839539440758823140903245358155233) }}, 
      {{ SC_(150), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(143.27201350466220984238793866688686011810287571453), SC_(146.5224849637359251853865345897086259008705517263) }}, 
      {{ SC_(150), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(146.75559839791572035114597389089392772486482280383), SC_(142.97197466951559747666964829069534442912421386375) }}, 
      {{ SC_(150), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(146.89745091365054020707042082509540394427880270923), SC_(142.78333642619553576189898211626370726573588592912) }}, 
      {{ SC_(150), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(147.48537555408611955069698836532872253600429401351), SC_(141.94583429402499269535267626644285154488346507301) }}, 
      {{ SC_(150), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(147.56212250564996154384697247922161265018349498648), SC_(141.82904901026404666828270081671114220500055353926) }}, 
      {{ SC_(150), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(148.33304207784629990988446925937037947255540662181), SC_(140.53173990115956638215866295702074713605680994262) }}, 
      {{ SC_(158), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(14.834533823431491865711115241925781613990976203301), SC_(24.367970103960765056319007713155923123713170364061) }}, 
      {{ SC_(158), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(14.98959454747595162118309766448177587365409613686), SC_(24.190535971768004367780561656179425653767588613535) }}, 
      {{ SC_(158), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(16.298095501364366471615766898813571052627489189173), SC_(22.726777109490819514174180139940817304307101958426) }}, 
      {{ SC_(158), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(23.282285661039498179074401114138516325616914105347), SC_(15.795285123302576470575468377937404158220678722603) }}, 
      {{ SC_(158), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(23.629147490873518765107649872796720950929728887106), SC_(15.485211018190073313333995451015580465832505428705) }}, 
      {{ SC_(158), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(25.148600018120659629138547794480367841655347320238), SC_(14.161253377838318645502485357098610517058952780429) }}, 
      {{ SC_(158), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(25.35799663234395198803591994635869763560034683012), SC_(13.983098029922665887921070633109463257121873250058) }}, 
      {{ SC_(158), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(27.647992165942754767016647029776944976257281186257), SC_(12.100488170484327477382310596861328427334646675016) }}, 
      {{ SC_(158), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(16.041701141914654837400131816542584299335555265932), SC_(25.842019621887887185171240344500221318347304261435) }}, 
      {{ SC_(158), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(16.201692677812049768127593987452594666167727632818), SC_(25.660170755408478825415314352986805893390690861906) }}, 
      {{ SC_(158), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(17.550868972529664610384099633753314784285418713836), SC_(24.159309985843692351124118748247439409160019035404) }}, 
      {{ SC_(158), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(24.72904489493932509226986081985176308602236098841), SC_(17.032620854594497974725163203753923818129291050044) }}, 
      {{ SC_(158), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(25.084698370948136578361743118669488423971907972934), SC_(16.712908531812175427850910660778446855600022010694) }}, 
      {{ SC_(158), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(26.641868221186012240675867803780790693823858794749), SC_(15.346721812809736187220742166276354388336017213264) }}, 
      {{ SC_(158), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(26.856364505699981174026625924372268291833741483808), SC_(15.162743738201952527407886627899015999210623083268) }}, 
      {{ SC_(158), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(29.200670153952847251036971174127990864718456716178), SC_(13.216341583254394959663990540854822427815578115169) }}, 
      {{ SC_(158), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(28.50546647805453821024892864447773628644460370511), SC_(40.397214663743407017149578521906668518083374907361) }}, 
      {{ SC_(158), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(28.704640970739660503406033737717881610704607405116), SC_(40.181342857040268489085560666658761221457361661556) }}, 
      {{ SC_(158), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(30.376388421479308680082008295102274949058320664464), SC_(38.39368669908482689787445303471270761946218316699) }}, 
      {{ SC_(158), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(39.07357009100674126275457921350836931059378354277), SC_(29.735854853269802581017634474411935699526563031705) }}, 
      {{ SC_(158), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(39.497182593927828257710628347095483692071259290978), SC_(29.339707140720808770324940154990018972820036255363) }}, 
      {{ SC_(158), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(41.344912666228434809043454799448566519464030893166), SC_(27.637863407788572281300745215406525452378427947379) }}, 
      {{ SC_(158), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(41.598567859146961202721158728069929407998226368722), SC_(27.407511445227720641775789487708285974902772634914) }}, 
      {{ SC_(158), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(44.357928237675322587749128811630301413746318734508), SC_(24.951758107800774735235513729259407447788767426528) }}, 
      {{ SC_(158), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(122.62883813782892274398646553006144035880836288856), SC_(133.76077332285194284979381507286876856223333290313) }}, 
      {{ SC_(158), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(122.83249002766157260855653773197347682519547091691), SC_(133.57596914518499149235712533715079118672781638431) }}, 
      {{ SC_(158), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(124.51692536354013627696810930357447595847489286512), SC_(132.02235883841770310614194564819853943503672130557) }}, 
      {{ SC_(158), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(132.61814268438890247180978943756913152979348688193), SC_(123.87672994396628312836960638592341366600378339462) }}, 
      {{ SC_(158), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(132.98629691067073799441866729061169271689024607013), SC_(123.47757667394708741356488781835166994730325690662) }}, 
      {{ SC_(158), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(134.5650177699972942872853718005346789490853382259), SC_(121.73417784746839634865939938049204056996255699424) }}, 
      {{ SC_(158), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(134.7783357501060175963950501468598043892268928226), SC_(121.49455203004307762315959871300757085015752622283) }}, 
      {{ SC_(158), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(137.04665672363441752398621558987944289427381315352), SC_(118.8834032073747953014628927088473749600508954401) }}, 
      {{ SC_(158), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(126.08132656654698219220112182237380465943604183903), SC_(136.71426351371404403198646948904505918630645175836) }}, 
      {{ SC_(158), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(126.27685709013900787614539146216584968631907076752), SC_(136.53880383882205539671002342590184252041081892321) }}, 
      {{ SC_(158), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(127.89283882531637004731368726509631125291499543777), SC_(135.06212779738517859552654610031404368266394106077) }}, 
      {{ SC_(158), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(135.62874486638494390055817176560300633753514114813), SC_(127.27893304361169587941335254689342402184092198446) }}, 
      {{ SC_(158), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(135.9786689950755282944821135440863705025739879845), SC_(126.89600053886126082159389701659503814700498474935) }}, 
      {{ SC_(158), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(137.47734198675517845781157821978343108967508753737), SC_(125.22195988519229874127939012777943130545443458892) }}, 
      {{ SC_(158), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(137.67960164416949714878377274324093681414211056958), SC_(124.99168224859376998966367231143575665926833592368) }}, 
      {{ SC_(158), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(139.82647910572930702377782155146430258754073079778), SC_(122.4796285802973410465029394403325620182449673363) }}, 
      {{ SC_(158), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(138.39570877964928385049286948040792126420948546363), SC_(146.75342266565785649196873956963072045846509828994) }}, 
      {{ SC_(158), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(138.55355391549506116225487251122571497797168662793), SC_(146.61995914872623359459417934997478980873936681563) }}, 
      {{ SC_(158), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(139.85290205134192877561909276085934743904249282406), SC_(145.48975528851425019283553916592813906847747686165) }}, 
      {{ SC_(158), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(145.92486540104352167871723503445761398488415934604), SC_(139.36039000873175404053520857689199105517664320038) }}, 
      {{ SC_(158), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(146.19269147073299390681831540303548680523836356842), SC_(139.05248677622128321990365785838630848875385290771) }}, 
      {{ SC_(158), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(147.33169877992221176121173505249763663795192601303), SC_(137.70042221787558773459424187214258283987653587558) }}, 
      {{ SC_(158), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(147.48437027827726836888682900721441570001374864084), SC_(137.5136898893455658858156979784683622923847846595) }}, 
      {{ SC_(158), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(149.08799959399724789659381189353409192976883113554), SC_(135.46556576350227002780853751983142064500857525061) }}, 
      {{ SC_(158), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(139.74925926737315332448089493287836331394325222077), SC_(147.79491537453148669397216836294015706050065263723) }}, 
      {{ SC_(158), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(139.90187109787960751420543752284203539513511394638), SC_(147.66715528893402191781770624997219533599186480444) }}, 
      {{ SC_(158), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(141.15734943516110619279039114091034532039683947927), SC_(146.58406531022406869173675281217653683135789388306) }}, 
      {{ SC_(158), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(147.00127956136524090567586779485957138187898435171), SC_(140.68163568854854250952465427100955008071106009383) }}, 
      {{ SC_(158), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(147.25794196649899342101013097132812433753048295096), SC_(140.38412777579205088288673679109379586489435777461) }}, 
      {{ SC_(158), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(148.34811001585345075505915939561947716376318216555), SC_(139.07678901948762859250816818055091557374703377444) }}, 
      {{ SC_(158), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(148.49405553474518451818972806133052592512729363593), SC_(138.89612047678813563284835080687616824125597020467) }}, 
      {{ SC_(158), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(150.02408494228068205716090887099564643441187675718), SC_(136.91283272663169062873896808602340765556423318092) }}, 
      {{ SC_(158), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(150.06486937848522813267903680265720239055168701747), SC_(155.00528273792471111879056111446404310095730601385) }}, 
      {{ SC_(158), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(150.16478171285077304707635544625380678664994080614), SC_(154.9338877625925938276944232260643450021941365284) }}, 
      {{ SC_(158), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(150.97955453629495644821784889587131006951039740395), SC_(154.31647706662629438772068827623407153930023132681) }}, 
      {{ SC_(158), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(154.55677237171981294091269376587353631151103617094), SC_(150.67237216924645350292822176816688035952660140891) }}, 
      {{ SC_(158), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(154.70309772860293023886598616338728007426306651632), SC_(150.47929233810345842857860869005666192634252903097) }}, 
      {{ SC_(158), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(155.31055493103053741380383121532167236240345858341), SC_(149.6224893398907771522457861128862006671059298441) }}, 
      {{ SC_(158), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(155.38999117821742710874682342633685036893159123101), SC_(149.50306258484484550078827980277180429325913146142) }}, 
      {{ SC_(158), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(156.19048177701124237444176200343243064946124956017), SC_(148.17711702201635801025732027820980268560194347369) }}, 
      {{ SC_(166), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(15.730882295682088284271923162208775002199165109287), SC_(25.503425939887356094602618222010976022350750223727) }}, 
      {{ SC_(166), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(15.890136312973695587325398662144026112251234190607), SC_(25.321805187148401735526518365369286905110161301634) }}, 
      {{ SC_(166), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(17.233514006342752197640725520375226705077764035964), SC_(23.823208341291552685984652682477035863499801639427) }}, 
      {{ SC_(166), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(24.392003041640273181592314185101684223538451022765), SC_(16.717405795582698161358767364088443714359774568845) }}, 
      {{ SC_(166), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(24.747119973306019956302917122278223593824323807026), SC_(16.399067539202474859607646012047964563044064226605) }}, 
      {{ SC_(166), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(26.302387426231451115880158964190187338683438808552), SC_(15.039234399106404669456623689947035495557139246717) }}, 
      {{ SC_(166), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(26.516677733456366772694943689309674576495776622943), SC_(14.856173706526874566755760565629669231733790002225) }}, 
      {{ SC_(166), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(28.859592185504946251869286052375467518306200367751), SC_(12.920441734872845910571838848364470485887287094783) }}, 
      {{ SC_(166), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(17.002655873301028624482778702125311234170130108104), SC_(27.048710788953605795110812312671313143704245308729) }}, 
      {{ SC_(166), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(17.166956143905516964110547684290297073585122891804), SC_(26.862559395529206826971158969996462606565503587325) }}, 
      {{ SC_(166), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(18.55197206469475006476706923075580245175034881728), SC_(25.325895103012567508544085456814818978970803322086) }}, 
      {{ SC_(166), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(25.909284595216595130199881491145317111616095140463), SC_(18.020058469034275957706402694388681615578126260689) }}, 
      {{ SC_(166), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(26.273421969182514087712053859556937695531702195319), SC_(17.691853817127678021309406088048817024461817232649) }}, 
      {{ SC_(166), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(27.867398106995537331734269140399483951049242245141), SC_(16.288804474768928862693883761569943972335485314062) }}, 
      {{ SC_(166), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(28.086923364769654195430745064965230216734679021019), SC_(16.099786604796217246342763030159638238254367159465) }}, 
      {{ SC_(166), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(30.485607673427880596074246571332749537098722628625), SC_(14.098817487276691196810806347484595845426921549721) }}, 
      {{ SC_(166), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(30.124877372391700438733358280910721388358803131123), SC_(42.314354918737223388868822731783280063663684862909) }}, 
      {{ SC_(166), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(30.329266873326189949059026247455632666588125510383), SC_(42.093271468097469281828074541976379124285263210118) }}, 
      {{ SC_(166), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(32.044410159222698816331480741994793149833418457182), SC_(40.262239185869658857092946263162567432715716883031) }}, 
      {{ SC_(166), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(40.958666614749094247859930145470238856980638223969), SC_(31.387326574209787502559321537072947003776754217016) }}, 
      {{ SC_(166), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(41.39255743168416633522565166452098149821285847712), SC_(30.980895941085321898911175777495689212378513439713) }}, 
      {{ SC_(166), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(43.28486968554132075661728403539714480429230333112), SC_(29.234439548326688047624167282788784346743481879173) }}, 
      {{ SC_(166), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(43.544615049643608335163120147616080139430505092733), SC_(28.997991602834847507259069947528006238399120687387) }}, 
      {{ SC_(166), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(46.369806794579899634567726970785022554568736880013), SC_(26.476307037853065883773316924982760522542304747516) }}, 
      {{ SC_(166), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(129.00720701104822137903935575669184563773650311133), SC_(140.4179747049256498670310941182983151630052304315) }}, 
      {{ SC_(166), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(129.21574011335512495207237911150470471070212796756), SC_(140.2282850454724782611458306663436962985188329072) }}, 
      {{ SC_(166), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(130.94079933048737663315673846828596091755958756951), SC_(138.6340258988920435593011595083869510766953058245) }}, 
      {{ SC_(166), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(139.24531120192948183367593060054542658967304897567), SC_(130.28511001379967746322816463402115357597668365469) }}, 
      {{ SC_(166), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(139.62309739842742704999825605103658883056349708538), SC_(129.87633060524473487138534605960705955573486092925) }}, 
      {{ SC_(166), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(141.2436128566279469915746338986442275675188787977), SC_(128.09117587669867106131656107835923278599329695929) }}, 
      {{ SC_(166), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(141.46264267155059989119174648257867712520874076656), SC_(127.84584561956520968516784282686627623378663027039) }}, 
      {{ SC_(166), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(143.79275926705993344572344357297193472002266149644), SC_(125.17302871532754043961710175594992239655801557604) }}, 
      {{ SC_(166), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(132.62817657560860470127723917173447022011402122719), SC_(143.52754032171499157136250446446004116231405132608) }}, 
      {{ SC_(166), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(132.82837139373789246289187769660981281225443457574), SC_(143.34741142005838784704919023774646370847829129202) }}, 
      {{ SC_(166), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(134.48317017161538481927020541722477144389437873273), SC_(141.83188955112182042389286891271987712802264654488) }}, 
      {{ SC_(166), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(142.41331979688369398903061071345205067985663621245), SC_(133.85445992130809944634052960952931025979639616882) }}, 
      {{ SC_(166), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(142.77244863720980263513074938337114515110113145613), SC_(133.46232942944628023947576164226859554656758126487) }}, 
      {{ SC_(166), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(144.3110669028824732150262074167104678083977375201), SC_(131.74838822523012682829158278899038848751649070061) }}, 
      {{ SC_(166), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(144.51878635562618726286827548256161530392894719302), SC_(131.51265935478332609733612584848817756024664700609) }}, 
      {{ SC_(166), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(146.72474731454226090247579643629738419273676442648), SC_(128.94167027574993129538001198025981936906367792671) }}, 
      {{ SC_(166), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(145.53707019057480655707518578948835089252275002145), SC_(154.10470798918816823280775451080418335474756271499) }}, 
      {{ SC_(166), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(145.69859169245739606525151904410547688437797055885), SC_(153.96755894475658641638499699367848062043500494598) }}, 
      {{ SC_(166), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(147.02852694914147783488521809655154882144159017426), SC_(152.80671514897015861799163451378631955192018461079) }}, 
      {{ SC_(166), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(153.25350513025910125641169246679674436106383089039), SC_(146.52435087320730821023226811872323611853327828692) }}, 
      {{ SC_(166), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(153.52859133060717227923878126548065897843608927827), SC_(146.20919983257910752509104910550622716298065072045) }}, 
      {{ SC_(166), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(154.69913264998332394279543402859498303156196674342), SC_(144.8256845784993434375344657000559511659402719044) }}, 
      {{ SC_(166), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(154.85611849153327842844710922986737130104003099131), SC_(144.6346540524523711448513169222899293177851049167) }}, 
      {{ SC_(166), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(156.50652690825195375163221915207275884260724368196), SC_(142.54003600386456802166348177623266705595898002204) }}, 
      {{ SC_(166), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(146.95515996041869353091137065611524514286096386595), SC_(155.20300060937613004060620562198955840444891094575) }}, 
      {{ SC_(166), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(147.11131283975725910247025266816354729721811724535), SC_(155.07168950164541216368938354142468971444730421218) }}, 
      {{ SC_(166), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(148.39625090305109068871066359407593048533555774228), SC_(153.95908245009520424497966375100560787809972520164) }}, 
      {{ SC_(166), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(154.38754766872212188983401207823037002207656785202), SC_(147.90930335061941601171044390886333960987789650629) }}, 
      {{ SC_(166), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(154.65120410813000541554276686429925975595085082243), SC_(147.60481477990897461353020610064924261125601927622) }}, 
      {{ SC_(166), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(155.77175624437535425366815454959346398993528140617), SC_(146.26718268965240882133056604294499670171853562487) }}, 
      {{ SC_(166), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(155.92185968522567250479638460964140087032410865771), SC_(146.08237385720712049453248440987537157568822077304) }}, 
      {{ SC_(166), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(157.49699231129951442777710637230055535464484183198), SC_(144.05429569272145332460180742447706091793910944019) }}, 
      {{ SC_(166), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(157.75304528035762381208853699667032737301474093451), SC_(162.81882590765961847350855404059746408387499854387) }}, 
      {{ SC_(166), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(157.85515607592923469048809046876821290616001349651), SC_(162.74520920972856971633734143532033548046536055244) }}, 
      {{ SC_(166), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(158.6881995359903949514095927114661651288902453154), SC_(162.10940204475966683814575982217766599478996797817) }}, 
      {{ SC_(166), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(162.35669647176027748170333609419427081261435351347), SC_(158.37405395247993883660487162134502671236623160269) }}, 
      {{ SC_(166), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(162.50738024828618700965733869325949029045947367824), SC_(158.17664485822295167562174500074993253841176738141) }}, 
      {{ SC_(166), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(163.13386277712994236614854540614093107634752182334), SC_(157.30103118445213143609081518815099109090425015974) }}, 
      {{ SC_(166), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(163.2159172438669384868837994776886416864226550342), SC_(157.17903032688767865785391814832225547999720053904) }}, 
      {{ SC_(166), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(164.04516643912107651239826221923537717206274104321), SC_(155.82518345504587379475105858887658134116581066294) }}, 
      {{ SC_(174), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(16.630085384586891122921950577607564518209157352179), SC_(26.636025508073967963036438832479929411646265010237) }}, 
      {{ SC_(174), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(16.793431838461065091638576941457877419142930158672), SC_(26.450318391530995789712909443474269674016081471376) }}, 
      {{ SC_(174), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(18.170849842258363683136437275603959079140203440751), SC_(24.917716541446471951033247008314276694763653414505) }}, 
      {{ SC_(174), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(25.499479968274895925903407603177150186679233226914), SC_(17.641762253487237550187356591794630630974713344985) }}, 
      {{ SC_(174), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(25.862654628024120627541220791900380823607202987051), SC_(17.315358024248090101068229336109288617567603728987) }}, 
      {{ SC_(174), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(27.452879131154461311186462435552293524845476618144), SC_(15.920512718744036830631554172438109921268730269429) }}, 
      {{ SC_(174), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(27.67194569060892981032590643057240623011767525665), SC_(15.732665182726350782769394720639120884069400201297) }}, 
      {{ SC_(174), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(30.06650502306751443943828942702851446233993366378), SC_(13.745103939206292075017090023528561820509322563591) }}, 
      {{ SC_(174), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(17.966543820244285168761079414676636711225901250151), SC_(28.252467256825567541013583291647090586068603913599) }}, 
      {{ SC_(174), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(18.135049260303834921722236657760785914990714320961), SC_(28.062116342609402642288160931347354843751926224352) }}, 
      {{ SC_(174), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(19.555045699051514394039733483290765029773591932542), SC_(26.490504413862228427176798464319633794241531422998) }}, 
      {{ SC_(174), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(27.087222324874055740418021652985746350904026356876), SC_(19.009793755432447572584990895149008842750375383683) }}, 
      {{ SC_(174), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(27.459640794895286154384811804956656903827252513459), SC_(18.673300327867764981466170386744971038854683406917) }}, 
      {{ SC_(174), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(29.089541828924231411312149333829269080519483507739), SC_(17.234274838501216260085401776808145825794718597404) }}, 
      {{ SC_(174), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(29.31397541054841260185225754793896184045913002473), SC_(17.040338808449044155845628483662229175535933043975) }}, 
      {{ SC_(174), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(31.765729715154371500591319185328480572171210596184), SC_(14.986128814246495293842606941747731542630884661401) }}, 
      {{ SC_(174), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(31.747838016716784907134432528304712558212121410056), SC_(44.227944771888194825144697161550340544574369625399) }}, 
      {{ SC_(174), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(31.957317637800345859515106193688775856581323010658), SC_(44.001774259767988600589196929093905537749405292521) }}, 
      {{ SC_(174), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(33.714819363905521609474352742975147314885638761739), SC_(42.128401467559344580208520301359521842272184108196) }}, 
      {{ SC_(174), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(42.84097818906319480068459585169733724434035396392), SC_(33.04158104443330035339614946331439931238175610804) }}, 
      {{ SC_(174), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(43.284901929810143060713868547657527209960455260523), SC_(32.625113296848073423779955982803311090927136944577) }}, 
      {{ SC_(174), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(45.220730424216647648693977413589411741491944157457), SC_(30.83511295783610956486883271141568884999422417034) }}, 
      {{ SC_(174), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(45.486420122605335100515560084209198990454532163482), SC_(30.592715397971676634680299034710356546137932802327) }}, 
      {{ SC_(174), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(48.375862645694255733700964785039165186027176307681), SC_(28.006689415066868088553355980157619415096380851604) }}, 
      {{ SC_(174), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(135.38890241210559563184959370511073141872378925692), SC_(147.0718504422228850005997665658219563315644407245) }}, 
      {{ SC_(174), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(135.60219998904780064702761039663668203331378954178), SC_(146.87739242576211523908499111211677328396547956159) }}, 
      {{ SC_(174), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(137.36691280959160413559517529432453491657334804886), SC_(145.24345696413794523715361352790681935688258984742) }}, 
      {{ SC_(174), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(145.86987323194821192683189966206797697157614255695), SC_(136.69609941080434651942380503610132732241532626744) }}, 
      {{ SC_(174), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(146.25706096592990551219344186465496140946994925397), SC_(136.27792377180190908617170610584045533303932138635) }}, 
      {{ SC_(174), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(147.91836866831922816366084008941301360444015468311), SC_(134.45201198315479262026288765910838306542980157755) }}, 
      {{ SC_(174), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(148.1429729644461600551202895221256850981062820034), SC_(134.20111396413409282475687216039398099396344304764) }}, 
      {{ SC_(174), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(150.53339171275292375293063572638838743696824886683), SC_(131.46811066156084124523664820276883588208093154504) }}, 
      {{ SC_(174), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(139.17820619523557475968496851118072092921754375034), SC_(150.33763859071138611498470063248928065440761199578) }}, 
      {{ SC_(174), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(139.38295371827289805550659416365647029605850274302), SC_(150.15295249806070869141915315997068365858212488391) }}, 
      {{ SC_(174), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(141.07564214458065778335534384507240407121049769901), SC_(148.59951477996985144689232662077844334002737950603) }}, 
      {{ SC_(174), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(149.19540397338312123904068652335113869127617382201), SC_(140.43248087733430418774047756901610144644412233845) }}, 
      {{ SC_(174), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(149.56351717575566821337085193312204630548300917305), SC_(140.03137214474417393476628863401048932126993882076) }}, 
      {{ SC_(174), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(151.14112185530190410198511203548235156288378741087), SC_(138.27848519748547275036795602156169547138790836558) }}, 
      {{ SC_(174), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(151.35416965380214867099605298703133458257844599197), SC_(138.03743576111731164442746753318699275668136255488) }}, 
      {{ SC_(174), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(153.61778361869456865893958213271146800962303653969), SC_(135.40892807158012420877303935132573291090752651223) }}, 
      {{ SC_(174), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(152.68094285739213056166008149975134867662539082553), SC_(161.45348478026549757146556801923679499239698355776) }}, 
      {{ SC_(174), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(152.84605256879867753996619587584742077584060867063), SC_(161.31273917941911868776523093764865460337116590171) }}, 
      {{ SC_(174), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(154.20584279919699905369851960480905623911472652655), SC_(160.12199222597726188594615753832107764541022494943) }}, 
      {{ SC_(174), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(160.58018176288518512795899077227999151371034160926), SC_(153.69028162899111115436870946055289368833090886125) }}, 
      {{ SC_(174), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(160.86235353463054577967401877259632114543033814289), SC_(153.36805626066039221089197077477025657043861337973) }}, 
      {{ SC_(174), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(162.06366704839458279449320176938271980464060622958), SC_(151.95384469454449010086535015459883676711016067832) }}, 
      {{ SC_(174), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(162.22486245089691493533886503244290204176988035578), SC_(151.75861929321033226830872269742981891699148070485) }}, 
      {{ SC_(174), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(163.92090187144752276295197651447901549789625754851), SC_(149.61862903535704793060419918729867542762736154823) }}, 
      {{ SC_(174), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(154.16348050353633326276191699341757843118791393661), SC_(162.60866913886633326670536586025108228653507208925) }}, 
      {{ SC_(174), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(154.32308948323334889397590997181912413795245137133), SC_(162.47389284038981595003893068252364844388721099218) }}, 
      {{ SC_(174), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(155.63678186340716314681793119508647064846455173002), SC_(161.33247912449068816296481263807682471341792298124) }}, 
      {{ SC_(174), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(161.77192509834208986830232716380034182770332940046), SC_(155.13886923840990455190899423811038950982951130931) }}, 
      {{ SC_(174), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(162.04240726326897269503467861442751334896084293375), SC_(154.8275671542890381782662617219645023942027904776) }}, 
      {{ SC_(174), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(163.19260847676049465171388143937765824975010832402), SC_(153.46036867648449593334202194384907579348287058534) }}, 
      {{ SC_(174), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(163.34676866952292124474121806349827378441185732832), SC_(153.27151913422131882828995594468092992295745740099) }}, 
      {{ SC_(174), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(164.96589424172364661776042235336773557485429381716), SC_(151.19973190414667901036433016779710543290653219033) }}, 
      {{ SC_(174), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(165.44273802071368676886246253636451040777756854428), SC_(170.63087352072307225875793596896190928660648614969) }}, 
      {{ SC_(174), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(165.54699415493413402787816683296220919155730765042), SC_(170.55508988446952069398496297555199487329754760358) }}, 
      {{ SC_(174), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(166.39786831601900240998308010937415796626550674918), SC_(169.90133462271773762512407312222876036655797182992) }}, 
      {{ SC_(174), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(170.15545853982742078810499731394323640999728693652), SC_(166.07692687181743258960632247791434556772299695211) }}, 
      {{ SC_(174), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(170.31039455704450657539648516917516791313861093353), SC_(165.87529275262642585007975099058278879314430840872) }}, 
      {{ SC_(174), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(170.95543210598052194607939364837135806908442896555), SC_(164.98132317626948012012032161787655836131307029407) }}, 
      {{ SC_(174), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(171.04003895536038071176020216192653610841250334205), SC_(164.8568107006794802544986238921394461388145170229) }}, 
      {{ SC_(174), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(171.89729573360168516885036545341273269598403274596), SC_(163.47574409522903401186530988442444244948490869974) }}, 
      {{ SC_(182), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(17.531947936479945686311006376470981911456604808202), SC_(27.765964212244578454910971052697504569143678430791) }}, 
      {{ SC_(182), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(17.699292918455615732522701268972042194128163478101), SC_(27.576264117709964686936800245819951712787295829006) }}, 
      {{ SC_(182), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(19.109972252542561262033790758621656450348653925074), SC_(26.01043323367203782340543483109946004077864813777) }}, 
      {{ SC_(182), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(26.604869673777457572054690762090245373931881916146), SC_(18.56820190067482250375651658295547416610487581835) }}, 
      {{ SC_(182), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(26.975918195732704609902325464900925649419919397513), SC_(18.233916266628436735575817353590624704891757292688) }}, 
      {{ SC_(182), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(28.600300679738085824725976098488414550716474556778), SC_(16.804862619314673714886054863580566488674681480708) }}, 
      {{ SC_(182), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(28.824034114413504494481014290316831224419725095736), SC_(16.61233853911649922084111025046696686309133459836) }}, 
      {{ SC_(182), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(31.269052010266191919638746359361208758143570422323), SC_(14.574150652776932179809408889604486602176697837208) }}, 
      {{ SC_(182), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(18.93316448290132121994067404613374787372423392856), SC_(29.453489748828425019769228919269319168742967889207) }}, 
      {{ SC_(182), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(19.105778657321147019524158527977444014076987226637), SC_(29.259035261956559971819996946429584795331083739483) }}, 
      {{ SC_(182), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(20.559955485576092466176598855338206860798578807421), SC_(27.65327301587099401981144304721394054006287655241) }}, 
      {{ SC_(182), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(28.263015485374154425075978859880144600730561223897), SC_(20.001669897197003609010398893878116875964307252617) }}, 
      {{ SC_(182), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(28.643526126779100230645988284699130253836330957402), SC_(19.657077274221290314217961374008084142714268571093) }}, 
      {{ SC_(182), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(30.308531072021507174278065968675446273345606788123), SC_(18.182901050302782936032049703976493846265986575654) }}, 
      {{ SC_(182), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(30.537760610222960882816927778001229472077263528021), SC_(17.984160084683656258967758125968662449495067956078) }}, 
      {{ SC_(182), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(33.041366325284998388520798456019298728927077311434), SC_(15.877942913141048070734540883972397774119689225645) }}, 
      {{ SC_(182), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(33.374105992542268930509315598970957629176141675216), SC_(46.138226736343407093873235551895499237138662986177) }}, 
      {{ SC_(182), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(33.588559412070109828045689303672449492397191938745), SC_(45.90708521861951526867044089524482730740581062763) }}, 
      {{ SC_(182), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(35.387453213187700634047492958764414271869801213615), SC_(43.992336731664407724511122577960950273761478110297) }}, 
      {{ SC_(182), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(44.720694972361650962620379233715660723788215725647), SC_(34.698428401274693037430365170486146775869264306501) }}, 
      {{ SC_(182), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(45.17442302223162743704221895533718878215588796546), SC_(34.272152515976586229546640578597942253321532287099) }}, 
      {{ SC_(182), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(47.152774784225454556684008922966632152191664339053), SC_(32.439603614594136126074396219508272770839361545224) }}, 
      {{ SC_(182), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(47.424272977062733026629751143895870241140565189108), SC_(32.191392742129978147350875793109324522820932756262) }}, 
      {{ SC_(182), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(50.376494297748644153459556557893935665091121258751), SC_(29.542505322869550158869869269269559011195536227731) }}, 
      {{ SC_(182), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(141.77369702827492297164632692214968170924868690348), SC_(153.72262771766762024060797645870003186907947370279) }}, 
      {{ SC_(182), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(141.99165033455911283699993498614423002629774039668), SC_(153.52351042615542720784900708878453730441896113087) }}, 
      {{ SC_(182), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(143.79511283280314142429133242532180871632720389366), SC_(151.85080453208572944710854036002363153144481568064) }}, 
      {{ SC_(182), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(152.49200663370082541213993457375007128886950244824), SC_(143.10951989260964435573176721642440993659893338795) }}, 
      {{ SC_(182), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(152.88838126189354328771902693664270536179608139588), SC_(142.68216220946493771756884773458109250966786342056) }}, 
      {{ SC_(182), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(154.58954771083762164367947749700215074158078522074), SC_(140.81642380275876958234731100187882007285744836227) }}, 
      {{ SC_(182), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(154.81959859634846061787693184338588523426780719407), SC_(140.5600853263975302259232118709689493092894266696) }}, 
      {{ SC_(182), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(157.26892945427488378176463295111084732994249048734), SC_(137.76827544323004394231565849319450873705805644771) }}, 
      {{ SC_(182), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(145.73119808490140826173633443989531824230557681816), SC_(157.14477550234785535927186381030566622015153420777) }}, 
      {{ SC_(182), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(145.94039436536157953659561367850056973189187591552), SC_(156.95563655448568346422428979553742509980461668409) }}, 
      {{ SC_(182), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(147.67010847959374534584725518348584393559304181322), SC_(155.36514919926854447033372250101965664994491123028) }}, 
      {{ SC_(182), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(155.97516737153016605909957185919836398897935652734), SC_(147.01282548626975408283021709958623713436638974406) }}, 
      {{ SC_(182), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(156.35205969418208055497816752592470900945624040421), SC_(146.60294322908089291369813333049616428706948897789) }}, 
      {{ SC_(182), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(157.96775785651759192058371260956750640437114633035), SC_(144.81199994360290047831119381348749323851266044372) }}, 
      {{ SC_(182), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(158.18601161755381924333279509365860020883421476471), SC_(144.56575164515219606323013213909278387779250955431) }}, 
      {{ SC_(182), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(160.50594735474549135119110768976011712937496292326), SC_(141.88104470086455474110364061565774970640637690125) }}, 
      {{ SC_(182), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(159.82715476288571868477496831944614077256957411775), SC_(168.79992463270461608609249848545812664801842631018) }}, 
      {{ SC_(182), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(159.99577057489197125865574658573498989899965277884), SC_(168.65566529540172164190031605076114415811417324354) }}, 
      {{ SC_(182), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(161.38473377940867819812512504420154136648099801438), SC_(167.43570123432817008901795793272018633093800718043) }}, 
      {{ SC_(182), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(167.90502927426609827146251116787848949737920566583), SC_(160.85804736380628541058763611408533046792803518287) }}, 
      {{ SC_(182), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(168.19412407511900693215061705740180018683929068731), SC_(160.52890926622038895685527799628515735075727852434) }}, 
      {{ SC_(182), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(169.42550067935955231665410909596974576162253341162), SC_(159.08470400767947523226055182129300717363588043501) }}, 
      {{ SC_(182), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(169.59080815229801252390096445425947190998970245547), SC_(158.88537995027260866971898643085693139677308192603) }}, 
      {{ SC_(182), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(171.33141131748400208882425889613059985005775297921), SC_(156.70106184587052489034072752890683886952144350208) }}, 
      {{ SC_(182), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(161.37405507097154294750468584431379674049438604175), SC_(170.01208629614148563560399650411043036135380833597) }}, 
      {{ SC_(182), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(161.53704103184829200359465563560696457946571960776), SC_(169.87392469737355236389616452168567137042117275288) }}, 
      {{ SC_(182), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(162.87883064753156797907380189629382339958917969443), SC_(168.70436577552381333308980437837055317744321482419) }}, 
      {{ SC_(182), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(169.15454086974119366471270776523791996960145163243), SC_(162.37020328773798853868880745832597809148196205689) }}, 
      {{ SC_(182), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(169.43169204686889496386293982052820734137407704868), SC_(162.05224338399064247803814760506269968523308438178) }}, 
      {{ SC_(182), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(170.61085824831404494689858331391281172846457794809), SC_(160.6561555679604216810653180438133474816549034962) }}, 
      {{ SC_(182), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(170.76898107611593843519722586069976738520064813659), SC_(160.46335804743188743522443750235125050960044630628) }}, 
      {{ SC_(182), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(172.43106774281435451404789848772600368293538174334), SC_(158.34886849728211839100610233562162891631644147279) }}, 
      {{ SC_(182), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(173.13384277960575484367110309094829749066664763194), SC_(178.44152677534984757224253267877467573847396276997) }}, 
      {{ SC_(182), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(173.24019479116596260076490237515851906309010041749), SC_(178.36362717602176303760714965677644473052771286432) }}, 
      {{ SC_(182), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(174.10848994725716822141891491031704666286722543391), SC_(177.69234128819508439275175261608723371595040110568) }}, 
      {{ SC_(182), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(177.95313670561872607972977888034289563747497277845), SC_(173.78090851720079435265502861864315165116011692231) }}, 
      {{ SC_(182), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(178.11222609947689904315450957995779692020590337629), SC_(173.57514644887766672308599278581186174945095205679) }}, 
      {{ SC_(182), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(178.77538112632532783930522431179396951967312692685), SC_(172.66324438622814959196517129401554383606307597773) }}, 
      {{ SC_(182), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(178.86247916857828730222586362494431394013049586469), SC_(172.536278454528364738173049149446956672694996604) }}, 
      {{ SC_(182), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(179.74704703467261995968167776506816209608662998539), SC_(171.12862630843595903535560113760182853816619375608) }}, 
      {{ SC_(190), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(18.436296061781527310579523443856549834112992557371), SC_(28.893416144568906163840177851767664934710392538595) }}, 
      {{ SC_(190), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(18.607551848486962887595158742872924637163080685588), SC_(28.699810337309075355078399274117735435016293692494) }}, 
      {{ SC_(190), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(20.05076469177813369222893711923597270126489411777), SC_(27.101475598835186528568739294851688493344241488876) }}, 
      {{ SC_(190), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(27.708308681708907387316464620021892170636857022053), SC_(19.496588739471796882326076554979361305326801009524) }}, 
      {{ SC_(190), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(28.087059234516159300252198590915502767618241550098), SC_(19.154594148311887683540243419772501101260558765235) }}, 
      {{ SC_(190), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(29.74485301262129322811709469497077800370747537314), SC_(17.692083011648465483902066675831863918318238279397) }}, 
      {{ SC_(190), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(29.973151127121419586813424029894984709497489131701), SC_(17.494985389682336325824846850723694648118363213297) }}, 
      {{ SC_(190), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(32.467519370176190170315964190054362162821004424932), SC_(15.407293318953194912770553639322739453418140006652) }}, 
      {{ SC_(190), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(19.90233920629008185569957632590428546643677606566), SC_(30.651957101185571378580412789281000622159688286459) }}, 
      {{ SC_(190), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(20.07897202755269449380403779223374229315632893376), SC_(30.453488702480085297538120086348554526645100847872) }}, 
      {{ SC_(190), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(21.566581641742210470239824917440804374198252127865), SC_(28.814321277719219804468269555976156241713603573322) }}, 
      {{ SC_(190), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(29.436804318356865886690933950415871369394566177401), SC_(20.995547136117881675025181435834045455025169375557) }}, 
      {{ SC_(190), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(29.825230570245213810033096818153337712394393045045), SC_(20.643032453861564924954727292100625552117395079677) }}, 
      {{ SC_(190), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(31.524572250661608956989387208791751101467771504005), SC_(19.134476549834168529058930630621839012870369837996) }}, 
      {{ SC_(190), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(31.758492754429074989249706165810825101560375328712), SC_(18.931036389674743989708474730373603612739854714649) }}, 
      {{ SC_(190), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(34.312811496845506580525890528844524397789897128325), SC_(16.773963619930701835081901384466643197091875514966) }}, 
      {{ SC_(190), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(35.003465275347463797307859741831619184289860017443), SC_(48.045416913916987707477926334766358896522099158464) }}, 
      {{ SC_(190), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(35.222783801168269566147829390346011828039049540104), SC_(47.809412850104870502578141781841586913612866355221) }}, 
      {{ SC_(190), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(37.062166587823679378600122248902965372848945542277), SC_(45.854190400437091902273896851962418204343156288286) }}, 
      {{ SC_(190), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(46.597986420015180293075236922960983249618295652851), SC_(36.357699434388851955033114372215220579081422694997) }}, 
      {{ SC_(190), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(47.061305111637762074377983141397903565269114459513), SC_(35.921829395860089372548770300866830817026191453204) }}, 
      {{ SC_(190), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(49.081252174375847466571466378993568838224365420936), SC_(34.047662008466007591965702721781936105122976523721) }}, 
      {{ SC_(190), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(49.358431926645590789641019632818086139561077383404), SC_(33.793765162303110136710885726637272221215374933183) }}, 
      {{ SC_(190), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(52.372056779927097977013239076860222620023271862253), SC_(31.083398558488133316817852271416012518989634215536) }}, 
      {{ SC_(190), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(148.1613883120325286729720577603601930978469339151), SC_(160.3705089730347621226641125672114871748266042249) }}, 
      {{ SC_(190), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(148.38389572270640024718722474846181143803387534231), SC_(160.16683432615065789175624792461200568041160538019) }}, 
      {{ SC_(190), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(150.22526309214907113849670542886892822374414262856), SC_(158.45620452079313752737125856066386176562388634274) }}, 
      {{ SC_(190), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(159.11186991873718287138838274486814431524488288909), SC_(149.52521263048173557323639160397928305208062044512) }}, 
      {{ SC_(190), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(159.51723086241806822611587404942250571241369316394), SC_(149.08887308147859707399697939742547421515968538083) }}, 
      {{ SC_(190), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(161.25738387573671567021296284817690287766902303957), SC_(147.18417756447412921565318512064741819177822632248) }}, 
      {{ SC_(190), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(161.49276188136430586898075066394266906100823889638), SC_(146.92251758648068781178306255311645301998424356815) }}, 
      {{ SC_(190), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(163.99970680960334984914200542062583186218025059468), SC_(144.07319023342505795978707574444801931690936098352) }}, 
      {{ SC_(190), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(152.28695858963604649828892095741199479434387797985), SC_(163.94914458236368421821114477763124479991386615174) }}, 
      {{ SC_(190), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(152.50050648803291956261931865487154784993993184887), SC_(163.75565025880370218265361244011550308861765315649) }}, 
      {{ SC_(190), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(154.26643884743974172864654110476006570395889265052), SC_(162.12892268281995691957383563350703729826592973122) }}, 
      {{ SC_(190), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(162.75276147652235017498097762986125364348443273787), SC_(153.59534189074900450664839812681738292809315478647) }}, 
      {{ SC_(190), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(163.13824113410559427668965206023457185959336607243), SC_(153.17687743350519494748279078272640280930866035005) }}, 
      {{ SC_(190), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(164.79119854984090786560144646435288130747468030528), SC_(151.34870895202077584075804086754656008516546948604) }}, 
      {{ SC_(190), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(165.01454395949805585405306796424131284453692608246), SC_(151.09737551120859792755923003323152697218659311457) }}, 
      {{ SC_(190), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(167.38955850907513620440962259327592094764934547108), SC_(148.35770190099554233977533845521040617279658475443) }}, 
      {{ SC_(190), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(166.97555267241552362047532253920449640696376775213), SC_(176.14418043978230809281523090094258690721943545972) }}, 
      {{ SC_(190), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(167.14759786273235368981985139764847595689423937608), SC_(175.99648471256244950676586525838184929438139768614) }}, 
      {{ SC_(190), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(168.56509671627899694321253105980325685443681365318), SC_(174.7479444315833488532873547629775308634589339169) }}, 
      {{ SC_(190), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(175.22816707369492083525539396094402788023100604167), SC_(168.02752789592155902521149036612750978270463525599) }}, 
      {{ SC_(190), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(175.52403306009119626920079771030693118893926781333), SC_(167.69162808230476546027799122186149632925750165642) }}, 
      {{ SC_(190), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(176.78481055023549609868629292118236032582303973867), SC_(166.21808564552557866231669086643521675353139333556) }}, 
      {{ SC_(190), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(176.95413908599582751994792714752359021138476693063), SC_(166.01475282601866571980717482809033553951515194422) }}, 
      {{ SC_(190), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(178.73831049532571989036396451989316994846634994576), SC_(163.78708237979528324069246359444144671894881235317) }}, 
      {{ SC_(190), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(168.58673595042033994507422298584680001578790869161), SC_(177.4133993968974312787674021168164659288953519731) }}, 
      {{ SC_(190), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(168.75302496535511405983586476648030562972987626096), SC_(177.27192710255056372480924030961509805526141003049) }}, 
      {{ SC_(190), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(170.1222977876457420051221555163175699104496797722), SC_(176.07484085683687925381131362092992972177793929294) }}, 
      {{ SC_(190), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(176.53550997908254895034971848574916465227438075229), SC_(169.60318964179395080376717970585113901741360346785) }}, 
      {{ SC_(190), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(176.81918377778164605773765187870285046435976045175), SC_(169.27871741133736188499927994467389405350279264984) }}, 
      {{ SC_(190), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(178.02667617724398934789994379921622116573611329931), SC_(167.85437286514698995088542327117671776502631836395) }}, 
      {{ SC_(190), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(178.18867379273184543312603705300664332447450781881), SC_(167.65771399963666680869779243101786213507134318092) }}, 
      {{ SC_(190), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(179.89275928843532635565204363137572236066007206791), SC_(165.50146246577198561530696529813984463719278040532) }}, 
      {{ SC_(190), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(180.82626627116482539598224128166248568797351440021), SC_(186.25087608247759172273975412527002844490219625801) }}, 
      {{ SC_(190), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(180.93466795868491637128049759222612730029167893702), SC_(186.17090809946156840646841549832872662249832073336) }}, 
      {{ SC_(190), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(181.82000132890499181062890584653230934379388219914), SC_(185.48248149562441428040989615128864176407338478377) }}, 
      {{ SC_(190), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(185.7498008088529565509730776758412533223157454911), SC_(181.4859255599879402076629026643004514597415869146) }}, 
      {{ SC_(190), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(185.91295123950621862856838067896036893399516955656), SC_(181.27612623887545010638732660420366707068488666455) }}, 
      {{ SC_(190), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(186.59381540978530057173982322787894949960224257601), SC_(180.34668718790423683274215713913260626751991201254) }}, 
      {{ SC_(190), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(186.68334759552856218103972243465816167362181070498), SC_(180.21732211479331186051514945861516570211313117257) }}, 
      {{ SC_(190), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(187.59457860671264035133583266119903046910685225399), SC_(178.78367647092988617778484441256188436661469909422) }}, 
      {{ SC_(198), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(19.342974027158486932473431746522856929871710298385), SC_(30.01853720415440482436955577429322789164066629107) }}, 
      {{ SC_(198), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(19.518058429672246658567025607599480912354646155903), SC_(29.821107469356046262811479559190126447030386073221) }}, 
      {{ SC_(198), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(20.993122754042093907926719362319205810230863022454), SC_(28.190948573700989476445176959486147395165882319152) }}, 
      {{ SC_(198), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(28.809919251139046420075242492657666881425265623104), SC_(20.42680094910156695888706397275706007114420827814) }}, 
      {{ SC_(198), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(29.196210780186694926978614713977266614189104474439), SC_(20.077258999355331891804484450944614495474494097677) }}, 
      {{ SC_(198), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(30.886716065694442866665900913462050128822200770423), SC_(18.581993830267420718879229370141028455384626109883) }}, 
      {{ SC_(198), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(31.119483093504960332802087183351578434345198394208), SC_(18.380419143229209773210313065860110416205158573383) }}, 
      {{ SC_(198), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(33.6621633627640806304767680168243201610121133358), SC_(16.244273717023501328724252655101706696607262709023) }}, 
      {{ SC_(198), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(20.873907987651403277327272993912303573576159292108), SC_(31.848029465102922482927502747559189284968428746056) }}, 
      {{ SC_(198), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(21.054475048460918460317805200483193886866939886457), SC_(31.645631185893996464534804676202477640908612227471) }}, 
      {{ SC_(198), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(22.574816862753450535394807094204021169732983625802), SC_(29.973756993980005433219614643280003844866616116931) }}, 
      {{ SC_(198), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(30.608714415784902460367345678822686550732379444905), SC_(21.991300283289165012898945693696602503477294091823) }}, 
      {{ SC_(198), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(31.004890788984229419450800532466950248874222934327), SC_(21.631029538397776421842934497783193194192760292905) }}, 
      {{ SC_(198), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(32.737850206566602442538247100138032199364587804663), SC_(20.088816368660448732607635277353171558984140708862) }}, 
      {{ SC_(198), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(32.976363288156684182042422633123150377648035490801), SC_(19.880776061636489452942523824188535522482879820488) }}, 
      {{ SC_(198), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(35.580328452649676026463691843367186354509414733371), SC_(17.673925888106871875701467279232803144845594274524) }}, 
      {{ SC_(198), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(36.635722378824839324259747322039001297971732522718), SC_(49.94970885463168918958398922325708095898207926175) }}, 
      {{ SC_(198), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(36.859804148965987757350200459885029596751396595716), SC_(49.708943901958049260926789029187615727505191828762) }}, 
      {{ SC_(198), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(38.73882948913239468866549605297511813152889798076), SC_(47.714092726088035166966948544131716428518543595769) }}, 
      {{ SC_(198), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(48.473004308903722439974001174243448815662663551708), SC_(38.019242571624382435026547447881697186755727586036) }}, 
      {{ SC_(198), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(48.945713361337111030316849246324617296938389435606), SC_(37.573978940110835236991962659990125134055218113951) }}, 
      {{ SC_(198), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(51.006385967655982988985964160962564396002157438002), SC_(35.659064680184657817531089561771833808014872754113) }}, 
      {{ SC_(198), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(51.289128317002886165116392084610491223495611629582), SC_(35.399601177844205354768063943089943809839824315797) }}, 
      {{ SC_(198), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(54.362868007755877679664114378678344729556978375222), SC_(32.629050221589082388127147299927443950618890734889) }}, 
      {{ SC_(198), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(154.55179486079551400908974907168775826234197465455), SC_(167.01567552392070956222765808940809019994592809549) }}, 
      {{ SC_(198), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(154.77876112672710117516049512600663468916442090633), SC_(166.80753903026991667481953734987048827592938616438) }}, 
      {{ SC_(198), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(156.65724150492076708350737201721298526395280666615), SC_(165.05977868685570963880484285226236801091829085667) }}, 
      {{ SC_(198), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(165.72960507459808559363556374474621331783281428432), SC_(155.94303537203302039038459253858514519744042492687) }}, 
      {{ SC_(198), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(166.1437643475072450213850589977706405097494459633), SC_(155.49790159057507093379090279421715326600188839423) }}, 
      {{ SC_(198), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(167.92208662510538605295123531016085392863105576667), SC_(153.55506390929983022173923443501958373918045961089) }}, 
      {{ SC_(198), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(168.16267981804798359388072629530735668808033811404), SC_(153.28819391079877000530366101763415840680211693349) }}, 
      {{ SC_(198), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(170.72602305167669158015910296169100914823218665514), SC_(150.38255701073586332068266010439148117028178018157) }}, 
      {{ SC_(198), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(158.84531427666256996529468940790405779783170794294), SC_(170.75091915739496235017282742674793916371301204571) }}, 
      {{ SC_(198), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(159.06312274949735363002228892956551356984637309286), SC_(170.55316080106777874310772013859230993787618429305) }}, 
      {{ SC_(198), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(160.8645165246363626491313370689954259278090693715), SC_(168.89095157333355931870697618724042185451258904013) }}, 
      {{ SC_(198), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(169.52832198159022913533093139395802626206166211806), SC_(160.17989408693920543128651318357339499464532794123) }}, 
      {{ SC_(198), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(169.92220923595183344555444422166281142357641783845), SC_(159.75302676159423635862617153821637196311584446055) }}, 
      {{ SC_(198), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(171.61164421300958690613714659797237016654433863798), SC_(157.88841205816680346274497523683460835337964971394) }}, 
      {{ SC_(198), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(171.83997417674223656516147625252599536264993557659), SC_(157.63210004687400987993156006125300607964013211823) }}, 
      {{ SC_(198), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(174.26890349964832540142374008818339483038217267433), SC_(154.83861470119032558506455797903091089573940433914) }}, 
      {{ SC_(198), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(174.12599938256832194670600237012627852592760455259), SC_(183.48638912686766776434832568008483389014312105826) }}, 
      {{ SC_(198), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(174.30140205146075852828586109314856069573190108097), SC_(183.3353294604459270939051995723159993949969635633) }}, 
      {{ SC_(198), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(175.74683923154893972970123157593558813936086903282), SC_(182.05881343182666751361099215623688066407292787809) }}, 
      {{ SC_(198), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(182.54970212776968039928403459188542445202050881041), SC_(175.19861561625049174899061898558303212767168292138) }}, 
      {{ SC_(198), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(182.85219703052325676898900273656490913160173348563), SC_(174.85609562154234920924457278948046066556288274324) }}, 
      {{ SC_(198), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(184.14175514818880931803902531903448796761102725543), SC_(173.35383124442109455659528289543932153499312709564) }}, 
      {{ SC_(198), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(184.31501953353370807942897331749426088039327798332), SC_(173.14657389512751016541954992336084145151889276259) }}, 
      {{ SC_(198), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(186.14182773377281892266317500695832597845425492734), SC_(170.87646499666006831317729474448537786906334806723) }}, 
      {{ SC_(198), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(175.80139088876971640454458767230025866849737594527), SC_(184.81274037163795522594824960978433149014902742764) }}, 
      {{ SC_(198), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(175.97091367887202611270560688562288369058307379299), SC_(184.66802725901383680203785406933598927970888746697) }}, 
      {{ SC_(198), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(177.36709422830142837432736422365471553856012888179), SC_(183.44399257813184360915829323623369280881567334436) }}, 
      {{ SC_(198), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(183.91493544252435967529487260489039435537825625173), SC_(176.83772456903188105314181670627993054489495191085) }}, 
      {{ SC_(198), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(184.20499470938435293912506551369096236830629203564), SC_(176.50687637083981326014273233967785743218256746634) }}, 
      {{ SC_(198), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(185.44021502706079791875538530330822920726128423834), SC_(175.05486791719180519374486105656628403636269456709) }}, 
      {{ SC_(198), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(185.60600518546287820961807587569129998395593867928), SC_(174.8544288816673554299512299374901148074915954718) }}, 
      {{ SC_(198), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(187.35118933081629895752794483350664191404285970376), SC_(172.65729627905434626520533992354239835019669345568) }}, 
      {{ SC_(198), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(188.51992504244490340080005528655826495419566257943), SC_(194.05900258903283005099803149062650237406013488164) }}, 
      {{ SC_(198), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(188.6303331220830676580310543497658251423341666146), SC_(193.97701076046074516032975847123326724221760969929) }}, 
      {{ SC_(198), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(189.53234603021285039139496576514929954318973421181), SC_(193.27180865521372522598112398729681330254903875139) }}, 
      {{ SC_(198), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(193.5455135676301538321769773838846777062911229731), SC_(189.19191241142306786263661185511699911534583298413) }}, 
      {{ SC_(198), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(193.71263854134416872645838036650533552054987276184), SC_(188.97816082266079820649321194472033610771495252754) }}, 
      {{ SC_(198), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(194.41082967521906462956969084961627525090833363564), SC_(188.03155529633252210917254869748952300151807587156) }}, 
      {{ SC_(198), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(194.50274265981510427273894463739203909382968250275), SC_(187.89984195464530485392340805060940086699896060402) }}, 
      {{ SC_(198), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(195.44003226368224219560317142136588685554998859647), SC_(186.4407571647469219519801521530859281798093586033) }}, 
      {{ SC_(206), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(20.251841708195420720323760739457621920949366565161), SC_(31.141467652301973907517725437297093821976912463803) }}, 
      {{ SC_(206), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(20.430677513367510366086458808684337785609024930391), SC_(30.940290845489304392384594741871198901786247845292) }}, 
      {{ SC_(206), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(21.936952473911317759599153651349418764088924822163), SC_(29.278946570596372572955132269631807456988720583039) }}, 
      {{ SC_(206), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(29.909811379897521429358684336091130290594923275773), SC_(21.35872889993246488712989992070181168891240019865) }}, 
      {{ SC_(206), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(30.303492526178536444904940784391582521615224330747), SC_(21.001791432994304695362478961859197175582301008566) }}, 
      {{ SC_(206), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(32.026051720961699121027340984614199113457148489815), SC_(19.474433079823571135647608013640752098632021506149) }}, 
      {{ SC_(206), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(32.263197677712535562820350195717072058716979143137), SC_(19.268471940303398440530664492910595537490121345569) }}, 
      {{ SC_(206), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(34.853214499712072016490770094230796015908332051299), SC_(17.084859675924401540916036763329531434102347995325) }}, 
      {{ SC_(206), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(21.847726859629994238089786893499406134823761741646), SC_(33.041850930624025842535593558608871159898254682041) }}, 
      {{ SC_(206), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(22.032148859845508432969000390420892699087244168859), SC_(32.835601738093441761047261757092800118543251664037) }}, 
      {{ SC_(206), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(23.584564574970978794509391944398898763920430674589), SC_(31.131677150713404841469549431606925761858638813098) }}, 
      {{ SC_(206), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(31.778858776848783333489726672402304277622904587009), SC_(22.988816678232830277321729576147916333944178032187) }}, 
      {{ SC_(206), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(32.182629743310094596132507819028568051992211944937), SC_(22.620945848692134355446276175134308168121479935629) }}, 
      {{ SC_(206), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(33.948531238901754807266706334480216118368311194164), SC_(21.0457540972546015026397054921509217226594176993) }}, 
      {{ SC_(206), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(34.19154444967564540788744663150729827745269105159), SC_(20.833206675706616008047285447006199287101249227127) }}, 
      {{ SC_(206), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(36.844153972880140130453574561225789815865206625277), SC_(18.577591394433303703765991943674961995227038983586) }}, 
      {{ SC_(206), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(38.270703194383361517478530256309730399620491553468), SC_(51.851276720057441272520319422801271523748857909429) }}, 
      {{ SC_(206), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(38.499452490246258409846582804201209194198992800193), SC_(51.605846415980201205788394197321703436961821665769) }}, 
      {{ SC_(206), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(40.41732492148896418616423906361847507808928480781), SC_(49.572160917996366912830022433416999297475388002694) }}, 
      {{ SC_(206), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(50.345885216515379956062975530380324826032971926131), SC_(39.68292140788005403164530997850380200818182106274) }}, 
      {{ SC_(206), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(50.827796393421846152635552586310609652507583058246), SC_(39.228452666992746477673535229671813856415300497042) }}, 
      {{ SC_(206), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(52.928377154322410676379639500218318709130381378386), SC_(37.273610565593290408935306157099397266609266226615) }}, 
      {{ SC_(206), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(53.21657031001507918717159561142731320570673825101), SC_(37.008692511783125947898866920743550661131647171404) }}, 
      {{ SC_(206), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(56.349213997294072600231850382599820481539780930253), SC_(34.179173463614422501383941710896186112564143631091) }}, 
      {{ SC_(206), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(160.94475344991623381776651278517572463662076075189), SC_(173.65829052278883411089297198473671883284747243571) }}, 
      {{ SC_(206), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(161.1760890578884061942882788069986772532009107712), SC_(173.44578192521071477875207801977361646482490496438) }}, 
      {{ SC_(206), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(163.09093821812428636126543441129002208391598356884), SC_(171.66163660842081450277777713295539978472522372773) }}, 
      {{ SC_(206), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(172.34533987986791678718774687119226890100508458381), SC_(162.36286011580501901408924791591105001718710753867) }}, 
      {{ SC_(206), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(172.76812082320704178237887758009228309418560786813), SC_(161.90910844817194473329400115323380006686201652921) }}, 
      {{ SC_(206), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(174.58384442093617361072480309111940938274608928082), SC_(159.92889446389467387910232780590226333120951285214) }}, 
      {{ SC_(206), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(174.82954764406288283273681172559387821831630517281), SC_(159.65691920266945721328381175613082019560638785996) }}, 
      {{ SC_(206), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(177.44814734610283093929917089062770660714375181941), SC_(156.69610766775371566738606006236197596281252506355) }}, 
      {{ SC_(206), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(165.40610909713538728246297681782391071465705567897), SC_(177.55025518833416256353213154429794434175919318554) }}, 
      {{ SC_(206), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(165.62809258494926449271044682583128573807033687275), SC_(177.34831862374357028350299161588085919773015814441) }}, 
      {{ SC_(206), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(167.46423648419104188035777491689984516305151381582), SC_(175.65134057698183291619500924250503361398075362755) }}, 
      {{ SC_(206), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(176.30197100043386594483943641769109638037038566495), SC_(166.76635969988270336880107060853537140818451938023) }}, 
      {{ SC_(206), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(176.70409694973774055554047056590260876873413400751), SC_(166.33125804838845358229279488859047271390046861163) }}, 
      {{ SC_(206), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(178.42927503898412114572159650296299321368113922819), SC_(164.43092916675078871998711838195037990553852155791) }}, 
      {{ SC_(206), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(178.66248895200305675859574602324700456478973595731), SC_(164.16973872760264058773496138679088300149637470891) }}, 
      {{ SC_(206), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(181.14423990923147341876372377130710504182588150387), SC_(161.32352674255657071169240196803313803210207085352) }}, 
      {{ SC_(206), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(181.27837146722263928461999072330310649392948984854), SC_(190.8266738914945100021307767779253281429869831161) }}, 
      {{ SC_(206), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(181.45706405278310198215387967081583618598833891446), SC_(190.67231833648095469573261179561123203678547647573) }}, 
      {{ SC_(206), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(182.92987822403260991030637064375984069399471838877), SC_(189.36839069366406323041484906495485479883035360539) }}, 
      {{ SC_(206), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(189.8697307019271111906608789961879905392794722574), SC_(182.37121372061945566194158975783198724534184341684) }}, 
      {{ SC_(206), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(190.17872086060439847746565081638488407744904769251), SC_(182.02220655288877281051160233055162790669293576745) }}, 
      {{ SC_(206), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(191.49647704314669097086664432165686292169363356145), SC_(180.49179834667541441615036090680973610038463579386) }}, 
      {{ SC_(206), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(191.67359726892557600568418800857288908961188993376), SC_(180.2806956083239202463901753355523264273952766459) }}, 
      {{ SC_(206), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(193.54216825633241342583637003073385015846001310725), SC_(177.96900675184739194298596553708038177822617950743) }}, 
      {{ SC_(206), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(183.01790091785300223664217243026030826749984957406), SC_(192.21022792364225165289976682114859106933118294644) }}, 
      {{ SC_(206), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(183.19059238515529342907210039309173078950797077534), SC_(192.06233962175761762442321888303795289597572227629) }}, 
      {{ SC_(206), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(184.61313986141623829707905287926306589273882769765), SC_(190.81190033659776960330328627642137638745079204585) }}, 
      {{ SC_(206), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(191.29290997234942188954837038777447833432560738774), SC_(184.07371475766980593460751673829269153750836496391) }}, 
      {{ SC_(206), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(191.58922585900585266172091289782105098961026723479), SC_(183.73661873377596180671158971974835158149991172514) }}, 
      {{ SC_(206), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(192.85161221602488490310892082493780649060085086064), SC_(182.25750341067665243464070091340611578036262028993) }}, 
      {{ SC_(206), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(193.02111770350110172753890340460396815076356493668), SC_(182.05336047154478674430541339163188244107298658575) }}, 
      {{ SC_(206), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(194.80655599138416607090786997661750569819771437938), SC_(179.81617429423748876293856820092078411716784070019) }}, 
      {{ SC_(206), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(196.21474408169899481824031507204467754421988742367), SC_(201.86597943926896950432969198677811617458017504025) }}, 
      {{ SC_(206), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(196.32711789301964964447097170211781478741374368466), SC_(201.78200556799246252571137677498037571502157211452) }}, 
      {{ SC_(206), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(197.24547334356955819817442899044336209459209313923), SC_(201.06037095184991861900975038179886961877017395415) }}, 
      {{ SC_(206), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(201.34033154557400218217685481891586753299188613004), SC_(196.89881012551786094227415493887195514414588407336) }}, 
      {{ SC_(206), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(201.51134982984021674937774239503122803835256397578), SC_(196.68118611734334341451313000590110917904087162119) }}, 
      {{ SC_(206), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(202.22650926749720787234898407602125397263107971752), SC_(195.71776216335552573509230943947840878406499090193) }}, 
      {{ SC_(206), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(202.32075303485910378036418896320280375156824080936), SC_(195.58374833211862847782652069568636188550861099113) }}, 
      {{ SC_(206), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(203.28353559504967870996823283034846986825451617518), SC_(194.09974488322564080707852326205473484714216083982) }}, 
      {{ SC_(214), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(21.162772483801590939634327062225761138047886761269), SC_(32.262334224076235388729137432394297584198538833092) }}, 
      {{ SC_(214), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(21.345286971483899596111911802498515554202957833984), SC_(32.05748274712800795638823706835317996945702084137) }}, 
      {{ SC_(214), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(22.882168921365392980900676956928006340321047134935), SC_(30.365554898463236972054667684997231005032499762766) }}, 
      {{ SC_(214), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(31.008084460010103684476025149187057042437196083442), SC_(22.292273511508589243603997434711709276401811430474) }}, 
      {{ SC_(214), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(31.409012624962784662627644226518243995238206641557), SC_(21.928083555724738961164937613572927901015368275005) }}, 
      {{ SC_(214), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(33.163006244923160043187492604474114985825097433932), SC_(20.369254394404405068290756686702494309810709163351) }}, 
      {{ SC_(214), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(33.404446369198324532489265886403533294332608112834), SC_(20.158992122204350651189744610446328768645098783305) }}, 
      {{ SC_(214), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(36.040881026395751411345039997508300229596730541803), SC_(17.928841536607540467535260316965637897355830516943) }}, 
      {{ SC_(214), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(22.823665727246410556657808450553935850320027862843), SC_(34.233551694968751740094247645614473546469180432654) }}, 
      {{ SC_(214), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(23.011867978638173850702635805689299716621815872972), SC_(34.023525981084251718918941768114658635265537263819) }}, 
      {{ SC_(214), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(24.595737491524441110950227265255026131981152482465), SC_(32.288169384544267112599296172326433384202910043362) }}, 
      {{ SC_(214), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(32.947339507814114666022661911423365583166007721542), SC_(23.987994501393103884241980897364297533207865385969) }}, 
      {{ SC_(214), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(33.358558539951323667167434455232444061892391157883), SC_(23.6126705155565846945314986398937700879790793061) }}, 
      {{ SC_(214), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(35.156765608217871268500983534303005099321294371656), SC_(22.005139378618196077522283553201152115096579573302) }}, 
      {{ SC_(214), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(35.404191864371638959982954355743248738298649148893), SC_(21.788172445112823896320202794833836755137898494671) }}, 
      {{ SC_(214), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(38.104501970337270739994269302341027258797016504087), SC_(19.484744911793079189584238326898891727203007040646) }}, 
      {{ SC_(214), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(39.908250378572563369854160853705385890517146088533), SC_(53.750277898046865485103011228045920327972589623692) }}, 
      {{ SC_(214), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(40.141577031100097586978980333225902127568922263595), SC_(53.500272250595017991878901533622672956260401082599) }}, 
      {{ SC_(214), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(42.0975471414295548954958677744434556766833051154), SC_(51.428500901110090050589579484523592483883485005672) }}, 
      {{ SC_(214), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(52.216752570208216912434709577419342128530699960915), SC_(41.348612661985652418452829480248415352352575078075) }}, 
      {{ SC_(214), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(52.70768851908606377707046116572148179328495052415), SC_(40.885116384183585653492232169570389126544253625779) }}, 
      {{ SC_(214), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(54.847407361283995948366943746727880447146461316974), SC_(38.891117974135438194177233114818313705491411108554) }}, 
      {{ SC_(214), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(55.14094601150247400697589993484735665499587617425), SC_(38.62085095959215785863715417869817072375420704544) }}, 
      {{ SC_(214), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(58.331353173717457866503064018041520000187602275046), SC_(35.733509150862200575503530167729603411530270888988) }}, 
      {{ SC_(214), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(167.34011658039491928646495096671923511580427823297), SC_(180.29850140825448071605570628860670621868878974237) }}, 
      {{ SC_(214), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(167.57573719964400020135739617130942957906233041911), SC_(180.08170524169071604788329562526083277544671606847) }}, 
      {{ SC_(214), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(169.52625395905171120249911448126010309116456309496), SC_(178.26187732492418490762362126334129744311938242681) }}, 
      {{ SC_(214), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(178.95918981825907003902558371045737209253472474435), SC_(168.78457118918805709989665631266976131830819325216) }}, 
      {{ SC_(214), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(179.39042600676166617454866139155938494061104051992), SC_(168.32236778254751478443008406142977008993626322296) }}, 
      {{ SC_(214), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(181.24282755935193322312853276284307997045565522627), SC_(166.30549900875863624870943679018853016663979652376) }}, 
      {{ SC_(214), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(181.49354177379977018697295890403427836007147276447), SC_(166.02851716887605093525127762717275809101348742694) }}, 
      {{ SC_(214), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(184.16632282876844188484729219714746180615915804129), SC_(163.01359996937959110647838619736313559069863281295) }}, 
      {{ SC_(214), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(171.96920204038152121948117684728834392398183564629), SC_(184.34729361237812049894010121584006615282395361836) }}, 
      {{ SC_(214), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(172.19527993848955461361272224786544098196342156065), SC_(184.14125967993385906840589793722506951725434103921) }}, 
      {{ SC_(214), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(174.06550381761056661755512862755830915396840307688), SC_(182.41018433003964651089353674826655420127006704443) }}, 
      {{ SC_(214), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(183.0738188964916743666227709602094034230327587355), SC_(173.35462814480632107687884608954140246779110961333) }}, 
      {{ SC_(214), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(183.4840244281756621909574339268135576775616317557), SC_(172.91145095937959419726702769005977864601883152016) }}, 
      {{ SC_(214), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(185.24425384727550029999727789945951204601800947261), SC_(170.97609754294822218275204695644340334467000470885) }}, 
      {{ SC_(214), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(185.4822569642000188169988604629282276480015888045), SC_(170.71012301067829495180466242757854204482176971863) }}, 
      {{ SC_(214), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(188.01580039352860113027294492132434638278858817591), SC_(167.81220641139037720249957261238702341320968650437) }}, 
      {{ SC_(214), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(188.4325574153516192424059904638152493280210755505), SC_(198.16514605515319099091399546135565909705098618028) }}, 
      {{ SC_(214), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(188.61447627433107925901280232325584165881967634559), SC_(198.00755869023522753004209537534177502822680027585) }}, 
      {{ SC_(214), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(190.11413861540468675410497759596508678146789254736), SC_(196.67675075118672718153277228384936039633538764468) }}, 
      {{ SC_(214), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(197.18833980079893427505526347558781322962473255645), SC_(189.54523474929987201135413021443974587645237503422) }}, 
      {{ SC_(214), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(197.50369932913223119232065883254099148494319193216), SC_(189.1898657126411840402789662333083270884151933103) }}, 
      {{ SC_(214), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(198.84910503873211260109023307139545481736736378761), SC_(187.63185825024948912813081498766658281313004477674) }}, 
      {{ SC_(214), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(199.0300057905118862974084433281352760077138577808), SC_(187.41698466483315938521604508282055478205811672832) }}, 
      {{ SC_(214), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(200.9395173280453902556214027545910465637333795313), SC_(185.06452432453978257074875698763558735461169378492) }}, 
      {{ SC_(214), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(190.23615855821068410480835366710755890400759548994), SC_(199.60596931300219702245327722823819349658100222722) }}, 
      {{ SC_(214), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(190.41195738157278320754678939189990781450032674917), SC_(199.45496761638711103723186914810241317441426467009) }}, 
      {{ SC_(214), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(191.86036231611967858793372311089409391196018127444), SC_(198.178635901231620210071042307844889617567427561) }}, 
      {{ SC_(214), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(198.66951736337970294678784288138597481705704281954), SC_(191.31107590674657581199990825238336399622297316728) }}, 
      {{ SC_(214), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(198.97196852089573033396045648477945238464165534807), SC_(190.96785277536385337464583053127922075262454622392) }}, 
      {{ SC_(214), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(200.26099189088078309284913138591517632546991831337), SC_(189.46215529551464422978604935487100669649972026972) }}, 
      {{ SC_(214), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(200.43414003134692188790140699103760662080913587563), SC_(189.25438028588651793302841895396545992642714397619) }}, 
      {{ SC_(214), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(202.25903810481684720100819434864150708628716184592), SC_(186.9779197925510405185079114422646844639712912107) }}, 
      {{ SC_(214), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(203.91065566998727328985635292785745314865108450243), SC_(209.67187282633954047782498755993481636616964149598) }}, 
      {{ SC_(214), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(204.02495692168816984983313657888728273128571552443), SC_(209.58595624529602077363000376590374775394561635762) }}, 
      {{ SC_(214), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(204.95933750365910578974838829789629813866951137533), SC_(208.84821202796014949833074313608127576992235484317) }}, 
      {{ SC_(214), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(209.13430595807359314799398970103330681241404313442), SC_(204.60656549405027759469432672256418270194461865896) }}, 
      {{ SC_(214), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(209.30914107437193740781301200822407809434886096884), SC_(204.38514427446105271483944622138793518402770495779) }}, 
      {{ SC_(214), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(210.04093139100107920513143703460290161124985420256), SC_(203.40522965341719001424309703031084742431242769643) }}, 
      {{ SC_(214), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(210.13745892726619524853779004358088411095059305544), SC_(203.26896031860690231167451218338259828425241387316) }}, 
      {{ SC_(214), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(211.12520383520358422457098218860339209090229234977), SC_(201.76052813772729760013454384486072757565066780675) }}, 
      {{ SC_(222), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(22.075651482215534448710792571338339949994817923514), SC_(33.381251886862847036303689961626205441228796210201) }}, 
      {{ SC_(222), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(22.261776005634421050754474315356119259580799414978), SC_(33.172794102077707312834820952454574443956347003926) }}, 
      {{ SC_(222), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(23.828695030763343855167009343632980089492120984676), SC_(31.450850946332090003617417416841144588484139413079) }}, 
      {{ SC_(222), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(32.104828656398436175709433784069325422612378949035), SC_(23.227344884328609559496981395970937502645250614143) }}, 
      {{ SC_(222), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(32.512869188325678897797215742433452454065017191252), SC_(22.856037475944557447979434236071344166228838196675) }}, 
      {{ SC_(222), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(34.297712319226353031868985349867867274511813342081), SC_(21.266325004913108280689643127996564869828101238486) }}, 
      {{ SC_(222), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(34.543366586252992292173113299482725758612218478527), SC_(21.051842123325704632666509580241825857310897059858) }}, 
      {{ SC_(222), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(37.225351820966099885707303025641035620828754445719), SC_(18.776029209175093625518071571341247894210774081767) }}, 
      {{ SC_(222), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(23.801606566056829151478074105339465806040033431397), SC_(35.423249868430489106590798507802132429254399284638) }}, 
      {{ SC_(222), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(23.993518561802574052693087487984455346049467366657), SC_(35.209517875254548295495455292340892241144783395963) }}, 
      {{ SC_(222), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(25.608256408582075171562583672761166278343182841585), SC_(33.44331319785693297263767492932823914431026465904) }}, 
      {{ SC_(222), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(34.114249237764037760530216251821320050509379068056), SC_(24.988741368001083954384265548220276431750227526737) }}, 
      {{ SC_(222), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(34.532777972676251308994183746645413799448731716569), SC_(24.606102947269530485877627150471614633079157063277) }}, 
      {{ SC_(222), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(36.362689621768336325873812327786672215953359614533), SC_(22.96683582092123205718497805386476542219564810546) }}, 
      {{ SC_(222), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(36.614446704897159025712005224154904272053927065978), SC_(22.745532056965049867342397342546226170422254157051) }}, 
      {{ SC_(222), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(39.361566467271892762855102429064878378488787210289), SC_(20.395191291543288653217839347617976731121609042622) }}, 
      {{ SC_(222), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(41.548221176624897683908435128073611748553759433777), SC_(55.646855180853351384158739006044882876217366393396) }}, 
      {{ SC_(222), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(41.786040049858636736116000391598151311678779743108), SC_(55.392359182199731401830505115468659732629898890394) }}, 
      {{ SC_(222), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(43.779400198661862376051190981715048482625755481169), SC_(53.283208780803369700025410712313908434208030433289) }}, 
      {{ SC_(222), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(54.085718354358538863255197804125310324034113860802), SC_(43.016204474347803007626872769034306434594953404473) }}, 
      {{ SC_(222), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(54.585511596583482507678474973531144692971122322702), SC_(42.543848334775107281393560204612012938304804030677) }}, 
      {{ SC_(222), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(56.76364136717006010725146453405188594454304015312), SC_(40.511422072080642874051771701590126121798217940467) }}, 
      {{ SC_(222), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(57.062426076483591962340584377822425592790685393801), SC_(40.235905781122549452800450814738011647050693438258) }}, 
      {{ SC_(222), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(60.309519959411178581073420898153492183058169404249), SC_(37.291822254154429239042123394283443134569401683765) }}, 
      {{ SC_(222), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(173.7377504362100797907865614244066797804400391504), SC_(186.93644194545116349020007355206134682112349740152) }}, 
      {{ SC_(222), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(173.97757643695194657617829748496838730450953128173), SC_(186.71543802204271861044032677516883944041333564452) }}, 
      {{ SC_(222), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(175.96309866130980754913383544072434704139570256322), SC_(184.8605907034876006077609664694002391484064402758) }}, 
      {{ SC_(222), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(185.57125967346380308236924708923751392897806476803), SC_(175.20806364733391500106963727044115453844303332693) }}, 
      {{ SC_(222), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(186.01079396389421406079125367888113635410170122722), SC_(174.73756539637066161116620534318604447677720530453) }}, 
      {{ SC_(222), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(187.89919053124675676715975553584277419418885596567), SC_(172.68472311954115664459852306779963814556353330698) }}, 
      {{ SC_(222), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(188.15482224501327984549718539362012368944773189588), SC_(172.40282787637289641820784290928263311300702827005) }}, 
      {{ SC_(222), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(190.88076999968029416412383286809828494738588388347), SC_(169.33481418718505003342746464718201635257399760663) }}, 
      {{ SC_(222), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(178.53446518005775467603537054437092121594731025745), SC_(191.14216229402838794789553070001720559364050939287) }}, 
      {{ SC_(222), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(178.76456137813479944818878637626633908625016453228), SC_(190.93210731462766361469838934002989823560429283962) }}, 
      {{ SC_(222), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(180.66823242051517550815479847309366990559537711552), SC_(189.16756870440367922611938460197603345053455702718) }}, 
      {{ SC_(222), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(189.84396580713980084815119941885821805207334213221), SC_(179.94459909557891563744332338077444471613308555909) }}, 
      {{ SC_(222), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(190.26210068726390380415424140251509410807813939504), SC_(179.49349632377135172307379572670379814799109234257) }}, 
      {{ SC_(222), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(192.05672834213438406447509778803661898749254273734), SC_(177.52376955626169742075994847109989752253748731068) }}, 
      {{ SC_(222), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(192.29943122919016031624472300081570877491909743368), SC_(177.2530999981368544011608171387591712919477882288) }}, 
      {{ SC_(222), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(194.88379593350740124574824270251716692443346751333), SC_(174.30444361939690809426679181149520160810098380679) }}, 
      {{ SC_(222), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(195.58845608043654531418756328396519012855935571351), SC_(205.50190660597022816930089634921394101277791077458) }}, 
      {{ SC_(222), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(195.77354112365960540355547311046731257549478820506), SC_(205.34114790994292353434134347261773097281154965779) }}, 
      {{ SC_(222), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(197.29955230592833119577959102951928636687090714166), SC_(203.98396124012956597516936793524774400688509468436) }}, 
      {{ SC_(222), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(204.50560836866116324860398103185232167846066368545), SC_(196.72059937094716703916617775121960755457371254159) }}, 
      {{ SC_(222), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(204.82721842899695696369379757138887525135207809702), SC_(196.35898678134797198240462638387131070103834615641) }}, 
      {{ SC_(222), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(206.19975596351423177028427508907861999728623496896), SC_(194.77389421831184312690258313302735805133813143958) }}, 
      {{ SC_(222), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(206.38436617940528236114276985243063824369797410233), SC_(194.55532015765775346615072450925364379542157253532) }}, 
      {{ SC_(222), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(208.33404287187629769269999841105595532615205646124), SC_(192.16285146036441661341297000390510632928558660957) }}, 
      {{ SC_(222), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(197.45606632351597401947877413963079704978249081671), SC_(207.00006184293618967276312344593518326750696224036) }}, 
      {{ SC_(222), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(197.63491460715946598904233792727435327355631941446), SC_(206.846005071123720098247452525462245341220099781) }}, 
      {{ SC_(222), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(199.1086959512471880596687907884884171666885215703), SC_(205.54426440022745003933681492381458807922912492255) }}, 
      {{ SC_(222), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(206.04483364857600390926171490214300981821651228151), SC_(198.54973155304732552883768498387321402754023595899) }}, 
      {{ SC_(222), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(206.35330552712174963622566369342982052777144119602), SC_(198.20049529851824456865758830202774466374416226223) }}, 
      {{ SC_(222), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(207.6684666538516359467964496648984563401499414707), SC_(196.66871105806562131385207139712897184246028426197) }}, 
      {{ SC_(222), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(207.84518888095197186262431937397506037451307721103), SC_(196.45737179102267276237407825714439192670120674814) }}, 
      {{ SC_(222), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(209.70879774960982647931920552976821339654521926436), SC_(194.1423725124478282173836138168924173005708759884) }}, 
      {{ SC_(222), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(211.60759842607732799593023523928257989265859720924), SC_(217.47674287464110737147857199585747972110101301072) }}, 
      {{ SC_(222), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(211.72379097489494726338684547793767775332626491374), SC_(217.38892067812664578211836652266604987876975448284) }}, 
      {{ SC_(222), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(212.67389703843098741754532637353660730487978852501), SC_(216.63537155671649499714296278932620239374930738911) }}, 
      {{ SC_(222), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(216.92748334884253879787903315424519148793445853664), SC_(212.31513029411234732068059133801849671156577232915) }}, 
      {{ SC_(222), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(217.10606313049154264453403678916557952510909467838), SC_(212.08998286287217825714757472579220822424703608171) }}, 
      {{ SC_(222), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(217.85416614490925201306213062780973270905954528841), SC_(211.09388694215416336689356118034100273959460827161) }}, 
      {{ SC_(222), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(217.95293315411079944675369856869647581289913405481), SC_(210.95540455810456764540795701501508864617976770428) }}, 
      {{ SC_(222), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(218.96514143959665680037293283822877762956122238473), SC_(209.42300588305336358953465670911266182210853024906) }}, 
      {{ SC_(230), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(22.990374109425856771198081930864891864605488975338), SC_(34.498325315468400592483184263868955479312471844936) }}, 
      {{ SC_(230), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(23.180043728459829088029951881143001575722551245874), SC_(34.286325907672760594461400628691768985872193079046) }}, 
      {{ SC_(230), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(24.776460617945565616070794247602094149835896344904), SC_(32.534905176031495184927574501962163469553261044207) }}, 
      {{ SC_(230), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(33.200126063367838617456716599272417679378389873731), SC_(24.163861151593770861011108332085599316255719150547) }}, 
      {{ SC_(230), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(33.615151545841053629300654598081316061951224708875), SC_(23.785564052473325570967715375051794904627587316237) }}, 
      {{ SC_(230), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(35.430290743937693739445314668784456063815630235439), SC_(22.16552403412696261217577575762827699246822998332) }}, 
      {{ SC_(230), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(35.680083440381837508353482596108807793493820543552), SC_(21.946896703392142944568960381748307533418221153806) }}, 
      {{ SC_(230), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(38.406798825524904439197068019200645908508499155283), SC_(19.626249706946440622273701158347826169749054396174) }}, 
      {{ SC_(230), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(24.781441910429272788461972957923115260752241015309), SC_(36.61105298923368575529444868523436828094660153038) }}, 
      {{ SC_(230), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(24.976996948859544618307842089539294251083120351326), SC_(36.393681180869966331953181770346976208824196502124) }}, 
      {{ SC_(230), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(26.622049195028980632678579204198589638734075359602), SC_(34.597180978154094014329530308115465356549581338217) }}, 
      {{ SC_(230), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(35.279672306202712327784613513486686985020436413306), SC_(25.990973148025214150214934215709906768973308252895) }}, 
      {{ SC_(230), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(35.70537981465433775465490203520503909256321919759), SC_(25.601151543600326763729213095289149934154901655509) }}, 
      {{ SC_(230), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(37.56642738268604359638212943551058546368832785706), SC_(23.93071924661222583336123847164066747008704486751) }}, 
      {{ SC_(230), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(37.822437503095514451306136409188346871920943385776), SC_(23.705156857020421970971168509339389076403036542447) }}, 
      {{ SC_(230), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(40.615524091836104743830937279523859453724791589108), SC_(21.30875293467714080937057105436059276169549161005) }}, 
      {{ SC_(230), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(43.190485596312487497231477415189383369924577405755), SC_(57.541138592564768196823728657393994128055740644123) }}, 
      {{ SC_(230), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(43.432716135835219976748821844487205427387774384781), SC_(57.2822326682075756486957476403299166099795260793) }}, 
      {{ SC_(230), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(45.462796711623259593085335000902812710186155520157), SC_(55.136372071950822811395060263276357928471108663952) }}, 
      {{ SC_(230), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(55.952884542714955889568437306551600269487088260305), SC_(44.685594978374621535571499663868728958638997639717) }}, 
      {{ SC_(230), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(56.461376590099193483225761565129531659269596155496), SC_(44.204537641515569983588377942599673102324619049742) }}, 
      {{ SC_(230), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(58.677229212363375748921972098688242467043654003687), SC_(42.134372771112420085069064936440330058762852335364) }}, 
      {{ SC_(230), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(58.981165894841698931088190268990910764220181618059), SC_(41.853701512688181579205850281025992278661113385921) }}, 
      {{ SC_(230), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(62.283927783565249242153208562398093751355737739969), SC_(38.853898821621932943909588681961160155717822448157) }}, 
      {{ SC_(230), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(180.13753317062401619927121874828773979410475167843), SC_(193.57223393793857420738459494011696629915960214828) }}, 
      {{ SC_(230), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(180.38148920296023843594975401813304987086646163641), SC_(193.34709777112030423926417936955468707580250665135) }}, 
      {{ SC_(230), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(182.40139031208442415759442886685213740087739603782), SC_(191.45785858567811553553504484771009597340520525443) }}, 
      {{ SC_(230), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(192.18164486752191027342178453893014323255508491128), SC_(181.63324192987697845096630751795293228434310210772) }}, 
      {{ SC_(230), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(192.62932856661223485684334655580171443687339939125), SC_(181.15459730481600096653310993086443832720409423491) }}, 
      {{ SC_(230), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(194.5530740026044331183144232587497934366137110168), SC_(179.06642618830997306244641623469741409985143645477) }}, 
      {{ SC_(230), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(194.81353477118928769662220675786434334771615122096), SC_(178.77970570260928216455218637114431427198908792729) }}, 
      {{ SC_(230), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(197.5916895681743394598225732769270882138005407265), SC_(175.65955027655541629760389577611389754133053614254) }}, 
      {{ SC_(230), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(185.10178203504889908318351535554007369062976397489), SC_(197.93497766199157337471513780148273701233044723363) }}, 
      {{ SC_(230), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(185.33582451446410770055804493439849958197609495775), SC_(197.72097384313754530325815329560555658242730630759) }}, 
      {{ SC_(230), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(187.2723438899539214661120837377714177766584526016), SC_(195.92357190328304837332514304562571701415318462662) }}, 
      {{ SC_(230), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(196.61250292278072684244667437723361031705821679337), SC_(186.53618119984253950013956393356509627726885391901) }}, 
      {{ SC_(230), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(197.03842499974012113532246823916369859811888062744), SC_(186.07729473619626229057592048954011979678921691903) }}, 
      {{ SC_(230), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(198.86683300685238213184277812237422057494114210937), SC_(184.07381078790187517881801138947706363370073053287) }}, 
      {{ SC_(230), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(199.11415106321359445750839345577032099661771555785), SC_(183.79853047627696423600938613225568123130106713202) }}, 
      {{ SC_(230), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(201.74841856161343312768616829655745639568010163451), SC_(180.80004710328085321424617689453006122007139091329) }}, 
      {{ SC_(230), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(202.74597538004017960479006978088598777012242110478), SC_(212.83704749305832905819481918507949244046005242521) }}, 
      {{ SC_(230), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(202.9341697535945235277569202379035374700196212431), SC_(212.67317466982744810501133797731551287545699924554) }}, 
      {{ SC_(230), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(204.48605729870651082112375114674999526352540340844), SC_(211.29008375936594005552230632205903781070438279983) }}, 
      {{ SC_(230), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(211.82160829704885965588072792758965043858889533452), SC_(203.89723536274256339547394888216412941363036583463) }}, 
      {{ SC_(230), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(212.14935646617892613497224527371392799823134304926), SC_(203.5294911741759841501027192225378419728760862684) }}, 
      {{ SC_(230), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(213.54853617342538331097907556015836527983318604919), SC_(201.91779997769331697450634953323622662621290620303) }}, 
      {{ SC_(230), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(213.73678865811870092476798293638319283351479473906), SC_(201.69559201814242163355292317921402046134725592952) }}, 
      {{ SC_(230), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(215.72589765999348742823625160562144598752204955114), SC_(199.26383682712513874361492564625952871143632574633) }}, 
      {{ SC_(230), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(204.67753546635619085187418584931787235058967636215), SC_(214.39259410689922923829519395568447638800061232233) }}, 
      {{ SC_(230), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(204.85937843253343821796463070021080802396403476608), SC_(214.23553741843709030526282401532871901527327826276) }}, 
      {{ SC_(230), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(206.35808101048831266145978251966973040457887010009), SC_(212.90884515000529623195188951717649504323885656266) }}, 
      {{ SC_(230), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(213.41892806908458491930557708219932376712044183127), SC_(205.78961208736188135254587854312631416219493278092) }}, 
      {{ SC_(230), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(213.73331230586213200308852919753806823875917450473), SC_(205.43447056357392468306493084023609276108940314922) }}, 
      {{ SC_(230), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(215.07413901117804188272860040784160738351384645738), SC_(203.87706827297154877137276832160928578320122407254) }}, 
      {{ SC_(230), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(215.25437049474444194814448169211873091690799754513), SC_(203.66222890285450964789441221341795006099965941888) }}, 
      {{ SC_(230), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(217.15598236717119081356889902519754641977961889954), SC_(201.30938658128525235849488443807182274988387464487) }}, 
      {{ SC_(230), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(219.30551650631683486463874450767869863111356190895), SC_(225.28064438465584511690803186412539698039786909943) }}, 
      {{ SC_(230), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(219.42356616374812279018614679461905567310980045576), SC_(225.19095163082239418561768723202065677533843107596) }}, 
      {{ SC_(230), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(220.38911422567610607460269330206140060268047866406), SC_(224.42188572618435364847317253094558005572034211413) }}, 
      {{ SC_(230), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(224.7199061611748966458545840959825018252831642775), SC_(220.02446065792007296710852790377202439157339319117) }}, 
      {{ SC_(230), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(224.90216236606136993533143221928970849086188561731), SC_(219.79565418433534197696933767243875292242508350475) }}, 
      {{ SC_(230), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(225.66627739724161771773759933232020162387854155179), SC_(218.7836695936338792316843454312325618311912957045) }}, 
      {{ SC_(230), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(225.76724205249889985919818917474656334042439971764), SC_(218.64301431147040190271965044544802396881519186816) }}, 
      {{ SC_(230), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(226.80344341921146672695936402356412933895820615256), SC_(217.0870861983845640535308816947899070278742188759) }}, 
      {{ SC_(238), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(23.906844806356379286625728829766000823339815711318), SC_(35.613650137680403064308039015767459690711145648916) }}, 
      {{ SC_(238), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(24.099997965439939416049001938986046869259708457861), SC_(35.398170432470690796916563974448520198574478126096) }}, 
      {{ SC_(238), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(25.725401549802624082471011105494889880394313165184), SC_(33.617781960421874540705720590601452012065352797248) }}, 
      {{ SC_(238), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(34.294051681149170598914574665214218030180303552516), SC_(25.101747509199610769922975914644956909225693167106) }}, 
      {{ SC_(238), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(34.715941307529035563220878806942403285048454457722), SC_(24.716581837426727616169219627714383526083392265612) }}, 
      {{ SC_(238), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(36.560851875716716465983791306870530228771968304666), SC_(23.066741057107332107263804392066018474322921476846) }}, 
      {{ SC_(238), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(36.814711226056765948534366643535140631238666070371), SC_(22.844041454918597176017068615102700017917541684175) }}, 
      {{ SC_(238), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(39.585379098501335445529916462375421310248283217756), SC_(20.47934506625371427696056845434282105699584194346) }}, 
      {{ SC_(238), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(25.763073576820120954911122152411841655776629709405), SC_(37.797059302702842337114571847794603860455210029311) }}, 
      {{ SC_(238), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(25.962208430927336121372176503047868141491551894219), SC_(37.576110692190211444744430183287839924810052058002) }}, 
      {{ SC_(238), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(27.6370499388870429406162300952902731199194466984), SC_(35.749838858825513555294954585405504985363975529802) }}, 
      {{ SC_(238), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(36.443685765905320124026390097891748926386348806012), SC_(26.994612969316237683725729712392540574530747872189) }}, 
      {{ SC_(238), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(36.876447909765846951570510632934194117941950210199), SC_(26.597732609555537844242224744002185735061078572325) }}, 
      {{ SC_(238), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(38.768092266960217551757226862326461907429226276656), SC_(24.896676214003366977607935204449109044169536262032) }}, 
      {{ SC_(238), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(39.028281679941112047838034363590847891843849200876), SC_(24.66692931702584623123135287793660799241407865529) }}, 
      {{ SC_(238), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(41.866536185623124078047235474311487721083603027847), SC_(22.225267658363547828618478411399921892801522040514) }}, 
      {{ SC_(238), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(44.834924865577598008748296585605084670855554510111), SC_(59.433246932485926977038326268225377386521996878706) }}, 
      {{ SC_(238), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(45.0814907017210739123609349548391539672117504359), SC_(59.170007336060511265090955157920435552113887439629) }}, 
      {{ SC_(238), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(47.147656833089453957708069987585249162695118442833), SC_(56.988070737009081898490901632752314119343030572902) }}, 
      {{ SC_(238), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(57.818344308160911837620806215013395852632313842042), SC_(46.35669109371882107128732566148019489495694313364) }}, 
      {{ SC_(238), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(58.335384886355549663007820695155553453994694208333), SC_(45.867082992677039975641379672032326810200821735837) }}, 
      {{ SC_(238), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(60.588307980976013199172576602999008241717644909412), SC_(43.759832945230228737341473319893966412535689951224) }}, 
      {{ SC_(238), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(60.897307437149733030904913872012004167797348054788), SC_(43.474096119422445102299003541555234402081547802692) }}, 
      {{ SC_(238), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(64.254771623335710094404996130371149432631935941901), SC_(40.41954342346156612463171283694212008097416058715) }}, 
      {{ SC_(238), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(186.53935345893756168917971261934397287266777104317), SC_(200.20598867354831499618563976758521484272649594187) }}, 
      {{ SC_(238), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(186.78736808274261805193378721179688231839856202385), SC_(199.97679185066410945405177068070323845863593378252) }}, 
      {{ SC_(238), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(188.84105397859871423568375931754673331880552893408), SC_(198.05375575629111577943822453020075652930281782395) }}, 
      {{ SC_(238), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(198.79043259137910889835086248612540758425862589588), SC_(188.0600187264721346424185601382668810125956412072) }}, 
      {{ SC_(238), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(199.2461247245925018019046213281132347793543271145), SC_(187.57336850094257666145101526892733016253909297769) }}, 
      {{ SC_(238), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(201.20460648680106122774223018237237689972979127786), SC_(185.45047975254863276268104505021210747158043169902) }}, 
      {{ SC_(238), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(201.46981247461881436839136318889503606307450227781), SC_(185.15901760463837865013399125026624510673613073571) }}, 
      {{ SC_(238), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(204.2992648541538761824254134688991108922891679573), SC_(181.98762549332147876839486356611645189289118254715) }}, 
      {{ SC_(238), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(191.67104618527377479162564324817250431907286281925), SC_(204.7258460916511777824509383055697562455012690111) }}, 
      {{ SC_(238), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(191.90896666518310897696390334449738231084384940894), SC_(204.50796188424098676038891962305132859175591604151) }}, 
      {{ SC_(238), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(193.87776659318019462069219215129817671902043860738), SC_(202.67826538685664048069789303646550885401776451336) }}, 
      {{ SC_(238), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(203.37951356733375496101262647159894418747520088317), SC_(193.1292909939298746328210730082336470195928934424) }}, 
      {{ SC_(238), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(203.81308807210764556485956675219791309739681245124), SC_(192.66275537586016354737530334330050324473015463468) }}, 
      {{ SC_(238), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(205.67469070336870015840742158928144903296071707052), SC_(190.62609843256753891539616808536596263652232408315) }}, 
      {{ SC_(238), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(205.92654374081040862221476403369870735178069775886), SC_(190.34628726014879675076195056570210980643892673368) }}, 
      {{ SC_(238), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(208.60984366230350000187008318072645536083715271716), SC_(187.29884214484937643631836154379428025536299650953) }}, 
      {{ SC_(238), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(209.90503119791610653368270501062687484616224398615), SC_(220.17065271968803267678290304697121578132814651326) }}, 
      {{ SC_(238), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(210.09628100298419958357674146411763860614622476349), SC_(220.00371998362186211949004799905023233599845847165) }}, 
      {{ SC_(238), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(211.67359696036298672304051239096529947917023515061), SC_(218.59517459890618842724576991997070785900681960386) }}, 
      {{ SC_(238), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(219.13640527607439148076986860222887763847696702233), SC_(211.07507674938184180922940329073747821826544207066) }}, 
      {{ SC_(238), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(219.47018498816813496337669484949237517896835066932), SC_(210.70130710409736304182572905469284465013497668135) }}, 
      {{ SC_(238), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(220.89554282027906439051521622233997158961478618391), SC_(209.06347845123556765881616440386292824592200666599) }}, 
      {{ SC_(238), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(221.08737390642770056152174195305250495751556909285), SC_(208.83769970284123740362691172450856962434707626852) }}, 
      {{ SC_(238), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(223.11522116141590765942558864546550744298046102157), SC_(206.36734220489646183876648241034341624556452771149) }}, 
      {{ SC_(238), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(211.90048491940958611768566572605343020148504258822), SC_(221.78364704189204024293930345117763374550638049273) }}, 
      {{ SC_(238), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(212.08527063832985362525408803015784342208923502013), SC_(221.62364271001377434241613413730174157472608908433) }}, 
      {{ SC_(238), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(213.60846290920137692648458338007972959858279733227), SC_(220.27243235583536051335425054629427860393701389585) }}, 
      {{ SC_(238), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(220.79186389387056084335334162698185394351216545564), SC_(213.03065392401640963017777058563591567806169430264) }}, 
      {{ SC_(238), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(221.11205777548888400226436211919693548783549216597), SC_(212.66970938475193302744093027266984604629769887065) }}, 
      {{ SC_(238), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(222.47810259615147814358493694462020816032775917175), SC_(211.08713338063144312478305606891204670851326294038) }}, 
      {{ SC_(238), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(222.66178191454419468742241573805890872572213466458), SC_(210.86885472046394165905895297130461698488751150586) }}, 
      {{ SC_(238), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(224.60072654835301175517214072404278294496330747028), SC_(208.47882876960797804030418809845117517043989598443) }}, 
      {{ SC_(238), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(227.00435892982268321097831779428430665675568517216), SC_(233.08362746531821679925838613901691903568277710517) }}, 
      {{ SC_(238), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(227.12423329232302164021532925318751780991148857485), SC_(232.99209735425762794002055224849888052929181925604) }}, 
      {{ SC_(238), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(228.10495463494254871890689034606855155416158157137), SC_(232.20778765063144303968598832132013726971903920752) }}, 
      {{ SC_(238), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(232.51161322309181010680650477077498373949457388364), SC_(227.7345165414559973222062548023804471799101412904) }}, 
      {{ SC_(238), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(232.69748119293212311185277645173754200932898380079), SC_(227.50211469636557995735888175583511798992190201922) }}, 
      {{ SC_(238), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(233.47732352689595314759772470577961202317067589899), SC_(226.47451878206648282379076459424955092347681519405) }}, 
      {{ SC_(238), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(233.5804462517740876833936268335969273470596937519), SC_(226.33172865032231758939346705264400439781074880008) }}, 
      {{ SC_(238), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(234.6401964753038481673555208066266268464628259214), SC_(224.75268517484635502868694763021283753295593434901) }}, 
      {{ SC_(246), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(24.824975992805908699769320355760625637270966665235), SC_(36.727313992488324192699393100987859248831802654318) }}, 
      {{ SC_(246), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(25.021554236710992549874110275376724923448734677051), SC_(36.508412237210762579018239730815087596732310269897) }}, 
      {{ SC_(246), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(26.67545903837284788979493125844810279847408591774), SC_(34.699540295555641502420622243186267311128816863671) }}, 
      {{ SC_(246), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(35.386674245576286624642488509292037375527406607215), SC_(26.040935391286501531742082828490338266474767475603) }}, 
      {{ SC_(246), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(35.815313266699152589900692474879848141663650235575), SC_(25.649016177790667227295601653762520126493339595147) }}, 
      {{ SC_(246), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(37.689496849639530288360343366126042227263615184492), SC_(23.969874878175576684985720842595664042527434500116) }}, 
      {{ SC_(246), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(37.947354686343750049877377841176881987049641708974), SC_(23.743171535274102719986649050458142434730719579569) }}, 
      {{ SC_(246), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(40.761236557952940071619813234867960159430641567032), SC_(21.335170580685224926328381491733185414540812109475) }}, 
      {{ SC_(246), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(26.746411578895360933357362713830400320040043483272), SC_(38.981358848067790320342558768699634369334308858501) }}, 
      {{ SC_(246), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(26.949066204689153479366193565298313752939390540612), SC_(38.756893286003084514495651980973399189113822486838) }}, 
      {{ SC_(246), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(28.653198221750296810779717147542478387527179936595), SC_(36.901347450479323381489955546670718314198990006217) }}, 
      {{ SC_(246), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(37.606360234973974803691615171437774902869139386214), SC_(27.999590370350015841126056743242126167117777371354) }}, 
      {{ SC_(246), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(38.046059099814852020607911065528773058795420852325), SC_(27.595769432204075219961951619129267217138589538745) }}, 
      {{ SC_(246), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(39.967788178258506935884324350269508194184446319284), SC_(25.864602761238729443126385280939005246057126946639) }}, 
      {{ SC_(246), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(40.23208684534334141199149310283410315015829645349), SC_(25.630741732672471254277613906172942155962648304289) }}, 
      {{ SC_(246), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(43.114750593870975201587937060070572853629041828021), SC_(23.144586884833444868790810625093826221403156549256) }}, 
      {{ SC_(246), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(46.481430121835658051233473294707762858904164122795), SC_(61.323289086637985024136144883829512487793020920876) }}, 
      {{ SC_(246), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(46.732258719398276441284912384308539508402989377474), SC_(61.055788248537728729000315509420028901635291065305) }}, 
      {{ SC_(246), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(48.83390737098082241521098072672368414144436468986), SC_(58.83837806817470214182338577368358088366561330001) }}, 
      {{ SC_(246), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(59.682183050758127324761905396532140735841452765659), SC_(48.029407500645241522664142554433617805982288044642) }}, 
      {{ SC_(246), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(60.207629413439358831310446535501435734413309423554), SC_(47.53139152520913212865827324262279224998292121874) }}, 
      {{ SC_(246), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(62.497003315031813781217177672492976354708039626675), SC_(45.38767691564795850599306702066432665794019928113) }}, 
      {{ SC_(246), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(62.810980823086555642446557551360301394612002578105), SC_(45.096959425382113876460063102437814536671691632413) }}, 
      {{ SC_(246), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(66.222230162712111146987398311687849935536377455498), SC_(41.98857698172342258089683296211857804207957121275) }}, 
      {{ SC_(246), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(192.94310926874513120035871151756314653390555111067), SC_(206.83780815302224185941630967557338456670762464566) }}, 
      {{ SC_(246), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(193.19511462686421702629379473792586143306964236789), SC_(206.60461866422727823969840748233333845691622487742) }}, 
      {{ SC_(246), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(195.28202098085115083697649187888540968617308461941), SC_(204.64835076679132854526902199080493407571110298176) }}, 
      {{ SC_(246), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(205.39770276575815765786859385697513605668321531469), SC_(194.48831401279429896327974391489750012096079742852) }}, 
      {{ SC_(246), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(205.8612694316934239923004074926171926097598450646), SC_(193.99379190659136861137693119252843239872990892003) }}, 
      {{ SC_(246), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(207.85390576549401042617645786114610826990450665913), SC_(191.83676607533845414029271401674278218217710515145) }}, 
      {{ SC_(246), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(208.12377735886619719540533625365669961557574850684), SC_(191.54064164843148528921850122890514470349600811985) }}, 
      {{ SC_(246), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(211.00366382720873561960736577246122319781684108006), SC_(188.31887236904197436486078836824287221066200997439) }}, 
      {{ SC_(246), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(198.24216009556045821647960715414811407769998699764), SC_(211.51486507983241115369120753984811627152383548972) }}, 
      {{ SC_(246), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(198.48389372042018684822302775260736558731771791723), SC_(211.29316549306192069101551332346033496811571934239) }}, 
      {{ SC_(246), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(200.48443487638553091630607435917966442158337988682), SC_(209.43171465907060955255651472184406775112304800983) }}, 
      {{ SC_(246), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(210.14507411655711489776401838291359806486696454507), SC_(199.7238519808627685424119739854394475408312549012) }}, 
      {{ SC_(246), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(210.58617304494818454626723630235677713507703049534), SC_(199.24979500316714787812476457252006981879357018883) }}, 
      {{ SC_(246), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(212.48041403134527252007298687415821017169536985284), SC_(197.18051994051905020882407511275640569366348825842) }}, 
      {{ SC_(246), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(212.73672590337753719022256330084334965801420110556), SC_(196.89625378696730083453769700424684130574164532749) }}, 
      {{ SC_(246), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(215.46823192542799148314418817835727493601103166185), SC_(193.80066863426554290229212494564632817202394778901) }}, 
      {{ SC_(246), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(217.06554645138728560254746552815753310805445432838), SC_(227.50279927220891030535464067312893706477306683505) }}, 
      {{ SC_(246), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(217.25980049690082135513788526215302564701604470346), SC_(227.33285809984883802231277606421538241136716142561) }}, 
      {{ SC_(246), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(218.86211939304162449463407311603751715275469869243), SC_(225.89928535883055564622647591447113860685982640886) }}, 
      {{ SC_(246), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(226.45005951808129371050647633206267215678736064958), SC_(218.25406307168033533726760271431603299065360013396) }}, 
      {{ SC_(246), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(226.78976957307348642152259616432851183065046544441), SC_(217.87436878609633333906241226390518772411499470497) }}, 
      {{ SC_(246), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(228.24086492939276715393847058245453042102534065361), SC_(216.21084068099166831292824910644387577759648138316) }}, 
      {{ SC_(246), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(228.4362141791223365697907213444869345145057004753), SC_(215.98155107809579203240709042638620435409118485789) }}, 
      {{ SC_(246), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(230.50214110967217215330556682466224559888738470755), SC_(213.47324094889139092282950404636304067397130783722) }}, 
      {{ SC_(246), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(219.12484039605505991182968076190487019247846339001), SC_(229.17329482353248286706908111438731107683033995226) }}, 
      {{ SC_(246), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(219.31251954745609912727348750987687022171006935376), SC_(229.01039247930323394529309041736598672263524983765) }}, 
      {{ SC_(246), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(220.85979162865119392044354857560985610138662123401), SC_(227.63507570754285688644246515192494500254344593867) }}, 
      {{ SC_(246), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(228.16369911647929427548448650363406678169348895124), SC_(220.27279879546424120985001247742547452634561459606) }}, 
      {{ SC_(246), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(228.48960510452990005557175688052593898446868441305), SC_(219.90614836267799629428410922335604025928406894962) }}, 
      {{ SC_(246), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(229.88044320809674730334952495618967694752769306539), SC_(218.29882064878281640559616828394408698546796980339) }}, 
      {{ SC_(246), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(230.0675120594263056773546970352681882185681235698), SC_(218.07716045044595155554665599215358039904485075246) }}, 
      {{ SC_(246), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(232.04315354905174152825386667453305361604822441189), SC_(215.65057700859644610801061313435954042202281853472) }}, 
      {{ SC_(246), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(234.7040790058105402541115503616414026812435350852), SC_(240.88573807378439490899818859579548592690840287485) }}, 
      {{ SC_(246), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(234.82574730492734434769432552719506797350630794619), SC_(240.79240210479703040721294039598337060024914019499) }}, 
      {{ SC_(246), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(235.82138673896588577928800089213233635815252769304), SC_(239.99310772186341579969056815454269660303646902588) }}, 
      {{ SC_(246), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(240.30264016160680690479150097672582581736866851446), SC_(235.44526127364156136726323178573667789969998172762) }}, 
      {{ SC_(246), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(240.49205852087116544724675456874861453956108977447), SC_(235.20932452251130427599553668981157630239825912368) }}, 
      {{ SC_(246), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(241.28735805694711229439056103677862692125135228068), SC_(234.166380631281583054845799063395455174390637234) }}, 
      {{ SC_(246), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(241.39260133255451158478961639514863423369964262898), SC_(234.02149177290220242800378128896411751671850412471) }}, 
      {{ SC_(246), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(242.47547996852577862602168348851387362602473234066), SC_(232.41972597148787353209323211020382380864419013157) }}, 
      {{ SC_(254), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(25.744687164954596333916048741745906406742499953787), SC_(37.839397434293153854695726593153941026894992364464) }}, 
      {{ SC_(254), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(25.944634886907930921037055358368620069494363949534), SC_(37.61712904718871969857351763265265037847756847771) }}, 
      {{ SC_(254), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(27.626579037384759196138699086182793629805647465308), SC_(35.780234409193016771862131515559266572714433623898) }}, 
      {{ SC_(254), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(36.478056937024752037652382381756913435469581357192), SC_(26.981361765517804765292282781115607841297291409499) }}, 
      {{ SC_(254), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(36.913336171407073371233534243036617982106821875261), SC_(26.582798447519651449042719020639194248575867308965) }}, 
      {{ SC_(254), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(38.816318623166587191895975919175367362365470868811), SC_(24.874832485925791011711588230267169037610014556973) }}, 
      {{ SC_(254), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(39.078110094286376020789736581798448102569441915942), SC_(24.644190583377951516448833396213082068209511781096) }}, 
      {{ SC_(254), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(41.934503470838077928989231404555236235929318716134), SC_(22.193593293559103093462886668541835556844833590642) }}, 
      {{ SC_(254), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(27.731373200403794949938639817880139617383125458151), SC_(40.164034387121539972642575506579017543487138023962) }}, 
      {{ SC_(254), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(27.937490478431790982863784180008386172798774824967), SC_(39.936108817585154896816706787270911887429654058286) }}, 
      {{ SC_(254), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(29.670438498529986497056682555977283907312638752466), SC_(38.051762465859280581556139543011217068470205867709) }}, 
      {{ SC_(254), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(38.767760624919679624431452705156279970636852913706), SC_(29.005840576017498714081716641557797874164106750814) }}, 
      {{ SC_(254), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(39.214284016831626329158472430367023708823748989645), SC_(28.595191491626297079162021181046851059479011330868) }}, 
      {{ SC_(254), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(41.165610620116605071869744769341764267628282753559), SC_(26.834403333084402079593313770645476595897998172747) }}, 
      {{ SC_(254), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(41.433951908758752670582070885219066577109154705263), SC_(26.596495111124536482321984135492102879923512866143) }}, 
      {{ SC_(254), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(44.360303194840736132935389667531362557682580377853), SC_(24.06657409500868887534073882710136734473314827147) }}, 
      {{ SC_(254), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(48.129901291790268702570269489442077339363773796654), SC_(63.211365148584540787755871680063637075943791798829) }}, 
      {{ SC_(254), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(48.384923639481329376621989316820417720385703427638), SC_(62.939671985114495202331983217541731356491052745051) }}, 
      {{ SC_(254), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(50.521481036823770853249122579267609243841608403884), SC_(60.687361441322391948030445984364206388775579232855) }}, 
      {{ SC_(254), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(61.544479276359301525230617881107224729919235640981), SC_(49.70366576336732085848722793567374313111349418452) }}, 
      {{ SC_(254), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(62.078195596993887516309729142166357130123106296431), SC_(49.197377870146290817940172110042440185323067194481) }}, 
      {{ SC_(254), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(64.403430708457601630238887352998616895971853085407), SC_(47.01778915604546690192366355442804763055635622752) }}, 
      {{ SC_(254), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(64.72230566175917728134678099290270260069165953006), SC_(46.722171772012546344446333592730068888333286314344) }}, 
      {{ SC_(254), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(68.186467637115617901592832076875087554246300095826), SC_(43.560834916503068474076725688135013997276103347367) }}, 
      {{ SC_(254), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(199.34870680902605588527926031388755724785876004501), SC_(213.46778614003857222507540812687443411919678679434) }}, 
      {{ SC_(254), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(199.60463833747794400394724277190441429031837596441), SC_(213.23066866986937222481833343820067764445801805743) }}, 
      {{ SC_(254), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(201.72422818463413354479743696676766938525693524123), SC_(211.24170663920226820462994708186759120798893849951) }}, 
      {{ SC_(254), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(212.00352886246653789110147355408000352413815825523), SC_(200.91805422670229921309900568478940668106487478807) }}, 
      {{ SC_(254), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(212.4748426604239182201383206127714736268833209475), SC_(200.41578747582705938953683605620915090441861541698) }}, 
      {{ SC_(254), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(214.50108010280356317516174534236742252641273500468), SC_(198.22517693206380879097346499297200485953066089656) }}, 
      {{ SC_(254), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(214.77554156698234680462031924358572679112664890044), SC_(197.92446575212949059292816943458265768215569943874) }}, 
      {{ SC_(254), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(217.7050408482085888109009574548584245795050023845), SC_(194.65313698110404826072610150464952202456741915983) }}, 
      {{ SC_(254), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(204.81503411059575677981341421815540522384025621132), SC_(218.30212424876948625540128084382323744691000647395) }}, 
      {{ SC_(254), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(205.06051917306568077699079279028031057534433267997), SC_(218.07667112927220227316777608109927677101552331067) }}, 
      {{ SC_(254), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(207.09228838850968461757778977378191958575348731411), SC_(216.18397994021328134303161964336206548444557458368) }}, 
      {{ SC_(254), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(216.90925478298905902672836738448265627711075986898), SC_(206.31979384243968489683183482332459729120656775205) }}, 
      {{ SC_(254), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(217.35775634790032768483017707623429182067676945537), SC_(205.83833710227226333314942758442262652618406251891) }}, 
      {{ SC_(254), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(219.28410648948874558595679136047469725548532459113), SC_(203.73697185721225406759541685251085112344007486608) }}, 
      {{ SC_(254), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(219.54480476272492679455580427805240528607134861453), SC_(203.44832291417923826862164055266688140107009962431) }}, 
      {{ SC_(254), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(222.32373101442347310633746939233908574755467561244), SC_(200.30537941536681958569887221725221869242654189032) }}, 
      {{ SC_(254), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(224.22745029456907687872379161447087536488586999287), SC_(234.83355791389902750052874804230110162173080473323) }}, 
      {{ SC_(254), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(224.42465987790304277621878312269804990914638129569), SC_(234.66065726696192931798217529472730597828260488355) }}, 
      {{ SC_(254), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(226.05157689789885167772474471207178173508274855076), SC_(233.20246347847565717333948344108196292905088166774) }}, 
      {{ SC_(254), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(233.76262637626929703958021482259294780286689829128), SC_(225.4341387617152262626151036661518190037841333947) }}, 
      {{ SC_(254), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(234.10817050413706643518001194029980734906933493472), SC_(225.04861575728817766990470653278100553463859527532) }}, 
      {{ SC_(254), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(235.58458432028079338650483482505404348099097631522), SC_(223.35980490829524993248170204491280599318808853847) }}, 
      {{ SC_(254), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(235.78339426091365438320615541142412428624104199209), SC_(223.12706146711774407950374350622678873393631638703) }}, 
      {{ SC_(254), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(237.88677484064148904506686509882945823700636690578), SC_(220.58141667648720359630926519824805178173485762272) }}, 
      {{ SC_(254), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(226.3505336220217139477527560604919829516643243133), SC_(236.56160563099268480960194962715590510673943223819) }}, 
      {{ SC_(254), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(226.54105928377462729100020978275783177571592054446), SC_(236.39585247870211897653138500593482387899032680542) }}, 
      {{ SC_(254), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(228.11202119853159665606730935491530294083099929157), SC_(234.99682088886846810595120027286343062871517439718) }}, 
      {{ SC_(254), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(235.53448705070226517555157118108783488933130334094), SC_(227.5159931496614430909935059224138692778297292562) }}, 
      {{ SC_(254), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(235.86601236129559619734604280456220297162004684199), SC_(227.14372922872285902918544475005409999259323194363) }}, 
      {{ SC_(254), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(237.28123970004723624732289815478164245711158883275), SC_(225.51205128539924130233456218513774097284545288788) }}, 
      {{ SC_(254), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(237.47164264653930940743102869769496635475733654187), SC_(225.28706448799352225001087543697234918489332723811) }}, 
      {{ SC_(254), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(239.48337658345481511677742469522699913049232877719), SC_(222.82451912376717580781258966601013058049483694214) }}, 
      {{ SC_(254), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(242.4046338447884840414896350679928573719319070802), SC_(248.68701847850488365135938930900043525776153610362) }}, 
      {{ SC_(254), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(242.52806681432096320544771698241687254757056340213), SC_(248.59190658953540893136958020394726578978792353865) }}, 
      {{ SC_(254), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(243.53838158214320815779796431080979688968366411981), SC_(247.77787391086914981881709345341327767658894513255) }}, 
      {{ SC_(254), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(248.0930197582795662982406750434149071126643283927), SC_(243.15666117161100269560153855591366564219229791724) }}, 
      {{ SC_(254), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(248.28593014709477974609192556703451539425913785984), SC_(242.91724703439795606730929165075480581999806679339) }}, 
      {{ SC_(254), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(249.09643019785026967231554935592818984520033687521), SC_(241.85920565090519310133054315803581556455268909432) }}, 
      {{ SC_(254), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(249.20375839198807927460791612351711797169079620161), SC_(241.71225242009488194351406919061699378842213781521) }}, 
      {{ SC_(254), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(250.30936675017848197735786392336286581349026595229), SC_(240.08813800953897377374813896243209421286152011118) }}, 
      {{ SC_(262), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(26.665904120000194764031734467398902087952426090245), SC_(38.94997470964496766731468341816085956061568045044) }}, 
      {{ SC_(262), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(26.869168337554735043614302239797570553344958933206), SC_(38.724392501651233605257131194061004389966709164777) }}, 
      {{ SC_(262), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(28.578711723643544481919649083674046357426799177028), SC_(36.859914283534214598381653638124581118394649196547) }}, 
      {{ SC_(262), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(37.568257989416499969624132556784615665755055966284), SC_(27.922968527501911041495224201325113723596518898285) }}, 
      {{ SC_(262), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(38.010073387164163101850685972064752514624199371017), SC_(27.517865387710260011889880223691032854545820618386) }}, 
      {{ SC_(262), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(39.941402872908228792465277104475546877980926016452), SC_(25.781528155591931285950963749858055831838898234675) }}, 
      {{ SC_(262), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(40.207066181801793286484450614982843533420240811692), SC_(25.547009789199048512552620569470369328571464974875) }}, 
      {{ SC_(262), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(43.105301732083421053738639646696213027184384260861), SC_(23.054490703915225741895604362928339336370956257477) }}, 
      {{ SC_(262), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(28.717882198645070640820735416360817864067898675948), SC_(41.345162201978978455144643000850760290306792635774) }}, 
      {{ SC_(262), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(28.927407703981769653612636193761963474763549014821), SC_(41.113830890376238062320284141201485139115091679457) }}, 
      {{ SC_(262), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(30.688719564413805996818162753833696134123145475184), SC_(39.201135256682570900869257937643637822638189941044) }}, 
      {{ SC_(262), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(39.927946766128936758306067569108912380162520736979), SC_(30.013303875305502034423144252858946871622837829445) }}, 
      {{ SC_(262), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(40.381187763707219004023976595426721230688463636236), SC_(29.59593378291733629550719167637228674694192784789) }}, 
      {{ SC_(262), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(42.36164761696784669450132433705475462304967086945), SC_(27.805989859035923180294612097621830825767184152728) }}, 
      {{ SC_(262), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(42.633968033216237509056609673278396952631277121614), SC_(27.564098215444831371081794135720322898211411651186) }}, 
      {{ SC_(262), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(45.603319213359629116527998055918763654647098349822), SC_(24.991103501053958215427391454368911084578699633255) }}, 
      {{ SC_(262), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(49.780246128972208246568367827192099210850145355417), SC_(65.097567382408917552060840298355662770493628876441) }}, 
      {{ SC_(262), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(50.039396462970766226051650556832680723965468544415), SC_(64.821747571037067845611655493108038250463059073458) }}, 
      {{ SC_(262), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(52.210315799920734301759926961953880385453299634661), SC_(62.535082963791568471332376452225243165267970830484) }}, 
      {{ SC_(262), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(63.405305351509647688666224870967927064744054093736), SC_(51.379393576732924301481161143480899815214406421366) }}, 
      {{ SC_(262), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(63.947162181769262042339298272363211451943975792187), SC_(50.86496333235811939569121924879232380226554499859) }}, 
      {{ SC_(262), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(66.307696618797302278744949588210564391587026504149), SC_(48.650063180226918459213519227858571528911822254469) }}, 
      {{ SC_(262), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(66.631392203208488850626552528692172135994185613491), SC_(48.349622865642156367314832275042686069952174212797) }}, 
      {{ SC_(262), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(70.147635417894465199338012062312432565649053614496), SC_(45.1361655539174649027288032675378077969211508662) }}, 
      {{ SC_(262), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(205.75605962727743674903128192501220074120814723036), SC_(220.09600906336950320123269566789803091856652603124) }}, 
      {{ SC_(262), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(206.01585579724373803813164871619244301037992549042), SC_(219.85502525025972330461376993300688509082421095843) }}, 
      {{ SC_(262), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(208.16761739412487632475399800842550973846829254688), SC_(217.83388147099516411476956524918116386675111050212) }}, 
      {{ SC_(262), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(218.60797861014203167843267357465025367257484945823), SC_(207.34917156043535455382395494869019365698566191529) }}, 
      {{ SC_(262), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(219.08691813052341213255738871448558982470509931044), SC_(206.83928142466001539245991697484857147227333184995) }}, 
      {{ SC_(262), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(221.14622928839223874530311264756867630552688864157), SC_(204.615612568071172331500130320377173120235858262) }}, 
      {{ SC_(262), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(221.42520846237575907681519986528910177093261532096), SC_(204.31038660638273293244536576040476508930479491509) }}, 
      {{ SC_(262), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(224.40353816477229060203911899859165135331996817615), SC_(200.99027746681546700696962999607699396718892030733) }}, 
      {{ SC_(262), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(211.38958559148489914754343216700563857579626112447), SC_(225.08770620867611840237604161313626912779075336217) }}, 
      {{ SC_(262), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(211.6387632857297718680341816118616177799003065951), SC_(224.85855848895584895744662525833328257047902808528) }}, 
      {{ SC_(262), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(213.70127150030974812064281638674861923289285120298), SC_(222.93511674490030898168030870568600782205650591415) }}, 
      {{ SC_(262), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(223.67212029044496335317081927798609247567361187773), SC_(212.91705176232112140481156667103865844796705330037) }}, 
      {{ SC_(262), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(224.12790843430411701575893128393889638332549006738), SC_(212.42831114443173688146641838281722963638407007835) }}, 
      {{ SC_(262), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(226.08586347318764627428419226562247305817922239076), SC_(210.29535882646053224061441324233878941201540166934) }}, 
      {{ SC_(262), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(226.35087913495618518456471715459188983744596861436), SC_(210.00239588692758129049829119318864002180593670664) }}, 
      {{ SC_(262), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(229.17647699861555349566051088895997342250171977459), SC_(206.81283886441212979613067421253296745652277845391) }}, 
      {{ SC_(262), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(231.39067743400956881093598135907069935317036918522), SC_(242.16299386698908957217759955231278431677069002623) }}, 
      {{ SC_(262), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(231.59079614575791460538949145610386065116501732436), SC_(241.98718039073846407792543609420399477028728095007) }}, 
      {{ SC_(262), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(233.24192551430640110342511500765673660565040487686), SC_(240.50475269127713730517888852440816294450551560615) }}, 
      {{ SC_(262), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(241.07415687633285298638958783959797671256245329889), SC_(232.6152526061308676755133602315319208693557191899) }}, 
      {{ SC_(262), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(241.42544334935045993465926274316082305160062441011), SC_(232.22399229296047784137344586996308486557858034273) }}, 
      {{ SC_(262), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(242.92677639746609537265950532689898810870957188136), SC_(230.51029578364206015671367760200062420918509056018) }}, 
      {{ SC_(262), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(243.12899228657582256840984152062968537717113547096), SC_(230.27415283154619686152089594704191894471227776435) }}, 
      {{ SC_(262), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(245.26923044045781174312606763451692858750257513816), SC_(227.69176213971185059041641862421462656661038611654) }}, 
      {{ SC_(262), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(233.57750167547388601469847895714993272524239081666), SC_(243.94864230419370719770400205195110197619484680246) }}, 
      {{ SC_(262), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(233.77082913540479647100684260490888308059445244562), SC_(243.78008331293995590347655890100738895835856784442) }}, 
      {{ SC_(262), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(235.36510925253814285639965087850617153932509130261), SC_(242.35771001529604925195413204593591307779374823386) }}, 
      {{ SC_(262), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(242.90427684250729691819303608214673968300634243393), SC_(234.76018763249470081368549289529508077717187939675) }}, 
      {{ SC_(262), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(243.2413330721286021524694116442081668432510831224), SC_(234.38239828187452399613152675254445047487700960303) }}, 
      {{ SC_(262), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(244.68056474119088390044415207644511071101556552948), SC_(232.72675267679936004431105583603769055096100206731) }}, 
      {{ SC_(262), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(244.87424898195809774731521613011079748793139761915), SC_(232.49849162769128437516076498751931633376698017803) }}, 
      {{ SC_(262), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(246.92149993354424074827891169801902109852917741111), SC_(230.00055174758411036747935768942132415769395090971) }}, 
      {{ SC_(262), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(250.10598393908064371165001997407407395928090290293), SC_(256.48750765840307603950500059502260257884053701892) }}, 
      {{ SC_(262), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(250.23115369685866936834842468089367294441337714992), SC_(256.390648350128595137873650027117126918348386059) }}, 
      {{ SC_(262), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(251.25591249614023568760095604540442277360631003697), SC_(255.56211202805182023662954938844041631682628724154) }}, 
      {{ SC_(262), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(255.88278225585136751222060808993172930665687025295), SC_(250.8686852106167381019666138995627279940040757379) }}, 
      {{ SC_(262), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(256.07912909215121395588387201117031181627109788472), SC_(250.62584849309191378025714369334571680884424374691) }}, 
      {{ SC_(262), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(256.90458531557472519678946760292450818058714436093), SC_(249.55294825248387224381705954150109676230874564476) }}, 
      {{ SC_(262), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(257.0139645308602948075704626329682839398343330452), SC_(249.40396337425050119916099347482714560957148733551) }}, 
      {{ SC_(262), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(258.14192387822955308436868047479951940866391337114), SC_(247.75785628097992793552009958552979433104575676153) }}, 
      {{ SC_(270), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(27.58855828670240714967769848194095432876408742804), SC_(40.059114427806938084332966491364919550893900668427) }}, 
      {{ SC_(270), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(27.795088441550366695966392217970220732865032672487), SC_(39.830268800757490951495522379643136576510620983935) }}, 
      {{ SC_(270), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(29.531811049125759310919454106348511359215064371263), SC_(37.93862610650128240092664672740586084548738413964) }}, 
      {{ SC_(270), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(38.657331215986699341554284042681712617655852392358), SC_(28.865701977829353499716341928572447335017117655276) }}, 
      {{ SC_(270), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(39.10558346906843937235178734480831960980988157677), SC_(28.454158536824739496863167004366857869105756914699) }}, 
      {{ SC_(270), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(41.064828768787095669163198552612252609143665939098), SC_(26.68988267414584137253958416603859051684781531305) }}, 
      {{ SC_(270), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(41.334304941572845720496302772891059778111327569175), SC_(26.451547090516741039980349782175174374019577526729) }}, 
      {{ SC_(270), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(44.273743968606877954925679418101287944532023475853), SC_(23.917749650184824346663756138906316306105750839545) }}, 
      {{ SC_(270), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(29.705868116732547953161568652341756027867329262458), SC_(42.524812783804400092819115236557268398128687769323) }}, 
      {{ SC_(270), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(29.918749913527413397817729365284295132068638684667), SC_(42.290127520464436161550040146227957724334340753196) }}, 
      {{ SC_(270), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(31.707994094506784904526973781714654950669666296375), SC_(40.349513277112396980697492454218534724802611169513) }}, 
      {{ SC_(270), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(41.08697394785648676509222181963245275163290227927), SC_(31.021925083880163105146348214876753398995260558081) }}, 
      {{ SC_(270), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(41.546830501813903855891338779789057275244021210037), SC_(30.597936230721867038556791346471054535528515250076) }}, 
      {{ SC_(270), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(43.555980509269886228119491090246508611793413840012), SC_(28.779280957459410053525371102620527621929032599169) }}, 
      {{ SC_(270), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(43.8322194589206268460159015267198145230315214746), SC_(28.533466739693544406933017246931541095729028493528) }}, 
      {{ SC_(270), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(46.843914354626413330704892000368867961989604524359), SC_(25.918058901119449674989115314133976418976612122148) }}, 
      {{ SC_(270), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(51.432379382681436004229527189416673633953445393587), SC_(66.981981054191016727257545333973436254010500127786) }}, 
      {{ SC_(270), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(51.695594939637392318506123422052425133075839677011), SC_(66.702097279532137517864538253743019192988580976569) }}, 
      {{ SC_(270), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(53.900354329606418525192240677391552835318029195559), SC_(64.381600033736213748870527962012540023727904506158) }}, 
      {{ SC_(270), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(65.264728155283383859973923386784764733602787507758), SC_(53.05652411568940277914205125899993214212238976132) }}, 
      {{ SC_(270), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(65.814601941002600918160893376898905890873085089039), SC_(52.534075182234470769531864153482275589958707222588) }}, 
      {{ SC_(270), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(68.209899427081345740933427563721171647715885728753), SC_(50.284400581728489188279769546770752501506901275091) }}, 
      {{ SC_(270), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(68.538342332624714461913906212329751856525451522918), SC_(49.979210782437724633024219607450571964855479691578) }}, 
      {{ SC_(270), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(72.105873380184472347707780757089005585057743498244), SC_(46.714428752049557709521283348024128967930846806093) }}, 
      {{ SC_(270), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(212.16508782997092122370651941952698314739639168016), SC_(226.72255679584973958906340139365969582321687384785) }}, 
      {{ SC_(270), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(212.42868991722528755470995965955439652335385127331), SC_(226.47776546398527326141578703858035940662304220845) }}, 
      {{ SC_(270), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(214.6121348274263776395422100531176471918129649049), SC_(224.42492895747991350526630214416343082315887353215) }}, 
      {{ SC_(270), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(225.21111460370731198370429417056373331174334311122), SC_(213.78160334947198107497025499178229521824382762711) }}, 
      {{ SC_(270), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(225.69756397265165315115328347209955321766723682104), SC_(213.26420556596690492801205393950121724033283762973) }}, 
      {{ SC_(270), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(227.78944553801854109145340422151672089146566149213), SC_(211.00798079873315413533950346180106347241231827312) }}, 
      {{ SC_(270), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(228.07287356196606664083946654578945084300226746293), SC_(210.69830874220414881371984077016428121945305610343) }}, 
      {{ SC_(270), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(231.09928720183810232448141473215950886066277043584), SC_(207.33016274070374760603197388900323821915464076801) }}, 
      {{ SC_(270), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(217.96573817027307725452169225972723957062797562623), SC_(231.8716873025202764259853371373780162319940325577) }}, 
      {{ SC_(270), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(218.21855237150502296825514277453006033156076591473), SC_(231.63890122288883106200807489105575554183881151933) }}, 
      {{ SC_(270), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(220.31133280278232959443413233523926053174307017124), SC_(229.68517638123584020423301399232812654955302007884) }}, 
      {{ SC_(270), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(230.43373045648733259302882624775050539185054371664), SC_(219.51556584157925865666467343924846137896984468666) }}, 
      {{ SC_(270), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(230.8966944155837087924937312788809512364562588427), SC_(219.01965195198025137640560167584332815431520914328) }}, 
      {{ SC_(270), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(232.88577313580720622154279825714685150916517023982), SC_(216.85559272981123576886407867005867021373885873547) }}, 
      {{ SC_(270), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(233.15504033302327298894580504063610280194692178608), SC_(216.55838144661744460540743672519591282092304107254) }}, 
      {{ SC_(270), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(236.02659558916548803804855525460968430216255327072), SC_(213.32292166323133335610398938776790265758184116481) }}, 
      {{ SC_(270), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(238.55516753794986866008523091441137831175462457675), SC_(249.49116740152436901702236098853782619137103207595) }}, 
      {{ SC_(270), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(238.75815108748678603034582241506746806758426576506), SC_(249.31248560190123079968433633844228880867931634277) }}, 
      {{ SC_(270), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(240.43312462210159865997888096042370125158230426604), SC_(247.80619341764275915318091496302376669996137068332) }}, 
      {{ SC_(270), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(248.38469817560476146203067045897504689462711680764), SC_(239.79735728286446719651897802042992968633367691976) }}, 
      {{ SC_(270), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(248.74163946199154228777039823399506220165760338376), SC_(239.40044690249735943467849964950747402203237424314) }}, 
      {{ SC_(270), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(250.26751083311915288373788431979462779380701259264), SC_(237.66224368467533763400084337017814960976927531248) }}, 
      {{ SC_(270), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(250.47308044885768766379356563324944171273023376883), SC_(237.42275306499050159390586761170974608751927799874) }}, 
      {{ SC_(270), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(252.64960773542990707121547250508668007883922460233), SC_(234.80417825214835170560517124044924407639904849074) }}, 
      {{ SC_(270), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(240.80568641739560109204654981951664235297662932307), SC_(251.33446291123611594014347140806822162761860518491) }}, 
      {{ SC_(270), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(241.00177300514607215806970088797728724064735036893), SC_(251.16314098598072286423920197277591887626465722787) }}, 
      {{ SC_(270), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(242.61901664476908063398520662445179962379454512656), SC_(249.71778201224865102344055496427957420428448915247) }}, 
      {{ SC_(270), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(250.27311391217822988909140604797222274185532132291), SC_(242.005336641034839945461253969513639447573328972) }}, 
      {{ SC_(270), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(250.61561670350345560211710676177095239021499930882), SC_(241.62210590266577177491337377676339833467103715165) }}, 
      {{ SC_(270), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(252.07848547501641662540889796901493437560462960447), SC_(239.94285773002327552844619891909015952865835296409) }}, 
      {{ SC_(270), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(252.27540064330269644182504884836206791338322553507), SC_(239.7113723823205636494617396407393894232300967265) }}, 
      {{ SC_(270), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(254.35761990578799423871917515999291714299208844311), SC_(237.17857938102811099944226322978545887785784794395) }}, 
      {{ SC_(270), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(257.80809280103207305184069569476813047198271898352), SC_(264.2872416485335151274383722923446070280556418678) }}, 
      {{ SC_(270), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(257.93497274331013297140812145356249918769405775193), SC_(264.18866209518500442242440829074672036513979513587) }}, 
      {{ SC_(270), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(258.9739548546931820518660852055010159363846308897), SC_(263.34584594875064905150634342714310067963348891445) }}, 
      {{ SC_(270), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(263.67195562389468354000986058428191488006575201765), SC_(258.58130473937605184933485458990578346684980965391) }}, 
      {{ SC_(270), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(263.8716858908595303028720889172377314165025522505), SC_(258.33509773981085665168678082212930354380235566699) }}, 
      {{ SC_(270), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(264.71186533685377025683164723249122027569483743347), SC_(257.24756633212769362394468626448633447150598767941) }}, 
      {{ SC_(270), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(264.82326327523712534339606243201155347089083361307), SC_(257.09658102690269725141523127884925870403034047083) }}, 
      {{ SC_(270), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(265.97321323660996407153519493412071287572848871176), SC_(255.42882075221560976111830813204718727533911903377) }}, 
      {{ SC_(278), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(28.512586144676532901012301904874896673657373624664), SC_(41.166880142362286715335431505282335952662758727322) }}, 
      {{ SC_(278), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(28.722333923212716931206955490584691599543647036853), SC_(40.934819266717423870348243889171242547246985773336) }}, 
      {{ SC_(278), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(30.485834352347615849313977574300715808639613515688), SC_(39.016412663155677466877819477534394946338716035549) }}, 
      {{ SC_(278), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(39.745326465309305463111237091375409052524722115763), SC_(29.809512368356627673394349412492716777994424543927) }}, 
      {{ SC_(278), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(40.199920658043600051543440463961110158087918144042), SC_(29.391623736387655725584930597472854037765477768544) }}, 
      {{ SC_(278), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(42.186669645481270092920441488075150184273154678322), SC_(27.599822668221879834647724783865631662242078820893) }}, 
      {{ SC_(278), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(42.459902322535117655299715699181149378226492029977), SC_(27.357726476298051076891860599769689760491661588619) }}, 
      {{ SC_(278), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(45.439934496710840701844476064085389747271804679758), SC_(24.783265342597506113141895453195801339608875682979) }}, 
      {{ SC_(278), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(30.695265687024793437469790630080000032955984807392), SC_(43.703051430185312141495493685474640002049109613888) }}, 
      {{ SC_(278), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(30.91145414433730365597071434274888839785657442835), SC_(43.465061712935845730198924228621847938688528671067) }}, 
      {{ SC_(278), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(32.728218244398676889328994594923664986455298661963), SC_(41.496940485759865870284694684175921461397436933753) }}, 
      {{ SC_(278), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(42.244893386601044042389016463848683174435311517748), SC_(32.031653077833565545068455675230307889576613114625) }}, 
      {{ SC_(278), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(42.711267960690833411949033123777427566686307709497), SC_(31.601143181320921849130567042088383815915983511904) }}, 
      {{ SC_(278), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(44.748684643144824789376262194062390370978239666022), SC_(29.754201245328212922084935472929623662756396874511) }}, 
      {{ SC_(278), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(45.028784217585029209292044206599398315322393563901), SC_(29.504522593504206780701928746285580472448484242594) }}, 
      {{ SC_(278), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(48.082195787452113678144723003360707926133299325017), SC_(26.847332686611313466690931484736783736312265677892) }}, 
      {{ SC_(278), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(53.086222077049593485209277698515538125833167621615), SC_(68.864685153286984013297050243683647198804376907255) }}, 
      {{ SC_(278), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(53.353442872613802624636005557170531942348675368706), SC_(68.580797327702369060354987522302510694388870059113) }}, 
      {{ SC_(278), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(55.591543511337761071579385726343067776027462742741), SC_(66.22696582536166329369945554559797656294156504282) }}, 
      {{ SC_(278), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(67.122809644748709315654761143745476438865006663805), SC_(54.734995470892634757294526064035268370776769718862) }}, 
      {{ SC_(278), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(67.680582291797019180842210288562532081840262342578), SC_(54.204646041184438096198170279889874412938295656088) }}, 
      {{ SC_(278), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(70.110130270455450511612054505880331787759110107538), SC_(51.920710200751631652567287883197104250734113349253) }}, 
      {{ SC_(278), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(70.443250432760664265709304914210922694618400207596), SC_(51.610841105299541870169375417962461880899801039887) }}, 
      {{ SC_(278), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(74.061311089269961159899583141851785438200600866447), SC_(48.295494709458516229700316972124426782287886379722) }}, 
      {{ SC_(278), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(218.57571740634983016199362304506218470083064824968), SC_(233.34750333011062283038500996968204976481366333875) }}, 
      {{ SC_(278), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(218.84306928448564000879360227739131899166981894465), SC_(233.098960697303203237615007534113147925374249348) }}, 
      {{ SC_(278), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(221.0577306616193925330527620891902596828673610609), SC_(231.01489884504526967886292260254665170764127563756) }}, 
      {{ SC_(278), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(231.81299483311845288691124931369973784750635131556), SC_(220.21529154239049654598588858019319386678985750169) }}, 
      {{ SC_(278), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(232.30684330416929316889426386992935525746219419114), SC_(219.69049673256555611843261338315705121970674860091) }}, 
      {{ SC_(278), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(234.4308142746672914858405583411662540225216815788), SC_(217.40219622883751354270122155108255365136781807618) }}, 
      {{ SC_(278), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(234.71862534556842576163135839704050740194531940908), SC_(217.08814372242632767256851295461103651587340242318) }}, 
      {{ SC_(278), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(237.79240968063911198592116050856395761333474708028), SC_(213.67267138205713296608369136826198362692410755602) }}, 
      {{ SC_(278), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(224.54342110331054889470598193307962642725940817119), SC_(238.6541382520857426860592793145910062128686428275) }}, 
      {{ SC_(278), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(224.79981817008965956051061445350351654560702965729), SC_(238.41776755963182979102926227171381124359460432811) }}, 
      {{ SC_(278), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(226.92242467207947840705728607893778018053273354525), SC_(236.43420638390137600717416184616630789709761846676) }}, 
      {{ SC_(278), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(237.19414069776302894048639830942426601398353726792), SC_(226.11528059172801655059771273486001532253746045185) }}, 
      {{ SC_(278), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(237.66417461159986064365037719191810530619043835606), SC_(225.61229914662827967603719996355452667842511638568) }}, 
      {{ SC_(278), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(239.68391713574544132191930233052337866182956729698), SC_(223.41759194005585581871740331227062358532855373689) }}, 
      {{ SC_(278), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(239.95737294087174064342277058990599870845911048772), SC_(223.11619505770931675830028605641403399492263259237) }}, 
      {{ SC_(278), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(242.87420321059414817281647742603004160919381983263), SC_(219.83551173523480364184935732168776709558195088703) }}, 
      {{ SC_(278), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(245.72086472401219751188370127979006640318229794997), SC_(256.81813434615585357645846776367391515631530968664) }}, 
      {{ SC_(278), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(245.92667078307805099604982626037428015522042597924), SC_(256.63662674850678172871050680208228380979990337806) }}, 
      {{ SC_(278), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(247.62513659665179695200299462190629208995968064097), SC_(255.10682310586837900450150057686201609350995727458) }}, 
      {{ SC_(278), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(255.69429396142810541247711684451112498702239272332), SC_(246.98040895937725476935345010847480075344422993981) }}, 
      {{ SC_(278), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(256.05680641487663459268212760862439912317746501636), SC_(246.5779318922237583170475527805178465966588188552) }}, 
      {{ SC_(278), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(257.60685215907150894728159058020615031983559811937), SC_(244.81558412473034721196260906614700740735194950981) }}, 
      {{ SC_(278), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(257.81572561237705424130343320667284065552446925061), SC_(244.57279538038298146124219572749027906841459525779) }}, 
      {{ SC_(278), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(260.027999149765955947393013936304575044188856345), SC_(241.91857324517375436432529915830873031185787393297) }}, 
      {{ SC_(278), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(248.03503399761754465195105318468965111689143416735), SC_(258.71912124060515521494574550360823438323653006201) }}, 
      {{ SC_(278), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(248.23383893388163853132141143981657854311461399123), SC_(258.5450773754432291434495189786343955841272204848) }}, 
      {{ SC_(278), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(249.87370711707818542407136353722427267947414429535), SC_(257.07707294328364338800564311214737766929857437554) }}, 
      {{ SC_(278), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(257.64104033794629485840533149567116566473051003615), SC_(249.25139793611889269145411778069592188812209937706) }}, 
      {{ SC_(278), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(257.98890908029387216201361989443973099293695023585), SC_(248.86280613164947634113091102340106543761935932154) }}, 
      {{ SC_(278), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(259.47506409007879396212695188900483663875986575629), SC_(247.16030430255043512013790569485159518496943046957) }}, 
      {{ SC_(278), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(259.67516207168798133405753298458159885415155978153), SC_(246.92564239214136117833352512369192259753442841217) }}, 
      {{ SC_(278), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(261.79182565997991146159480858574342496944298891801), SC_(244.35851357992284681684078443070548587145134619478) }}, 
      {{ SC_(278), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(265.5109266494901604696081585461534103381080113386), SC_(272.08625384067624544341964055799780938897031862525) }}, 
      {{ SC_(278), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(265.63949135627804781767803769351012635295715482169), SC_(271.98597998934413096142292447698947200814936414283) }}, 
      {{ SC_(278), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(266.692485861200015300522890305463838419625154218), SC_(271.12909780951929319897782582785435000680377323918) }}, 
      {{ SC_(278), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(271.4605657899421589191159996819808152919651088133), SC_(266.29449323344149446234508241409250328244965911559) }}, 
      {{ SC_(278), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(271.66362884539897261681364677508512514295776092409), SC_(266.04496592792952211708157367954397438207603451591) }}, 
      {{ SC_(278), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(272.51830910148948057748082789574742738305077719207), SC_(264.94302090882969697932710776491505550525282094553) }}, 
      {{ SC_(278), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(272.6316949429893641674684576593095241439304346311), SC_(264.79006500415315074672414403810293509879219828901) }}, 
      {{ SC_(278), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(273.80329207299076092920023365373478660516985494262), SC_(263.10097584734615935467808781696962749155248430596) }}, 
      {{ SC_(286), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(29.437928718468820504689811387345446286029387721513), SC_(42.273330857875620521396608723997438647545931612621) }}, 
      {{ SC_(286), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(29.650847890417980026701812293157945301471811139354), SC_(42.038100832624098431009751270237619463468335372583) }}, 
      {{ SC_(286), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(31.440742019694880348950988472523514822807117765856), SC_(40.093313676680675912184742510887846858213809434932) }}, 
      {{ SC_(286), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(40.832290018565340878258681141008573036691278627352), SC_(30.754353506851523626857561162492849715871794001943) }}, 
      {{ SC_(286), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(41.293135313138844655586148361528692324163117823131), SC_(30.330210700287269436800392288645609739372359225277) }}, 
      {{ SC_(286), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(43.306993587329870179233888406882857296046826397157), SC_(28.511280018669389428342121637015639823938141025724) }}, 
      {{ SC_(286), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(43.583928835722179859446114501649197367558307622614), SC_(28.265477379890812781936681824928263102988135252748) }}, 
      {{ SC_(286), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(46.603970155965620792513779639069605769128120003184), SC_(25.650940520796802328772808300865703025986917790598) }}, 
      {{ SC_(286), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(31.686014311377661726434244146164612639159673761446), SC_(44.879938765539524179763650526875183826388640310508) }}, 
      {{ SC_(286), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(31.90546193754469049924264997573348021207541547404), SC_(44.638691963968703662398115822567794579680969576278) }}, 
      {{ SC_(286), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(33.7493513020851893437755945791663336558628916494), SC_(42.643457695895655966139437166759294439258111210081) }}, 
      {{ SC_(286), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(43.401752634141770449659605724281567643953750172584), SC_(33.042440387406382416142418028645351609833365901186) }}, 
      {{ SC_(286), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(43.874551882067585063675902232764536556941185260274), SC_(32.605502960075055644284963550773324683697354717704) }}, 
      {{ SC_(286), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(45.939829971148322120759084290199908434381960719387), SC_(30.730680736921621582111343086849761980066547188468) }}, 
      {{ SC_(286), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(46.223734754704558719293023702998324526184967640323), SC_(30.477193278887336837516430601400671351907726020134) }}, 
      {{ SC_(286), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(49.318263000673442478329269541253736817200774946289), SC_(27.778824977871109158477888429851504794842901264864) }}, 
      {{ SC_(286), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(54.741700882897899898661659839498383144908395239873), SC_(70.745753020752646831607109992169106335834800744655) }}, 
      {{ SC_(286), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(55.012869512485616684099539536408552928402896502429), SC_(70.457918482837266968737492788439480673352559143291) }}, 
      {{ SC_(286), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(57.283834025012646230304930792475933053095639746805), SC_(68.071229711708378025993953517297700150127488076999) }}, 
      {{ SC_(286), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(68.979607347650427058458904421239274775252344838578), SC_(56.414750156915978011267616084180923781070851931172) }}, 
      {{ SC_(286), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(69.54516583128973017602132156100231544010920958816), SC_(55.876613346196312411874019028303354250552543058937) }}, 
      {{ SC_(286), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(72.008473767595776896245286189065661180140230618769), SC_(53.558907398379311570161111733390646905777928902551) }}, 
      {{ SC_(286), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(72.346204135289026841917599771827800689692925648031), SC_(53.2444261719242676482469940024851951400886163238) }}, 
      {{ SC_(286), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(76.014068834038340389475495825553686692927857705254), SC_(49.879242927454350453166416919123953235269116019617) }}, 
      {{ SC_(286), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(224.98787963930077382903112077548527903534621008765), SC_(239.97091736732368239381526070933910494672570814802) }}, 
      {{ SC_(286), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(225.25892759368956430747107277371672725810527957374), SC_(239.71867723200113912968706369044366071529297883888) }}, 
      {{ SC_(286), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(227.50435863638616188069275823021548789714061236093), SC_(237.60383732611637236933287981465493060827162493249) }}, 
      {{ SC_(286), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(238.41367314409638849998698119090825124043351735768), SC_(226.65018223898340503913830216113198252466282325378) }}, 
      {{ SC_(286), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(238.91481473083413969525508401236480363560939978829), SC_(226.11809627457021377405505963672222438886363227748) }}, 
      {{ SC_(286), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(241.0704148090596754175716034060611155825374667902), SC_(223.79817957251571055252251682980117660349928543215) }}, 
      {{ SC_(286), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(241.36254596099969452210416716493916346084571705199), SC_(223.47980943730221458734130474398132818009483184816) }}, 
      {{ SC_(286), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(244.48301859317335883965374296861830703090757346681), SC_(220.01769066588162335631875985242688078140494663376) }}, 
      {{ SC_(286), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(231.12256870790038349829675194849447579235379844257), SC_(245.43512472085416323589778215677498370532203107653) }}, 
      {{ SC_(286), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(231.38249730425946670872794728427729234055943691273), SC_(245.19522084841246593298050676322247961770983263077) }}, 
      {{ SC_(286), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(233.5345028904515833372279499918601757156859600909), SC_(243.18225089155578035858459254772375043398450101126) }}, 
      {{ SC_(286), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(243.95340247033464190848938163522903390102161454576), SC_(232.71614449303744243732959253219936298702408157249) }}, 
      {{ SC_(286), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(244.43040503018721751008677835904737233811525677454), SC_(232.20619666880645611559431554659224441862166507965) }}, 
      {{ SC_(286), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(246.48037128724028508110125155605420182508086562479), SC_(229.98128067090258046789495357914528118751556619621) }}, 
      {{ SC_(286), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(246.75795548782699048557874823432845395100253117871), SC_(229.67575823412257302822197826347130126062505857051) }}, 
      {{ SC_(286), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(249.71940793385469548756546870406811649378122664394), SC_(226.35050131861603961130839986090145050069002057019) }}, 
      {{ SC_(286), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(252.88771711295381731734807299155850459439356017949), SC_(264.14394653314629751663580793770599568990118613723) }}, 
      {{ SC_(286), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(253.09630517494010689162781440384337733013548929738), SC_(263.95965382493614427857600936103106541117924228705) }}, 
      {{ SC_(286), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(254.8179265084064939756541645120136443460717817319), SC_(262.40667652925258988848296918185169456700230530561) }}, 
      {{ SC_(286), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(263.00298479830390678725048971689665161680576485445), SC_(254.1643669426960895363829975567676762645000577737) }}, 
      {{ SC_(286), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(263.37098837874694680532197013464925446109177628801), SC_(253.75640298462168112300177668680070230309868705492) }}, 
      {{ SC_(286), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(264.9448602824846231094453967353429122956863013833), SC_(251.97025723766218422589922404971425603235725680282) }}, 
      {{ SC_(286), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(265.15698984831870614545209834468304057729746752303), SC_(251.72421777635251361839636608152003373684488499786) }}, 
      {{ SC_(286), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(267.40449045205963341193993440155484509946197294517), SC_(249.03486193312631843938476824390992111157628371165) }}, 
      {{ SC_(286), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(255.26549442456076088562242981549221053290625570271), SC_(266.10266722998687751479441134937501492625531668217) }}, 
      {{ SC_(286), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(255.46697868545642302205120086338245668031447030504), SC_(265.92594064594129642715468992132956811370105785715) }}, 
      {{ SC_(286), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(257.12914700934406518517413950538074981010190540596), SC_(264.43561629613269032592113737789668195765290506285) }}, 
      {{ SC_(286), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(265.00809519030232097037900498398296415245419748532), SC_(256.4983323049061987067721017685387012741320446645) }}, 
      {{ SC_(286), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(265.3612527502386323432777163477072534258260766565), SC_(256.1044563022449259295439166218743567094053852265) }}, 
      {{ SC_(286), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(266.87035831715324189614469647744412675038804189971), SC_(254.37903470558726985826380545370630703019622572245) }}, 
      {{ SC_(286), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(267.0735930872980858125650883598087090694232756886), SC_(254.14124191038449010445416661194860712149310893444) }}, 
      {{ SC_(286), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(269.22419993050965037567254136077585790935130738659), SC_(251.54027224632891047347852355379701011966923486686) }}, 
      {{ SC_(286), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(273.21445413691757415293621405510325905887164890102), SC_(279.88457524580031890600428699030806258864556062464) }}, 
      {{ SC_(286), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(273.34467928683440020192013253873656834109948597023), SC_(279.78263190570411205975493004026869178610285169038) }}, 
      {{ SC_(286), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(274.41148436389703538537729868583823451872930161975), SC_(278.91188817964322634465779130572365722570196775583) }}, 
      {{ SC_(286), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(279.24863684139545311278728785286466250125815138988), SC_(274.00822608056691125886595720953930240194269346029) }}, 
      {{ SC_(286), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(279.45498424636506881891135916725933919426625585479), SC_(273.75542628973722641562881119513734853738066626985) }}, 
      {{ SC_(286), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(280.32395266986395645872908087835795472486993262608), SC_(272.63927580964752023283641950878649132759447010976) }}, 
      {{ SC_(286), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(280.43929696368562981544594461359812557065601181273), SC_(272.48437784059345807876395664483595318769795497096) }}, 
      {{ SC_(286), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(281.63221346756413471946120146373684506553362546227), SC_(270.77426999842773285011093662839855308764286705821) }}, 
      {{ SC_(294), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(30.364531134971434212927461454234482950692103046068), SC_(43.378521473084369621864382391597322043784448092551) }}, 
      {{ SC_(294), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(30.58057740780655922179882755214433894651643280213), SC_(43.140166470051492942792263759873172934957861573399) }}, 
      {{ SC_(294), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(32.396497189083098667572624961391737729278844952092), SC_(41.169366106651211491044713966694576854825056189523) }}, 
      {{ SC_(294), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(41.918264937050202273873107735032555181061154339662), SC_(31.70018241108058143968026671197754921895898291706) }}, 
      {{ SC_(294), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(42.385274289679183028703881479964151258149509069038), SC_(31.269872637957451484948300834327049092249013513541) }}, 
      {{ SC_(294), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(44.425863939953900906474428781835979908743051330192), SC_(29.424191348466009802640102496408895881980786155987) }}, 
      {{ SC_(294), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(44.706450084197990772924974230081026161599477959097), SC_(29.174734148273742039786616963597963577323232569704) }}, 
      {{ SC_(294), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(47.76594103851471663015596336905161994199008902288), SC_(26.520684717411754954120662133716991520599560202365) }}, 
      {{ SC_(294), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(32.678057606463216704612777502162130428040384200261), SC_(46.055531196339167903037495576039182887660250257762) }}, 
      {{ SC_(294), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(32.900718899667661839021239621353175106448105591614), SC_(45.811072700040226571405200077839392140747390163654) }}, 
      {{ SC_(294), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(34.771355383398359369273096949000944699166852556749), SC_(43.789102881800238411872955149905317701943843703848) }}, 
      {{ SC_(294), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(44.557595934472628490100134142941768097949520425702), SC_(34.054242841519899105008829995575883746728547096241) }}, 
      {{ SC_(294), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(45.036730408277664881321340642349597508082677718388), SC_(33.610967484231580337885622359405303669193935243258) }}, 
      {{ SC_(294), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(47.129481577776157047403364425262697936399606681592), SC_(31.708654317862392966557941981600934925433378591851) }}, 
      {{ SC_(294), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(47.41713847386880283182945552710677422446954281384), SC_(31.451411345134916028105035310444095124116442408589) }}, 
      {{ SC_(294), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(50.552208552176680594199029580903954182071583311981), SC_(28.712442868527467632819372574330282989382021904773) }}, 
      {{ SC_(294), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(56.39874756819723797982248569778031923844093250395), SC_(72.625252899116151684366713652781917261644479536191) }}, 
      {{ SC_(294), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(56.673809027194794866061004963344938470056262394308), SC_(72.333526592843784842981923329931982150125972326496) }}, 
      {{ SC_(294), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(58.977179976008243032160525095204517534007697174456), SC_(69.914437634534842211548794405249150868730856604371) }}, 
      {{ SC_(294), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(70.835174793442646296786215476123627727840679440023), SC_(58.095734681961855712997367637155497276424761238917) }}, 
      {{ SC_(294), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(71.408410805725500770524610488543224741634894369701), SC_(57.549918881371290880983202389288111306836687012932) }}, 
      {{ SC_(294), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(73.905008653315545626638233159228101861014488624808), SC_(55.198913421657694002436368551967793156527245903777) }}, 
      {{ SC_(294), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(74.247284978097751822793627700533888841204738177334), SC_(54.879884417020979920651884901554113425537846262692) }}, 
      {{ SC_(294), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(77.964258530945998669777062029750729732879193346578), SC_(51.465561302556372491502545319090127378478517153863) }}, 
      {{ SC_(294), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(231.40151058997570787414316905402030051963964169881), SC_(246.59286283226069355112442973459081311953377666307) }}, 
      {{ SC_(294), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(231.67620314985848621894199822957669702786016126836), SC_(246.33697674219641091040269343799482937195373772635) }}, 
      {{ SC_(294), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(233.95197570724482567222818440532334970809701057748), SC_(244.19178738473516884580780495633591781069143479939) }}, 
      {{ SC_(294), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(245.01319964123809339350711772416817554851305343516), SC_(233.0862252861831499238500353352632693329858405248) }}, 
      {{ SC_(294), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(245.52153278573991023039283578553774227255202751012), SC_(232.54694961966227189609906838993904243140419399355) }}, 
      {{ SC_(294), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(247.70832093494452408061848786696357225894449062643), SC_(230.19585705832364349320802804883196479494633772691) }}, 
      {{ SC_(294), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(248.00471184087066507020375909577260178331693431084), SC_(229.8732294883095713025775447358118199854026781072) }}, 
      {{ SC_(294), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(251.17121905434433076438863817684833110502462706645), SC_(226.36511571530497867458949115290989398197839635893) }}, 
      {{ SC_(294), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(237.70311986948274449661420643408991879114773590827), SC_(252.21470780643275390870884946647783422732858013515) }}, 
      {{ SC_(294), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(237.96653080439163686291591646536811913138654439696), SC_(251.97132003406614170971397603918960433361132300203) }}, 
      {{ SC_(294), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(240.14752631464362055004186539895397662567991157867), SC_(249.92935097705505402652294708830824977872474084045) }}, 
      {{ SC_(294), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(250.71156365494231173316456727331456294435278148652), SC_(239.31810960814224705745457824332142239409005483587) }}, 
      {{ SC_(294), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(251.19543778670355897670473248205100804306825657815), SC_(238.80129235718468660542982611395178506901885361429) }}, 
      {{ SC_(294), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(253.27520612966263154862271045622318299478165559609), SC_(236.54658840809126860606971791875842111857956158546) }}, 
      {{ SC_(294), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(253.55686103849685409381898552078061929752087754612), SC_(236.2369979500006343726359717346417422104091777941) }}, 
      {{ SC_(294), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(256.56231029221178464977848855817458316700147697309), SC_(232.86779015572791525430505441892367506050900545628) }}, 
      {{ SC_(294), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(260.05567643836356706610879542426409251662922970661), SC_(271.46865218765609636341029842600307789789773997896) }}, 
      {{ SC_(294), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(260.26700769132778598178429607578410595381316014523), SC_(271.28161334718490085382730216765005506902419914678) }}, 
      {{ SC_(294), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(262.0114618601189869333050919070441865539874652778), SC_(269.70578604609526997495704515330560492007709939489) }}, 
      {{ SC_(294), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(270.31080843163900242489653222553930951493918978635), SC_(261.34919337332635715256791442806344971230580835434) }}, 
      {{ SC_(294), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(270.68422645332707010462863992709384025289623450877), SC_(260.93581898528070414505575930027801665326540708728) }}, 
      {{ SC_(294), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(272.28159093686983404391677266090598507009362673097), SC_(259.12620732726657637221928809828592610328605672822) }}, 
      {{ SC_(294), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(272.49693090207344819314550414594692432090817104149), SC_(258.87696257050858462607360824232376512959835304645) }}, 
      {{ SC_(294), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(274.77916140767813821971786914466892809474182908027), SC_(256.15296507069349055239359705780606702477372592506) }}, 
      {{ SC_(294), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(262.49702118893152319601303284074794553575663365076), SC_(273.48514734139249228965092688470227758295742229153) }}, 
      {{ SC_(294), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(262.70114738360773252302223819694798949066005879353), SC_(273.30577561068496648772539199011050432701425031437) }}, 
      {{ SC_(294), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(264.38530500607656152757173095845253898961943183081), SC_(271.79344323301831168458943933549931115441201141453) }}, 
      {{ SC_(294), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(272.37431482452125731149039804437258097542943465071), SC_(263.74610326574870339824442646537370596536042132287) }}, 
      {{ SC_(294), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(272.7326873028265697961197596475156483584731580489), SC_(263.3470167196218603085664468876767508143003115558) }}, 
      {{ SC_(294), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(274.26442186405513728787980385268005475111112273841), SC_(261.59899526964768245559050774347373775905677618183) }}, 
      {{ SC_(294), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(274.47074934029110836459857695820331743681313599044), SC_(261.35811535327170405581004303298084145250638388421) }}, 
      {{ SC_(294), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(276.65481965664873383719959080373623287609661287849), SC_(258.72377900888740330124444721517626653968572559929) }}, 
      {{ SC_(294), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(280.91864611088221790415858614360296460307467169965), SC_(287.68223472411177895546697162615684185444420400502) }}, 
      {{ SC_(294), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(281.05050840433724852870392210866432261231453382017), SC_(287.57864564709024626975256849304965486132567490164) }}, 
      {{ SC_(294), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(282.13093069436533926742226475022722728965608420679), SC_(286.6942362115925027927261506326129185840425194209) }}, 
      {{ SC_(294), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(287.03619120258383410347399750697471857133002556587), SC_(281.72248039313864773049637971031717974541086587604) }}, 
      {{ SC_(294), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(287.24577656658714603071836161315550096082279805048), SC_(281.46645393259444747973011218651949041771493176892) }}, 
      {{ SC_(294), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(288.12882959237824730752192773802215547452628276779), SC_(280.33629739453555843273773851681047859063933375348) }}, 
      {{ SC_(294), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(288.24610415885267553789528374876231568149748160188), SC_(280.17948469429508866405120913440033527272657198047) }}, 
      {{ SC_(294), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(289.46002674318988088392120011833307089412185955354), SC_(278.44865525240979829149806811945810074734530411151) }}, 
      {{ SC_(302), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(31.292342234747843456190454977173947286290382866553), SC_(44.482503170075512836709258561044920150729559180716) }}, 
      {{ SC_(302), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(31.511473121966436973456741232739118598809593520023), SC_(44.241065564539626208602482051510117267757260273742) }}, 
      {{ SC_(302), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(33.353065489657043872092200177971252352094399252153), SC_(42.24460441095398394217548817228807559429863993581) }}, 
      {{ SC_(302), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(43.003291367332386881497899864433829958356656169104), SC_(32.646959004986568797194513986422501336458749965545) }}, 
      {{ SC_(302), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(43.4763812713323501886891828319727708044066148467), SC_(32.210565923425271264829554358751229433339439224976) }}, 
      {{ SC_(302), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(45.543339759511410317017000113490640633802855912558), SC_(30.338497573060964213882313142082084812612460450806) }}, 
      {{ SC_(302), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(45.827527228387683147855595707519902026219955509897), SC_(30.085435576027884982243607008901305128295633778647) }}, 
      {{ SC_(302), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(48.925931129397044024840848120799109418174722706508), SC_(27.392413611735936911785939888042177084932337593133) }}, 
      {{ SC_(302), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(33.671343004469466437130326850592388489877411107669), SC_(47.22988131086080387806068636857080920202071931145) }}, 
      {{ SC_(302), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(33.897174317527715217828830443100602231161649566257), SC_(46.982254663613084973129343455516594584398691316157) }}, 
      {{ SC_(302), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(35.794195164479201228308225926647102820681136493033), SC_(44.93391144778559126001075572910026486354583163779) }}, 
      {{ SC_(302), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(45.712464537245682571778940031958686777518108293405), SC_(35.067019255561636589052216209350020244820658209391) }}, 
      {{ SC_(302), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(46.197848423344506712109827209195135485085021218003), SC_(34.617491922860128766830933819444702049682042687907) }}, 
      {{ SC_(302), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(48.317700140920595635321590886076499934351619742815), SC_(32.688061283268559105528169102602551705547652752281) }}, 
      {{ SC_(302), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(48.60905821472806864980166672519117312313200502406), SC_(32.427113910186825418776509124576882042553814059568) }}, 
      {{ SC_(302), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(51.784118726544460684269758384467019937965942467431), SC_(29.648099762271335147864169961046958818809001159165) }}, 
      {{ SC_(302), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(58.0572985154335089748148038572708853533854154552), SC_(74.5032484152062239885056494257678843244091196993) }}, 
      {{ SC_(302), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(58.336200036474502653484068137003645324915416334958), SC_(74.207683052090313170869662548150911518590873190181) }}, 
      {{ SC_(302), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(60.67153857110073132411961111973350101628963139325), SC_(71.756632429171658182785172546591736041700381657529) }}, 
      {{ SC_(302), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(72.689561891845918813641687512375296819979313186345), SC_(59.777899169929246209391540331841793755552760748683) }}, 
      {{ SC_(302), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(73.270371522420506655501602700801882934553339244817), SC_(59.224508366468674955408593192560505321802769879678) }}, 
      {{ SC_(302), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(75.799808335881713441527234006411817254443047561274), SC_(56.840654846014731339719114285610193540886963647557) }}, 
      {{ SC_(302), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(76.146568982527270379299401284395799943742870964458), SC_(56.517139794660362279298950733468855370786900841832) }}, 
      {{ SC_(302), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(79.911984517789259221595761817865603053763281916454), SC_(53.054345329713257097986585754784264508112656135661) }}, 
      {{ SC_(302), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(237.81655064518486241552900573562634174932783242277), SC_(253.21339932563664332577492581901698654696838791079) }}, 
      {{ SC_(302), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(238.09483843168554944714761604857794684349708542695), SC_(252.95391673064911502400539275422890456178085819654) }}, 
      {{ SC_(302), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(240.40054174101000148877597992151905127478621699176), SC_(250.77878910010458143139522720886105812420502112006) }}, 
      {{ SC_(302), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(251.61162104207688373352587195995198014229410321942), SC_(239.52337392319392053220914935334673903378245197141) }}, 
      {{ SC_(302), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(252.12704831483301474653106066676491671415998445233), SC_(238.97700588691109546577504102762955471049554908349) }}, 
      {{ SC_(302), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(254.34460145186159018312664363341258700321597825077), SC_(236.59515990679523661953859093378244439626826909928) }}, 
      {{ SC_(302), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(254.64519424421830439494381157738425414947331940339), SC_(236.26833264702471323242559230797885471493976811698) }}, 
      {{ SC_(302), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(257.85710905003433329198295139722721956217168147537), SC_(232.71484875732819534696159015685501733739005187597) }}, 
      {{ SC_(302), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(244.28501760885277386939391861154227148157985983523), SC_(258.99294447301436438191720374524623953622675118147) }}, 
      {{ SC_(302), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(244.55186369090791553014585616553214930301740815475), SC_(258.74612007414671320110746009596626269921387859109) }}, 
      {{ SC_(302), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(246.76145658467984117127414433722949093161738392499), SC_(256.67554493750567473608908755942748128629189815697) }}, 
      {{ SC_(302), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(257.46866889538594922811338154772763726300427218462), SC_(245.92113124271226227725728301415369518060251721501) }}, 
      {{ SC_(302), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(257.95932147251472045909788792903119310340112004991), SC_(245.39753757940691700991882860331357096634780157485) }}, 
      {{ SC_(302), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(260.06848742743634363803033206556301345601654418956), SC_(243.11344940982185359609728888137545289209194749885) }}, 
      {{ SC_(302), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(260.35415771077629636203493314397717527572252836985), SC_(242.79984612227331808503655851605834835944734817771) }}, 
      {{ SC_(302), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(263.40300399743197525690265065940927189412191868648), SC_(239.38728478131606442366749454437839792668756042103) }}, 
      {{ SC_(302), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(267.22469770396138259385114023049642030040746240446), SC_(278.79229626960368029923613905020757118177991739019) }}, 
      {{ SC_(302), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(267.43873491569629429666761294105773506186507609981), SC_(278.60254868244455998156550041828215881303830104518) }}, 
      {{ SC_(302), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(269.20571235612098215553021876962742806723539911379), SC_(277.00418182809231838235869211455539775267851096277) }}, 
      {{ SC_(302), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(277.61780005454468200267214948259675723027754669551), SC_(268.53485295649588595006946171613467364351758356937) }}, 
      {{ SC_(302), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(277.99655895809332392385421000661282091728963076765), SC_(268.11614149046684485579308142399181310865724485711) }}, 
      {{ SC_(302), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(279.61709607809546533564801696348618727126111106059), SC_(266.28338247166331496241810535849178415491793478642) }}, 
      {{ SC_(302), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(279.83560260381711966068713062326900771164421249491), SC_(266.03097598965945505355268272782797978661316904552) }}, 
      {{ SC_(302), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(282.15208635115622908687851759200919555661298655155), SC_(263.27280878875950734688889770749211328263933252366) }}, 
      {{ SC_(302), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(269.72957093332278384778839822540361664920407245552), SC_(280.86660489058294656818429946885261075035167993189) }}, 
      {{ SC_(302), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(269.93630319318707463802060515694146075321642972689), SC_(280.68462404904181542368726915991365026523514054785) }}, 
      {{ SC_(302), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(271.64215191394071003552105886131753093459548980085), SC_(279.15058281055076168397247087351254758021979286304) }}, 
      {{ SC_(302), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(279.73973313760842693466200440513305439794032074809), SC_(270.99467680906563186691614397477764937780131730959) }}, 
      {{ SC_(302), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(280.10324964937734475330700748646575569437175973503), SC_(270.59045037875754075316420079663438195577479866405) }}, 
      {{ SC_(302), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(281.65730479741707434048337373809036296310908815628), SC_(268.8201359631369514205971263715023843581471331736) }}, 
      {{ SC_(302), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(281.86668270667749796433412897727547934609713215041), SC_(268.57621090494063184787930488863785461965000812104) }}, 
      {{ SC_(302), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(284.08375653549881679861963857371318325522942790502), SC_(265.90896267883724206025410732240965693988980440092) }}, 
      {{ SC_(302), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(288.62347540477632844174316594053655416944978700901), SC_(295.47925918742221465837913418000787633477001641752) }}, 
      {{ SC_(302), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(288.75695249445879720525593165603742789970821812958), SC_(295.374047140715413090351230426807516288610777144) }}, 
      {{ SC_(302), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(289.85080652586632429223246775482997575032141710919), SC_(294.47615977347437638610253300048165883538321852089) }}, 
      {{ SC_(302), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(294.82324979059433730114032708658926753431587690972), SC_(289.43723484361480869452791076645844985337234676731) }}, 
      {{ SC_(302), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(295.03602863168074420713641143332219020295526615264), SC_(289.17802566008345096219698304535963692891226675259) }}, 
      {{ SC_(302), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(295.93297114638916082266012272267617209155590929384), SC_(288.03405431489162718862079299168289907307616601638) }}, 
      {{ SC_(302), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(296.05214898840347028401051470872046839680681580646), SC_(287.87535309671933759009925849215510250869867140358) }}, 
      {{ SC_(302), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(297.28677782551279538572719627585853837331884707516), SC_(286.12408692626032435405609503706507505255412315564) }}, 
      {{ SC_(310), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(32.221314229454548819199058429410764648033753635825), SC_(45.585323757281930352125437203094641006114813118707) }}, 
      {{ SC_(310), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(32.443488931061489562814623263074576602848645822316), SC_(45.340844246525305986633214783475287899874607137444) }}, 
      {{ SC_(310), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(34.310414812314064248309066330835332887947949587832), SC_(43.319060776629910586207027871668452489079703039538) }}, 
      {{ SC_(310), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(44.087406810205434887676950819450058547925331202456), SC_(33.594645850861792626418855714030457715232015514585) }}, 
      {{ SC_(310), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(44.566497062775799769700637679713208923201665228107), SC_(33.152249803581177893258865009978267902836686634697) }}, 
      {{ SC_(310), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(46.659476208633945809881126848182331514896372517073), SC_(31.254143504091473293040744316307133643149414482493) }}, 
      {{ SC_(310), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(46.947217396178578639384702847140660803658301787129), SC_(30.997524494637807060611942196661450464011350288266) }}, 
      {{ SC_(310), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(50.084018870805342061488187673561259030249454112081), SC_(28.266048460393099899367923957296449106515819217182) }}, 
      {{ SC_(310), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(34.665821401153968997810677863198221720278333301459), SC_(48.403038231506591379849291504200857149416747878265) }}, 
      {{ SC_(310), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(34.894780818828451722007605455230058136871393012549), SC_(48.152285253062968197692617116012440608599213183967) }}, 
      {{ SC_(310), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(36.817837645931713735316937424403740470819728614729), SC_(46.07791646530159408824759168121942661617919929161) }}, 
      {{ SC_(310), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(46.866396974029946542427414222113483724335537359154), SC_(36.080731156161647951601541706198325744680337558393) }}, 
      {{ SC_(310), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(47.357947853602948767597703197739275800772492484553), SC_(35.625034397090460343545554607450680333889934411178) }}, 
      {{ SC_(310), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(49.504542338566807304410060193149157660701608597523), SC_(33.668844930719205480585374707104644111668637133796) }}, 
      {{ SC_(310), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(49.799552674237196870291753549588018381385631995542), SC_(33.404242238816119497403361748095963132099344240784) }}, 
      {{ SC_(310), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(53.014074114590676784740721588343271038951154457707), SC_(30.585714788601785386349350835527871070810191439578) }}, 
      {{ SC_(310), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(59.717294296184354259735159885673200619213403098572), SC_(76.379799005737393810434634083803188764404089969577) }}, 
      {{ SC_(310), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(59.999985201466501407920622357068843345324166104551), SC_(76.080445212023370337479254887937302084655032805304) }}, 
      {{ SC_(310), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(62.366869832769215744575097987017458384256057676308), SC_(73.597854110870842815571943834819586473085186896359) }}, 
      {{ SC_(310), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(74.542815266532036769640971290981226663036134538142), SC_(61.461197027255706397179498638167146967230815456675) }}, 
      {{ SC_(310), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(75.131098712891607434722557020760758209385115585335), SC_(60.900331094205546098314098948632977215658318635379) }}, 
      {{ SC_(310), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(77.69294138824440869074933787859055159468932359341), SC_(58.484063083804927598472967054377172202858906527311) }}, 
      {{ SC_(310), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(78.044127162154165324219095615925222516970079388524), SC_(58.156121269139351353929155740845572856834603425995) }}, 
      {{ SC_(310), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(81.857344253266152008834143052466878573634880646829), SC_(54.645497400196892822029003002135974115938040987514) }}, 
      {{ SC_(310), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(244.23294411846197401819509908469568641619118216876), SC_(259.83258252282388035702474192450730302238360046257) }}, 
      {{ SC_(310), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(244.51477970663297409158742070787838076842647631011), SC_(259.5695509133529074483759604865096894316288586392) }}, 
      {{ SC_(310), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(246.85001924735992855398158041870832287861917978351), SC_(257.36487991418144294161214526727597306301474969655) }}, 
      {{ SC_(310), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(258.20898098919470816492320923268687527004166638258), SC_(245.96158446869824003972156404715796987618800570962) }}, 
      {{ SC_(310), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(258.7314088167448871082349430659445912981927511513), SC_(245.40821754638382897692832632352540471651449709945) }}, 
      {{ SC_(310), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(260.97932062589283726561048305369676671159077964298), SC_(242.99602386996211150123189286642259266453497629126) }}, 
      {{ SC_(310), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(261.28405973387745345210476892512263915375594547296), SC_(242.66505237818172121677054591090191011738781532982) }}, 
      {{ SC_(310), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(264.54078009623585804147698611834970308682516921652), SC_(239.06679846692882580787886982985486575247421094015) }}, 
      {{ SC_(310), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(250.86820870070878661910799700037808119986733307046), SC_(265.76988793256051306861471243091871414301890485394) }}, 
      {{ SC_(310), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(251.13844460624053719115162447410997044556773589112), SC_(265.51967230658668057293162306647859538693628072939) }}, 
      {{ SC_(310), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(253.37625786718241363142834193546646638727312232336), SC_(263.42086854996552535552445676659822289766801634651) }}, 
      {{ SC_(310), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(264.22475989681625179957874414006939064494518423278), SC_(252.52516764636299558362771353974490789602197984734) }}, 
      {{ SC_(310), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(264.72210147981139343985956435676409370599434958318), SC_(251.99488690661743997547688265841727781632074974739) }}, 
      {{ SC_(310), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(266.86027661064543927226087492045802049749562534527), SC_(249.68180226644579139006580530123591690402154421018) }}, 
      {{ SC_(310), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(267.14990913238256546386895693938147754954775567502), SC_(249.36423915460527005254767632896422410821655694463) }}, 
      {{ SC_(310), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(270.24157657078133707153400816758856672165918818708), SC_(245.90889789526294848498837673605936614495051334776) }}, 
      {{ SC_(310), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(274.394738881591729871100309807683813929143643206), SC_(286.11492077497459808681738749002641151332904555598) }}, 
      {{ SC_(310), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(274.61144629531686166085816438261771633457823706972), SC_(285.9225003395988361166274008409362840573255170443) }}, 
      {{ SC_(310), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(276.40064969899725013846669455255992643469639691621), SC_(284.30189206169706196955592936797628117750971606197) }}, 
      {{ SC_(310), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(284.92399254303365888722459866969856975765096858828), SC_(275.7213127253115721067021752607471074803826932825) }}, 
      {{ SC_(310), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(285.30802168858579075780175652858968637267813806041), SC_(275.29733462941458217392065043101820871242940128041) }}, 
      {{ SC_(310), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(286.95142423336477789018067560921897314932320848155), SC_(273.44173417466408270810719761741508198006154381234) }}, 
      {{ SC_(310), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(287.17305523031333350454519436713790111147238553759), SC_(273.18620780869963362515682198332769826409102784725) }}, 
      {{ SC_(310), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(289.52333469026808651004074838848116738647201528383), SC_(270.39432409731409192671929404073492832965564718623) }}, 
      {{ SC_(310), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(276.96310316105785450029946915160677725817412668535), SC_(288.24708033741728198174801738828637988798924989781) }}, 
      {{ SC_(310), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(277.17240703924339189522848349252663802677033895934), SC_(288.06252498643953021837421538473132767349504616787) }}, 
      {{ SC_(310), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(278.89966046570885326910518325700072626514777421263), SC_(286.50706217360313724056067586621103664012076418473) }}, 
      {{ SC_(310), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(287.10438179481551740281985765382445937930035439126), SC_(278.24402116899542186958160375758449707020101089888) }}, 
      {{ SC_(310), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(287.47297426993568779195731330455736103406785077063), SC_(277.83472271598000571963837842928512536745208277541) }}, 
      {{ SC_(310), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(289.04905387912128170142293944189813933214195171714), SC_(276.04241005624358650037933437171507066781661297329) }}, 
      {{ SC_(310), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(289.26144163716129455031596135845856514122209720647), SC_(275.79548016930263429181382164631275244477691547078) }}, 
      {{ SC_(310), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(291.51107750889369608165707935000741483124371530004), SC_(273.09575677071015437318624565322340248000058914295) }}, 
      {{ SC_(310), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(296.32891665350358820979811152313778408355389292104), SC_(303.27567377778206904566758481080461145749439422135) }}, 
      {{ SC_(310), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(296.46398708131161127629112521946474036548506239841), SC_(303.16886061002246261287084173452998127650451008848) }}, 
      {{ SC_(310), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(297.57109474860968713682409081537346747169912950598), SC_(302.25767556603920762990813555373950320289736307582) }}, 
      {{ SC_(310), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(302.60983215289045225062084825268469750173484791863), SC_(297.1524695196150422595588408414939758900738274933) }}, 
      {{ SC_(310), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(302.82576177064444905219662766274734134915004118684), SC_(296.89011981450718240949139756303016966524769828114) }}, 
      {{ SC_(310), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(303.73640654528278809562680487790480356042866800229), SC_(295.73251730090432445484965422136640473032385965352) }}, 
      {{ SC_(310), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(303.8574617680637570290200197277712991871975659161), SC_(295.57195273245788561416307203366016221229610320151) }}, 
      {{ SC_(310), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(305.11250956022734467521927908718826935931277679485), SC_(293.80052330325248124516153356079771798853898630681) }}, 
      {{ SC_(318), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(33.151402398849168978038569113702195927287614461581), SC_(46.687027972824254606149343743626349202315839282971) }}, 
      {{ SC_(318), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(33.376581692629111645023908335422540336524856175802), SC_(46.439545684014435354791333444444921438981587165759) }}, 
      {{ SC_(318), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(35.268515106704995564770272543101558653797730020413), SC_(44.392765324030457802717986336235670574142335185491) }}, 
      {{ SC_(318), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(45.170646358549155890628483970181152239815713802067), SC_(34.543207912439025713824811847187329616865460785316) }}, 
      {{ SC_(318), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(45.655659848531061212680533636443598727745535168932), SC_(34.094886140136541571335337008452525505933633473591) }}, 
      {{ SC_(318), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(47.77432490658009037602035029757858071418735807555), SC_(32.171077498928293475317015200043643815216134482032) }}, 
      {{ SC_(318), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(48.065574045597719181309687077236179879559165847424), SC_(31.910947409300051884903027411413224487015852279211) }}, 
      {{ SC_(318), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(51.240277661040220644432512400177140892024238262472), SC_(29.141515594068631749134977118216328517751347833887) }}, 
      {{ SC_(318), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(35.66144684456398295857808776565376099191507981064), SC_(49.575047926398009628285739988530976591948008349628) }}, 
      {{ SC_(318), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(35.89349407194733008869176264849999219352198110449), SC_(49.321208823312585942536477327701643617680354630078) }}, 
      {{ SC_(318), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(37.842251944190671397695777486225124292025878277939), SC_(47.221148882636322593510116254629410054885202529155) }}, 
      {{ SC_(318), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(48.019429302639267877193276381146856100728976924592), SC_(37.095342537740726422576279393941156179646354136281) }}, 
      {{ SC_(318), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(48.517067933573151712355321022546366027145885601635), SC_(36.633555714964832770983573037821099781275911013916) }}, 
      {{ SC_(318), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(50.690061208467898169747260292333477153575335463348), SC_(34.650952200287305147879201517573223806786387488371) }}, 
      {{ SC_(318), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(50.988676779193271956843683971278365956642387059523), SC_(34.382741369601049435864537735795861344402194888602) }}, 
      {{ SC_(318), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(54.242150125831397687650507481883919439153250410507), SC_(31.525212286344255880016942866673394999671937298332) }}, 
      {{ SC_(318), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(61.378679294830728918340167819636576488836878382729), SC_(78.25496029373457112629282044217909714753136667253) }}, 
      {{ SC_(318), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(61.66511086173173093194201261711478553326361557885), SC_(77.95186674435449118491894627723807231019916900575) }}, 
      {{ SC_(318), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(64.063136346469712258991895233494731630411886528107), SC_(75.438140128085816877303285991379904088834602919559) }}, 
      {{ SC_(318), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(76.394978550271099830173782659429421643487308010175), SC_(63.145584648216731833528102897232182189497938394649) }}, 
      {{ SC_(318), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(76.990639854045296775066878467905380328728039786859), SC_(62.5773396094309909892654293565278748206310144275) }}, 
      {{ SC_(318), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(79.584471982511990145720651006557899176903244869196), SC_(60.129073949640916505211779077342037448617226934057) }}, 
      {{ SC_(318), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(79.940025972788873821665982131790860755196262068163), SC_(59.79676236468313000335815574238088151902518188939) }}, 
      {{ SC_(318), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(83.80042893564440237659733349576277980091708858593), SC_(56.238926180773045704776690541560209529984466206401) }}, 
      {{ SC_(318), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(250.65063889722194579671356217088807244689581481503), SC_(266.4504645265092156004602163201108830547265679654) }}, 
      {{ SC_(318), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(250.93597669049899727378591695105672156604188642036), SC_(266.18392955970524764278904775995883479083998533414) }}, 
      {{ SC_(318), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(253.30037314141188868951609202020866573585137748616), SC_(263.95009486838892303715866520397707928007915401179) }}, 
      {{ SC_(318), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(264.80532032630492728878611981929158290276815690828), SC_(252.40081604419722197390276653623004553211066662955) }}, 
      {{ SC_(318), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(265.33465874338690752176812495293386922277135493188), SC_(251.84054011807840034706429247149879483357840964978) }}, 
      {{ SC_(318), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(267.61253859716199906049336184947858584309899910002), SC_(249.398388824086618063984042072708955566201968705) }}, 
      {{ SC_(318), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(267.9213705986713498548760913944960510272252329623), SC_(249.06332641785040945967194341875533913998282067018) }}, 
      {{ SC_(318), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(271.22231782183466425595307752737152217413605660773), SC_(245.42087938702596768119072234012757162969257981644) }}, 
      {{ SC_(318), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(257.45264333628043804468380508366063837900798274), SC_(272.54558798194775402552345802293370949153082179211) }}, 
      {{ SC_(318), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(257.72622548932614315479073085288752218905310741991), SC_(272.29202477488841194334928796403393558347290211231) }}, 
      {{ SC_(318), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(259.99189662834680026585333735111194522025505892214), SC_(270.165355297637381512694631877478886451584031398) }}, 
      {{ SC_(318), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(270.97987568959101387658225821512029817195989506031), SC_(259.13017974812318154025527871450004185812136915838) }}, 
      {{ SC_(318), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(271.48382028892045450160855172238145460275121401896), SC_(258.59329782559390788575530282088257273158786403135) }}, 
      {{ SC_(318), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(273.65063116470876308375939646427139912273143051449), SC_(256.25158951104828245441257301979784568955312665117) }}, 
      {{ SC_(318), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(273.94417484460740464373855791923917297367285100215), SC_(255.93011753405780404970379987706700401991519025119) }}, 
      {{ SC_(318), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(277.0781099008989277718253158175153775845378906419), SC_(252.43254780789351492318022922409554617148049789101) }}, 
      {{ SC_(318), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(281.56576064415655966884153886271056503265704744554), SC_(293.43656500230637587779842461853341173215556898082) }}, 
      {{ SC_(318), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(281.78510388360231648542437802786738534376539095049), SC_(293.24150622615346437134678868944512586518362439304) }}, 
      {{ SC_(318), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(283.59624740978519452868492953111673585584540974572), SC_(291.59894312625787997504579355603105867723509313036) }}, 
      {{ SC_(318), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(292.22941666407195342542725240265782933752141332088), SC_(282.90854183131598247238746304735769555927184661687) }}, 
      {{ SC_(318), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(292.61864814312540301382372463152822385255369486596), SC_(282.47936483643204219076554507930088458124132580078) }}, 
      {{ SC_(318), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(294.2846208098146001517136420462728146219580933595), SC_(280.60121705747994507037644624426230376924851727491) }}, 
      {{ SC_(318), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(294.50933582483919494231137215896930427016096803713), SC_(280.34261103128331642690667580205664159874998691184) }}, 
      {{ SC_(318), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(296.89297135148804072357339267076715324050017138363), SC_(277.51744644593034434726676095364854783945271321448) }}, 
      {{ SC_(318), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(284.19757997872598455120220311764714908092490144258), SC_(295.62661154264319971121548139628713701402543782128) }}, 
      {{ SC_(318), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(284.40942235861273430871802138721151360774493859914), SC_(295.43951494192653444102325712286553276770288909933) }}, 
      {{ SC_(318), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(286.15780514690216097655055853184868143953183009517), SC_(293.86290672683068752636694774148775191056632735846) }}, 
      {{ SC_(318), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(294.4682904300168149669944810603853899825101128702), SC_(285.49410662147164110374134452391043183297074391871) }}, 
      {{ SC_(318), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(294.84189343166058371203587273653006025567049986226), SC_(285.07980138926130367909111414113912409217500913711) }}, 
      {{ SC_(318), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(296.43971286379941683398162924829728710455419765612), SC_(283.26577382373016309017317316061516549723500878561) }}, 
      {{ SC_(318), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(296.65507146559811363132515029488595423275445736305), SC_(283.0158778621944543428928787057946796590176723377) }}, 
      {{ SC_(318), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(298.93684519364859432580859139793249670934244613929), SC_(280.28409907854698211482852420083663100245879838179) }}, 
      {{ SC_(318), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(304.03494613058820138170574279352940689326899775823), SC_(311.07150202567899020050187091492199281573777834552) }}, 
      {{ SC_(318), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(304.17158927025013278844140743446301047277089831475), SC_(310.96310872688000623684625359364676798423257835243) }}, 
      {{ SC_(318), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(305.29177935954444497366166167826478549015577997366), SC_(310.0387992263774993353124383326118415422477050891) }}, 
      {{ SC_(318), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(310.39595658924452619429022801473849186774649727295), SC_(304.86816579586733198046622965905183347847690237144) }}, 
      {{ SC_(318), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(310.6149959492708543877210010850169529866209086706), SC_(304.60271613770281525384618215342036480974244320851) }}, 
      {{ SC_(318), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(311.53916312356598936905422762487161750930179345706), SC_(303.43165897361166323902421245649906938456685620214) }}, 
      {{ SC_(318), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(311.6620708618388586696750052085897799953440288872), SC_(303.26925524456838855290611256670809246727460787621) }}, 
      {{ SC_(318), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(312.93726199349806698247677127878190307995402796761), SC_(301.47792536456566980526273368669562188483859095386) }}, 
      {{ SC_(326), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(34.08256482193419371953558009797764141340195748617), SC_(47.787657753661476029988734823531701627190598988969) }}, 
      {{ SC_(326), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(34.310710964292482007823902875824092385849648034692), SC_(47.537210342266662870430443214635983288162025646698) }}, 
      {{ SC_(326), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(36.227338201072411370238728172610143469805319280409), SC_(45.465746287964306786320600261052898674462866770004) }}, 
      {{ SC_(326), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(46.253042908383200667026546889828227061751752155593), SC_(35.492612344647270553326698333867099256731799577968) }}, 
      {{ SC_(326), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(46.743905422626274076538448298077323381360206297547), SC_(35.038439180633342433102434546424622997842728884118) }}, 
      {{ SC_(326), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(48.887934239914628356475214117199997911812917649245), SC_(33.089251149734955403997364883331518051955108498502) }}, 
      {{ SC_(326), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(49.182647286600859407308310194232649727227570680007), SC_(32.82565417669064110216197408858141265102013250205) }}, 
      {{ SC_(326), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(52.394776297165727290317385067048981632132780221844), SC_(30.018745971171026406251297629511934874185354443225) }}, 
      {{ SC_(326), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(36.658176258823955714585156385879681853039107175696), SC_(50.745953485852535944894147135988659966966176012538) }}, 
      {{ SC_(326), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(36.893272519542268537101860454821427341503965542709), SC_(50.489066952584841334829458234946546247525226083187) }}, 
      {{ SC_(326), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(38.86740910636149852195907859482860981692720162678), SC_(48.363637710985326938552997889551616563772795326838) }}, 
      {{ SC_(326), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(49.17159532392747088843531919023032794771745082174), SC_(38.110819646460097036108329240110281356675679411057) }}, 
      {{ SC_(326), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(49.675245441873197504714045095398193526601385105505), SC_(37.643019136142101847097629360024540484578818883113) }}, 
      {{ SC_(326), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(51.874306467277015766210631086346786350246220377615), SC_(35.634333355154219145843259023517417012786385604006) }}, 
      {{ SC_(326), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(52.17648201677814908807005940664673887128388907441), SC_(35.36255978396001110589406506797908706229378659846) }}, 
      {{ SC_(326), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(55.468417443139261968941539432247055570667478971733), SC_(32.466521345572764763893098587867239284740522473975) }}, 
      {{ SC_(326), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(63.041401374640609709065764162008611021280827265079), SC_(80.128784422564348512212806746103519909181422767727) }}, 
      {{ SC_(326), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(63.331526713131705780782291300904768730047609227963), SC_(79.821997963346195766183017187033943433299501584017) }}, 
      {{ SC_(326), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(65.760303036345054434820775426333399219711891940954), SC_(77.277525587233393270367805783894487947407104606846) }}, 
      {{ SC_(326), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(78.246092646844982952444141796823283220097798789371), SC_(64.831021153392279137888468170113602665367451190869) }}, 
      {{ SC_(326), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(78.849039453199022393810251136710756900066528914391), SC_(64.25548942441365339664400327247973866743748811116) }}, 
      {{ SC_(326), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(81.474460275485867512311142910097957684971725654095), SC_(61.775627274692422180928404291593984253882207056301) }}, 
      {{ SC_(326), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(81.834327711781727746828727971656602336902467250377), SC_(61.439000765881625366158705968609347807865114691969) }}, 
      {{ SC_(326), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(85.741324051682505140053571922586542092830089703026), SC_(57.834546062936354301356189245243657526193903101051) }}, 
      {{ SC_(326), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(257.06958612966456759236598617571466410816880426816), SC_(273.06709417963391278893282918822180303267516292989) }}, 
      {{ SC_(326), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(257.35838224533167491468414903312278808850340993212), SC_(272.79709979437105985170587641678605836202504924977) }}, 
      {{ SC_(326), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(259.75157053303716268622362909804845960783612311211), SC_(270.5344668136950734864518772625048721799749376854) }}, 
      {{ SC_(326), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(271.40067734326188311428110459902400823737264693844), SC_(258.84103032851007536187101245770766991744892550092) }}, 
      {{ SC_(326), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(271.93683976670660992978660102532742481701528906639), SC_(258.27393190476602343859030986111034922046850964596) }}, 
      {{ SC_(326), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(274.24431174141668729954383234771537906597497684168), SC_(255.8021984082801076694628672596775933092639297007) }}, 
      {{ SC_(326), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(274.55718522802217807532052632939630586450921432785), SC_(255.46309639914212110793641382237383547625999519423) }}, 
      {{ SC_(326), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(277.90180248558350606303871437068122891054046099846), SC_(251.7770114138512835680613188388622869404659090552) }}, 
      {{ SC_(326), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(264.03827482396659528729528905223446949870138887333), SC_(279.32009130213974181716674582105902066706766345092) }}, 
      {{ SC_(326), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(264.31516128677131930268676394252570187683860600572), SC_(279.06322251669218816534567337962576622893719439903) }}, 
      {{ SC_(326), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(266.60834143249038197534530294613614870756903337115), SC_(276.9090365706125803989723442861582875277673863892) }}, 
      {{ SC_(326), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(277.73405286343364863451162760475188835841578759775), SC_(265.73613092170110755366737391397841722546726871186) }}, 
      {{ SC_(326), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(278.24451772327136355920773412132677336160994606755), SC_(265.19273048330877032752521602866318691750898038195) }}, 
      {{ SC_(326), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(280.43960497613812304918523513465692395599113100076), SC_(262.8227572739118893705889162247246738382059681579) }}, 
      {{ SC_(326), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(280.73701066055848623041603666726565917041688501378), SC_(262.49742547320334009052429180440741562722873115355) }}, 
      {{ SC_(326), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(283.91268073864476688781849254676478545122987439507), SC_(258.95815794784004453348965835262737993152178052078) }}, 
      {{ SC_(326), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(288.7377261286709785996502671860652181695295706354), SC_(300.75726578914443781413398364763856634415265929768) }}, 
      {{ SC_(326), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(288.95967211149536523308909661407112908086990953553), SC_(300.55960187622052098303561269628307485880695922717) }}, 
      {{ SC_(326), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(290.79248066845571764197328021037473995067337453626), SC_(298.89535975212314799016167224720848078474659321669) }}, 
      {{ SC_(326), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(299.53410126021824906575954678218794009702523909489), SC_(290.09651135866651231426969354978478468856325689923) }}, 
      {{ SC_(326), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(299.92846972400730411425846565007868872607529969741), SC_(289.66220064870936847518354189946333694394010962986) }}, 
      {{ SC_(326), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(301.61672836830124871159291437704355396203631187776), SC_(287.76178858520653910608648025875862190553823615134) }}, 
      {{ SC_(326), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(301.84448848100901358190446004876992108000256381776), SC_(287.50014160652214232471002586367912418115766928173) }}, 
      {{ SC_(326), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(304.26105717496093050973528218046835429362607153479), SC_(284.64211533386781292280789947999015339435152388083) }}, 
      {{ SC_(326), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(291.43296586776403135782531595886047890751730515351), SC_(303.00523399575052220686195296950722876968415622229) }}, 
      {{ SC_(326), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(291.64731487953208019596133252275776849994817338989), SC_(302.81562814784274944285994284741382767954314992204) }}, 
      {{ SC_(326), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(293.41656204199226819305429996443160513244368130072), SC_(301.21814028690535910743068652372692885549535225535) }}, 
      {{ SC_(326), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(301.83148682353933289178394317273598882550874411097), SC_(292.74490530507911397608493440930319639378736023136) }}, 
      {{ SC_(326), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(302.21003738263012740862702567655933663604811600807), SC_(292.32565608329636039689046019633960597891444183692) }}, 
      {{ SC_(326), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(303.82932276276728563520078312385734562890978454456), SC_(290.49018628125871621937984956567492958494497227849) }}, 
      {{ SC_(326), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(304.04761468263947239206666789577485181547119054664), SC_(290.2373615382666388082065749071224981318137393437) }}, 
      {{ SC_(326), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(306.36111826301108006791102678587924681140176744933), SC_(287.47393129997235773898278078057854623930871906627) }}, 
      {{ SC_(326), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(311.74154160373999806536232452643426813981570410466), SC_(318.86676599057524513451049242928846294345746940837) }}, 
      {{ SC_(326), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(311.87973760848467685843727210626876018606134323499), SC_(318.75681274679742791398815494157372746696096030531) }}, 
      {{ SC_(326), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(313.01284536465846214215045495994868076370176358635), SC_(317.81954542010613146300059413212859307093958211557) }}, 
      {{ SC_(326), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(318.18164026010711995288939529738260933999076264618), SC_(312.58430622067573715623856697477487253565985027971) }}, 
      {{ SC_(326), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(318.40374988870017691297528914083354033578874001294), SC_(312.31579564763290813583373322211569888357682294553) }}, 
      {{ SC_(326), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(319.34126650123773956983229223700491253273074436938), SC_(311.13145367825038538378599364172392324474565133354) }}, 
      {{ SC_(326), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(319.46600285291745679005243316947223239346014999468), SC_(310.96723406196223962771194260917058938558688423832) }}, 
      {{ SC_(326), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(320.76107262058619731365441129351301419683008369718), SC_(309.15625655131034733118125526786620420452875143574) }}, 
      {{ SC_(334), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(35.014762137650976103405234770181358063739227121271), SC_(48.887252475145722741675208717904890278456886246456) }}, 
      {{ SC_(334), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(35.245838772966806038930160458808833670866325342107), SC_(48.633876214925917116149324267617938833754417925302) }}, 
      {{ SC_(334), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(37.186857641862971142938259478342507172718645652324), SC_(46.538030178926804568089728007014007681222417005245) }}, 
      {{ SC_(334), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(47.334627346715716694244702845466978562924748571043), SC_(36.442828306453999473334795275955445112419612084187) }}, 
      {{ SC_(334), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(47.831267393007389075359688304949930005344206977941), SC_(35.982875354606090698109435830507595906323443537643) }}, 
      {{ SC_(334), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(50.000349639019639317873030085660739186041879172489), SC_(34.008619006728642941135674452503498816810283736922) }}, 
      {{ SC_(334), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(50.298484167469596532125317365021744734713537597772), SC_(33.74159771818398751401514627611851051629009264775) }}, 
      {{ SC_(334), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(53.547579368940430137431825358355075146812946702371), SC_(30.89767478074416294806402886196193714573878641046) }}, 
      {{ SC_(334), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(37.655969198279967292589762671190854344484684106933), SC_(51.915795368462576347614638351212856647544617584033) }}, 
      {{ SC_(334), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(37.894077141431661123514589595770375471973259623623), SC_(51.655898679828217038344696389273301029462703739793) }}, 
      {{ SC_(334), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(39.893281945383647520678074013029242885481271348594), SC_(49.505410190065393837136865122935137032246845548217) }}, 
      {{ SC_(334), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(50.322926774750457344665613472275129009428595834273), SC_(39.127130787895273183052535592123059171946265131438) }}, 
      {{ SC_(334), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(50.832514911196456004196664473303029287364751342587), SC_(38.653390162446274716878157223573799021823364701519) }}, 
      {{ SC_(334), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(53.057324794585847640174337132152008774690273280153), SC_(36.618941697350760468498314579224969468712248194548) }}, 
      {{ SC_(334), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(53.363016728750607020936098676935939507625831672311), SC_(36.343649111593995565185118713491466841864647057845) }}, 
      {{ SC_(334), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(56.692942427358695648822284810364125957976831751468), SC_(33.409575400060830453949316878806032150712581640819) }}, 
      {{ SC_(334), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(64.705411580535335110321850717009119484235286119396), SC_(82.001320353266257801973322639846768465499253906886) }}, 
      {{ SC_(334), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(64.99918552109332236676653226032062337615695179271), SC_(81.690886112689658837101414160752611313896143210471) }}, 
      {{ SC_(334), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(67.458336965555527261529256018284302047761804414), SC_(79.116043452766802745291953777190095631716046894854) }}, 
      {{ SC_(334), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(80.096195964189571995943248756932990132709593777353), SC_(66.517468156849338480966273300723188189153221613626) }}, 
      {{ SC_(334), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(80.706339301791410092107519900777865784216982981603), SC_(65.934738765395319723884482907579037794863974371291) }}, 
      {{ SC_(334), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(83.36296275182871076361044929244193098393674022451), SC_(63.423666563374643909354497901399416180552053083624) }}, 
      {{ SC_(334), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(83.727090873446580431618752064522164691778446765019), SC_(63.082777962044307818466824347098819358138433336351) }}, 
      {{ SC_(334), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(87.680109865179777489091988431757443326644853826957), SC_(59.432276672780686159972467362662100208320135985517) }}, 
      {{ SC_(334), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(263.48973994608546205016500892777948232014620910307), SC_(279.68251734395027206270989054162411312872181024047) }}, 
      {{ SC_(334), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(263.78195211053882247945051070773671194328518483386), SC_(279.40910586598351949926766583628781964004984991347) }}, 
      {{ SC_(334), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(266.20358053932437725513983877722216718022149790496), SC_(277.11802659763079200959961390686437579962127331831) }}, 
      {{ SC_(334), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(277.99508799416745380213409379979523557499161220468), SC_(265.2821913392480589642142174144029757620861019877) }}, 
      {{ SC_(334), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(278.53799101614741881343452882641235697625538680028), SC_(264.70835375418887681086840818409243280053774051817) }}, 
      {{ SC_(334), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(280.87469299186264316999882254865066606274483379616), SC_(262.20739970284191502254100905960014804340894831461) }}, 
      {{ SC_(334), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(281.1915584453755906932012595098682315990162757222), SC_(261.86430751905779940878096335373039716701487165877) }}, 
      {{ SC_(334), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(284.57930943612806087953010426196391283552116577508), SC_(258.13511933893188895368954329142914193407439917611) }}, 
      {{ SC_(334), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(270.62505932287649673696728995140923220419647058504), SC_(286.09344172448511012443303523716020544588473330236) }}, 
      {{ SC_(334), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(270.9052096957632530498289646877719231851900026826), SC_(285.83330782063910330403973154011472043191149058474) }}, 
      {{ SC_(334), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(273.22556276273916026437881634043193066279459900252), SC_(283.65194184457917405972144494341014378395839733599) }}, 
      {{ SC_(334), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(284.48732577587954174504925756785938717553365816703), SC_(272.34298677654692610282509586452700224840247435593) }}, 
      {{ SC_(334), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(285.00423117635949488341158447434890487034462049985), SC_(271.79314745956299688643204424270526216491074830233) }}, 
      {{ SC_(334), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(287.22724864028157338955900831771318045812534005392), SC_(269.39525497496531333433270215775878297945200072727) }}, 
      {{ SC_(334), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(287.52846898400703724681255190728086368065274242969), SC_(269.06611059158476230594568652668300821625507658109) }}, 
      {{ SC_(334), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(290.74536113741288566916692691274306283651102877571), SC_(265.48565642405347447929135651692126801575768604514) }}, 
      {{ SC_(334), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(295.91060072539045546660737686578186086925311461507), SC_(308.07705772250320112130810438089819920078705275747) }}, 
      {{ SC_(334), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(296.13511758401101705954160955295975954084685622078), SC_(307.87682065344489508033933134034522669066313673965) }}, 
      {{ SC_(334), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(297.98932617194742614482543505873083368500320633994), SC_(306.19116516139915229778633275194878245133844057904) }}, 
      {{ SC_(334), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(306.83807341399164443187822646645185916924391594243), SC_(297.28519415876011199019251304833494008706311298423) }}, 
      {{ SC_(334), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(307.23751591659610199152155390747998638543656308989), SC_(296.84581252637356781315938013912183341908872166401) }}, 
      {{ SC_(334), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(308.9477868670557198645980297675931536332597656234), SC_(294.92340882340915256586544098526377833657954406543) }}, 
      {{ SC_(334), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(309.17855459535296266450426648377283904704842552028), SC_(294.65875817686155510670358608027699801392477816358) }}, 
      {{ SC_(334), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(311.62764926580569306991945103573023289043306568365), SC_(291.76827396312049772389587667245090318873994081586) }}, 
      {{ SC_(334), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(298.66922748117701112872425361183223344728710411931), SC_(310.3829810177748558379488685862210077589656342342) }}, 
      {{ SC_(334), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(298.88605242550760906541340044546393923383921908343), SC_(310.19089674534614214946289626788275919116453823136) }}, 
      {{ SC_(334), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(300.67590869753136190229801457069360906943742615886), SC_(308.57278521805033131224689768055942583341998043188) }}, 
      {{ SC_(334), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(309.19399706047100287683702228184646493676766573773), SC_(299.99639106162581434748781002136226768729969220157) }}, 
      {{ SC_(334), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(309.57743452436116684701030339467036813158307375444), SC_(299.57225833603340259474433208561186640275217280691) }}, 
      {{ SC_(334), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(311.21792207890902823869922268743240471003432134686), SC_(297.71560895073919388267837566426266615757777266375) }}, 
      {{ SC_(334), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(311.43911117924760909790610506735195593603543617357), SC_(297.45989134793528649844901138452910670618321719097) }}, 
      {{ SC_(334), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(313.78395178591265206378894579254915551184313148584), SC_(294.66519870168408920490543370928678844370154266198) }}, 
      {{ SC_(334), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(319.44868220638294709724710530837659142209178508638), SC_(326.66148638612594871417808499280532128156280675967) }}, 
      {{ SC_(334), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(319.58841196110199028777763310091577166050130572678), SC_(326.54999262940963724140856504062159745860839986198) }}, 
      {{ SC_(334), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(320.73427869209406491399084673078435841922512619886), SC_(325.5999279235626784997469544823825373027595385931) }}, 
      {{ SC_(334), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(325.96689928320635221712939424391402272760173051115), SC_(320.30087441494617428597215802739189282683999255544) }}, 
      {{ SC_(334), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(326.19204117108264802376434302560207890893955873398), SC_(320.0293405286222171930292557312289086511737998973) }}, 
      {{ SC_(334), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(327.1427407301934424604948740958144614829289806877), SC_(318.83187733602110224359212907145054463719225685149) }}, 
      {{ SC_(334), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(327.26928269587912949289413709879748959142024321834), SC_(318.66586424586687624285782001540473052842373771702) }}, 
      {{ SC_(334), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(328.58397660694419229789807000989924537059974732008), SC_(316.83548255286664937669445100332261344247173595561) }}, 
      {{ SC_(342), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(35.947957331249102208838976018083922493472169809344), SC_(49.985849164864073166831196274439649211425432931599) }}, 
      {{ SC_(342), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(36.181929408823787877607674219652827688796075397595), SC_(49.729579030342921809737117759879728134829087009509) }}, 
      {{ SC_(342), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(38.147048550524609694357068555738421935039291282155), SC_(47.609641927025143208765135001745739063186813152884) }}, 
      {{ SC_(342), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(48.415428719231224405901744477655903982766348030646), SC_(37.393826793769470250529715689689987593638943733335) }}, 
      {{ SC_(342), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(48.917777364010657204616890837860002091082461018238), SC_(36.92816309159998653668689041185766056597019335675) }}, 
      {{ SC_(342), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(51.111613824920917379125717182257777272796453476216), SC_(34.92913833115447706132843297388910847052362348201) }}, 
      {{ SC_(342), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(51.413128930460849199270749639990203344824629671629), SC_(34.658733763869945169914719794359874464417130971747) }}, 
      {{ SC_(342), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(54.698747610422548916071590366399851397859395192733), SC_(31.778241088146206313477988406069061844013895876809) }}, 
      {{ SC_(342), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(38.65478762802065807930376489294399763000519347653), SC_(53.084611620764258041453061049978366651466860145144) }}, 
      {{ SC_(342), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(38.895871242909995346161224832629496941780041656188), SC_(52.821740716661522756376255144046661712526020925279) }}, 
      {{ SC_(342), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(40.919844892856130485349213183783201335768660661808), SC_(50.64649193595597652857790158572388067340585899396) }}, 
      {{ SC_(342), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(51.473453500221400964864802254579914966596155673945), SC_(40.144246155326064797032687426904230577453265944271) }}, 
      {{ SC_(342), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(51.988908815755641011420809719815001884918447109139), SC_(39.664636350872806178797143730419997564485917430576) }}, 
      {{ SC_(342), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(54.2391600864738454645800549677820467346099597795), SC_(37.604733314015658089566986468802157615438490893337) }}, 
      {{ SC_(342), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(54.548326374057590690328918862804282763096504873242), SC_(37.325963867558311920006368081730937961175939332131) }}, 
      {{ SC_(342), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(57.915787478452396648584273328893615337612038491092), SC_(34.354311863610928558490247769679540226966747085846) }}, 
      {{ SC_(342), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(66.370663873730449583674445777932984970503535155277), SC_(83.872614129995102696870249597218268013629285789057) }}, 
      {{ SC_(342), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(66.668042864619661473643607304218851177716927404868), SC_(83.55857562161570540621942390122477131317780561416) }}, 
      {{ SC_(342), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(69.157207158005585919920612878677726976592104083268), SC_(80.953724725795639520173509153385769503688280095959) }}, 
      {{ SC_(342), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(81.945324622536846495642331140043743950220244832187), SC_(68.204889558278604359467339955625050660254968577786) }}, 
      {{ SC_(342), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(82.562578701885546896981925161336088099265599146585), SC_(67.615048346313869985445156949863809905296276182463) }}, 
      {{ SC_(342), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(85.250032530420990372112266993878966915282157085552), SC_(65.073138686867561424435117995577743666563921851142) }}, 
      {{ SC_(342), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(85.618370466356015590292899930053975503620093022694), SC_(64.728038929713599173106407465889895343129100016556) }}, 
      {{ SC_(342), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(89.616861853077229249440206662514485089614259344807), SC_(61.032042433539845344743259761849176302021388545659) }}, 
      {{ SC_(342), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(269.91105721008278428096563782592212407193380054837), SC_(286.29677714870215955232684079663510007118748114431) }}, 
      {{ SC_(342), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(270.20664466284155873449035114541027941646348045444), SC_(286.01998938702884696649026325662047851923283986425) }}, 
      {{ SC_(342), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(272.65637411715653838180015653910821562975828401818), SC_(283.70080323126742706775716617515337318359577306464) }}, 
      {{ SC_(342), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(284.58858609209912090286960730414632692397689565879), SC_(271.72426523772651888119399457101384783300183055789) }}, 
      {{ SC_(342), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(285.13814929065074686791361320646884596041798117988), SC_(271.14376884676434811369486848973021799563645331915) }}, 
      {{ SC_(342), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(287.50373212646336835376288043251952457898232668887), SC_(268.61394294210999044162663906723136664035816958797) }}, 
      {{ SC_(342), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(287.82454180584185742402405560952730872209864711211), SC_(268.26690824108256411902114275166078529365713494398) }}, 
      {{ SC_(342), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(291.25490952256995072111402401847937757267525767367), SC_(264.49513244025504312131288053780223605094041335896) }}, 
      {{ SC_(342), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(277.21295560495924838381747359058390327812167184386), SC_(292.86568046845106087577506561684963484560993314888) }}, 
      {{ SC_(342), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(277.49633093456256717193934617055113339582465561583), SC_(292.60232045568494502440830383112936125171742737952) }}, 
      {{ SC_(342), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(279.84353286094973908303224148101895183058877920668), SC_(290.39409884038043396667737268733716763640387347199) }}, 
      {{ SC_(342), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(291.23972673837877605274739131825135776752503988335), SC_(278.95071497132850319361602491182516324114699097863) }}, 
      {{ SC_(342), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(291.76299581437587358689825489018282965711414008422), SC_(278.39451356401105935503294231606440535171858145655) }}, 
      {{ SC_(342), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(294.01360973603856430213935690092132432353144203498), SC_(275.96903504923511774811677584055208094813138074548) }}, 
      {{ SC_(342), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(294.31859909401012455591580882705705009831446440317), SC_(275.63612363135886629528165818107419914640839096184) }}, 
      {{ SC_(342), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(297.57621884608040405533344123911707197444540188228), SC_(272.01497563485360437614780686347874857560965042813) }}, 
      {{ SC_(342), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(303.08435188958693572809367096503669973547558465018), SC_(315.39597332674134910059314473706531122901173233859) }}, 
      {{ SC_(342), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(303.31140889863101289677952343253123409182215175275), SC_(315.19319393215828681329770458720679766633620090196) }}, 
      {{ SC_(342), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(305.1867620074495426367096085583627267744791191675), SC_(313.48638119363133408118425623285173270968328337545) }}, 
      {{ SC_(342), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(314.14135859462269531713061065017180217375373447834), SC_(304.47456470261953061624723620996363180263791406384) }}, 
      {{ SC_(342), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(314.54581444921832147978974109655209816785772053373), SC_(304.03017269186943725939567156110855314964391340601) }}, 
      {{ SC_(342), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(316.27783387916381752966349426884743226253770086279), SC_(302.08604022085573936534503678158963063048910809445) }}, 
      {{ SC_(342), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(316.51157309275393339621141672449659607169662358317), SC_(301.81842185304200051214481412437034944841870402323) }}, 
      {{ SC_(342), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(318.99280130751197360280787405870458303238178079292), SC_(298.89586892876687372247055041328068362985915592976) }}, 
      {{ SC_(342), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(305.90633346209665732526277349744064285967402190025), SC_(317.75988394233645050825671198621288057881523889827) }}, 
      {{ SC_(342), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(306.12560474025272385534529973967203923792967390673), SC_(317.56535095896050155113554862174582162205241941348) }}, 
      {{ SC_(342), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(307.93582399998753524172944542642326471317157630305), SC_(315.92686255305972446565120872813683380678158838608) }}, 
      {{ SC_(342), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(316.55584567200324038410660499426093298156573955657), SC_(307.24853929384166425238817825400423253077307549149) }}, 
      {{ SC_(342), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(316.94411156583221235218726036468369757566376459972), SC_(306.81958138383926254568186326424736725820511067445) }}, 
      {{ SC_(342), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(318.60554701632495472208431099305540829404072922057), SC_(304.94200565088964894467844861066187654369013683099) }}, 
      {{ SC_(342), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(318.82959846403801580097863847521149239107589922008), SC_(304.68342982044901911243738872482822142890833090092) }}, 
      {{ SC_(342), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(321.20539752959062580672792943426999399864268198469), SC_(301.85784982091436666227196269038738272364310485278) }}, 
      {{ SC_(342), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(327.15634832304271906173703666736954405827270029263), SC_(334.45568269206311343913011962643853295792906449412) }}, 
      {{ SC_(342), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(327.29759340046124698393681687893177039209848039607), SC_(334.34266714613934099574672262500098530575008034944) }}, 
      {{ SC_(342), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(328.45606611465143390791353875164725909085947320214), SC_(333.37995969729617706009652876216567293347371565581) }}, 
      {{ SC_(342), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(333.75174881989770564748418921554260554389225084672), SC_(328.01785498211336583678783612041339051034368027195) }}, 
      {{ SC_(342), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(333.97988633401669590847593034631895762079889184499), SC_(327.74333403344046619331132651051154281821838373295) }}, 
      {{ SC_(342), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(334.94360842499540249325930976707902163056810211247), SC_(326.53290731184210168932229373500838232015209793387) }}, 
      {{ SC_(342), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(335.0719338526350435656099261267831914534792585115), SC_(326.36512235284868988736936886468373154762694939744) }}, 
      {{ SC_(342), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(336.40600698538778266860308214615155040789608067844), SC_(324.51557111806707616583722639401022326879056305701) }}, 
      {{ SC_(350), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(36.882115543042755745185184491151570775622105820887), SC_(51.083482694062222774521942015205283108385971840774) }}, 
      {{ SC_(350), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(37.118949240843915411761551101467194868031961182466), SC_(50.824352436268474245647636546044848901770477508343) }}, 
      {{ SC_(350), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(39.107887495290645611892945004518696435108195144722), SC_(48.680605010816499368300606300355126209377874007138) }}, 
      {{ SC_(350), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(49.49547438040086288894653705298212434546337056341), SC_(38.345580489846034220855424427264878367823167449225) }}, 
      {{ SC_(350), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(50.00346509970738176884210579516879043690225157793), SC_(37.874272658247861200146937390851674975737247933683) }}, 
      {{ SC_(350), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(52.221767030234034775842706201302375940593309948304), SC_(35.850768874164812036989115143214925061602698863456) }}, 
      {{ SC_(350), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(52.526623240649428028526134204581849571976988358145), SC_(35.57702062342072095039448326782901026386031960836) }}, 
      {{ SC_(350), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(55.848338214677788492473662608616068588372833851211), SC_(32.660387517996378715403591516068843905849708980764) }}, 
      {{ SC_(350), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(39.654595727396615846570815167213138280540105409226), SC_(54.25243807387985810017272915144245079603891004622) }}, 
      {{ SC_(350), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(39.89862026524202439499348306226239893424400393087), SC_(53.986627637102600722882500904542059199491114367507) }}, 
      {{ SC_(350), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(41.947073867266113945652073172295177018897100560016), SC_(51.786907073445184696498139504446448160321093175715) }}, 
      {{ SC_(350), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(52.62320360791182541617970291589472771866328917655), SC_(41.162137676004704738395315341021313818554492464395) }}, 
      {{ SC_(350), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(53.144457739080368807244193557646943002932942449894), SC_(40.676727146178192285735111504222105474896697199665) }}, 
      {{ SC_(350), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(55.419853682475183875575121926364682387500574622446), SC_(38.591666850260360588708030076675437000301360522249) }}, 
      {{ SC_(350), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(55.732453763911641845147111567628840264716076845817), SC_(38.309461216909213535005368735294732572365945832846) }}, 
      {{ SC_(350), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(59.137011358753698182322068061375903808357721108321), SC_(35.300671804622644817936220838452254366809318129847) }}, 
      {{ SC_(350), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(68.037114894170418935068539036161668108839012414192), SC_(85.742709117657421380383610754461035209185339713757) }}, 
      {{ SC_(350), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(68.338056907110972335345854636580906049742365492161), SC_(85.425108334178362088331235569874726629319080365668) }}, 
      {{ SC_(350), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(70.856884438729544359308073111838045148271366784838), SC_(82.790598603999014549591281408562898784901780889905) }}, 
      {{ SC_(350), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(83.793512640757299024353486310661319794203386189923), SC_(69.893251356892197267497787783759314994974311271493) }}, 
      {{ SC_(350), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(84.417794668948468177633563522799213068393462942458), SC_(69.296381166218547728445385192776645680502302158496) }}, 
      {{ SC_(350), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(87.135719638620020817094247798382888331605606078842), SC_(66.723993608749046651728940202213354931656170131791) }}, 
      {{ SC_(350), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(87.508218297391192378927335097905455840007424450508), SC_(66.374731848449149169462402005430331920721146807721) }}, 
      {{ SC_(350), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(91.551651095831174620610424326872457945978467438966), SC_(62.633772174041408041945852634196898630997513492053) }}, 
      {{ SC_(350), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(276.33349729583105936773606995546608001815775058239), SC_(292.90991421325477196796010116226959705937956270564) }}, 
      {{ SC_(350), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(276.63242070137769711562576702420362338138746365566), SC_(292.62978954860428158474081640283419429132602578637) }}, 
      {{ SC_(350), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(279.10992391332631297770298050662285052298293718226), SC_(290.28282403871764654367483721934488895137708705618) }}, 
      {{ SC_(350), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(291.18120348345107306636726426740424179424047829788), SC_(278.16722015431383720832708612450558239884487945839) }}, 
      {{ SC_(350), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(291.73734924845863767051057063223156366549570054397), SC_(277.58014250552969897835047706806322895758047549929) }}, 
      {{ SC_(350), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(294.13147602512908793674865096313539282681211164724), SC_(275.02178125740269232152640295585503512515309107214) }}, 
      {{ SC_(350), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(294.45618386263821576239754390276740117711747843877), SC_(274.67085002894789695197777432862283820319304741569) }}, 
      {{ SC_(350), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(297.92866946191611984743260133710683737012556900869), SC_(270.85698411631021533354814640731152862365541160967) }}, 
      {{ SC_(350), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(283.80192484205991556230145041003981674433256853496), SC_(299.6368463544503276850526804500517781445079713527) }}, 
      {{ SC_(350), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(284.08848753704556866787967907533001730828098908023), SC_(299.37029787639229449636668931184756838945840672666) }}, 
      {{ SC_(350), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(286.4622255844031732948618323149237712140930270653), SC_(297.1355336668733097015115394672183732154243100786) }}, 
      {{ SC_(350), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(297.99128618291435768227375223805932129489537043341), SC_(285.55928504695033848726563739503869171897403420646) }}, 
      {{ SC_(350), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(298.52084475761775036337980603590152726472435104183), SC_(284.99679565445333934090898344987593192758088208041) }}, 
      {{ SC_(350), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(300.7987330717785822007922914778026720840324420943), SC_(282.5440527010725237367845820212766124486661881938) }}, 
      {{ SC_(350), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(301.10744739969331897225129780248260497262048074584), SC_(282.20741820274448459090903799776154526032942650258) }}, 
      {{ SC_(350), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(304.40531766067510953647908947377572389601658200488), SC_(278.54605191798753126314950599430036591993474412516) }}, 
      {{ SC_(350), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(310.25894897306988490675838507233226878379954901347), SC_(322.71404323174432212828268434624684521937934779482) }}, 
      {{ SC_(350), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(310.48851648274850242049339328524699096588164168511), SC_(322.50875125954896973841333792328390091916761297882) }}, 
      {{ SC_(350), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(312.38476753897817600341793337711986675589578482257), SC_(320.78102841833629153864782355874255480215286599775) }}, 
      {{ SC_(350), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(321.44398078944135579801717761931060800729639796793), SC_(311.66459894876376239052940676293322218356946539166) }}, 
      {{ SC_(350), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(321.85339143630955588920813060338243080279327992961), SC_(311.21525498618871538625076450356483893730280857073) }}, 
      {{ SC_(350), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(323.60690478722752737489299293600432289268985563353), SC_(309.24964741504484039852581517834513024479497484226) }}, 
      {{ SC_(350), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(323.84358062822391750959490037423812392120654919435), SC_(308.97909601267162721799160527755098147369308762253) }}, 
      {{ SC_(350), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(326.35656384231262314136190403274249440228509150926), SC_(306.02484994183483374322140746675636157576900748799) }}, 
      {{ SC_(350), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(313.14425428137740992572723676439891807643538625165), SC_(325.13597227770209425908121261627248172659874267128) }}, 
      {{ SC_(350), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(313.36594333099380504494635080750862529901225390264), SC_(324.93901925283094275484694053695811619071703622926) }}, 
      {{ SC_(350), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(315.19628806639925752675527728874450884416528724941), SC_(323.28039210165868884193549022326082370466267633585) }}, 
      {{ SC_(350), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(323.91705576197789035730552670279468581929625849625), SC_(314.50132683800778086875814274536875263141872785001) }}, 
      {{ SC_(350), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(324.31009366137650820446861663819062105059517669857), SC_(314.06760002290980056807388577772643734923516667734) }}, 
      {{ SC_(350), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(325.99223166797927547084365552051342926728779490064), SC_(312.16934230977456562393657803236810480195822975703) }}, 
      {{ SC_(350), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(326.21911185780708182365302014954800319253004484461), SC_(311.90794166972154462431621109228314270289397287898) }}, 
      {{ SC_(350), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(328.62550423030150764275394060888122569118186028523), SC_(309.05183619824552652607189488303830309322763558953) }}, 
      {{ SC_(350), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(334.86452148680906296609948911303772091007557469941), SC_(342.24937325443476551030868799169808446337736387495) }}, 
      {{ SC_(350), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(335.00726410724336394288274181130910083342788466744), SC_(342.134853976660451368556365039614073031847275849) }}, 
      {{ SC_(350), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(336.17819518046913340654381333902224487529055396044), SC_(341.15965295195150453649254683401749031317679841853) }}, 
      {{ SC_(350), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(341.53620315255874512540896286298441637484349750873), SC_(335.73523342756435671940367534567141584539152146771) }}, 
      {{ SC_(350), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(341.76730095518191987503440266416234981421226033497), SC_(335.45776039570529246414873075822865685569336708041) }}, 
      {{ SC_(350), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(342.74389087999451835019849235023539521061825603679), SC_(334.23452229603380466964069252571013876503116289297) }}, 
      {{ SC_(350), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(342.87397841416858292348684975864517262038812477764), SC_(334.06498631226493149524792842081281318030571263219) }}, 
      {{ SC_(350), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(344.22719483241411554797762972493763170811728612132), SC_(332.19649188628141225713069984756417822374164520141) }}, 
      {{ SC_(358), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(37.817203896752085733190204005160717404732815860485), SC_(52.180185949457209016295444528418656882792130550537) }}, 
      {{ SC_(358), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(38.056866551255008709133402114804012249339748318531), SC_(51.918228165625836116140321038419826526361275751119) }}, 
      {{ SC_(358), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(40.069352376077532490745685756508964641141197874708), SC_(49.750941572948233208181129702071163639955157693132) }}, 
      {{ SC_(358), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(50.574790128215885901091266462500471108569303547007), SC_(39.29806363098470162808649889586098624514447497265) }}, 
      {{ SC_(358), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(51.088358670515924585787185274627815332884049548005), SC_(38.821176012021951634803770972814777148072957279893) }}, 
      {{ SC_(358), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(53.330847197471272174957352494467343095164473166282), SC_(36.773472678358882524829224130305118809737534126359) }}, 
      {{ SC_(358), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(53.639006391321124919372470985411177203373417149481), SC_(36.496418980443936978263136677574602848973973574922) }}, 
      {{ SC_(358), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(56.996405116214417251261738612494316765307803463309), SC_(33.54405996970741527005078041567232004658468808156) }}, 
      {{ SC_(358), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(40.655359713659832562940569102917560045392844604914), SC_(55.419308520016915023190247380678195024023286531927) }}, 
      {{ SC_(358), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(40.902291615560117405810815539077147135951136878073), SC_(55.150592047862505263675271956684201633122745901) }}, 
      {{ SC_(358), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(42.974946155695190877812100851887163547446346959144), SC_(52.926678354820309413030268358354660440700723679608) }}, 
      {{ SC_(358), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(53.772203606258829668138481496913449061553125589648), SC_(42.180778873153906354073862442511787871314292218183) }}, 
      {{ SC_(358), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(54.299190524627875407682495788583646256636996751886), SC_(41.689633730603312712329604058896035642878924839781) }}, 
      {{ SC_(358), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(56.599444569292227053871977727422076241646598035558), SC_(39.579703305307999352231567019055684434612007093934) }}, 
      {{ SC_(358), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(56.915439272782618931726840476801213349547473319843), SC_(39.294100763471271993097016115369474760292123407793) }}, 
      {{ SC_(358), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(60.356669483073775562336257024289335668920013640916), SC_(36.248599654096926547329840679681105366452380902403) }}, 
      {{ SC_(358), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(69.704723747279955110255220723775641365736385150414), SC_(87.61164621522130891065282917361451960144858599551) }}, 
      {{ SC_(358), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(70.009188190641931357149740604777791179863358542681), SC_(87.290523715067657535232942235315532674961593483178) }}, 
      {{ SC_(358), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(72.557341290603529831547689368010005786905152103021), SC_(84.626692625172143765902232961431460104385603241219) }}, 
      {{ SC_(358), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(85.640792103629946958300932041296960443158915183331), SC_(71.58252148436127921731344626312661871939515321716) }}, 
      {{ SC_(358), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(86.272022113874946281671767640226424554832827177311), SC_(70.978702327414444372545724037589032762968713512533) }}, 
      {{ SC_(358), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(89.020071258438408662822748712077335215281575946383), SC_(68.3761841387224403160371514453160966628069377362) }}, 
      {{ SC_(358), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(89.396683226707094182602677312035117536006741558181), SC_(68.022807845718338138353369433820178385466812433349) }}, 
      {{ SC_(358), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(93.484544627786538707904887006202698054326562123048), SC_(64.237398777317728146922477084649103361401545729623) }}, 
      {{ SC_(358), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(282.75702188815984796600668682373352830517041083662), SC_(299.52196684693324479903316003222074227185075886141) }}, 
      {{ SC_(358), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(283.05924325480757166957519738255495056942799006894), SC_(299.23854331319291460554871846966257324645855457712) }}, 
      {{ SC_(358), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(285.56420412999500870859526897311528288052346075703), SC_(296.86411479134443196515920854445670539686975643874) }}, 
      {{ SC_(358), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(297.77297020443775782680830824418627661702514791182), SC_(284.61102603165997646113064664960862166103197109327) }}, 
      {{ SC_(358), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(298.33562357749352484897075201664236988096237469254), SC_(284.01744202554406440737954429411298043666342801063) }}, 
      {{ SC_(358), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(300.75796890056446164301684793753888947685674057037), SC_(281.43087044628520429294896000322332264977359680606) }}, 
      {{ SC_(358), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(301.08653040623859938371017425515562262786832892305), SC_(281.07608710765996179429450487469977787481822435559) }}, 
      {{ SC_(358), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(304.60065216882249690238959935010966873283759312268), SC_(277.22061155763744495321852187854942884235557153784) }}, 
      {{ SC_(358), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(290.39193041478217137516395363986533865802824350271), SC_(306.40697599487824418025978180686582114254850653125) }}, 
      {{ SC_(358), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(290.68164416828575868535171138328759038648422354446), SC_(306.13727540720650308700634799550829673823244017762) }}, 
      {{ SC_(358), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(293.08161627717165636323342887461962329939696392525), SC_(303.87627094917454684102590232065948727251162220608) }}, 
      {{ SC_(358), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(304.74203281157253072681656512335584048342164904076), SC_(292.16866827666968824314311933095998989997750028047) }}, 
      {{ SC_(358), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(305.27780924333407460320826932752714229178877973492), SC_(291.59996247373421134512786136610806380058565932118) }}, 
      {{ SC_(358), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(307.58266090606873521645763472655074156420857195293), SC_(289.12026568355295116421291243075561065968150445525) }}, 
      {{ SC_(358), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(307.89505766893038107886119778028951829567550530608), SC_(288.77995055554387982519763377134257439649278004358) }}, 
      {{ SC_(358), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(311.23271773994184321056744047344749245084807783207), SC_(285.07882523655860141955325941769258271838968816333) }}, 
      {{ SC_(358), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(317.43436307297830835811313101980955401423293339788), SC_(330.03129632387914623345070010469199608504218610602) }}, 
      {{ SC_(358), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(317.66641244777609654364105798723603851439395874778), SC_(329.8235205012232289138006137867014316524789799813) }}, 
      {{ SC_(358), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(319.58332330558019651596885514412162720933029541888), SC_(328.07512623602743487535853538037430458179971151489) }}, 
      {{ SC_(358), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(328.74596262182252470981834086219160172624706706409), SC_(318.85527422462261638200861060740096395849829248886) }}, 
      {{ SC_(358), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(329.16027150691064848963009407150587958385989016936), SC_(318.4010347398365210459483506681531271850142559364) }}, 
      {{ SC_(358), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(330.93503295806697597627590381098471922362204413837), SC_(316.4141970576719542877478737090218499942100616819) }}, 
      {{ SC_(358), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(331.17461176798560858293563828972020329306185357715), SC_(316.1407461194515735277982191952441471794234669587) }}, 
      {{ SC_(358), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(333.71898452268856500599435143106391850528169049502), SC_(313.15516958060391955045028194402552969794202772861) }}, 
      {{ SC_(358), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(320.38296209184405367297700055753678545329857809893), SC_(332.51127385224554626789619614490131785869704264083) }}, 
      {{ SC_(358), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(320.60704132784187282270310823361182623084443109602), SC_(332.31192847097638921430660241999120247895489331964) }}, 
      {{ SC_(358), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(322.45728214624222406622762635985178266668533601599), SC_(330.63339254778528129713753226995960411567720164305) }}, 
      {{ SC_(358), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(331.27764912048806784044333482082611090075466524771), SC_(321.75473184964504860549431682418882318102031479909) }}, 
      {{ SC_(358), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(331.67540453446243500518699135206222710531156349953), SC_(321.31629048488963286522087782818022537759817787882) }}, 
      {{ SC_(358), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(333.37800818410475638060127678303007512148975003684), SC_(319.39758679656669263773709928893105397928416657928) }}, 
      {{ SC_(358), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(333.60768466810492158675166582656128834794053912096), SC_(319.13339362007636456432418813407620308436755620534) }}, 
      {{ SC_(358), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(336.0443178361443098314658698875447242391321513056), SC_(316.24711213784752592960158187939982940510751538318) }}, 
      {{ SC_(358), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(342.57318428735398379138050569732613677303556906723), SC_(350.04257537564210324168137183302044219313344973329) }}, 
      {{ SC_(358), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(342.71740728168753369962572484033541306565808228586), SC_(349.92656979554963299083751083118525468649041334713) }}, 
      {{ SC_(358), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(343.90065415085141022323151127098682496080843117226), SC_(348.93901920748522962260416789391080845255042939721) }}, 
      {{ SC_(358), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(349.32027575413494325912078483191598184720259295079), SC_(343.45299608636297094567276449336376748460497386495) }}, 
      {{ SC_(358), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(349.55429972837931408944803440948667737785226649281), SC_(343.17260475130650317213767375995887269830457617832) }}, 
      {{ SC_(358), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(350.54360817449841522246492490345916431385701986029), SC_(341.93670219818170898756027022468860038184112824312) }}, 
      {{ SC_(358), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(350.67543720984078844334549853021005110231692947575), SC_(341.76543531632978930544496937167550202404235518823) }}, 
      {{ SC_(358), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(352.04756942628387338440479922793003906287879259336), SC_(339.87821623589941430114785662607536823021464255422) }}, 
      {{ SC_(366), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(38.753191345032815323931723810221701694801621584332), SC_(53.275989987840198392809644684895374157374637964223) }}, 
      {{ SC_(366), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(38.995651386546125442255676415789589745173679796848), SC_(53.011236185678698388363296883453253976110488345671) }}, 
      {{ SC_(366), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(41.031422320893526953288509704645372145506750045093), SC_(50.820672524215900863881151720246476198856701975441) }}, 
      {{ SC_(366), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(51.653400325426845006600138600125059058562535141543), SC_(40.251251885677336667864006992881628198088091722323) }}, 
      {{ SC_(366), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(52.172484585129426803063888486725634772434722257959), SC_(39.768846669621116198398160858802471941546991722891) }}, 
      {{ SC_(366), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(54.43889015748157313361893085486389164342335175949), SC_(37.697213899207733633587912683283398730093906974517) }}, 
      {{ SC_(366), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(54.750315488787844184900880619232008343703962920752), SC_(37.416891707445059773386763358653911359352402786041) }}, 
      {{ SC_(366), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(58.142999245100391208543187039341826211444090017491), SC_(34.429207361601277950823679693914264080088333947987) }}, 
      {{ SC_(366), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(41.657047683261106788008572380343142886841538304041), SC_(56.585254871289939554865055035364473122031315440768) }}, 
      {{ SC_(366), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(41.906854513790720935299085217587052361999902550009), SC_(56.313664741584241426680166710770640915327615312901) }}, 
      {{ SC_(366), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(44.003440307356038326425274354608026095875078522097), SC_(54.065827266762188939538806658297553303275283010606) }}, 
      {{ SC_(366), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(54.920478529111727438074684235065908463650796172759), SC_(43.200144741771518040376754101304946776265202677692) }}, 
      {{ SC_(366), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(55.453134411310702076693326965243236384913463551313), SC_(42.703328888635014372875608257208216352290323140621) }}, 
      {{ SC_(366), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(57.777969564102589744355507943501944079079157293095), SC_(40.568805849056550846610751302796371322624200146892) }}, 
      {{ SC_(366), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(58.097321028252831016093085582533457289558054613611), SC_(40.279844359771313088044206588907860521658025814977) }}, 
      {{ SC_(366), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(61.57481417972496969474686240528682022011878981338), SC_(37.198042942970854716899401296270610470480264317988) }}, 
      {{ SC_(366), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(71.373451812057405115873037416239611107118109736757), SC_(89.479464047675752947243689152790352968915101769035) }}, 
      {{ SC_(366), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(71.681399450826109669091648316230615453968987386633), SC_(89.154859034823022059653532377620879147514175125106) }}, 
      {{ SC_(366), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(74.258551725387997375121686640482508600817759655041), SC_(86.462032796408277858021510239462143687905283706263) }}, 
      {{ SC_(366), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(87.487193312372906660617278244832127402238384284817), SC_(73.272669654465615320470649346056275654894244791801) }}, 
      {{ SC_(366), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(88.125294006794557310587074581557119893370126017013), SC_(72.661978871801329379299204490314962534688821434996) }}, 
      {{ SC_(366), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(90.903131948077893098940224092474755376892489385468), SC_(70.029665711000572758805916123607513571058798519726) }}, 
      {{ SC_(366), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(91.28381139717220023591069792391735593735430610841), SC_(69.67222076733076981082744348380501280241831333971) }}, 
      {{ SC_(366), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(95.415605752447995578475565599259236339784390764975), SC_(65.842858864452030525686812682142131508933913138907) }}, 
      {{ SC_(366), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(289.18159480264673046859209482222563784455219533721), SC_(306.13297122885840900696281856316684609267071417704) }}, 
      {{ SC_(366), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(289.48707740773005513995876473165580239735003778644), SC_(305.84628558814456507439684232508178472959918715058) }}, 
      {{ SC_(366), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(292.01919040361803489122371083362501592552891299855), SC_(303.44469982854743244762477036559489179168695663934) }}, 
      {{ SC_(366), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(304.36391462194089617880261364967734026315510660813), SC_(291.05565448361709900475983166656497991740268001419) }}, 
      {{ SC_(366), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(304.93300314869038343126415208441575275754322167163), SC_(290.45563652036715394752315051728564303332724836433) }}, 
      {{ SC_(366), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(307.38325250599917969281732474257447842734457498186), SC_(287.84116876493884754025002005234459778225067901029) }}, 
      {{ SC_(366), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(307.7156246795717778143685263400840429533742112601), SC_(287.48257624845693659441557953356781061249583256324) }}, 
      {{ SC_(366), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(311.27091705225599089514789845485957858029405343871), SC_(283.58595545128837026752111022892663570281395160598) }}, 
      {{ SC_(366), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(296.98293774048875310252054315501956773393185692533), SC_(313.1761039660259681212277064093599215623096949702) }}, 
      {{ SC_(366), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(297.2757674585998338045271191109073244435186834118), SC_(312.90328640828663518546790833174289053078409515641) }}, 
      {{ SC_(366), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(299.70168165436259348053074839319795987027977952766), SC_(310.6163339440805903973066732817575239631063132864) }}, 
      {{ SC_(366), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(311.49199373114967541307914200745014114765793925436), SC_(298.77883753121775801994828830316093188267875698304) }}, 
      {{ SC_(366), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(312.03391877227632833764625573697343825509766036749), SC_(298.20398450296901784350288932693907606317080210455) }}, 
      {{ SC_(366), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(314.36543314629410383920270078990578570816426173109), SC_(295.69763409996710566400499117110345228851246748663) }}, 
      {{ SC_(366), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(314.68147123411591087386504906099338876781694529112), SC_(295.35367937354582151568221126328777225182908034797) }}, 
      {{ SC_(366), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(318.0584758892367981830001607331786355148425507549), SC_(291.61323889643194739319498213633473830475697368265) }}, 
      {{ SC_(366), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(324.61056689572797998501627954568396746907926344503), SC_(337.34775988183019594045032565310690043697932423066) }}, 
      {{ SC_(366), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(324.84507045787599619976095116271195537401419316908), SC_(337.13752797219084007487901501040738972520855747932) }}, 
      {{ SC_(366), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(326.78241092974016594251462692539021086983154835206), SC_(335.36869296914003618662034095359102598974129357225) }}, 
      {{ SC_(366), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(336.04732545733247192476242565743777869181954256173), SC_(326.04656911983622406105616666640880047578543705243) }}, 
      {{ SC_(366), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(336.46647792030460423378401827385886293616778840492), SC_(325.5874886567297646487077368456399685753957371527) }}, 
      {{ SC_(366), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(338.26224989990834971661765928054928610205994807419), SC_(323.57965765759151148517203791874622406065249674944) }}, 
      {{ SC_(366), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(338.50469915239542234620498465448305884238650240821), SC_(323.30333956052338406093069493479450829958356749388) }}, 
      {{ SC_(366), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(341.08010833755802316032242740370945124266041971898), SC_(320.28678306685806213311434295365878246028526234439) }}, 
      {{ SC_(366), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(327.62243059715070866725163415428549351434899900883), SC_(339.88581494533846675365895021844901945672925382269) }}, 
      {{ SC_(366), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(327.84887335726165771832192763402203832106632945631), SC_(339.68410396349729204128580017863300287308222562958) }}, 
      {{ SC_(366), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(329.71878853313456571358792391985364633897440131949), SC_(337.98588153714731483221551683499385676109577665788) }}, 
      {{ SC_(366), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(338.63764632611530654736511816713125963975695451733), SC_(329.0087337006618625170319233486906298529616529284) }}, 
      {{ SC_(366), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(339.04006658908697074451674883610996676767772173835), SC_(328.56563032496015864077049392177486375899178881155) }}, 
      {{ SC_(366), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(340.76290692372215528655110018677883376564203085463), SC_(326.6267087701766910526872817158644757927632657179) }}, 
      {{ SC_(366), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(340.99534834629923035947333594144545845753134698569), SC_(326.3597542494634400844298783556351482682931054) }}, 
      {{ SC_(366), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(343.4618817254275200177661148765317900989775855418), SC_(323.44363449177425215089343443322433524481751419074) }}, 
      {{ SC_(366), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(350.2823202882074640200596400124127221807030627224), SC_(357.83530539551175694931033730654388711991102386702) }}, 
      {{ SC_(366), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(350.42800706376195391767799774777291213557845400477), SC_(357.71783035031513766094461075248145405034593306398) }}, 
      {{ SC_(366), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(351.62343194436188973974135475036278652907314486132), SC_(356.71806934651751907402283291130540638778585209906) }}, 
      {{ SC_(366), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(357.10397935078534960944111144684715492387629649983), SC_(351.17113005825348539233083946979762298026637813581) }}, 
      {{ SC_(366), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(357.34089653201846326238742697870825909647804165442), SC_(350.88785306774162860358385312230486794544253562562) }}, 
      {{ SC_(366), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(358.3427792674389111006029469764923705478149626814), SC_(349.63942805168024431691401302105745375435368729769) }}, 
      {{ SC_(366), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(358.47632990577308676743077015506120804303326889943), SC_(349.46644972124350213124912049451010029282586910012) }}, 
      {{ SC_(366), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(359.86715838910847340702536707774786416148071964809), SC_(347.56071714807083415766688535329598620105770339926) }}, 
      {{ SC_(374), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(39.690048530136412516503650386789479278683929762948), SC_(54.370924175530484606856312429465396771014351092686) }}, 
      {{ SC_(374), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(39.935275423072803711029570238964310878276822183213), SC_(54.103404832583300791034740693464055171957698426123) }}, 
      {{ SC_(374), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(41.994077592381995020274672932973089989607349976548), SC_(51.889817637426135880469396000049717852332550284688) }}, 
      {{ SC_(374), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(52.731328008904461778706458390637136439015824999613), SC_(41.205122245577410089614612003412051787470570597214) }}, 
      {{ SC_(374), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(53.255867909517770228580819034881646942983237892278), SC_(40.717259588242446909276225115043507850029543751899) }}, 
      {{ SC_(374), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(55.545929790403237327674875850650790002056192431402), SC_(38.621958643982249483327870780775449399561475941881) }}, 
      {{ SC_(374), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(55.860585619089770922314714026160436543294790258876), SC_(38.338403698929780137964665086944529729003758848176) }}, 
      {{ SC_(374), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(59.288168756157060876427440098213599877830614854105), SC_(35.31578140017406869225474137502557537418450933024) }}, 
      {{ SC_(374), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(42.659629468691585437530967698205628334180856943808), SC_(57.750307302981634347675240070842698947387912683829) }}, 
      {{ SC_(374), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(42.912279854571678127052935937374285060234457201929), SC_(57.475874835068438130294684099054926470012185738841) }}, 
      {{ SC_(374), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(45.03253603754492723510739284068131078253131364183), SC_(55.204374126767888246292764757783714530361902499277) }}, 
      {{ SC_(374), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(56.068052048077770281409403434821871997976675152621), SC_(44.22021163659031249725234143970414748323335541094) }}, 
      {{ SC_(374), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(56.606315155747423345679418814518545628954988463619), SC_(43.717786885006713267896917730983780782340648353174) }}, 
      {{ SC_(374), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(58.955463479903869491301770874979026447874915165695), SC_(41.558939656619689935720713723026942497095280553759) }}, 
      {{ SC_(374), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(59.278135082267238086190875913417865733381584094299), SC_(41.266655935603016333338895545436986650217651916187) }}, 
      {{ SC_(374), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(62.791494925946210364762225582491133645226407041414), SC_(38.148952065260191834530481566983011903865342987736) }}, 
      {{ SC_(374), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(73.043262567956336771538963018952556649595698423167), SC_(91.346199139194670752517639258382658453547431827354) }}, 
      {{ SC_(374), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(73.354655449804310321089619435921735730324499516532), SC_(91.018149536912507362253633391741756636361014403998) }}, 
      {{ SC_(374), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(75.960491167387141749761881439856608725991637993227), SC_(88.296643710634769792821286014343950325805170442064) }}, 
      {{ SC_(374), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(89.332744920437559426905665105752695736816853455196), SC_(74.963667227456206924734269766985170448482603281228) }}, 
      {{ SC_(374), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(89.97764152484191413596581596523260691581226307972), SC_(74.346179633230333813836736524952033016702804727898) }}, 
      {{ SC_(374), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(92.784943841768482831142694639731136213809460328083), SC_(71.6843961843946250396048401232619347364614609662) }}, 
      {{ SC_(374), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(93.169646441338085860289073059891217791779211037493), SC_(71.322926970358566359817061359772625217136811462362) }}, 
      {{ SC_(374), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(97.344894326853649706114974792575855162914660022166), SC_(67.450092509435022277965737312483147623449511402961) }}, 
      {{ SC_(374), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(295.60718182332888050303212797271899094443013698389), SC_(312.74296157017361711923947322876869981017491854201) }}, 
      {{ SC_(374), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(295.9158901440973941742930672475126666451520937012), SC_(312.45304938217155648472424954871943404349323416741) }}, 
      {{ SC_(374), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(298.47485969572516330286646276459342066256942472937), SC_(310.0246021667317516315134003444195402882964927776) }}, 
      {{ SC_(374), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(310.95406356057266642173013846323998918686077646249), SC_(297.50107866797417458601705470541135005891895949542) }}, 
      {{ SC_(374), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(311.52951715432072006047819276133651622851585684983), SC_(296.89469678357078209076451300746742516704192370383) }}, 
      {{ SC_(374), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(314.00736632256933583926900329593933037178495002632), SC_(294.25263674086741392826265396059063024888716750174) }}, 
      {{ SC_(374), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(314.34350757213609087090125133972045411736377602683), SC_(293.8902765748304388644278660827279291547331662408) }}, 
      {{ SC_(374), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(317.93952028304324733309118409373169672377318475856), SC_(289.95295971425673343719652445268689629709148459897) }}, 
      {{ SC_(374), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(303.57491411814858594902515033147575240893398816761), SC_(319.94426296315879092981270404108465330070856283181) }}, 
      {{ SC_(374), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(303.87082585384770995896149394875118612929817728509), SC_(319.66836242509881899778044675573893536408880722212) }}, 
      {{ SC_(374), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(306.32239969769862028477499942894278056226084636578), SC_(317.35574464419499426076142551225925459888614744252) }}, 
      {{ SC_(374), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(318.24119457458562056821038975048343318133649439105), SC_(305.38976715712981941141090130620529630180751531741) }}, 
      {{ SC_(374), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(318.7892012409041658278771745820671665671680417347), SC_(304.80883382914527124760383696141981241010049088693) }}, 
      {{ SC_(374), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(321.14708752781822807848036138085218553503596887275), SC_(302.27612022475844307403099320583697157239125238793) }}, 
      {{ SC_(374), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(321.46672717777451674254634672262668784522130283794), SC_(301.92856558907043524757157121787980661555089916152) }}, 
      {{ SC_(374), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(324.88264581655059529960153055380147872976002378655), SC_(298.14923929134492168857375610106995979287430073259) }}, 
      {{ SC_(374), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(331.78753463429776252931123814630561957130644771137), SC_(344.66345969912615773028970124381017951211621090951) }}, 
      {{ SC_(374), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(332.02446561155999777413774155001717692819732251759), SC_(344.45079855501947135567730860969067216712566406384) }}, 
      {{ SC_(374), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(333.98201303476755271992106650160346126833996628097), SC_(342.6617459440628976498531813656961202674526845839) }}, 
      {{ SC_(374), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(343.34808949948721221411964508172467123397565628229), SC_(333.2384633900152867077368249241998611699604568878) }}, 
      {{ SC_(374), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(343.77203267033265413681658026335591110689748925961), SC_(332.77459470947789364445875165684666380594589278008) }}, 
      {{ SC_(374), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(345.58858540415682231377608581861179244694263072528), SC_(330.74599943917761525895207304849435348144399953197) }}, 
      {{ SC_(374), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(345.83387364288484229701513623250534801282115120237), SC_(330.46684549976653440640289813047299488893696822591) }}, 
      {{ SC_(374), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(348.43997781619684186647477882121908356179310148037), SC_(327.41964806409627454299742664694837216137342016613) }}, 
      {{ SC_(374), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(334.86263493349989197957807740507024985758870824893), SC_(347.25962040541632634449419340171431911322766202209) }}, 
      {{ SC_(374), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(335.09141542794842243333568509105046539890209444537), SC_(347.05556970041986079455645436120284362028645030014) }}, 
      {{ SC_(374), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(336.98079048520106779660413048692179782076020533768), SC_(345.33787575621631340301746065325651269308394395871) }}, 
      {{ SC_(374), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(345.99706683816185856487184582779366950575897740821), SC_(336.26331288658756543886719586894507771166603167432) }}, 
      {{ SC_(374), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(346.40410101026401704686522675016234346046796410297), SC_(335.81559832090149969457616343055743956066726839179) }}, 
      {{ SC_(374), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(348.14695659129834438931540312760986958264528649638), SC_(333.8566795427286291484807774027873950035816631516) }}, 
      {{ SC_(374), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(348.38213262922948631869984057384396671339436878299), SC_(333.58699384805333914720566665162185734851043498475) }}, 
      {{ SC_(374), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(350.87823690352472997775658672728137061485912669623), SC_(330.64136246543253282470333175505146313508772284805) }}, 
      {{ SC_(374), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(357.99191395217702419519241531693989360874370306685), SC_(365.62757876446734330103297032504858918569244910482) }}, 
      {{ SC_(374), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(358.13904846119387059839155002181850997082221749552), SC_(365.50865053182597148027999457238896185569292455283) }}, 
      {{ SC_(374), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(359.34651808642865025774543499064499058133458596495), SC_(364.49681366251273154393045976452529466565741838104) }}, 
      {{ SC_(374), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(364.8873259784446092087032384638212162133275470528), SC_(358.88962314906715724856759905848158359728399191379) }}, 
      {{ SC_(374), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(365.12710449094639214131807144112902641532611020258), SC_(358.60349208041062427594462975125114752209543850782) }}, 
      {{ SC_(374), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(366.14142208278831940755034550689283699753077913932), SC_(357.34268192767280616896421654187429549946039285914) }}, 
      {{ SC_(374), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(366.27667509360794417144690674174816188306103153474), SC_(357.16801095805382321594098151459482751170329739532) }}, 
      {{ SC_(374), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(367.68598781486729857981866917746281746239027376726), SC_(355.24396908386667151710720476039361489117132733059) }}, 
      {{ SC_(382), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(40.627747657928055050396455604008807357500386189854), SC_(55.465016314456317201248489629519480203674844195996) }}, 
      {{ SC_(382), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(40.875711845544294663278714052793561990061899152284), SC_(55.194760933037815740889916693223919331899178490032) }}, 
      {{ SC_(382), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(42.957299503313397171956399028949746118085530196105), SC_(52.958395632259313315817938747045995743014913075577) }}, 
      {{ SC_(382), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(53.808594988514343204520037603292697620320217513961), SC_(42.159652926914565343490154979027386660149861123509) }}, 
      {{ SC_(382), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(54.338532374518713713042786597093378848444780848445), SC_(41.666391058228543869869945662334964589947650670312) }}, 
      {{ SC_(382), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(56.651998171179363500559666113416908253027752532717), SC_(39.547674826132167845835954097476997257710168596209) }}, 
      {{ SC_(382), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(56.969849998708037863833408941750515770564227504354), SC_(39.260921720519155214299574284789481748315584505902) }}, 
      {{ SC_(382), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(60.431959236153362478104705682520918038678773941828), SC_(36.203736371553302938046649860861698392428561964965) }}, 
      {{ SC_(382), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(43.663076509047311243511504941679106521512305568765), SC_(58.91449438306730797830446259152632718343552206648) }}, 
      {{ SC_(382), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(43.918540082404325118632945009658215893313708650053), SC_(58.637249894245437844969548607001048125686760513254) }}, 
      {{ SC_(382), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(46.062214140791170903167073518003636806397580749164), SC_(56.342338170328865085041177864103073728786028381278) }}, 
      {{ SC_(382), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(57.214946574096753589521241842805217865633591421041), SC_(45.240957170769923278750303282019989108892897922555) }}, 
      {{ SC_(382), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(57.758757142792341393308789858622150767981986417085), SC_(44.732983354387770182997467331721609898359009144246) }}, 
      {{ SC_(382), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(60.13195927500153925082387042888967393851230742463), SC_(42.550071758737782220746015874067795877981399064935) }}, 
      {{ SC_(382), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(60.45791556595963461345390154121483787302210862645), SC_(42.25450134303768577609845293617459547458199442703) }}, 
      {{ SC_(382), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(64.006758560733255953075874131494365305571729711652), SC_(39.101280063976356173320084126086882613572127610388) }}, 
      {{ SC_(382), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(74.714121438354943902022867546578639188096473780912), SC_(93.211886069707114412743011905649006203695714417781) }}, 
      {{ SC_(382), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(75.028922825234367797692279897413016803459570437026), SC_(92.88042858880179086730096735760064106339204603228) }}, 
      {{ SC_(382), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(77.663136348248573783732822775741251175322255949203), SC_(90.130548651984182122049875321817107987691857502774) }}, 
      {{ SC_(382), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(91.177474056292094949031154938699811217371450920039), SC_(76.655487087408662964603601876422102433469256565505) }}, 
      {{ SC_(382), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(91.829094185768219669477311769474074253279468869972), SC_(76.031275104003152591356846903849997443682214348024) }}, 
      {{ SC_(382), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(94.66554683045436741686778373633438826406973975212), SC_(73.340335661564925024885096511719855645915729348424) }}, 
      {{ SC_(382), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(95.054229668571390257926105485144549372475162841003), SC_(72.974885135907781535880840418073968320604262454609) }}, 
      {{ SC_(382), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(99.272467018673407111423230410239143913823029954039), SC_(69.059042981393337109594162807582454885291523514017) }}, 
      {{ SC_(382), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(302.0337505559692056963159782916111456691019319913), SC_(319.35197026072517054378585267780002408770374509918) }}, 
      {{ SC_(382), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(302.34565020563750533954588745598047660094305848546), SC_(319.05886594684866935347733655424153415387543556367) }}, 
      {{ SC_(382), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(304.93119019416702503128221209576175300772681477877), SC_(316.60384359784223782678723821191792446757861451589) }}, 
      {{ SC_(382), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(317.54344241756867278333639131032925165650841548196), SC_(303.94727317138749121926712397253819998791281669909) }}, 
      {{ SC_(382), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(318.12519323306563998954343118865847070318711446507), SC_(303.33459516352231709319083590531384399038223473285) }}, 
      {{ SC_(382), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(320.63034772873413660706935638025067428405542244311), SC_(300.6652370035576594452816353636585051410778300182) }}, 
      {{ SC_(382), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(320.97021779550168566813453508128981026121526433767), SC_(300.29914938714287450283413543547753131670621634129) }}, 
      {{ SC_(382), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(324.60651503572394656388533871782919962090841014757), SC_(296.32157125248159803095128441377107076976942738244) }}, 
      {{ SC_(382), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(310.16782858805670370763231078750041682254293491213), SC_(326.71148394073158237518594577109884911514385661777) }}, 
      {{ SC_(382), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(310.46678948008219119628702488486537186073013423222), SC_(326.4325333236738821254806696247719579287546479391) }}, 
      {{ SC_(382), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(312.943749561105556330853937715950099321117645641), SC_(324.09452387208493081007481081548760417241587046974) }}, 
      {{ SC_(382), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(324.9896596107655756228747069261529716883534568896), SC_(312.0014328667368015340713736993600213149286624357) }}, 
      {{ SC_(382), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(325.54368306092554186759774239495259731353340532543), SC_(311.41448402541406908127903007600834266209121423301) }}, 
      {{ SC_(382), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(327.9276597759644097186997596861306244696375035833), SC_(308.85568834162819078623632377161088506696986591322) }}, 
      {{ SC_(382), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(328.25086250036998685578054740087337567010518006412), SC_(308.50457221529540019216319833340110977187672521227) }}, 
      {{ SC_(382), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(331.70527836393339605595109999069879267274106851706), SC_(304.68677567247347262672829403411150467614963455178) }}, 
      {{ SC_(382), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(338.96524185729062743981130364706035547577485074791), SC_(351.97842019491778869229203064874403661164714066073) }}, 
      {{ SC_(382), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(339.20457433465003829375931709716086383129779701081), SC_(351.76335580666132114881011704892035489459557051646) }}, 
      {{ SC_(382), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(341.18211317011096522185152211982241871373908489256), SC_(349.95430156531699705696153795148352696769496404009) }}, 
      {{ SC_(382), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(350.64827387633873678571657949226246574229572653393), SC_(340.43093786973526866464154007157141464946819180516) }}, 
      {{ SC_(382), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(351.0769565797150434017254017258705242204958234544), SC_(339.96233204471111901237770298018143207921714627463) }}, 
      {{ SC_(382), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(352.91406767356259578379825469177001510077551082324), SC_(337.91319421427737884554910105907407782468805845798) }}, 
      {{ SC_(382), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(353.16216445479517546087678078339337986840977952209), SC_(337.63123474517514177948863401619836443120348981483) }}, 
      {{ SC_(382), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(355.79863321251252160296886544887100837589604209531), SC_(334.55372449512386046787740371314996456878984214074) }}, 
      {{ SC_(382), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(342.10355156271315222041758747687998893895536603987), SC_(354.63271375672222227972487273170530188295905442937) }}, 
      {{ SC_(382), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(342.33464482765711546254208257523485028276741064613), SC_(354.42634837462533017383760296295360642691734458286) }}, 
      {{ SC_(382), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(344.24327215308057095748348550476385795255260174592), SC_(352.68939100366010696023896643550487451031723760265) }}, 
      {{ SC_(382), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(353.35592908004908214761178996263443421955251039195), SC_(343.51845094270851519440182427331746683104861152439) }}, 
      {{ SC_(382), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(353.76752785488440229898910745796183911941876104088), SC_(343.06617438184113425274475542197426627325055244544) }}, 
      {{ SC_(382), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(355.53018436028647572380507227378811844043629282608), SC_(341.08747195613969268451634754622157299643978385087) }}, 
      {{ SC_(382), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(355.76806566725972469844995850865871794062466083052), SC_(340.81508429040478752021452290674717621383820017128) }}, 
      {{ SC_(382), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(358.29342218075376040435224495097260662083103222987), SC_(337.84025744173813733910244895013452672694405618538) }}, 
      {{ SC_(382), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(365.70195057395234999198355307474947571095854999756), SC_(373.41941010971882932035632193051109946653979220321) }}, 
      {{ SC_(382), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(365.85051728443359498048278065081091165720019066116), SC_(373.29904443802445270454888567909721702100478406231) }}, 
      {{ SC_(382), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(367.06990266381085816044621935522639407938603686758), SC_(372.27526190338692439528591479968848678934585446067) }}, 
      {{ SC_(382), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(372.6703270340063621254504588450768427622353625819), SC_(366.60846381777725252360670521304919838008948280138) }}, 
      {{ SC_(382), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(372.91293603239049403036962829465367016757660714261), SC_(366.31950923505009036302276650136748895169489682266) }}, 
      {{ SC_(382), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(373.93955358680272160364224403489740798805541656347), SC_(365.04644685728192744563836344029778189701766450299) }}, 
      {{ SC_(382), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(374.0764903707696037178583469368982578316199178397), SC_(364.87010145210422930412610303367961318139353896471) }}, 
      {{ SC_(382), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(375.50408238501368990052035510090212237614994900445), SC_(362.92794787328103011356061247662339290852235027919) }}, 
      {{ SC_(390), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(41.56626238372996535767159982496078526333443401216), SC_(56.55829275639733925248189163338689331435609209594) }}, 
      {{ SC_(390), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(41.816935236915149511066868356621614225332280630691), SC_(56.2853299145097493975973914404999671047585119383) }}, 
      {{ SC_(390), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(43.921070340000578663660491360142672473493038930275), SC_(54.02642425216484075588464229809026258090082342218) }}, 
      {{ SC_(390), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(54.885221936708879518218029193082947252232424888428), SC_(43.114823281155834328904395753633968079917158256185) }}, 
      {{ SC_(390), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(55.420500473327670578070826084967621675477978459881), SC_(42.616218605786146472564446123733419287616311342049) }}, 
      {{ SC_(390), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(57.757125701407958111151486768743112972472388063493), SC_(40.47433203334237218668593179660633925339731367636) }}, 
      {{ SC_(390), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(58.078140111123280510165061892588508825416532983381), SC_(40.18441427223896964166012855803763628583129184787) }}, 
      {{ SC_(390), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(61.574413891527477287867334961193022211280556037967), SC_(37.09302895259299928677458519571912713637250781972) }}, 
      {{ SC_(390), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(44.667361732742533872417747165924507580646382020475), SC_(60.077843189578833254607242804680987735271295168294) }}, 
      {{ SC_(390), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(44.92560907852232486767786322175415799476322322024), SC_(59.79781604741466227047812127566900429817490787707) }}, 
      {{ SC_(390), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(47.092456412149655467285416808125011903782904984155), SC_(57.479737629925371161163975814796042081961695883691) }}, 
      {{ SC_(390), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(58.361183349480405892702242732454322347666375176812), SC_(46.262360124090706038962993558628528211439628914376) }}, 
      {{ SC_(390), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(58.91048348568906541642693221067247928917295591908), SC_(45.748895201421450012249697202796065858293706806011) }}, 
      {{ SC_(390), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(61.307488188459896263086363681836263212747964196586), SC_(43.542170906237364210564896431265494014639837284941) }}, 
      {{ SC_(390), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(61.636694829939895743811687008872649993846597107128), SC_(43.243348215993091890535673577600421177893719293659) }}, 
      {{ SC_(390), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(65.220649477668888852245330158360099842306975649897), SC_(40.054982437197053603192455095267739501125192964324) }}, 
      {{ SC_(390), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(76.385995648711103790688627469059481599617063963282), SC_(95.07655761677671437352529039254863075239544032363) }}, 
      {{ SC_(390), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(76.704169953447622908245194552476445915307020650055), SC_(94.741727818849045860498581489814585884138359018113) }}, 
      {{ SC_(390), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(79.36646521162661608876563175691640210197743737931), SC_(91.963769691280643894104537178229584828646413637168) }}, 
      {{ SC_(390), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(93.021406434686331129387040884827293267898295464032), SC_(78.348103531078291507440666780968689611556959585053) }}, 
      {{ SC_(390), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(93.679679969017748503868446541448633657095019326827), SC_(77.717237313892507995368929956765909303985586358433) }}, 
      {{ SC_(390), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(96.544978725523545089978139816282665007792698332916), SC_(74.997446325235533874314175230761613131640491239667) }}, 
      {{ SC_(390), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(96.937600234623706990832855961951457110533569683435), SC_(74.628056099463490108768862109375183031439721852737) }}, 
      {{ SC_(390), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(101.19837753916280843774163671898367702338141984377), SC_(70.669656511045209909955197280895466848290361224683) }}, 
      {{ SC_(390), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(308.46127029509285061406415240245502502771690395946), SC_(325.96002800197931954923548769141424905246162847953) }}, 
      {{ SC_(390), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(308.77632796356233392770511494886796197233817667489), SC_(325.66376490483693945672064034259408050690989255362) }}, 
      {{ SC_(390), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(311.38816122362749814930579429690925920534089216436), SC_(323.18244477865903614532352005188168103248894100238) }}, 
      {{ SC_(390), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(324.13207526690572172787654009529090441851333109484), SC_(310.39421390510831848206856608448545916304689116096) }}, 
      {{ SC_(390), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(324.72005758335713961518373767559860117255943075684), SC_(309.77530544991783843733659724115759023312571160188) }}, 
      {{ SC_(390), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(327.25223215378915259875989819015960917144249658103), SC_(307.07893413103418658902846508684801602917916894402) }}, 
      {{ SC_(390), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(327.59579204233605848125648736683063160074507349392), SC_(306.70915800370721117828847028770445946888939658294) }}, 
      {{ SC_(390), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(331.27195170766210708322461671608948739443905720495), SC_(302.69173974248739548696429535419030409061457629594) }}, 
      {{ SC_(390), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(316.76165180472072770226736777143989367797693926839), SC_(333.47779623944610301888184631138089097411260800407) }}, 
      {{ SC_(390), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(317.06363002090210818449695427134005803364972882404), SC_(333.19582741317337142409147523874234698197301462145) }}, 
      {{ SC_(390), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(319.56571148516032274969254146414329951029015274906), SC_(330.83269136560941511194629789114848180329918078135) }}, 
      {{ SC_(390), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(331.73741184402396756962954937948250812467266769978), SC_(318.61381163848069862036924938893103958584896435425) }}, 
      {{ SC_(390), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(332.29738926762342434420452854044246402749853916616), SC_(318.02091004261601894231614360758496303402165606412) }}, 
      {{ SC_(390), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(334.70718375278919930429538324641534836174189094584), SC_(315.43630459683812894923775085497244242586148796269) }}, 
      {{ SC_(390), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(335.03391227235736030900128253133357121473343550319), SC_(315.08166419432317484040743093519294518347531329045) }}, 
      {{ SC_(390), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(338.52642171715045326017557327474281567193211245647), SC_(311.22579993964639202409359439879811844607001502746) }}, 
      {{ SC_(390), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(346.14366540841728869210248110851069444922682383869), SC_(359.29266451435460415891706853180700165240099357783) }}, 
      {{ SC_(390), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(346.38537428329477547026689999330311341592070185282), SC_(359.07522205525151691180656542275971277971207297736) }}, 
      {{ SC_(390), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(348.38269574368909190554605924404721293316403140304), SC_(357.24637538278065929883095231846375953574267307589) }}, 
      {{ SC_(390), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(357.94789671894034507728070228162272059301417415544), SC_(347.62397439370423294387364848619644811942552115493) }}, 
      {{ SC_(390), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(358.38126938552253013154312216094669561805765865812), SC_(347.15068089730242060625842216506622138563106877349) }}, 
      {{ SC_(390), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(360.23872343834277087808072188754739378439205118025), SC_(345.08121526619583274003959019461193242227346121089) }}, 
      {{ SC_(390), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(360.48959927772625367490978351521859065645725695213), SC_(344.79647962869688292178773116519051878596639133299) }}, 
      {{ SC_(390), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(363.15611267193718584885652603048175903727270309905), SC_(341.68897437679676785368068738577157191001409558872) }}, 
      {{ SC_(390), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(349.34515817534953688163013595194239244964633964254), SC_(362.00511729602775590174701778437765650759829194832) }}, 
      {{ SC_(390), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(349.57854002972598822449180494212682707056198140796), SC_(361.79646149511643379138093129951455031784560359622) }}, 
      {{ SC_(390), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(351.50621851469863274325675367303476011963401506024), SC_(360.04044225508007344417763122658501200635641531823) }}, 
      {{ SC_(390), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(360.71425051489429998315258290677921542058471574613), SC_(350.7741303680843073890494330056280428774237329357) }}, 
      {{ SC_(390), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(361.13036613405141283396168747550707489602274291243), SC_(350.31733946557672770801943669111452789266801979095) }}, 
      {{ SC_(390), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(362.91261598505492766040381990545449739013859259952), SC_(348.31906027029890446757676875557180057028368336126) }}, 
      {{ SC_(390), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(363.15317414029261141622150725918286424314241646844), SC_(348.04399891964645805747172156150151090953697405839) }}, 
      {{ SC_(390), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(365.70747433346848576573492464371401483628922682963), SC_(345.04028282181072377701070929401681144330541914113) }}, 
      {{ SC_(390), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(373.41241621906680035613319656622833829346210469829), SC_(381.21081329526500297386847767973273639364634130282) }}, 
      {{ SC_(390), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(373.56240008775319726482178593478002696528725774635), SC_(381.08902543168680789508248594217505026450746952805) }}, 
      {{ SC_(390), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(374.79357628336578998920084537847645961165649595563), SC_(380.05342331106059796483171257431270711917459944344) }}, 
      {{ SC_(390), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(380.45299332173873293872675908261251676659628521871), SC_(374.32764112855104604129275134059603788033142402023) }}, 
      {{ SC_(390), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(380.69840293668453069987999196153034102370997215737), SC_(374.03589263559906089499446070110246431431325610659) }}, 
      {{ SC_(390), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(381.73718985802542781990489486901452754818083143704), SC_(372.75070676117416436313221715023858796651692520287) }}, 
      {{ SC_(390), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(381.87579241319614562005071509160670516936592242191), SC_(372.57270455007927320418548748100365517553032657224) }}, 
      {{ SC_(390), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(383.32146547310347967919955866002097157680950172929), SC_(370.61263061470828261122356281219043241461159092673) }}, 
      {{ SC_(398), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(42.505567708661206658521846120151879640801691394701), SC_(57.650778506719495473359071503806118675488319141253) }}, 
      {{ SC_(398), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(42.758921478399737066277359291166701752075650977213), SC_(57.375135905325377678356841032966216233880861599494) }}, 
      {{ SC_(398), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(44.885373292748001875210968669820082477676965819165), SC_(55.093920334184697821775450318847435068607595756077) }}, 
      {{ SC_(398), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(55.961228469879794604200947659292106246664626866172), SC_(44.070613713875199786968420760688115524199114485018) }}, 
      {{ SC_(398), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(56.501793550021623430306842368919319475124928511828), SC_(43.566720904644938084690931866587428443067270385808) }}, 
      {{ SC_(398), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(58.861341229063170863600828731195954118483622921933), SC_(41.401901407728466648247549883639320869683955767918) }}, 
      {{ SC_(398), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(59.185485830811570558041659039183448931030277372778), SC_(41.108851464389149534775995208509011461550520388989) }}, 
      {{ SC_(398), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(62.715573718826924028494060041174886545396563920728), SC_(37.983618039392469135786665613981101206357459591357) }}, 
      {{ SC_(398), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(45.672459451006603465243401162714094312608047474918), SC_(61.240379417175079842052464329200170046485522962943) }}, 
      {{ SC_(398), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(45.933462058160769489703461556243455170202151764406), SC_(60.957598088070070153647057079916420095287779023261) }}, 
      {{ SC_(398), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(48.12324557572239092305645137609572253498960554283), SC_(58.616589806756924002772842663999120134805503320641) }}, 
      {{ SC_(398), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(59.506782531488284957430390873706979143666101104193), SC_(47.284400359582552759451486790968071830864858250256) }}, 
      {{ SC_(398), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(60.061516117014233709638113766084552029683704012255), SC_(46.765500509949159772968609997939828234825588109801) }}, 
      {{ SC_(398), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(62.482079863094155631032373430148162225252269569435), SC_(44.535207446959525066587624154289384284062290209845) }}, 
      {{ SC_(398), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(62.814503571676886286923175570990548557888288874915), SC_(44.233165842723223524895501137184782451307695758446) }}, 
      {{ SC_(398), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(66.433209800003157269400953329141774761520403726797), SC_(41.010016962018949621447225446260903570571093137267) }}, 
      {{ SC_(398), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(78.058854097753447815401084316450433004267142148379), SC_(96.940244884440751808490451664482301050763252632355) }}, 
      {{ SC_(398), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(78.380366825180850105052199009774705381053322061742), SC_(96.602077240617980576421268148399999266380821123053) }}, 
      {{ SC_(398), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(81.070456826601946219828332770731897782392336390357), SC_(93.796327772751717687625027221879724715510343133832) }}, 
      {{ SC_(398), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(94.864566457691651030757396759425880559679506596931), SC_(80.041492166965484227050120890360149199084838919854) }}, 
      {{ SC_(398), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(95.529425425677314050839030411839260793930502478109), SC_(79.404039720277785274944868964271462028505768260615) }}, 
      {{ SC_(398), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(98.423275407486366986359322386003114689921513552462), SC_(76.655692289466406192650055922924100652023383188983) }}, 
      {{ SC_(398), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(98.819795295612756892192269921109135085921088351728), SC_(76.282402696833602661749846308161650395719220755463) }}, 
      {{ SC_(398), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(103.12267685468706602351994186205415455189131433792), SC_(72.281882078657027997923546693649234215006147455355) }}, 
      {{ SC_(398), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(314.88971190324679567337508268256680403127533293827), SC_(332.56716392772207649098800102757772410809017794001) }}, 
      {{ SC_(398), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(315.20789530206946952060479977243181394708695905394), SC_(332.2677743663226664977718668046386906308565002082) }}, 
      {{ SC_(398), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(317.84575316436102142607737057111046374255135836485), SC_(329.7604253118915230666832416917609368710130120029) }}, 
      {{ SC_(398), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(330.71998495385430674059347840255959756555396410009), SC_(316.84187801029470011741179002561253842898388537836) }}, 
      {{ SC_(398), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(331.31413506630514614326415395345543501507045763284), SC_(316.216802770744919889760163392716969398059452864) }}, 
      {{ SC_(398), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(333.87305321726352552749291122257132382176934406977), SC_(313.4936945105225176186430834301719985619030827042) }}, 
      {{ SC_(398), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(334.22026513080496715098427214342953130239250126597), SC_(313.12026761647905589527356787954725711687064496352) }}, 
      {{ SC_(398), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(337.93587811797583738774650068940575353036803923178), SC_(309.06341743311511696077159717656513981819713152532) }}, 
      {{ SC_(398), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(323.35635592143428087064879881566206471054441658856), SC_(340.24322770162855641085541948066330342085539919006) }}, 
      {{ SC_(398), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(323.66132060608138381057884737600623342189635436834), SC_(339.95827155718976995217020322796456274256714180936) }}, 
      {{ SC_(398), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(326.18826671940330417680082082957479399370240641265), SC_(337.57026585541027481953258903986455337977638396577) }}, 
      {{ SC_(398), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(338.48447310450653762683205078429249490727598138074), SC_(325.22688162639377719865288228871872325745384797015) }}, 
      {{ SC_(398), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(339.05034361822845332873017783217091717331176022324), SC_(324.62808811077929291442922007164764790799159809742) }}, 
      {{ SC_(398), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(341.48569159035754288159953190769088353931251669578), SC_(322.01793686600299171398277723041590471827078822179) }}, 
      {{ SC_(398), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(341.81590977224935973117500338394346849529493733233), SC_(321.65980825921996810860674664759425276950618589809) }}, 
      {{ SC_(398), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(345.34612159601997911281139223445358933906522184731), SC_(317.76626645177262668207360741198102094331984433739) }}, 
      {{ SC_(398), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(353.32278331523010528043885647786264462890609884838), SC_(366.60621461972956988619667698544998316466621902706) }}, 
      {{ SC_(398), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(353.56684425591111047509793261011415611431781026496), SC_(366.38641848800523156987964750429585605638376798849) }}, 
      {{ SC_(398), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(355.58374596044906163694854417810603735663318974756), SC_(364.53798215274153030815498195652243597416561136569) }}, 
      {{ SC_(398), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(365.24697523260285429302805367156329609105084701146), SC_(354.81755572518496743297479849242891412826221334372) }}, 
      {{ SC_(398), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(365.68498981679249277164923794532232310301951807043), SC_(354.33962251248299345536585866425222837457008878342) }}, 
      {{ SC_(398), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(367.56257806161401172388874858050401622180700950845), SC_(352.25003724435891415926469509897554910289227108817) }}, 
      {{ SC_(398), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(367.8162043848041197458821638110095724508274218141), SC_(351.96255389713212592216024231701862709690029116713) }}, 
      {{ SC_(398), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(370.51245238290233405653306374869710034883254012312), SC_(348.82536166998804656481339566195757354683826751911) }}, 
      {{ SC_(398), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(356.58743360274149656991981230450871767843325892013), SC_(369.37685218045757560073868006093008612562684612168) }}, 
      {{ SC_(398), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(356.82308060820405082205643658299233561863413448046), SC_(369.16592947170698200609980333495216231806690803023) }}, 
      {{ SC_(398), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(358.76961531604427371170148989872436812152504056321), SC_(367.39104372180423158919962664294670808929655324751) }}, 
      {{ SC_(398), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(368.0720477141442182273549324382564160070746892712), SC_(358.03033455655762994851564684841273132437202028508) }}, 
      {{ SC_(398), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(368.49263388784922047809486710736615964397476433063), SC_(357.56907550350857830968130891842997347628257191338) }}, 
      {{ SC_(398), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(370.29427590251144501746531296691129173407191605501), SC_(355.55142006153979767741406252898335754842256945027) }}, 
      {{ SC_(398), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(370.53748336309971237063124032271600363093475093286), SC_(355.27371244232116626364389318636286075116186144407) }}, 
      {{ SC_(398), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(373.12042825026019448447146235106525170362981440853), SC_(352.24140388034550901478782581193333314687459402474) }}, 
      {{ SC_(398), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(381.12329766849809916297012734434079365016721020709), SC_(389.00180147639975690866929749121353807144937853333) }}, 
      {{ SC_(398), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(381.274684115787222018882551208408246835697793388), SC_(388.87860619289593862079516061318041290485374952276) }}, 
      {{ SC_(398), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(382.51753003463004605506166508748065907616307827578), SC_(387.83130665740713585164064504608225997263010242411) }}, 
      {{ SC_(398), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(388.23533509546252493616079986420657277758489435546), SC_(382.04714470723424802493128588766144068295259161849) }}, 
      {{ SC_(398), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(388.4835163833588781139612085950600444411779257197), SC_(381.75263099688290172939088033442839106968545447556) }}, 
      {{ SC_(398), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(389.53434615086086617374270306263642688427680066642), SC_(380.45544638563171410434956820458727956755043978031) }}, 
      {{ SC_(398), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(389.67459704138604790016120435648682266787731469231), SC_(380.27580445378947593671187390241130931100846211628) }}, 
      {{ SC_(398), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(391.13815923968912971986083940995430123587146290429), SC_(378.29799558371243402064769364263239010555108056238) }}, 
      {{ SC_(406), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(43.445639885317985562070111219830278520143146162479), SC_(58.742497318759991194669404453799812452225690808461) }}, 
      {{ SC_(406), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(43.701647658495019431168869055237464590098126908865), SC_(58.464201825738056904324721308459625895917730348325) }}, 
      {{ SC_(406), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(45.850192392561168747342931863553344877823456200978), SC_(56.160899872484238975939308079988084622428102073846) }}, 
      {{ SC_(406), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(57.036633222378967228355568779918373021753661564602), SC_(45.027005610928226577135665095193992552510484108365) }}, 
      {{ SC_(406), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(57.582431880104838623085827771498206672815990153951), SC_(44.51787769567248083376472715441908339984117507859) }}, 
      {{ SC_(406), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(59.964672157424042208262455907447697574939111950222), SC_(42.33035553683393413309966075724329098150700182633) }}, 
      {{ SC_(406), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(60.291915536061966929911775418654659456490752530112), SC_(42.034204904606711456125548598984801104708344246092) }}, 
      {{ SC_(406), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(63.855477659772552103000274804528766824240659932809), SC_(38.875464591313819069283968650926660721502749860543) }}, 
      {{ SC_(406), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(46.678345260976933327764243975820316753254343548629), SC_(62.402127474107791392393373908711270362112879227179) }}, 
      {{ SC_(406), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(46.942075477080388932334308375525870792132647826448), SC_(62.116619568458831368119053992446061180539590623435) }}, 
      {{ SC_(406), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(49.154565219613848428479181633859657078979878435136), SC_(59.75291113600893996831929922685473320364871035612) }}, 
      {{ SC_(406), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(60.65176326837238897775320855590386228642150636737), SC_(48.307058747660442905288362008848568328150736530544) }}, 
      {{ SC_(406), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(61.211875871425812858098486357586378306169938767617), SC_(47.782778460409848294661300492088589657741294106777) }}, 
      {{ SC_(406), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(63.655762457376299541215458154106265546563910994276), SC_(45.529153213783297392197967389451837612216876243833) }}, 
      {{ SC_(406), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(63.991370951398787800936071062537974459989006461566), SC_(45.223925049805016735780061223055295474094396360341) }}, 
      {{ SC_(406), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(67.644479539940580201318211190009066699229717430352), SC_(41.96634353441731675087261571967707182749365536656) }}, 
      {{ SC_(406), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(79.732667240273424630426198314489131793308256551533), SC_(98.802977420444508384379511859343588502398887053767) }}, 
      {{ SC_(406), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(80.057484932499417151203637801571191093221475308044), SC_(98.461505365994171460929722262893364155474370708194) }}, 
      {{ SC_(406), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(82.77509130889427894413937429664078399235674533669), SC_(95.628242792931600209373347555498376346782932487988) }}, 
      {{ SC_(406), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(96.706977306641572392658999168298312447506903150505), SC_(81.7356298234679081700368182861395815394110409861) }}, 
      {{ SC_(406), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(97.378355778523587136327300400111755644802526678567), SC_(81.091657108172628235249758749906756351007122215991) }}, 
      {{ SC_(406), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(100.30047096126026434171681881401205522088887916586), SC_(78.315039464324994587943277595457253761009690271995) }}, 
      {{ SC_(406), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(100.70085014813138824797820482844740790713486109803), SC_(77.937889623973514146655821926702226143510226397272) }}, 
      {{ SC_(406), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(105.04541337917652961800322023276518873066851038724), SC_(73.895671221129749438178873148026090484294027720518) }}, 
      {{ SC_(406), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(321.31904770113664437667595905980547912362247785467), SC_(339.17340571388689375823324857526158037008236540508) }}, 
      {{ SC_(406), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(321.64032551233847823130401419686244474206353839202), SC_(338.87092103496896655876006185343430131353287004164) }}, 
      {{ SC_(406), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(324.30394737824931912579862094898289081591749204088), SC_(336.33780381997290373747456830795549634241676543773) }}, 
      {{ SC_(406), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(337.30719318101835868263680318881291396788742484692), SC_(323.29024377185219375589238130446627078004250378487) }}, 
      {{ SC_(406), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(337.90744929935645891894934113168126388874382858421), SC_(322.65906349852673185012955279465668789688601273592) }}, 
      {{ SC_(406), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(340.49284285575587643099609664758290982027611802224), SC_(319.90948621166664664102192856759396224548067377256) }}, 
      {{ SC_(406), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(340.84367013595966618050045864591511722313597526071), SC_(319.53244515975173306387858862254377951199597607837) }}, 
      {{ SC_(406), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(344.59833968851210035450869798426937467369625068205), SC_(315.43655896513052605727461851282191595255240822792) }}, 
      {{ SC_(406), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(329.95191448525029481834079820998076498336017325532), SC_(347.00780477621337951209965636617669834922318388831) }}, 
      {{ SC_(406), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(330.25983571023228086141810868621087084335786371584), SC_(346.71989127502120851578810962747510791040496082466) }}, 
      {{ SC_(406), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(332.81139745164919196109092978960726580455860025752), SC_(344.30726513542805241812383676260368724275389232286) }}, 
      {{ SC_(406), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(345.2308641303966707932626834838743454102829060044), SC_(331.84062207773253176024092645836429108090523649484) }}, 
      {{ SC_(406), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(345.8025686814331015047591827506349170004362079442), SC_(331.23599564949172208827072911792832805505480358456) }}, 
      {{ SC_(406), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(348.26321381200651080251132271472021321279200638291), SC_(328.60055463288670343671529354316062190151749136728) }}, 
      {{ SC_(406), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(348.59688661223799248543461954414344886068691783075), SC_(328.23897280848749706403737970903177848269988092742) }}, 
      {{ SC_(406), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(352.16442142756536794004369331369945215175534034662), SC_(324.30813185436400543270910726070847380017972043662) }}, 
      {{ SC_(406), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(360.5025747060876294870522626408524485678968559797), SC_(373.91909137340870486412538869218513233289567654237) }}, 
      {{ SC_(406), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(360.74896411306690756511946331688771136488408108647), SC_(373.6969652311938150400768130900484077592744972818) }}, 
      {{ SC_(406), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(362.78524976646576768149797261169109755351913495933), SC_(371.82913589345423763047118921658797526510724459334) }}, 
      {{ SC_(406), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(372.54552576173491800766004485010194479919568428546), SC_(362.0116654908718139260949415961056481036309288407) }}, 
      {{ SC_(406), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(372.98813566515427631683338482712045668432152629011), SC_(361.5291390749811084504417254562125334632927016952) }}, 
      {{ SC_(406), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(374.88565563531444478553167022230452125308706027274), SC_(359.4196360684773894689572718045271206366346502652) }}, 
      {{ SC_(406), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(375.14200473208964142247294220509326744865117253773), SC_(359.12943261287394804686117931252440472710373860381) }}, 
      {{ SC_(406), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(377.86768671460151092899619438470024471814310841276), SC_(355.96285214309712322222396361920231345819585527958) }}, 
      {{ SC_(406), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(363.83035773696511358910280656722428650738613453542), SC_(376.74793850739754922105815437673158130958294593861) }}, 
      {{ SC_(406), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(364.06824716063384140505249688384378656237275006457), SC_(376.53477169207912891287228022143669566907441512176) }}, 
      {{ SC_(406), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(366.03344901728882188154525573037306211362834217721), SC_(374.74120890438979142191582086893213835145372425611) }}, 
      {{ SC_(406), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(375.42933642002884418290245637144185197638039711828), SC_(365.28704773398673616560846611277574277684555828387) }}, 
      {{ SC_(406), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(375.85434825337706847700026332569109857651323664895), SC_(364.82136533234277318579680123735981905186182281287) }}, 
      {{ SC_(406), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(377.675187324558671761849220628164273082626179991), SC_(362.78452813027204440473289022863702082037559297584) }}, 
      {{ SC_(406), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(377.92101738114627283524276560772232796597256756152), SC_(362.50420083271679904307132666561549549674284665148) }}, 
      {{ SC_(406), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(380.53231706491709928713958921749364116445502381636), SC_(359.44358763404226115997385087391406304105764583554) }}, 
      {{ SC_(406), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(388.83458236828433674956067036149725362877037867574), SC_(396.79238714932381134581253707158587546585292589912) }}, 
      {{ SC_(406), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(388.98735725491332666994905097973915371721242833315), SC_(396.66779876680487608850267124302215977971975139792) }}, 
      {{ SC_(406), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(390.24175545579241288279312108042802339750800726642), SC_(395.6089202769895603564477959768184306236916193329) }}, 
      {{ SC_(406), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(396.01736209695449043553420762410770353160941439697), SC_(389.76696470177716780164852642747106476435773080692) }}, 
      {{ SC_(406), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(396.26828699310137800470607828614292034295146515642), SC_(389.46971360158208596464867962419008396627587925428) }}, 
      {{ SC_(406), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(397.33103695342442759345014892478887195861466421446), SC_(388.16065124441100501431755452211264977841194542542) }}, 
      {{ SC_(406), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(397.4729192804933882647362925180394893268984508306), SC_(387.97938615995024843776135580657945628799935324308) }}, 
      {{ SC_(406), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(398.95418471856031999162347256198176140280927675767), SC_(385.98402215006027732814554873509286382288651517345) }}, 
      {{ SC_(414), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(44.38645633178599872998542741972213221710226793035), SC_(59.833471779872123946950438275617484463386006775065) }}, 
      {{ SC_(414), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(44.645091990039119443261114148763180770413634830278), SC_(59.552549470949693399803252714278468639872817883924) }}, 
      {{ SC_(414), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(46.815512453441092882719993921878756569900322542335), SC_(57.227378076269842072760565756548445265206858502337) }}, 
      {{ SC_(414), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(58.111453913999297597872966400068223365225062241446), SC_(45.983981271143647005600438373271770702404678583512) }}, 
      {{ SC_(414), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(58.662434743937981450745127665382443409655390540474), SC_(45.469669713586727309668617146162156030821716704259) }}, 
      {{ SC_(414), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(61.067144544376544012211991433188044586689125779124), SC_(43.259668354261966084470264046866453476405941586509) }}, 
      {{ SC_(414), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(61.397456211823203278850244463890205193407419957196), SC_(42.960447594912781761256181359939694240468762103506) }}, 
      {{ SC_(414), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(64.994162742608488191369989390093532646385266945285), SC_(39.768531488819597369556976473123425512623941238488) }}, 
      {{ SC_(414), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(47.684995957352031184562849647697187393314822862276), SC_(63.56311057062012634869848638780894112677647204878) }}, 
      {{ SC_(414), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(47.951426946347794948852371164129651656311604947028), SC_(63.274902884873934588757525295650536938580549631209) }}, 
      {{ SC_(414), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(50.186399736626203225534892187840860981989754833084), SC_(60.888717246353508270904165714118198784190670151644) }}, 
      {{ SC_(414), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(61.796143768703721459867070412302175873110087492914), SC_(49.330317096956859517198418103660169371255991457588) }}, 
      {{ SC_(414), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(62.361582561100943322780231962884349473240045505638), SC_(48.800709254532392908735481969675480911129125116154) }}, 
      {{ SC_(414), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(64.828562747452080698561453541015955959742006382907), SC_(46.523981422545558964218473177602700516772258851466) }}, 
      {{ SC_(414), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(65.167324697751105759045827532311827063128202331597), SC_(46.215598096379940633308746677566860427852598006565) }}, 
      {{ SC_(414), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(68.854496743841268083130020399026634602508383682748), SC_(42.923924023290350555109493053488733603625845913384) }}, 
      {{ SC_(414), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(81.40740698026636746246238051988618166000169834283), SC_(100.66478332312340861681894902836553558055200570102) }}, 
      {{ SC_(414), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(81.735497165703996810150036452745921630341048889622), SC_(100.32003930831313229367381852974700604408306250356) }}, 
      {{ SC_(414), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(84.480349749027568891070969096776192002823944963928), SC_(97.459533672598299555906210984747255273350111913967) }}, 
      {{ SC_(414), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(98.548661025954912880274298754076716699029732350275), SC_(83.430494465139255016593946576218272409117020457652) }}, 
      {{ SC_(414), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(99.226495013236902683655563182430633539340837973893), SC_(82.780065499077253284000532925099968038452116472172) }}, 
      {{ SC_(414), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(102.17659779950649117803369242586246134285295150533), SC_(79.975455432510731818427277173149525016548900455621) }}, 
      {{ SC_(414), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(102.58079835698194258995419546171521619729486515625), SC_(79.594483309192904142943741619021500271601973946014) }}, 
      {{ SC_(414), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(106.96663314957336394375143454775287276650607116716), SC_(75.510977856147129834499088781101326356309986580177) }}, 
      {{ SC_(414), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(327.74925136746640617162884760289483797454767554111), SC_(345.77877967868368159878353948012931840592467441265) }}, 
      {{ SC_(414), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(328.07359319588907877725394249251420075601485493991), SC_(345.4732303045117269281758081683741285340837786182) }}, 
      {{ SC_(414), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(330.76272614138753368049357313011369272749379766165), SC_(342.91459801234274359915955341589953168647046394288) }}, 
      {{ SC_(414), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(343.89372058678062212680923362265591142971886816474), SC_(329.73929053988298213976382185886028632501721038201) }}, 
      {{ SC_(414), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(344.50002274168559399579026023186568314923203281353), SC_(329.10206516484564707078699874393725343816763512189) }}, 
      {{ SC_(414), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(347.11163143856525311588271367747291656238043350302), SC_(326.32627887094561379310297978993805142827150760619) }}, 
      {{ SC_(414), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(347.46603850951581190279919161014216409666216892211), SC_(325.94565919045041725480895792663359038401416523051) }}, 
      {{ SC_(414), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(351.25937960880842616722210555105133360708833891331), SC_(321.81112120677797780568757324460497226407671037949) }}, 
      {{ SC_(414), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(336.54830234123139365588474321804257581574613210035), SC_(353.77155261445521345323111052642265635805498739529) }}, 
      {{ SC_(414), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(336.85915106041952883466772769073790912277198562928), SC_(353.48071083400275883087124593978281594599423587012) }}, 
      {{ SC_(414), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(339.43508674354082896828756137190160379131484098556), SC_(351.04370612719513089234211310172025917470606381096) }}, 
      {{ SC_(414), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(351.97660464288367265227936199419519044372152372431), SC_(338.45501325788607781883076083885708351087782678779) }}, 
      {{ SC_(414), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(352.55408591900318556532289062984008932876992655056), SC_(337.84461118618894513809889110292466112631933390987) }}, 
      {{ SC_(414), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(355.03977944289475351841350608857220592350684811973), SC_(335.184128878906276408195996371023330909561838398) }}, 
      {{ SC_(414), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(355.37687285271544623416227223390977817094978700463), SC_(334.81912779162497858808215831734069947138433566049) }}, 
      {{ SC_(414), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(358.98136250384116686569501219465997577308788572571), SC_(330.85135492230615977480526966930962009040819957032) }}, 
      {{ SC_(414), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(367.68301973446039487443005111109826435478599972723), SC_(381.23131461343273425439869731216963243299146212057) }}, 
      {{ SC_(414), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(367.93171470444679784994362511176597333931459122675), SC_(381.00688142305516675156190406886176696295807110906) }}, 
      {{ SC_(414), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(369.98719379798337390854996967478878446483900793195), SC_(379.11984993579613152720339076218581284747981918651) }}, 
      {{ SC_(414), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(379.84356384895957206212911435746192850143986957604), SC_(369.20628812152472723594481142813151904703046251442) }}, 
      {{ SC_(414), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(380.29072384921815567417034835857756674583148248979), SC_(368.71921364442546944329874530941764171404672148501) }}, 
      {{ SC_(414), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(382.20797906764271989471318689680176944567160866829), SC_(366.58998884118491100022949521836300557596145317318) }}, 
      {{ SC_(414), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(382.46702404919388752767024510056667312083233883523), SC_(366.29709206342545560421956362118040910010920889068) }}, 
      {{ SC_(414), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(385.22184834252827887994964926755299764183815055468), SC_(363.1014132476372347738915057885013844796820780281) }}, 
      {{ SC_(414), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(371.07391145788711799824131196713311431797458163593), SC_(384.11839538734147770479612726139577509627005601614) }}, 
      {{ SC_(414), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(371.3140212376621404316874061589161593981914269712), SC_(383.9030065920324007858787158913538150364394343809) }}, 
      {{ SC_(414), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(373.29770674366943757962912354044703652823377696282), SC_(382.09095064140551354067708579161386979464922161688) }}, 
      {{ SC_(414), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(382.78613160250247238471423846750867488247098826589), SC_(372.5442549010280081645747371858187110821151837876) }}, 
      {{ SC_(414), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(383.21552552677588528052871496381009107446808897859), SC_(372.0741926318333041631561835496760213745425570696) }}, 
      {{ SC_(414), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(385.05537232237214517437555127596271944288344935774), SC_(370.0183624167820315529849146476793440010436702405) }}, 
      {{ SC_(414), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(385.30379905793826917777028989949545739448105434888), SC_(369.73544124565849584689204002129369350307849780288) }}, 
      {{ SC_(414), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(387.94317227757913413047957208975163538935581965528), SC_(366.64680272167922118675750189353232934072393917914) }}, 
      {{ SC_(414), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(396.54625838361135955112011557348070679689721885558), SC_(404.58258219638738333630574211211627888309688043367) }}, 
      {{ SC_(414), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(396.70040798894791110437217128793884376276909722682), SC_(404.45661460719627926261187680232830915392910248249) }}, 
      {{ SC_(414), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(397.96624450269005918407621413399421795424053294492), SC_(403.38627209692876680414632673223057763316475670853) }}, 
      {{ SC_(414), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(403.79908359097971212386396162783806955475848647244), SC_(397.48709174617485279919871695051814044051447681559) }}, 
      {{ SC_(414), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(404.05272486603121032364294976512129085283758540282), SC_(397.18713026102097802730377606290544617689477740425) }}, 
      {{ SC_(414), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(405.12727604028433978946332708351000776255892722047), SC_(395.86630756576072556729444877988382021633804455706) }}, 
      {{ SC_(414), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(405.27077341511268961802173002505224625504019758166), SC_(395.6834354053048567663890536421923512230885870112) }}, 
      {{ SC_(414), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(406.76956189527341809003550213309446262844163556548), SC_(393.67069070212176244841956544554977900759097215994) }}, 
      {{ SC_(422), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(45.32799555310255766222294762132673564117728886045), SC_(60.923723390013394363995039721726570503439947548221) }}, 
      {{ SC_(422), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(45.589233734454889749341219096450584167616638158658), SC_(60.640199586937692740058562723647850615731899654722) }}, 
      {{ SC_(422), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(47.781319019673070999642878948482045688883428966549), SC_(58.293369422687915415460725076068597108772199312178) }}, 
      {{ SC_(422), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(59.185707411608282615687037694710051384288747548937), SC_(46.941523844842333492308086010871091342733050684841) }}, 
      {{ SC_(422), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(59.741820493804380481680645199329355128269100822745), SC_(46.422078620014937062549740506059158012492904106018) }}, 
      {{ SC_(422), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(62.168783193108737314353910543398057288539195384894), SC_(44.189815048921166090360262100511247770859661243229) }}, 
      {{ SC_(422), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(62.502133543635841652921615491255505880394349500187), SC_(43.887553837685690204092654733628146161807686607065) }}, 
      {{ SC_(422), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(66.13166421119186102150703697048822090352955645682), SC_(40.662783403662737281615916303561270262181605436985) }}, 
      {{ SC_(422), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(48.69238945169823555896998896327109125894025235367), SC_(64.723350799685249007945797189391170761906979837207) }}, 
      {{ SC_(422), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(48.961495154497690331980946629804169044587183197752), SC_(64.432469355556185188249824853277766973070075463272) }}, 
      {{ SC_(422), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(51.218734270087338458275697915395163865672781114056), SC_(62.024023014294923185758619464153908573874323361222) }}, 
      {{ SC_(422), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(62.939941364692261059282402025275015604696926501396), SC_(50.354158091142468117386346046458608036889676645084) }}, 
      {{ SC_(422), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(63.510655044637533896562473486502942742808562033931), SC_(49.819274046549133356328997111718654107288246321362) }}, 
      {{ SC_(422), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(66.000506220316676328246290457062101023650986413839), SC_(47.519666578809003256154040736853671397169045589091) }}, 
      {{ SC_(422), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(66.342391204297343970199416295096358341957251041147), SC_(47.208158577563863406712876590361486654078997491027) }}, 
      {{ SC_(422), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(70.063297624829078395422872592150451985165157949128), SC_(43.882722137181999988657296381949859405288089888169) }}, 
      {{ SC_(422), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(83.083046573326190284617757556862056048190343707581), SC_(102.52568933902877360087495098064604645823627098142) }}, 
      {{ SC_(422), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(83.414377719164209979796432905919026536617819090636), SC_(102.1777048765573824985245214342218973621169203401) }}, 
      {{ SC_(422), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(86.186214146712292111152890823528128547020663445994), SC_(99.290218422482031234789999844682482423171057154612) }}, 
      {{ SC_(422), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(100.38963859970068232029997487370617215965461559456), SC_(85.126065116196867952112512079800711405849658994573) }}, 
      {{ SC_(422), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(101.07386596171651268356637574467669987622005452626), SC_(84.469242067721704721083064019492094863791017731127) }}, 
      {{ SC_(422), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(104.05168677528380760202901079845518645883181750758), SC_(81.636909336666838426459314962567633518098402445743) }}, 
      {{ SC_(422), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(104.45967187184613925431683582806425170440614679807), SC_(81.252151796433561220057823021017478328964855773116) }}, 
      {{ SC_(422), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(108.8863799860713290466207310817340219434528587614), SC_(77.127758121576843819936711231604260524993569479679) }}, 
      {{ SC_(422), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(334.18029784745400452147045025682181283967041049007), SC_(352.38331087405583262445692382164897782015105875302) }}, 
      {{ SC_(422), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(334.50767417631003788401903873869393576075410449823), SC_(352.07472634699023219305954275218857759748277864734) }}, 
      {{ SC_(422), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(337.22207258250859898180246515008054940035044106257), SC_(349.49082474690628668515326546617032634416327224624) }}, 
      {{ SC_(422), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(350.47958681695718343567030673362599044497275932851), SC_(336.18899865793795414753073646963153267735834412455) }}, 
      {{ SC_(422), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(351.0918767721924709986775854976212428999554279759), SC_(335.54578638226987539420085637198667550402536796279) }}, 
      {{ SC_(422), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(353.7294478733037006061197554526682505513423558618), SC_(332.74404358610327160274624977982810502232251306366) }}, 
      {{ SC_(422), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(354.0874001892534764458553927867772501037860589594), SC_(332.3598797787970773437343447230666407041275800513) }}, 
      {{ SC_(422), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(357.91903898674005775348687493771738292815886938119), SC_(328.18706310359028957613814571183776347299811127866) }}, 
      {{ SC_(422), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(343.14549554499505003950117049979940714430701529777), SC_(360.53449515735062440861949534009639388014154414451) }}, 
      {{ SC_(422), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(343.45924355177759035430581278766638555486456411251), SC_(360.24075333384102264644936031333938330573626222061) }}, 
      {{ SC_(422), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(346.05931847168510732490140423159409070639438800204), SC_(357.77960493856432964913893087293403463313526202861) }}, 
      {{ SC_(422), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(358.72171341464095425879645376890421591635706765111), SC_(345.07003638178882297341975526930764758876417014158) }}, 
      {{ SC_(422), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(359.30491576032303344731303121195322661495133793094), SC_(344.45391428152049878409796526924279045717437953272) }}, 
      {{ SC_(422), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(361.81541611097246211290936811769092632190302599965), SC_(341.76863198220942470066844856054207621991132746102) }}, 
      {{ SC_(422), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(362.15589710687013452847090569490474856002909653124), SC_(341.40024460460684231801218744040156484652101037821) }}, 
      {{ SC_(422), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(365.79698412605900031249268815599910871406584378241), SC_(337.39589641626176303138050598942774705079197848664) }}, 
      {{ SC_(422), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(374.86409950979993556265927884974184060121615871126), SC_(388.5429032225669026231397106914986368805060002534) }}, 
      {{ SC_(422), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(375.11507780215043108565896944668942834154081025872), SC_(388.31618528038655933232049414139121624038594175963) }}, 
      {{ SC_(422), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(377.18956533487522440458228166684208620196620236965), SC_(386.41013696953947813614265388275443655475816154722) }}, 
      {{ SC_(422), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(387.14110428911259671523206213991187520477397608529), SC_(376.40140879775044863602694833409846554766467449618) }}, 
      {{ SC_(422), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(387.59277047338795028858657321661734177427413967066), SC_(375.90983009634919998047204695551434002820634765706) }}, 
      {{ SC_(422), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(389.52957016291340086271626786811287584209033421583), SC_(373.76107376825202929196344026720598279048202425015) }}, 
      {{ SC_(422), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(389.79128492203255875430358887622877546118016998367), SC_(373.4655096787640544653043414645228017181681158269) }}, 
      {{ SC_(422), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(392.57496836308987356514886759347408022594741577705), SC_(370.24101400461995012854068564588995359895897580013) }}, 
      {{ SC_(422), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(378.31807656653857847669119122123892022772823941995), SC_(391.48824101042426542446651658229277066041759247181) }}, 
      {{ SC_(422), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(378.56038527875490492691798340746986452828067132267), SC_(391.27065171964544235151834903232124892178033902758) }}, 
      {{ SC_(422), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(380.56237624063224298352294232439222285569319142629), SC_(389.44028115399297165914143058156174696287197039907) }}, 
      {{ SC_(422), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(390.14244751125498238999803626861947148547170807838), SC_(379.80194178088033168814829256983016226596326987979) }}, 
      {{ SC_(422), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(390.57618121988312313084341159126687261271196758739), SC_(379.32754186792305823965973935807246148610429036832) }}, 
      {{ SC_(422), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(392.43485190336766569800131075444346122865126895737), SC_(377.25290192433640736581089675132513392244170795904) }}, 
      {{ SC_(422), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(392.68585015479070825038666145059811366949071112845), SC_(376.96741193686508148999066892728072957180085302775) }}, 
      {{ SC_(422), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(395.3530238653443929986755361194488127376995976508), SC_(373.85101929459662532313206972943220870916500765819) }}, 
      {{ SC_(422), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(404.25831435689598524806937324273899449929522641271), SC_(412.37239792742406196892388342030360531292701826098) }}, 
      {{ SC_(422), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(404.41382535869778332971154651091385561034540813528), SC_(412.24506461628061523199225088596394904292416439358) }}, 
      {{ SC_(422), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(405.69098952050610320588792915728073658612362858518), SC_(411.16336966420398102155536592478246947723539986667) }}, 
      {{ SC_(422), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(411.58050839730710563235532845576110626239219458927), SC_(405.20751692754723778242612662474703489008572312004) }}, 
      {{ SC_(422), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(411.8368396166733748366879589270895939471759316369), SC_(404.90487127937020384440784465491516983804323338449) }}, 
      {{ SC_(422), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(412.92307652063498768240402621884915080395919352836), SC_(403.57240224405061382271607883044386552602731593936) }}, 
      {{ SC_(422), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(413.06817303931460351532227447065369264722067683342), SC_(403.38793861652312085125050868045776224392977834871) }}, 
      {{ SC_(422), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(414.58430977879379304150515993799285853858548954945), SC_(401.35798257785370969839805336064068861593754253383) }}, 
      {{ SC_(430), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(46.270237069394545316899794015235209083099073205424), SC_(62.013272633651803618529871110041554154397414836409) }}, 
      {{ SC_(430), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(46.534053132432135395355195393884193036072566293111), SC_(61.727171939835030030351499654047370975138021223232) }}, 
      {{ SC_(430), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(48.747598317591452565617793288590536724689350226152), SC_(59.35888770522676212969685975664562282304693780846) }}, 
      {{ SC_(430), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(60.259409785541897195083295827021404337736422618764), SC_(47.899617277578690441526809886662709691726481574955) }}, 
      {{ SC_(430), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(60.820606615274620722885136113513162221450420335523), SC_(47.375086942240003391725933630469664804163812628265) }}, 
      {{ SC_(430), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(63.269611735093601207397362884493372470792587075183), SC_(45.120771981989731930430668352848713302104933555654) }}, 
      {{ SC_(430), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(63.60597200357646260661168544949084109487752166132), SC_(44.815499149632136277782564110917978333189532682462) }}, 
      {{ SC_(430), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(67.268015643097433087299158599471365141803645454709), SC_(41.558186680141723720736148810679528027697879380714) }}, 
      {{ SC_(430), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(49.700504698615067318814632163291565142170214520793), SC_(65.882869210880922992620200195412123741252183014595) }}, 
      {{ SC_(430), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(49.9722597963102695817333487812513827699514206055), SC_(65.589339291973539214138627840912261299697790579682) }}, 
      {{ SC_(430), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(52.251554664278927589424268007316588497616827638353), SC_(63.158842613895608199245429131877507402388254717928) }}, 
      {{ SC_(430), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(64.083172570124423206459741959364721960802052280159), SC_(51.378565231113391044901304319497997566210712118756) }}, 
      {{ SC_(430), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(64.659111290098736116464138912809938052379484221507), SC_(50.838454880253426271539543812148377694250401351829) }}, 
      {{ SC_(430), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(67.171617159067831582292905550428962081875857600745), SC_(48.516184392558524285887977169249569258933750136304) }}, 
      {{ SC_(430), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(67.516595617814065605951284904448003500584289523205), SC_(48.201581336072115104150332128266447039464290226325) }}, 
      {{ SC_(430), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(71.270916684116416346588631203651544671281678479384), SC_(44.842703302362599542806037880781995037535754441896) }}, 
      {{ SC_(430), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(84.759560537332772103604482431553991873592607054636), SC_(104.38572095225850169818629018151760531683227131804) }}, 
      {{ SC_(430), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(85.094102005152248714743481080535670745347802650133), SC_(104.03452666155001072094986432150077221496361832543) }}, 
      {{ SC_(430), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(87.892667350799571032347956785634382637407604354732), SC_(101.12031420339159980054642503992441021657989717008) }}, 
      {{ SC_(430), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(102.22993002165839592687076234467199047769995041333), SC_(86.822321790525785743549182764506479594433031791874) }}, 
      {{ SC_(430), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(102.92049037831749650671743944604256507113650236164), SC_(86.159165065880843362692962091788126093584450126403) }}, 
      {{ SC_(430), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(105.92576728512874721152206263417146894652747279044), SC_(83.299371776269275408167540903678500107525597770828) }}, 
      {{ SC_(430), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(106.33750113403979113968177796857521167781275029389), SC_(82.910864638468086144466412433829698672828879566972) }}, 
      {{ SC_(430), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(110.80469563872921546012797391737269243720238512675), SC_(78.745970228537969628468808236482332465510573103865) }}, 
      {{ SC_(430), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(340.61216326912134981082963627874034435206545733618), SC_(358.98702316936590376319344684146243415719518342095) }}, 
      {{ SC_(430), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(340.94254541848933003194535353535143049264912563367), SC_(358.67543219348119225008157095680708432239999624836) }}, 
      {{ SC_(430), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(343.68197062663952419474573989641068966133889838324), SC_(356.0665000862749223011166243684126931509960804429) }}, 
      {{ SC_(430), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(357.06481059036609742660240645334678199407961573973), SC_(342.63934939736521474884003193224954165323036870442) }}, 
      {{ SC_(430), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(357.68303176087452512219719798872865996043457380284), SC_(341.99020677291424105205440713851496458314826127249) }}, 
      {{ SC_(430), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(360.34631970253133602048053752092263325600680853261), SC_(339.16275281955100881518302453240006842612495104213) }}, 
      {{ SC_(430), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(360.70778369911672742351630829298375978254479982974), SC_(338.77507840826879786426158092190756656694806778453) }}, 
      {{ SC_(430), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(364.57735698634211285657064204127603814485099047152), SC_(334.56434554097268359210061654906470040936093436958) }}, 
      {{ SC_(430), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(349.74347128269181385371252119044928078223427580578), SC_(367.29665521563065419190981205906508404278951808122) }}, 
      {{ SC_(430), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(350.06009117029968596928232672883203596456826142198), SC_(367.00004078378253062635849860872721320445698594748) }}, 
      {{ SC_(430), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(352.68407727379111042308196442993477934069718594636), SC_(364.51497691745048231059206462546591351252069107492) }}, 
      {{ SC_(430), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(365.4662083324878688980615255857365963405711582008), SC_(351.68567355116180441892718140894782521363495825508) }}, 
      {{ SC_(430), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(366.05507767060799299739965428112838693300416114454), SC_(351.06388546105863041545507379670997117631900969541) }}, 
      {{ SC_(430), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(368.59015013936725222757150415839518270417324598667), SC_(348.35403762533119059979972316058520966376326741957) }}, 
      {{ SC_(430), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(368.93398663638932569971728761560838854587558450155), SC_(347.98229599424588161324123735661082750025446744691) }}, 
      {{ SC_(430), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(372.61132373643957399026103555726810227759638752882), SC_(343.94171895128875992223035450571332252433480607441) }}, 
      {{ SC_(430), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(382.04579603428863097096826224367731819484865909277), SC_(395.85387519147975754300498667607777505602360432299) }}, 
      {{ SC_(430), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(382.29903603966477710704629173830388745251757294964), SC_(395.62489415947626577694186278212108799955376506396) }}, 
      {{ SC_(430), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(384.39235225806274464469951929582067745592107543468), SC_(393.70000908569492349033411479156962957462378091237) }}, 
      {{ SC_(430), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(394.43816117865399994104472557958177446039658704264), SC_(383.59701340039564850030130644297811854801853981633) }}, 
      {{ SC_(430), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(394.89429088167633544418639421008453682258815107091), SC_(383.10097306821216706836689979259320035785447299659) }}, 
      {{ SC_(430), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(396.85044969461734993750356704925042429893465479507), SC_(380.93287008558836281453937770458167558945973605669) }}, 
      {{ SC_(430), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(397.11480886853716354761164188762275163960498578311), SC_(380.63466395573665907045378179916430329980015621802) }}, 
      {{ SC_(430), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(399.92707639843653202571455915845880456212887592894), SC_(377.38162490061324780114475076080544109040892169042) }}, 
      {{ SC_(430), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(385.56283572415734544388649816822714895636465998555), SC_(398.85749270729762380226523968032380038113558522788) }}, 
      {{ SC_(430), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(385.80732255338164378341601176148588934667399626073), SC_(398.63772379398292614559344976476575269452569013143) }}, 
      {{ SC_(430), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(387.82744583279206230672922578990941373784342158517), SC_(396.78921208664463281939097869116499374255672166219) }}, 
      {{ SC_(430), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(397.4982977233051554413002521578661380157532254823), SC_(387.06009477147530417452944169179020058016915708932) }}, 
      {{ SC_(430), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(397.93633011207360866790436488829962618056863616672), SC_(386.58139824072226369498561542986214709030304478614) }}, 
      {{ SC_(430), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(399.81364608161840705039429104801181145068055767359), SC_(384.4881266488290623183412806193015841135327687252) }}, 
      {{ SC_(430), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(400.06719140380562988118971588599642615565356504284), SC_(384.20009219008300775380449592178089094896804294878) }}, 
      {{ SC_(430), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(402.76190038342852778923780119372508474662492797988), SC_(381.0562089165064371072230053088936662908215555225) }}, 
      {{ SC_(430), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(411.97073946944811601326322260833509171089209254416), SC_(420.16184511758005078607772615632056032209386502913) }}, 
      {{ SC_(430), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(412.12759892496549730889136232481166910161578665566), SC_(420.03315918112173483555624881892698478179799197507) }}, 
      {{ SC_(430), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(413.41598321788633939315614910634093615329184649262), SC_(418.94022017064968982113513959241115983544309910407) }}, 
      {{ SC_(430), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(419.36164492001902663229574962780858186649750153422), SC_(412.92823175603147814427137955730197697472835447735) }}, 
      {{ SC_(430), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(419.62064040597421906268850608026780740024080985227), SC_(412.62292742090631348467137481877427926511616810358) }}, 
      {{ SC_(430), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(420.71845088237520896385806604754288643539831800395), SC_(411.27892279552996942751698112075236093383542537119) }}, 
      {{ SC_(430), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(420.86513110242503373515454896722290661535164319118), SC_(411.09288286437759676562717736722567151397875522808) }}, 
      {{ SC_(430), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(422.39844646697324295008795641710817439720052707278), SC_(409.0458800016796736300568094881362379517871208223) }}, 
      {{ SC_(438), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(47.213161350011517873649210456728453609034895561662), SC_(63.102139045671836353970190596080435879856491747101) }}, 
      {{ SC_(438), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(47.479531340392064753429269736445106301296574577863), SC_(62.813485379520962919736379774660247279649134350379) }}, 
      {{ SC_(438), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(49.714337211364493941592843160079113551740205350017), SC_(60.423946078079941973301812679603303390474886702081) }}, 
      {{ SC_(438), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(61.332576361293144145702878092456498693970376188058), SC_(48.858246258572342507735295740110997536522825239374) }}, 
      {{ SC_(438), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(61.898809783450951292174393948975728034134432868788), SC_(48.328678017054564373647754502642339656763370048575) }}, 
      {{ SC_(438), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(64.36965270614624288539136664874867193048037589262), SC_(46.052516610810677534097827590764870485230859653631) }}, 
      {{ SC_(438), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(64.708994929028753735597361780621857500939237210166), SC_(45.744260182940333719788387635523584770332719620196) }}, 
      {{ SC_(438), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(68.40324905785844508205478501256236632251435822426), SC_(42.454709226289471134397228004201079813702580560988) }}, 
      {{ SC_(438), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(50.709321628059909674007769008930123966938876508593), SC_(67.041685878100122956804746740045551296501060889247) }}, 
      {{ SC_(438), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(50.983701507529417890396449458206898018710971166569), SC_(66.745532064153160641410270846867295392733419183382) }}, 
      {{ SC_(438), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(53.28484741899603381493186143510929287910332914466), SC_(64.293189562353510488786724165317401992001249188556) }}, 
      {{ SC_(438), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(65.225853133466885536138528230857594727176005266758), SC_(52.403522781998266517451869427817666746500503046627) }}, 
      {{ SC_(438), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(65.806968432797579839761925635114331935585667588275), SC_(51.858234631305645184153982690166217755490854772144) }}, 
      {{ SC_(438), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(68.341918721044569252146262906455285976889661895462), SC_(49.513511700017233765872242610767558727912260007297) }}, 
      {{ SC_(438), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(68.689961919217329935186142319716406931485289500846), SC_(49.19584238122158430254664810791974433450969314107) }}, 
      {{ SC_(438), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(72.477386822197322369819360678681808189292325440047), SC_(45.803834551106175231210981230225370953322875421542) }}, 
      {{ SC_(438), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(86.43692457058683806836357500721116378725594781031), SC_(106.24490246633818529765409985913784081530336717002) }}, 
      {{ SC_(438), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(86.77464657486117522363138154475159481838235494384), SC_(105.89052811496050044297802708518959718301835305784) }}, 
      {{ SC_(438), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(89.599693004239583130744262632616709007231011818976), SC_(102.94983738132763232305514786014631243093542340533) }}, 
      {{ SC_(438), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(104.06955435953671978986132520306314860027855916542), SC_(88.51924542751734465416156630184399564826593643713) }}, 
      {{ SC_(438), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(104.76638900973074146777783927285664660713214370326), SC_(87.849813752540510466720918021874297913749933386745) }}, 
      {{ SC_(438), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(107.79886736353841845499496898637328669901244087673), SC_(84.962814713116430879406193371636066052967272125336) }}, 
      {{ SC_(438), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(108.21431517436318512896696055386772677765458296041), SC_(84.570592799007926539647002878737167133846873073308) }}, 
      {{ SC_(438), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(112.72161992184793758807162671726653082351273906896), SC_(80.365574326739725854559107399999547026520631877048) }}, 
      {{ SC_(438), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(347.04482486656639393111162554313594333385134098779), SC_(365.58993932810210707929084018905424402989824067246) }}, 
      {{ SC_(438), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(347.37818495458086102110075756305215497127188591149), SC_(365.27536980810025748698603969896832026372194546912) }}, 
      {{ SC_(438), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(350.14240494345630191664356591502882641544593617481), SC_(362.64163934931940712831343566648732072879501247322) }}, 
      {{ SC_(438), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(363.64940975893017664633535373896348270429777687094), SC_(349.09032489713360097579591778614327637749066214039) }}, 
      {{ SC_(438), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(364.27350713424838871929102707500380149940177133631), SC_(348.43530690295884753994708596700001791796003013392) }}, 
      {{ SC_(438), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(366.9622731923293681848080266107451335546103037329), SC_(345.58238030982854773354687251022622335505926908032) }}, 
      {{ SC_(438), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(367.32721624096124627911364334514310683138608669551), SC_(345.19122788390188223524625316585860635263687510842) }}, 
      {{ SC_(438), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(371.23437095411654437001339477566698325659085359148), SC_(340.94293121825751471103089691503297437010999421665) }}, 
      {{ SC_(438), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(356.34220779765874948900569854918512416922345462204), SC_(374.05805454308153973781690795712907291033870514196) }}, 
      {{ SC_(438), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(356.66167292206737577159459272320700542932720984228), SC_(373.75859417334641611298121277453985635357570210053) }}, 
      {{ SC_(438), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(359.30934849930054954395763478220296107536679591073), SC_(371.24983670109298674857710889469271962893957768296) }}, 
      {{ SC_(438), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(372.21010645482781758139230445807569217653177522316), SC_(358.30190769698848410803842083761923603105606455056) }}, 
      {{ SC_(438), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(372.80459021342960832840982293070915820992133745161), SC_(357.67450615270320007183581632904268249930868744204) }}, 
      {{ SC_(438), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(375.36400663106141243299308872930763939856507153625), SC_(354.94032071055475865113865829261764876974265726919) }}, 
      {{ SC_(438), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(375.71116743917545423508482110487196633707904727249), SC_(354.56525597053573100051149205322896795407402618768) }}, 
      {{ SC_(438), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(379.42441703904468237990419032859048570187723814476), SC_(350.48878687642717811911229738533709935597611079913) }}, 
      {{ SC_(438), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(389.22809214487026894764827264336653211143714623039), SC_(403.16424767664966441187051127299884304424307667168) }}, 
      {{ SC_(438), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(389.48357285593148076651064319497453637413847772007), SC_(402.93302461195125450476867454684089818101851757959) }}, 
      {{ SC_(438), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(391.5955430104893312728786680850559174166959894489), SC_(400.98947781532631715464705073871925602519715606535) }}, 
      {{ SC_(438), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(401.73474796095996055359766823039112819893242107919), SC_(390.79308846508143082558267669959864050930414497681) }}, 
      {{ SC_(438), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(402.19529970703215975262649606640730665429679341129), SC_(390.29262790992957205896393937196880017887692852005) }}, 
      {{ SC_(438), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(404.17063747238064493418847755244915582271350299217), SC_(388.10535799234014641377517320857618726103971000395) }}, 
      {{ SC_(438), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(404.43761640804197957439589896478596472020795027967), SC_(387.8045343887682537047031551223346202572033915054) }}, 
      {{ SC_(438), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(407.2782006925084955545735905175165472085159380913), SC_(384.5232177924852180423019639676524748147843979802) }}, 
      {{ SC_(438), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(392.8081723963206829490202576160733662163708410676), SC_(406.22616700492531529028247127526720928861163225443) }}, 
      {{ SC_(438), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(393.05481710711102168310206094830689240111127394811), SC_(406.00423875890386329645064487208754355917236380752) }}, 
      {{ SC_(438), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(395.09290438631921843136112612250789625506943842608), SC_(404.13775454458398135517337613597976681693624085217) }}, 
      {{ SC_(438), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(404.85369518662611595815156864620475324919277295442), SC_(394.3187009016595359887500946165978602368278401406) }}, 
      {{ SC_(438), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(405.29598629777702090178092697765786066934957487457), SC_(393.83574763683069023040771721526936599620877005614) }}, 
      {{ SC_(438), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(407.19177394239041013671515709690291340521915450064), SC_(391.72401751430363291478881128938401568304794235537) }}, 
      {{ SC_(438), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(407.44784257475313331272708826619491071194017997635), SC_(391.43346225030597120327181876998469065573185303534) }}, 
      {{ SC_(438), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(410.16982905784505016961575468389015005564387836919), SC_(388.26234447167567419610419567272597587716040291715) }}, 
      {{ SC_(438), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(419.68352340634527197560713180855125493175537929863), SC_(427.95093404199456607768879422498986269844300208816) }}, 
      {{ SC_(438), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(419.84171873465468938181828830913437945460430462219), SC_(427.82090820703205445849597458777784131665728226645) }}, 
      {{ SC_(438), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(421.14121864322710545978710775396597293148019409992), SC_(426.71683047588180609591792855084498804681460325936) }}, 
      {{ SC_(438), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(427.14250117438884987294019087792091205257908114113), SC_(420.64922813719833438375003632786316606624080208372) }}, 
      {{ SC_(438), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(427.40413597065778162160221513923209271296323279612), SC_(420.34128988001557074024953314472211291738186549796) }}, 
      {{ SC_(438), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(428.51341103250829512148870426073199869072584263787), SC_(418.98585731779304931892651968635803530667907609132) }}, 
      {{ SC_(438), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(428.66165995098117819241632484650284847482360584946), SC_(418.79825582175927363620702818730880463649270036456) }}, 
      {{ SC_(438), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(430.21198920649725911101811714204078276808639176506), SC_(416.73436602666193927516805654100166997050019081359) }}, 
      {{ SC_(446), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(48.156749753053794278116103962489125401517672389909), SC_(64.190341271880975417143516713290413870041284350826) }}, 
      {{ SC_(446), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(48.425650372155193272387050172706629918773035569466), SC_(63.899157898002095650034718125634048627685450089907) }}, 
      {{ SC_(446), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(50.681523162397264020631317883776609034948320615721), SC_(61.488557096875495555246714745789142676086496086113) }}, 
      {{ SC_(446), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(62.405221766966400417030173331529173500505430548345), SC_(49.817396173360905381597032617509104290343975788129) }}, 
      {{ SC_(446), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(62.976445914604181434225477673877209412931048717897), SC_(49.282835939211811911060714534735867785342185336831) }}, 
      {{ SC_(446), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(65.468927616249083470558780782918959777816082360183), SC_(46.985027419023867998937422171260985258917952567318) }}, 
      {{ SC_(446), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(65.811224594999907218926426718967154959693193363753), SC_(46.67381465289565827091063978402875361642287765299) }}, 
      {{ SC_(446), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(69.537395016332176593600462611095542670417366503625), SC_(43.35232041399866114932799677576620015503710740914) }}, 
      {{ SC_(446), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(51.7188210832154561124283838217376203932307241237), SC_(68.199819961714843692953014383143838806676502957092) }}, 
      {{ SC_(446), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(51.995801804927087628798709564053047349798882825703), SC_(67.901066160661668640881500463247321471507213490533) }}, 
      {{ SC_(446), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(54.3185996478250420057403227533406443249021797434), SC_(65.427076761846303034208853005387399828398418015599) }}, 
      {{ SC_(446), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(66.367998086620703799004317986591491804087512228582), SC_(53.429015724502927464455363011160950611448547692373) }}, 
      {{ SC_(446), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(66.954242828348376824674648426543909160070108971057), SC_(52.878596954262476079148954322353515183376963238759) }}, 
      {{ SC_(446), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(69.511433009563906564011527026728205286864580925537), SC_(50.511626391869058723983088976422912972643751252124) }}, 
      {{ SC_(446), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(69.862512997858431952359412397555777994289321649361), SC_(50.190918814570908761288766385043987607540142009193) }}, 
      {{ SC_(446), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(73.682739440924105237892639143599554562270885924872), SC_(46.766084419141035728168742378293789166788451772439) }}, 
      {{ SC_(446), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(88.115115476647100386852917189129771582925251081869), SC_(108.10325707939817105150096601073395846369228263169) }}, 
      {{ SC_(446), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(88.455989045889006166251315595980432749263365978285), SC_(107.74573162184210302199056613008321329334205732738) }}, 
      {{ SC_(446), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(91.307275493543776055975086314889611741480685851515), SC_(104.77880357808425913308897064897391994910106849519) }}, 
      {{ SC_(446), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(105.90852981393496521800064774473793968006251981964), SC_(90.216817833158721378999290033233944633639223477727) }}, 
      {{ SC_(446), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(106.61158165914209065431510266847205745187263719103), SC_(89.541168329779500756409651254509890067762497078278) }}, 
      {{ SC_(446), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(109.67101376971634448252602377620039222439995826816), SC_(86.627211384558638968248743722797105991258253857364) }}, 
      {{ SC_(446), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(110.09014170293838394926167604460366827562879416556), SC_(86.231308562828872448728488481430140693022647434526) }}, 
      {{ SC_(446), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(114.63719083733676435762020664659963878674677515022), SC_(81.986532380861605442223992600858018689797362747917) }}, 
      {{ SC_(446), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(353.47826090951834016009063039928810523438546829544), SC_(372.19208107830406887039780638299699685185603701018) }}, 
      {{ SC_(446), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(353.81457181603351098424844371353744358466584192584), SC_(371.87456015594474117128626523066599601402801399115) }}, 
      {{ SC_(446), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(356.60336089986722942457980854187565965220777952707), SC_(369.21625715850461716301423580908187564499290945559) }}, 
      {{ SC_(446), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(370.23340136286070318007617655861058642574230258023), SC_(355.54190810858328191690534507523926693622784430521) }}, 
      {{ SC_(446), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(370.86332143541645977895359953884316859349595559276), SC_(354.88106822252936373678180557099626585579195112359) }}, 
      {{ SC_(446), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(373.57733341361818727611194925680556092705525981657), SC_(352.00290099031616969646721736709370624977127660349) }}, 
      {{ SC_(446), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(373.94572377878622253846195926542230567161953353999), SC_(351.60830224810625578857359106622410288947083937983) }}, 
      {{ SC_(446), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(377.89011653497846554623300208474922248671897242991), SC_(347.32278453308078219860556513971128698656887912659) }}, 
      {{ SC_(446), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(362.94168432307987827035268081367974746506722904753), SC_(380.81871390386135904052132883083598384217359698918) }}, 
      {{ SC_(446), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(363.26396876827600040163032387018880790668635899431), SC_(380.5164335372654339267640796921570448707106139607) }}, 
      {{ SC_(446), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(365.93511816406086880080971891254327797182755335959), SC_(377.98419826128727731157972071754921841213867415835) }}, 
      {{ SC_(446), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(378.95342406438517966638136766144803341054914947839), SC_(364.91872252670108408686208859449752267841040570902) }}, 
      {{ SC_(446), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(379.55347110812248582612380571350872893833238625852), SC_(364.28575862921253358145856516860783996738052511795) }}, 
      {{ SC_(446), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(382.13700954663236265640933082299185167207376562074), SC_(361.52745728220514386474567803815311163194870558564) }}, 
      {{ SC_(446), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(382.48746432987585889363647703282907612322728077425), SC_(361.14909972617377639690233713129548973404962667614) }}, 
      {{ SC_(446), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(386.23629811069449819507369092834581931943088464936), SC_(357.03706616415568326322426541821533982457589201131) }}, 
      {{ SC_(446), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(396.41097146003227509012225939346662411411284932416), SC_(410.47403705352696506309432908393405080434113828998) }}, 
      {{ SC_(446), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(396.66867244399882849101416888908817541174091037216), SC_(410.24059243604992360629301674740026659326568024046) }}, 
      {{ SC_(446), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(398.79912656129306564627752390868234655986516455223), SC_(408.2785541651897141738465850193859191780293841102) }}, 
      {{ SC_(446), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(409.03087746790732700945161890027208415928359550708), SC_(397.98962114046431281237657251623367305002885541988) }}, 
      {{ SC_(446), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(409.49581091662885569088405553385661671217975438059), SC_(397.48478063845536762874489327505218701196034081042) }}, 
      {{ SC_(446), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(411.49015240343343926268598878036918343728596903203), SC_(395.27851858947241592160999417827192251263325412592) }}, 
      {{ SC_(446), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(411.75972712498067298160599125899693431292827749968), SC_(394.97510140625119685135543193339363615138485717851) }}, 
      {{ SC_(446), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(414.62836819918362311721155852376907274513824083925), SC_(391.66576581996251950805557355898955711976193331058) }}, 
      {{ SC_(446), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(400.05407080165804096108998662903471380058567097781), SC_(413.5942796778066692791993567510567454471342179647) }}, 
      {{ SC_(446), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(400.30285371212558347680372383138095274143566426517), SC_(413.37021183246174838438567565775222108931568099239) }}, 
      {{ SC_(446), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(402.3587412744099684113408506403007629408895045125), SC_(411.48591912808740479863722231725232796878475517608) }}, 
      {{ SC_(446), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(412.20865226019980245018871530202159243003416317964), SC_(401.5777477909690379203824350857809679348248182972) }}, 
      {{ SC_(446), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(412.65516323010460271279937426294240897261247394527), SC_(401.09057658556836580786997897293728884294087705404) }}, 
      {{ SC_(446), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(414.5692537013859158169828730204001195327978313158), SC_(398.9605563137627206824996862403351609530329958582) }}, 
      {{ SC_(446), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(414.82782253646661629552695475770453367266134002886), SC_(398.66750326247031448701375924330280094272108373277) }}, 
      {{ SC_(446), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(417.57683587045940695958695435349342508492436897641), SC_(395.46940008064360921118887105545328846033566490858) }}, 
      {{ SC_(446), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(427.39665632419660221757318140935343778573385115416), SC_(435.73967450764535176370329592532469463907438060904) }}, 
      {{ SC_(446), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(427.5561752896637563351228553244421469875651859749), SC_(435.60832114823934186726809793480260885008465747535) }}, 
      {{ SC_(446), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(428.86668916291577145993396284165817349848516451965), SC_(434.493207128358585277618701040005783141893971397) }}, 
      {{ SC_(446), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(434.92308481156828091235715497642429466865587918174), SC_(428.37049834673872444786974641288187710996500079189) }}, 
      {{ SC_(446), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(435.18733465018754503862085409169084074303948311036), SC_(428.05995025366591908449247282392265696086917906617) }}, 
      {{ SC_(446), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(436.30796833423132862942305657629999891546231611204), SC_(426.69319445257873220848167172463969284451065308506) }}, 
      {{ SC_(446), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(436.45777136724686166806595215871203821884279980056), SC_(426.50404572514683703751339618490661252026245756339) }}, 
      {{ SC_(446), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(438.02495444786127178629126967345181894503981330409), SC_(424.42342448143340731445219787807853460527030004589) }}, 
      {{ SC_(454), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(49.100984469765109441684126850150762200324947709569), SC_(65.277897124647758755594455085701621676098278083624) }}, 
      {{ SC_(454), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(49.372393045301165441991756284507224209617152084138), SC_(64.984206683096124771230317660339109659937448029389) }}, 
      {{ SC_(454), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(51.649144191997233219609130284058408721887314405882), SC_(62.552732756128399639386289660118365516369324943617) }}, 
      {{ SC_(454), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(63.477359976913932931283634563502474557837445480556), SC_(50.777053060259106339144478661335521453153709808124) }}, 
      {{ SC_(454), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(64.053530213656155026954742382590037602805576502036), SC_(50.237545514021268215096944379786442037712912745234) }}, 
      {{ SC_(454), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(66.567457013757988383158981223624762023929136888766), SC_(47.918283852321348971110621638176271959037953196846) }}, 
      {{ SC_(454), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(66.912682280617223076157778023232283325522700042432), SC_(47.604141271322980603452902054094240914435313279852) }}, 
      {{ SC_(454), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(70.670482712063747802669939127630528383478003320575), SC_(44.25099098720249580076199583097648166524040543908) }}, 
      {{ SC_(454), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(52.728984763355001731796656937837103403193868240042), SC_(69.357289765738557811447354821507709512911602380144) }}, 
      {{ SC_(454), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(53.008543031188310802446146627303500157580297621207), SC_(69.055959243759838527023451823513951407795759200156) }}, 
      {{ SC_(454), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(55.3527990397746993392296988291666594197800177088), SC_(66.560516538009465226861294374817454657194307003608) }}, 
      {{ SC_(454), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(67.509621789753408332997521474690395871535186359021), SC_(54.455029710166520294566068159467712371271029481925) }}, 
      {{ SC_(454), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(68.100950101450301843886266776239262033530806502624), SC_(53.899526233865346818087572452696837002323829371963) }}, 
      {{ SC_(454), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(70.680181139885210317621998879452622114296965365533), SC_(51.510507347257757553576638284777285129398373648392) }}, 
      {{ SC_(454), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(71.034270719841096746937352968357932561086503561869), SC_(51.18678876154573216549282006990460611473031979374) }}, 
      {{ SC_(454), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(74.887004537364699114028841255367334108752313963584), SC_(47.729422851369482517419814616170968842604108524955) }}, 
      {{ SC_(454), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(89.794111095210980326769744126324333638702277893432), SC_(109.96080695330547307254154609383358771311892996829) }}, 
      {{ SC_(454), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(90.138108035553184271137109268693094802183766800426), SC_(109.60015856733649377485725994300003279175534058891) }}, 
      {{ SC_(454), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(93.015399902308509097678752403806586540365521642169), SC_(106.60722771778258179908778234456131242722986080539) }}, 
      {{ SC_(454), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(107.74687377256406021636990676728167354145227945286), SC_(91.915021625857560676885111585980494117579033187526) }}, 
      {{ SC_(454), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(108.45608724523287344017464785618465381046311001496), SC_(91.233209883805755760524886218888605645230493731194) }}, 
      {{ SC_(454), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(111.54223206734187654395239140149560546048731890215), SC_(88.292536223706652813923623787041811654832640348131) }}, 
      {{ SC_(454), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(111.96500719182115984672164141407432163032317987486), SC_(87.892985453125773275887975291594209237143623790851) }}, 
      {{ SC_(454), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(116.55144468815170988998312737566710628643359854691), SC_(83.608808056888124029496610124633432188112035436221) }}, 
      {{ SC_(454), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(359.91245063855837003628948785151995629092526952476), SC_(378.79346917732518241159374053639622009964008750725) }}, 
      {{ SC_(454), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(360.25168597108658270597182555107680066333986375403), SC_(378.4730232655730149568894022578488173296654387863) }}, 
      {{ SC_(454), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(363.06482451640905215590317021931324903483848790408), SC_(375.79036748342018716265661932197145995293516682694) }}, 
      {{ SC_(454), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(376.81680168140533949225211571734440256851689126209), SC_(361.99408274461916949135976332706766909255550497361) }}, 
      {{ SC_(454), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(377.45249237930454355529782079030551544704417432123), SC_(361.32747301041193152616145933780861612231993980355) }}, 
      {{ SC_(454), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(380.19152431693385827945997714069153988663610154961), SC_(358.42429091448544998331844103409653306691448377583) }}, 
      {{ SC_(454), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(380.56333111618957640954651490831221004262736324563), SC_(358.02627670325176779034121995264126084877570544906) }}, 
      {{ SC_(454), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(384.54462777886203657134371194203736737733377841914), SC_(353.703871475065011513333858395689280281665356875) }}, 
      {{ SC_(454), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(369.54188102006306221597174018671765334890741520225), SC_(387.57865313440278739410302152244049988620358405586) }}, 
      {{ SC_(454), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(369.86695956548619061871890384801837512836142966171), SC_(387.27357801520457904788388379164923813449335398123) }}, 
      {{ SC_(454), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(372.56137290864362861166494458426597752332582414876), SC_(384.71807494598117046267042158460207080416705597545) }}, 
      {{ SC_(454), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(385.69617671670295069192573940857412842377814660419), SC_(371.53610247561441268063296798572371549117771053089) }}, 
      {{ SC_(454), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(386.30173728257579182661694595448799281904673763604), SC_(370.89762595535632827449176011734995574723701926815) }}, 
      {{ SC_(454), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(388.90918177573846515707230688741433736236347438392), SC_(368.11542445519407241799242366314576060787044902942) }}, 
      {{ SC_(454), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(389.26290101393273515696576362828306467336406391958), SC_(367.73380356255844499681086508568846126756261057824) }}, 
      {{ SC_(454), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(393.04699950294674609070521209844609327472625760318), SC_(363.58652430874680962954347431083742881714697545202) }}, 
      {{ SC_(454), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(403.59441833087207694018801830570527221159950607904), SC_(417.78325896541834357588191135673451105157367771533) }}, 
      {{ SC_(454), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(403.8543197038072404577241308713642209418246878718), SC_(417.54761272376970741009118842477914641350031611203) }}, 
      {{ SC_(454), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(406.00309237286350504417624014892875817982352897363), SC_(415.56724865050843224110457984938450181154278632745) }}, 
      {{ SC_(454), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(416.32656195811492424527968711515099295949000038472), SC_(405.18659914985703672949471151269350758771830014005) }}, 
      {{ SC_(454), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(416.79583785351087626227070602406122488457400255178), SC_(404.67741789602155383026078693599271923447329510535) }}, 
      {{ SC_(454), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(418.80901254912906693972931996862424181697132347241), SC_(402.45233382329611411637955899193400113276127581599) }}, 
      {{ SC_(454), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(419.08115972745271039600134310118472970327046797789), SC_(402.14634631205623296521813104882397022449574666417) }}, 
      {{ SC_(454), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(421.97760466330551820579203739361835668058829102447), SC_(398.80924332523406423548525698972832493090352465016) }}, 
      {{ SC_(454), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(407.30051586469324016079957806574099752146521018533), SC_(420.961845795077980065354245341819621859811822545) }}, 
      {{ SC_(454), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(407.55141782172072409248776517067454494807078206704), SC_(420.73565755232998659571965193585659854248911096427) }}, 
      {{ SC_(454), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(409.6249463455371046126453334396610206997647153531), SC_(418.83371596404814340502910260886849274827025452284) }}, 
      {{ SC_(454), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(419.56318075085129618513308280953313187736708445367), SC_(408.83722361264221022240647391072341044335734187895) }}, 
      {{ SC_(454), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(420.01387376096747452472804209167436047695130428518), SC_(408.34587221873019136977118496996435879716588682529) }}, 
      {{ SC_(454), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(421.94610275921542982571094182667221336319925044989), SC_(406.19772565474350586995008089169045953998803293774) }}, 
      {{ SC_(454), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(422.20714931329230802632181395834421916106198406363), SC_(405.9021972150872607033299038491915548775228531345) }}, 
      {{ SC_(454), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(424.98294563717012645129883722024510271550575951126), SC_(402.6773510227308576034466156562391924007656158467) }}, 
      {{ SC_(454), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(435.11012882151110612549173750396804911320870522469), SC_(443.52807588263700484893610479292247552746969782141) }}, 
      {{ SC_(454), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(435.27095951829257915351128124035042001766514301692), SC_(443.39540703609223527045191866666234598783224487057) }}, 
      {{ SC_(454), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(436.59238844133085704057369102617797495746862996901), SC_(442.26935638475817301739820506097297031154416250866) }}, 
      {{ SC_(454), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(442.70340314129831269390667164386618527107159922505), SC_(436.09203500719619728227999718095318050546480050767) }}, 
      {{ SC_(454), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(442.97024441156768587348613345630058348668552186524), SC_(435.77890051610337754724354179724142707844835704145) }}, 
      {{ SC_(454), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(444.10213364103892764811838602767911638813648167298), SC_(434.4009233515753019059000496525064139927184967743) }}, 
      {{ SC_(454), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(444.25347660462523729937210322189190593878879010883), SC_(434.21024133918857079374139266334607832906456259311) }}, 
      {{ SC_(454), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(445.83735789586960269055530301889652492784711953887), SC_(432.11303992141923665475325840269186459012467057114) }}, 
      {{ SC_(462), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(50.04584847331995562483275393325660419320694355323), SC_(66.364823634141754354687198302351675136965126290634) }}, 
      {{ SC_(462), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(50.319742931767346006301600485139851271085467378734), SC_(66.06864816787209687343950334566141248784987616893) }}, 
      {{ SC_(462), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(52.617188846987702707400514616575488811782447893531), SC_(63.616484523732817823774559390847729125667522096645) }}, 
      {{ SC_(462), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(64.549004351923416572959996952805376987324385384544), SC_(51.737203570256832198664494618373278591569233958485) }}, 
      {{ SC_(462), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(65.130077217909160211336367306936535626323886222689), SC_(51.192792213689340783250166225037111774388170370382) }}, 
      {{ SC_(462), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(67.665260544532309474320200503574452874539227729732), SC_(48.852266259282523771985777476676041562048252008723) }}, 
      {{ SC_(462), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(68.013388330367306251000688720114637847988999563299), SC_(48.535219685292496706664865041258838310315124444267) }}, 
      {{ SC_(462), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(71.802540055421868170346684697572743253217029569524), SC_(45.150692977330678624468025972292740141400736443319) }}, 
      {{ SC_(462), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(53.739795171222854539802098334928827183778178234774), SC_(70.514112790470495113367692848183326665903474182075) }}, 
      {{ SC_(462), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(54.021908304151288114318535953257101991256018663137), SC_(70.210228200197934082971211057716971043126861028263) }}, 
      {{ SC_(462), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(56.387433823936690833244464396145242776633499077766), SC_(67.693520675373405004474010232492611258429808283056) }}, 
      {{ SC_(462), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(68.650737972587943016782286766131513932714835755564), SC_(55.481551020151500107128929845791794669646015535119) }}, 
      {{ SC_(462), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(69.247105190815425587192453376085891492117810757824), SC_(54.921007540176788098869374790341778693551504833492) }}, 
      {{ SC_(462), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(71.848183299959923271385148904301669635848906778566), SC_(52.510134373004159485314341368383765088809751258824) }}, 
      {{ SC_(462), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(72.205255990937807491501326387765126674760451036753), SC_(52.183431308470588357470614266264042994621119089194) }}, 
      {{ SC_(462), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(76.09021079023541008927650189975220767318323211873), SC_(48.693821115055950415866389131356912362436163992595) }}, 
      {{ SC_(462), SC_(0.22103404998779296875), SC_(0.12698681652545928955078125), SC_(91.473890238455393922742272332918884569797011865451), SC_(111.81757327733425401312252686514606931564223516256) }}, 
      {{ SC_(462), SC_(0.22103404998779296875), SC_(0.135477006435394287109375), SC_(91.820983099472539415515469227537429195455462137458), SC_(111.45382939810889865252685270988496922566292975343) }}, 
      {{ SC_(462), SC_(0.22103404998779296875), SC_(0.22103404998779296875), SC_(94.724051968408192819921075770463769644815737250003), SC_(108.43512406972868279073171724673082414866727440413) }}, 
      {{ SC_(462), SC_(0.22103404998779296875), SC_(0.814723670482635498046875), SC_(109.58460286018467659577340155079212172063994505968), SC_(93.613840186544673407397105108894081249299802991432) }}, 
      {{ SC_(462), SC_(0.22103404998779296875), SC_(0.835008561611175537109375), SC_(110.29992385651988045247881502965037115365674382973), SC_(92.925920330649254578037662130581103523508857087667) }}, 
      {{ SC_(462), SC_(0.22103404998779296875), SC_(0.905791938304901123046875), SC_(113.41254669803691235369926635444417693728356224189), SC_(89.958764785945043196999745612095002613403353240766) }}, 
      {{ SC_(462), SC_(0.22103404998779296875), SC_(0.9133758544921875), SC_(113.8389369510853615165327351484589424506726480099), SC_(89.555598155398217252937943809693281297647221956114) }}, 
      {{ SC_(462), SC_(0.22103404998779296875), SC_(0.968867778778076171875), SC_(118.46441618276542283999156428593171000508403703773), SC_(85.232366617435603858727915292447303108879448558759) }}, 
      {{ SC_(462), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(366.34737420545874442238221115291633974255551979091), SC_(385.39412347147842949069932878055960066545995779033) }}, 
      {{ SC_(462), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(366.68950826720375537056067073635745094610807175144), SC_(385.07077828654809305974170276374350293065208267136) }}, 
      {{ SC_(462), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(369.52678242708776628742959218778979998428825207247), SC_(382.36398368087413929821491434486112552834726684396) }}, 
      {{ SC_(462), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(383.39962627958838708488965344732287579600932141899), SC_(368.44683323291813379944568666580592072576455888311) }}, 
      {{ SC_(462), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(384.04103690353672291842299000701987459315148906768), SC_(367.77450432313584002403003049241276891691689337133) }}, 
      {{ SC_(462), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(386.80486880129491568765070057261717752595099504027), SC_(364.84652718705696461209218261146300999977406338047) }}, 
      {{ SC_(462), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(387.18006196770118088836897502089709358059882204361), SC_(364.44512754037228506136735492102500419868025189395) }}, 
      {{ SC_(462), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(391.1979372388894667313317488436941468297856338792), SC_(360.08615952790907327852939271832934339967258884367) }}, 
      {{ SC_(462), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(376.14277892061017849266775901808505747312225934913), SC_(394.33789120042478975215523077546862132662147940277) }}, 
      {{ SC_(462), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(376.47062701059669499387868529275643470509113751059), SC_(394.03004590676159627740764045030348480565576709442) }}, 
      {{ SC_(462), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(379.18809995995613471328554800138413075452476668576), SC_(391.45147951758687874169405809424639185125272456402) }}, 
      {{ SC_(462), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(392.43837928481028126646073601917700733527343373877), SC_(378.15403266219698379771114242082032368969242437767) }}, 
      {{ SC_(462), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(393.0494049218549429851402512675154900185236854482), SC_(377.51009193924422812717110873059467516599044508596) }}, 
      {{ SC_(462), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(395.68054520295444541561872495346098157216590762668), SC_(374.7042003492121975403116531525070739928849275944) }}, 
      {{ SC_(462), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(396.03750015577938107018070400739144079347599034163), SC_(374.31934482163543166773732423558235755036350427585) }}, 
      {{ SC_(462), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(399.85655233600266888086901662617538469166965290174), SC_(370.13713023266072785880996336774329538400032584841) }}, 
      {{ SC_(462), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(410.77841779603348299009132062991806834191114132292), SC_(425.09192836850669467964774217200606567091489385596) }}, 
      {{ SC_(462), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(411.04050019870873412928204791009626631793165778548), SC_(424.85409990428803893880371527354629061091777136208) }}, 
      {{ SC_(462), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(413.20743037050376397313177889683126115801350031291), SC_(422.85557132516048428686099311119423735829582532068) }}, 
      {{ SC_(462), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(423.62181315216437335232445710883865624489575861881), SC_(412.384010755884455878159061159658137846137080341) }}, 
      {{ SC_(462), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(424.09539327494980230925529034323151094008499154172), SC_(411.87052691167998064749135957293786099905640575261) }}, 
      {{ SC_(462), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(426.12723517699196060712792921408370314767680064867), SC_(409.62678643346206726187796520740152524187070973137) }}, 
      {{ SC_(462), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(426.4019321011556842693438692165731311536954876857), SC_(409.31825123167004990102031796718648244988746090145) }}, 
      {{ SC_(462), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(429.32593469528266849431422550896091856464531454781), SC_(405.95362577891838024646713447954699109277704571247) }}, 
      {{ SC_(462), SC_(0.9133758544921875), SC_(0.12698681652545928955078125), SC_(414.54749317241684103166151201044157289557560066664), SC_(428.32887976389006323958081567847829759072678046843) }}, 
      {{ SC_(462), SC_(0.9133758544921875), SC_(0.135477006435394287109375), SC_(414.80049552840271675364275050243742214362718825342), SC_(428.10058981763657174736653663422610344943505276056) }}, 
      {{ SC_(462), SC_(0.9133758544921875), SC_(0.22103404998779296875), SC_(416.89150989421192572249673797944131156939052148208), SC_(426.18115473504837209951197968533905334246040854066) }}, 
      {{ SC_(462), SC_(0.9133758544921875), SC_(0.814723670482635498046875), SC_(426.91729194717382243189697410571951485038139257899), SC_(416.09711705955833706875763226722903633636646325407) }}, 
      {{ SC_(462), SC_(0.9133758544921875), SC_(0.835008561611175537109375), SC_(427.37213017802529379127292358079248928283540824397), SC_(415.60162223352377968657825664449093045486831839776) }}, 
      {{ SC_(462), SC_(0.9133758544921875), SC_(0.905791938304901123046875), SC_(429.3223377515598904641695530576862301200922783231), SC_(413.4355089091988924882925074231621936947576819029) }}, 
      {{ SC_(462), SC_(0.9133758544921875), SC_(0.9133758544921875), SC_(429.5858401370714466977766917756196697426616416387), SC_(413.13752688833461862829157641357569678006403754388) }}, 
      {{ SC_(462), SC_(0.9133758544921875), SC_(0.968867778778076171875), SC_(432.38818207988393867668921543142972096521280530344), SC_(409.88617366468320542592944593518289804952858533401) }}, 
      {{ SC_(462), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(442.82393191141749173724816325072326820230463861198), SC_(451.31614712317827841869644152156836743662631399408) }}, 
      {{ SC_(462), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(442.98606274891854929687497244464980968557637066531), SC_(451.1821745050413112505324438707834719314419238511) }}, 
      {{ SC_(462), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(444.31831042243092829560186140968343282457861353281), SC_(450.04528422783410389071851518631959672024544710996) }}, 
      {{ SC_(462), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(450.48346315283352091572919321540490887699874734837), SC_(443.81383106654679638874061205590535899657992881982) }}, 
      {{ SC_(462), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(450.75287287219138398255983761247801341317357905199), SC_(443.49813299555706441752047724189621951549274423869) }}, 
      {{ SC_(462), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(451.89591732812948291460872123812941435040707992501), SC_(442.10903364493891816867430327722153866406411695147) }}, 
      {{ SC_(462), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(452.0487864202684433692288504005674021335799201021), SC_(441.91683192409503729874122861358957872208941993018) }}, 
      {{ SC_(462), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(453.64921455609407364749407038846093208870919124129), SC_(439.80319758393201038757522213012342652322688527575) }}
   }};
#undef SC_

