/*\file Reducevectorgtof.c
 *\brief: reduce g set vector to s set vector (set of single point constraints)
 */

#include "./Reducevectorgtof.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Vector     *ug         = NULL;
	Nodes      *nodes      = NULL;
	Parameters *parameters = NULL;

	/* output datasets: */
	Vector *uf = NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ReducevectorgtofUsage);

	/*Input datasets: */
	FetchData(&ug,UG);
	FetchData((DataSet**)&nodes,NODES);
	FetchData(&parameters,PARAMETERS);

	/*!Reduce vector: */
	Reducevectorgtofx(&uf,ug,nodes,parameters);

	/*write output datasets: */
	WriteData(UF,uf);

	/*Free ressources: */
	delete nodes;
	delete parameters;
	xdelete(&ug);
	xdelete(&uf);

	/*end module: */
	MODULEEND();
}

void ReducevectorgtofUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: uf = %s(ug,nodes,parameters);\n",__FUNCT__);
	_printf_(true,"\n");
}
