/*!\file: hydrology_core.cpp
 * \brief: core of the hydrology solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../io/io.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../solvers/solvers.h"

void hydrology_core(FemModel* femmodel){

	int i;

	/*intermediary*/
	double time;
	int    nsteps;
	double starttime,final_time;
	double dt;
	bool   save_results;
	int    output_frequency;

	//first recover parameters common to all solutions
	femmodel->parameters->FindParam(&starttime,TimesteppingStartTimeEnum);
	femmodel->parameters->FindParam(&final_time,TimesteppingFinalTimeEnum);
	femmodel->parameters->FindParam(&dt,TimesteppingTimeStepEnum);
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);
	femmodel->parameters->FindParam(&output_frequency,SettingsOutputFrequencyEnum);
	/*first compute slopes: */
	surfaceslope_core(femmodel);
	bedslope_core(femmodel);

	/*Compute number of time steps: */
	if((dt==0)|| (final_time==0)){
		dt=0;
		nsteps=1;
	}
	else nsteps=(int)((final_time-starttime)/dt);
	time=starttime;

	/*Loop through time: */
	for(i=0;i<nsteps;i++){
		
		if(nsteps)_printf_(VerboseSolution(),"time step:%i/%i\n",i+1,nsteps);
		time+=dt;
		femmodel->parameters->SetParam(time,TimeEnum);

		/*call hydrology_core step: */
		hydrology_core_step(femmodel,i,time);

		if(save_results && ((i+1)%output_frequency==0 || (i+1)==nsteps)){
			_printf_(VerboseSolution(),"   saving results \n");
			//InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,WatercolumnEnum,i+1,time);
			//InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,HydrologyWaterVxEnum,i+1,time);
			//InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,HydrologyWaterVyEnum,i+1,time);
			
			/*unload results*/
			_printf_(VerboseSolution(),"   saving temporary results\n");
			OutputResultsx(femmodel->elements, femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters,femmodel->results);
		}
	}
}

