/* \file ModuleBoot.cpp
 * \brief Carry out operations needed to boot, for example, petsc, MPI, plapack, etc ... 
 * at the beginning of a module
 */

#include "../../toolkits/toolkits.h"

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

int ModuleEnd(void){

	#if _PETSC_MAJOR_ == 3 && _PETSC_MINOR_ < 1
	if(0){
		PetscBool        flg;
		PetscErrorCode   ierr;
		extern PetscBool PetscBeganMPI;

		/*Close PETSc but do not close MPI*/
		PetscBeganMPI = PETSC_FALSE;
		ierr=PetscFinalize();CHKERRQ(ierr);
	}
	#else
		/*Do nothing*/
	#endif

	return 1;
}
